//=============================================================================
// VisuStella MZ - Core Engine
// VisuMZ_0_CoreEngine.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_0_CoreEngine = true;

var VisuMZ = VisuMZ || {};
VisuMZ.CoreEngine = VisuMZ.CoreEngine || {};
VisuMZ.CoreEngine.version = 1.85;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 0] [Version 1.85] [CoreEngine]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Core_Engine_VisuStella_MZ
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Core Engine plugin is designed to fix any bugs that may have slipped
 * past RPG Maker MZ's source code and to give game devs more control over
 * RPG Maker MZ's various features, ranging from mechanics to aesthetics to
 * quality of life improvements.
 *
 * Features include all (but not limited to) the following:
 *
 * * Bug fixes for the problems existing in the RPG Maker MZ base code.
 * * Failsafes added for Script Call related event commands.
 * * Lots of Quality of Life Settings that can be activated through the
 *   Plugin Parameters.
 * * Control over the various Text Colors used throughout the game.
 * * Change up the maximum amount of gold carried, give it an icon attached to
 *   the label, and include text for overlap specifics.
 * * Preload images as the game boots up.
 * * Add specific background images for menus found throughout the game.
 * * A button assist window will appear at the top or bottom of the screen,
 *   detailing which buttons do what when inside a menu. This feature can be
 *   turned off.
 * * Choose which in-game battler parameters to display inside menus (ie ATK,
 *   DEF, AGI, etc.) and determine their maximum values, along with plenty of
 *   notetags to give more control over parameter, x-parameter, s-parameter
 *   bonuses through equipment, states, and other trait objects.
 * * Control over how the UI objects appear (such as the menu button, cancel
 *   button, left/right actor switch buttons).
 * * Reposition actors and enemies if the battle resolution is larger.
 * * Allow class names and nicknames to support text codes when displayed.
 * * Determine how windows behave in the game, if they will mask other windows,
 *   their line height properties, and more.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 0 ------
 *
 * This plugin is a Tier 0 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ Plugin library.
 *
 * ============================================================================
 * Important Changes: Bug Fixes
 * ============================================================================
 *
 * This plugin also serves to fix various bugs found in RPG Maker MZ that have
 * been unaddressed or not yet taken care of. The following is a list of bugs
 * that have been fixed by this plugin:
 *
 * ---
 *
 * Attack Skill Trait
 *
 * Enemies are unaffected by the Attack Skill Trait. This means if they have
 * an Attack action, they will always use Attack over and over even if their
 * Attack Skill Trait has been changed. This plugin will change it up so that
 * the Attack skill will comply with whatever their Attack Skill Trait's skill
 * is set to.
 *
 * ---
 *
 * Auto Battle Actor Skill Usage
 *
 * If an actor with Auto Battle has access to a skill but not have any access
 * to that skill's type, that actor will still be able to use the skill during
 * Auto Battle despite the fact that the actor cannot use that skill during
 * manual input.
 *
 * ---
 * 
 * Auto Battle Attack Seal Bypass
 * 
 * By default, if the attack skill is sealed via a trait and an actor has
 * auto-battle, the action can still be used via auto-battle. This is now fixed
 * and actors should not be able to attack via auto-battle if their attack
 * ability is sealed.
 * 
 * ---
 * 
 * Auto Battle Lock Up
 * 
 * If an auto battle Actor fights against an enemy whose DEF/MDF is too high,
 * they will not use any actions at all. This can cause potential game freezing
 * and softlocks. This plugin will change that and have them default to a
 * regular Attack.
 * 
 * ---
 * 
 * Auto Save After New Game
 * 
 * Normally, when starting a new game through the "New Game" option, there is
 * no auto save trigger. However, if you start a new game or load a saved game,
 * then go to the Game End screen, return back to the title screen, then start
 * a New Game, the auto save trigger occurs when it shouldn't. The Core Engine
 * will now patch this and prevent the trigger from taking place.
 * 
 * ---
 * 
 * Battle Forced End Action Crash
 * 
 * Depending on various circumstances, currently active battlers can be cleared
 * from the battle system at will due to a number of reasons. However, if it
 * just so happens that the targets are cleared, too, with actions remaining,
 * then a crash will follow up. This plugin will prevent that change. Fix made
 * by Olivia.
 * 
 * ---
 * 
 * Debug Console Refresh Bug
 * 
 * When pressing F5 to refresh while the debug console (DevTools) is open,
 * some graphics will fail to load properly. This started occurring since the
 * RPG Maker MZ 1.5.0 update and the code for loading the images has now been
 * reverted to the 1.4.4 version where it was last stable.
 * 
 * ---
 * 
 * Gamepad Repeat Input
 * 
 * Cleared inputs on gamepads do not have a downtime and will trigger the
 * following input frame. The causes problems with certain RPG Maker MZ menus
 * where the inputs have to be cleared as the next immediate frame will have
 * them inputted again. This plugin changes it so that whenever inputs are
 * cleared, there is a downtime equal to the keyboard clear frames before the
 * gamepad input is registered once more.
 * 
 * ---
 * 
 * Invisible Battle Sprites
 * 
 * If you removed a party member during battle and added that exact party
 * member back into the same slot, their sprite would appear invisible. The
 * VisuStella Core Engine will fix this problem and prevent it from happening.
 * 
 * ---
 * 
 * Instant Text Discrepancy for Window_Message
 * 
 * Window_Message displays text differently when it draws letters one by one
 * versus when the text is displayed instantly. This isn't noticeable with the
 * default font, but it's very visible when using something like Arial. The
 * error is due to Bitmap.measureTextWidth yielding a rounded value per letter
 * versus per word. The Core Engine will provide a bug fix that will single out
 * the cause and make it so that only Window_Message will not utilize any round
 * number values when determining the width of each letter, whether or not it
 * is shown instantly. This change will only affect Window_Message and not any
 * other window in order to prevent unintended side effects.
 * 
 * This can be disabled through the Plugin Parameters:
 * 
 * Plugin Parameters > QoL Settings > Misc > Font Width Fix
 * 
 * ---
 *
 * Move Picture, Origin Differences
 *
 * If a Show Picture event command is made with an Origin setting of
 * "Upper Left" and a Move Picture event command is made afterwards with an
 * Origin setting of "Center", RPG Maker MZ would originally have it instantly
 * jump into the new origin setting without making a clean transition between
 * them. This plugin will create that clean transition between origins.
 *
 * ---
 * 
 * Overly-Protective Substitute
 * 
 * When an ally with critical health is being targeted by a friendly non-
 * Certain Hit skill (such as a heal or buff) and another ally has the
 * substitute state, the other ally would "protect" the originally targeted
 * ally and take the heal or buff.
 * 
 * The new changed behavior is that now, substitute will not trigger for any
 * actions whose scope targets allies.
 * 
 * ---
 * 
 * Skill List Active After Party Member Change
 * 
 * If the skill list is active (ie. the player can move the cursor around) and
 * the party member currently being viewed is changed via the button commands,
 * then previously, RPG Maker MZ would still have that window be active despite
 * having the cursor hidden temporarily. Upon pressing direction buttons, the
 * cursor reveals itself and both the skill type window and skill list window
 * are both active, making way for lots of potential problems to happen.
 * 
 * ---
 * 
 * Sprite Removal and Destroy Crash
 * 
 * A texture check will now occur for sprites that are being removed and
 * destroyed in order to prevent crashes. In the off chance that someone
 * creates a sprite through a script call and removes it through such, the
 * likelihood of this occurance becomes higher. This makes the "destroy"
 * property take into account a texture check in order to see if the sprite
 * removal is taking extra steps and will reduce those extra steps.
 * 
 * ---
 * 
 * Status Window Name Vertical Cutoffs
 * 
 * In the battle status windows, whenever actor names are displayed, the bitmap
 * used to display their name text do not extend vertically all the way,
 * causing letters like lowercase "Q" and "G" to be cut off, making them hard
 * to distinguish from one another. The Core Engine will remedy this by
 * extending the bitmap to allow enough room. Fix made by Irina.
 * 
 * ---
 * 
 * Termination Clear Effects
 * 
 * In RPG Maker MZ, requesting an animation while transitioning between
 * scenes, such as going from the map scene to the battle scene, can cause
 * crashes. This is because the animation queue does not take off immediately
 * and will likely register incorrect targets for the scene. This plugin will
 * forcefully clear any registered animations and balloon effects when
 * terminating a scene in order to prevent crashes.
 * 
 * ---
 * 
 * Timer Sprite
 * 
 * By default, RPG Maker MZ adds Sprite_Timer into its spriteset, either for
 * maps or for battles. There is one major problem with this: when spritesets
 * are affected by filters, zooms, and/or blurs, this hinders how readable the
 * timer sprite is, making the information perceived by the player to be much
 * harder than it needs to be. The Core Engine adds the sprite to the parent
 * scene instead of the spriteset to ensure it's unobscured by anything else.
 * 
 * ---
 * 
 * Unusable Battle Items
 * 
 * If any party member is able to use an item in battle, then all party members
 * are able to use said item, even if that party member is supposed to be
 * unable to use that item. This is now changed so that battle items are
 * checked on an individual basis and not on a party-wide basis.
 * 
 * ---
 * 
 * Water Tile Bug
 * 
 * It seems like there's a new bug that occurs if you create a tileset from
 * scratch in RPG Maker MZ version 1.5.0+ and version 1.6.0+! What this bug
 * does is it causes many tiles to become water tiles without intending to.
 * You can find this out by turning off all the plugins in your project,
 * putting a Ship or Boat on what are normally ground tiles, and then seeing
 * the Ship or Boat traverse through it.
 * 
 * There are two ways to fix this. We cannot fix it through code in this plugin
 * as it's a problem that involves the tileset json data there are ways to work
 * around it so that you can get the proper water-flags to go where they need
 * to be at.
 * 
 * 1. Copy a working un-bugged tileset onto the currently bugged one and
 *    reapply the tile features like passability, terrain tags, etc. This will
 *    make sure the water-passability tiles get copied over correctly.
 * 
 * 2. If you're on RPG Maker MZ version 1.5.0 or above, select a working
 *    un-bugged tileset (usually a pre-existing tileset when a new project is
 *    made), click the "Copy Page" button, go to the bugged tileset and press
 *    "Paste Page". You'll have to reapply any different properties like
 *    passabilities and terrain tags, but the water tile flags should now be
 *    working properly.
 * 
 * The plugin will not fix the problem itself since flag data is delicate and
 * should not be tampered with midgame as the changes made by the plugin might
 * not match the desired settings.
 * 
 * This plugin, however, will also send out an alert message when coming across
 * such a tile. Pay attention to it and do one of the following two steps above
 * to fix the problem.
 * 
 * ---
 * 
 * Window Arrows Sprite Tearing
 * 
 * If a window object in RPG Maker MZ were to have an odd number for width size
 * then the arrow elements found for the window would be positioned on a half
 * pixel, giving it a blurry look and also have sprite tearing issues. This is
 * now fixed by rounding the number to the nearest whole number.
 * 
 * ---
 * 
 * Window Client Area Scaling Bug
 * 
 * If the window has a scale value different from 1.0, the client area (the
 * interactable parts) will not scale properly and appear clipped out. This
 * is now fixed by adjusting the client area to the window's scale values and
 * rounding upward to the nearest whole number.
 * 
 * ---
 * 
 * Window Skin Bleeding
 * 
 * This bug is fixed in the core scripts for RPG Maker MZ v1.3.0+.
 * 
 * Since the v1.2.0 update, Window.prototype._refreshBack's frame value has
 * been set from 96 to 95. This results in the window skin bleeding past the
 * window's intended borders. The Core Engine now reverts this change to
 * prevent the bleeding effect from happening.
 * 
 * ---
 *
 * ============================================================================
 * Major Changes: New Hard-Coded Features
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 *
 * Scroll-Linked Pictures
 *
 * - If a Parallax has a ! at the start of its filename, it is bound to the map
 * scrolling. The same thing now happens with pictures. If a Picture has a ! at
 * the start of its filename, it is bound to the map's scrolling as well.
 *
 * ---
 *
 * Movement Route Scripts
 *
 * - If code in a Movement Route Script command fails, instead of crashing the
 * game, it will now act as if nothing happened except to display the cause of
 * the error inside the console.
 *
 * ---
 * 
 * Script Call Failsafes
 * 
 * - If code found in Conditional Branches, Control Variables, and/or Script
 * Calls fail to activate, instead of crashing the game, it will now act as if
 * nothing happened except to display the cause of the error inside the
 * console.
 * 
 * ---
 * 
 * Digit Grouping
 * 
 * - There exists an option to change how numbers are displayed and converted
 * in your game. This option can be enabled or disabled by going into the
 * Plugin Manager > VisuMZ_0_OptionsCore > Quality of Life Settings >
 * Digit Grouping and toggling on/off whichever ones you want.
 * 
 * - Digit Grouping will follow the rules of whatever country/locale the Plugin
 * Parameters are set to. If it's to default 'en-US', then 1234567.123456 will
 * become 1,234,567.123456. Set it to 'es-ES' and it becomes 1.234.567,123456
 * instead.
 * 
 * - This uses JavaScript's Number.toLocaleString() function and will therefore
 * follow whatever rules it has. This means if there are trailing zeroes at the
 * end of a decimal, it will cut them off. Numbers like 123.45000 will become
 * 123.45 instead. Excess numbers past 6 decimal places will be rounded. A
 * number like 0.123456789 will become 0.123457 instead.
 * 
 * - Numbers in between [ and ], < and > will be excluded from digit grouping
 * in order for text codes to be preserved accurately. \I[1234] will remain as
 * \I[1234].
 * 
 * - If you would like to enter in a number without digit grouping, surround it
 * with {{ and }}. Typing in {{1234567890}} will yield 1234567890.
 * 
 * ---
 * 
 * Show Scrolling Text, additional functionality
 * 
 * The event command "Show Scrolling Text" now has additional functionality as
 * long as the VisuStella MZ Core Engine is installed. If the game dev inserts
 * "// Script Call" (without the quotes) inside the scrolling text, then the
 * entirity of the Show Scrolling Text event command will be ran as a giant
 * script call event command.
 * 
 * The reason why this functionality is added is because the "Script..." event
 * command contains only 12 lines maximum. This means for any script call
 * larger than 12 lines of code cannot be done by normal means as each script
 * call is ran as a separate instance.
 * 
 * By repurposing the "Show Scrolling Text" event command to be able to
 * function as an extended "Script..." event command, such a thing is now
 * possible with less hassle and more lines to code with.
 * 
 * This effect does not occur if the Show Scrolling Text event command does not
 * have "// Script Call" in its contents.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 * 
 * ---
 *
 * === Actors-Related Notetags ===
 *
 * Parameter limits can be adjusted in the Plugin Parameters, but this won't
 * lift the ability to change the values of an actor's initial or max level
 * past the editor's limits. Instead, this must be done through the usage of
 * notetags to accomplish the feat.
 *
 * ---
 *
 * <Max Level: x>
 *
 * - Used for: Actor Notetags
 * - Replace 'x' with an integer to determine the actor's max level.
 * - This allows you to go over the database limit of 99.
 * - If this notetag isn't used, default to the actor's database value.
 *
 * ---
 *
 * <Initial Level: x>
 *
 * - Used for: Actor Notetags
 * - Replace 'x' with an integer to determine the actor's initial level.
 * - This allows you to go over the database limit of 99.
 * - If this notetag isn't used, default to the actor's database value.
 *
 * ---
 *
 * === Classes-Related Notetags ===
 *
 * As actor levels can now surpass 99 due to the notetag system, there may be
 * some skills you wish certain classes can learn upon reaching higher levels
 * past 99, too.
 *
 * ---
 * 
 * <Learn At Level: x>
 *
 * - Used for: Class Skill Learn Notetags
 * - Replace 'x' with an integer to determine the level this class will learn
 *   the associated skill at.
 * - This allows you to go over the database limit of 99.
 * - If this notetag isn't used, default to the class's database value.
 *
 * ---
 *
 * === Enemies-Related Notetags ===
 *
 * Enemies are now given levels. The levels don't do anything except to serve
 * as a container for a number value. This way, levels can be used in damage
 * formulas (ie. a.atk - b.level) without causing any errors. To give enemies
 * levels, use the notetags below. These notetags also allow you to adjust the
 * base parameters, EXP, and Gold past the database limitations.
 *
 * ---
 *
 * <Level: x>
 *
 * - Used for: Enemy Notetags
 * - Replace 'x' with an integer to determine the enemy's level.
 * - If no level is declared, the level will default to 1.
 *
 * ---
 *
 * <param: x>
 *
 * - Used for: Enemy Notetags
 * - Replace 'param' with 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI',
 *   or 'LUK' to determine which parameter to alter.
 *   - This notetag does NOT work with X Parameters, S Parameters, or any
 *     custom parameters. This notetag ONLY works with the base parameters.
 * - Replace 'x' with an integer to set an enemy's 'param' base value.
 * - This will overwrite the enemy's database value and can exceed the original
 *   value limitation in the database.
 * - If these notetags aren't used, default to the enemy's database value.
 *
 * ---
 *
 * <EXP: x>
 * <Gold: x>
 *
 * - Used for: Enemy Notetags
 * - Replace 'x' with an integer to determine the enemy's EXP or Gold values.
 * - This will overwrite the enemy's database value and can exceed the original
 *   value limitation in the database.
 * - If these notetags aren't used, default to the enemy's database value.
 *
 * ---
 * 
 * === Animations-Related Notetags ===
 * 
 * Animations in RPG Maker MZ are done by Effekseer and the animation system
 * has been revamped. However, the animations are only centered on the targets
 * now, and cannot be attached to the head or foot. Insert these tags into
 * the names of the animations in the database to adjust their positions.
 * 
 * ---
 * 
 * <Head>
 * <Foot>
 * 
 * - Used for: Animation Name Tags
 * - Will set the animation to anchor on top of the sprite (if <Head> is used)
 *   or at the bottom of the sprite (if <Foot> is used).
 * 
 * ---
 * 
 * <Anchor X: x>
 * <Anchor Y: y>
 * 
 * <Anchor: x, y>
 * 
 * - Used for: Animation Name Tags
 * - Will anchor the animation at a specific point within the sprite based on
 *   the 'x' and 'y' values.
 * - Replace 'x' and 'y' with numeric values representing their positions based
 *   on a rate where 0.0 is the furthest left/up (x, y respectively) to 1.0 for
 *   the furthest right/down (x, y respectively).
 * 
 * Examples:
 * 
 * <Anchor X: 0.4>
 * <Anchor Y: 0.8>
 * 
 * <Anchor: 0.2, 0.9>
 * 
 * ---
 * 
 * <Offset X: +x>
 * <Offset X: -x>
 * <Offset Y: +y>
 * <Offset Y: -y>
 * 
 * <Offset: +x, +y>
 * <Offset: -x, -y>
 * 
 * - Used for: Animation Name Tags
 * - Will anchor the animation to be offset by an exact number of pixels.
 * - This does the same the editor does, except it lets you input values
 *   greater than 999 and lower than -999.
 * - Replace 'x' and 'y' with numeric values the exact number of pixels to
 *   offset the animation's x and y coordinates by.
 * 
 * Examples:
 * 
 * <Offset X: +20>
 * <Offset Y: -50>
 * 
 * <Offset: +10, -30>
 * 
 * ---
 * 
 * <Mirror Offset X>
 * <No Mirror Offset X>
 * 
 * - Used for: Animation Name Tags
 * - If an animation is mirrored, you can choose to have the animation's Offset
 *   X value be mirrored, too (or not at all).
 * - If no name tag is discovered, this will use the setting found in the
 *   Plugin Parameters > QoL Settings > Misc > Ani: Mirror Offset X setting.
 * 
 * ---
 * 
 * <Rate: x>
 * 
 * - Used for: MV Animation Name Tags
 * - Allows you to adjust the update for this MV Animation.
 *   - Does NOT work with Effekseer animations.
 * - The lower the number, the faster.
 * - Replace 'x' with a number representing the animation update rate.
 *   - Default rate: 4.
 *   - Minimum rate: 1.
 *   - Maximum rate: 10.
 * 
 * ---
 *
 * === Quality of Life-Related Notetags ===
 *
 * By default, RPG Maker MZ does not offer an encounter step minimum after a
 * random encounter has finished. This means that one step immediately after
 * finishing a battle, the player can immediately enter another battle. The
 * Quality of Life improvement: Minimum Encounter Steps allows you to set a
 * buffer range between battles for the player to have some breathing room.
 *
 * ---
 *
 * <Minimum Encounter Steps: x>
 *
 * - Used for: Map Notetags
 * - Replace 'x' with the minimum number of steps before the player enters a
 *   random encounter on that map.
 * - If this notetag is not used, then the minimum encounter steps for the map
 *   will default to Quality of Life Settings => Encounter Rate Min.
 *
 * ---
 *
 * Tile shadows are automatically added to certain tiles in the map editor.
 * These tile shadows may or may not fit some types of maps. You can turn them
 * on/off with the Quality of Life Plugin Parameters or you can override the
 * settings with the following notetags:
 *
 * ---
 *
 * <Show Tile Shadows>
 * <Hide Tile Shadows>
 *
 * - Used for: Map Notetags
 * - Use the respective notetag for the function you wish to achieve.
 * - If this notetag is not used, then the minimum encounter steps for the map
 *   will default to Quality of Life Settings => No Tile Shadows.
 *
 * ---
 * 
 * <Scroll Lock X>
 * <Scroll Lock Y>
 * 
 * - Used for: Map Notetags
 * - Will prevent the map from being able to scroll left/right(x) or up/down(y)
 *   if these notetags are present.
 * - Useful for when maps are just slightly smaller than normal and the tiny
 *   scrolling is distracting.
 * - This will use the display nudge setting found in the Plugin Parameters.
 * - This setting will be disabled if the map is zoomed in.
 * 
 * ---
 * 
 * <Scroll Lock X: x>
 * <Scroll Lock Y: y>
 * 
 * - Used for: Map Notetags
 * - Will prevent the map from being able to scroll left/right(x) or up/down(y)
 *   if these notetags are present and will nudge the map camera slightly.
 * - Useful for when maps are just slightly smaller than normal and the tiny
 *   scrolling is distracting.
 * - Replace 'x' and 'y' with numbers between 0 and 1 to represent how much is
 *   being judged.
 *   - For example, for a 1280x720 resolution, a 27 tile wide map will benefit
 *     from a nudge of 0.15625. Play with these numbers to determine the best
 *     value for your maps.
 * - This setting will be disabled if the map is zoomed in.
 * 
 * ---
 *
 * === Basic, X, and S Parameters-Related Notetags ===
 *
 * A battler's parameters, or stats as some devs know them as, are the values
 * that determine how a battler performs. These settings allow you to alter
 * behaviors and give boosts to trait objects in a more controlled manner.
 *
 * ---
 *
 * <param Plus: +x>
 * <param Plus: -x>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Adds or subtracts 'x' to 'param' plus value when calculating totals.
 * - Replace 'param' with 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI',
 *   or 'LUK' to determine which parameter to modify.
 * - Replace 'x' with an integer on how much to adjust the parameter by.
 * - This is used to calculate the 'plus' portion in the Parameter Settings =>
 *   Basic Parameter => Formula.
 *
 * ---
 *
 * <param Rate: x%>
 * <param Rate: x.x>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Changes 'param' rate to 'x' to alter the total 'param' value.
 * - Replace 'param' with 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI',
 *   or 'LUK' to determine which parameter to modify.
 * - Replace 'x' with a percentage (ie. 150%) or a rate (ie. 1.5).
 * - This is used to calculate the 'paramRate' portion in Parameter Settings =>
 *   Basic Parameter => Formula.
 *
 * ---
 *
 * <param Flat: +x>
 * <param Flat: -x>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Adds or subtracts 'x' to 'param' plus value when calculating totals.
 * - Replace 'param' with 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI',
 *   or 'LUK' to determine which parameter to modify.
 * - Replace 'x' with an integer on how much to adjust the parameter by.
 * - This is used to calculate the 'flatBonus' portion in Parameter Settings =>
 *   Basic Parameter => Formula.
 *
 * ---
 *
 * <param Max: x>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Sets max caps for the 'param' to be 'x'. If there are multiple max caps
 *   available to the unit, then the highest will be selected.
 * - Replace 'param' with 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI',
 *   or 'LUK' to determine which parameter to modify.
 * - Replace 'x' with an integer to determine what the max cap should be.
 * - This does NOT set the max cap to be lower than the default cap.
 *
 * ---
 *
 * <xparam Plus: +x%>
 * <xparam Plus: -x%>
 *
 * <xparam Plus: +x.x>
 * <xparam Plus: -x.x>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Adds or subtracts 'x' to 'xparam' plus value when calculating totals.
 * - Replace 'xparam' with 'HIT', 'EVA', 'CRI', 'CEV', 'MEV', 'MRF', 'CNT',
 *   'HRG', 'MRG', 'TRG' to determine which X parameter to modify.
 * - Replace 'x' with a percentage (ie. 150%) or a rate (ie. 1.5).
 * - This is used to calculate the 'plus' portion in the Parameter Settings =>
 *   X Parameter => Formula.
 *
 * ---
 *
 * <xparam Rate: x%>
 * <xparam Rate: x.x>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Changes 'param' rate to 'x' to alter the total 'xparam' value.
 * - Replace 'xparam' with 'HIT', 'EVA', 'CRI', 'CEV', 'MEV', 'MRF', 'CNT',
 *   'HRG', 'MRG', 'TRG' to determine which X parameter to modify.
 * - Replace 'x' with a percentage (ie. 150%) or a rate (ie. 1.5).
 * - This is used to calculate the 'paramRate' portion in Parameter Settings =>
 *   X Parameter => Formula.
 *
 * ---
 *
 * <xparam Flat: +x%>
 * <xparam Flat: -x%>
 *
 * <xparam Flat: +x.x>
 * <xparam Flat: -x.x>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Adds or subtracts 'x' to 'xparam' plus value when calculating totals.
 * - Replace 'xparam' with 'HIT', 'EVA', 'CRI', 'CEV', 'MEV', 'MRF', 'CNT',
 *   'HRG', 'MRG', 'TRG' to determine which X parameter to modify.
 * - Replace 'x' with a percentage (ie. 150%) or a rate (ie. 1.5).
 * - This is used to calculate the 'flatBonus' portion in Parameter Settings =>
 *   X Parameter => Formula.
 *
 * ---
 *
 * <sparam Plus: +x%>
 * <sparam Plus: -x%>
 *
 * <sparam Plus: +x.x>
 * <sparam Plus: -x.x>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Adds or subtracts 'x' to 'sparam' plus value when calculating totals.
 * - Replace 'sparam' with 'TGR', 'GRD', 'REC', 'PHA', 'MCR', 'TCR', 'PDR',
 *   'MDR', 'FDR', 'EXR' to determine which S parameter to modify.
 * - Replace 'x' with a percentage (ie. 150%) or a rate (ie. 1.5).
 * - This is used to calculate the 'plus' portion in the Parameter Settings =>
 *   S Parameter => Formula.
 *
 * ---
 *
 * <sparam Rate: x%>
 * <sparam Rate: x.x>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Changes 'param' rate to 'x' to alter the total 'sparam' value.
 * - Replace 'sparam' with 'TGR', 'GRD', 'REC', 'PHA', 'MCR', 'TCR', 'PDR',
 *   'MDR', 'FDR', 'EXR' to determine which S parameter to modify.
 * - Replace 'x' with a percentage (ie. 150%) or a rate (ie. 1.5).
 * - This is used to calculate the 'paramRate' portion in Parameter Settings =>
 *   S Parameter => Formula.
 *
 * ---
 *
 * <sparam Flat: +x%>
 * <sparam Flat: -x%>
 *
 * <sparam Flat: +x.x>
 * <sparam Flat: -x.x>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Adds or subtracts 'x' to 'sparam' plus value when calculating totals.
 * - Replace 'sparam' with 'TGR', 'GRD', 'REC', 'PHA', 'MCR', 'TCR', 'PDR',
 *   'MDR', 'FDR', 'EXR' to determine which S parameter to modify.
 * - Replace 'x' with a percentage (ie. 150%) or a rate (ie. 1.5).
 * - This is used to calculate the 'flatBonus' portion in Parameter Settings =>
 *   S Parameter => Formula.
 * 
 * ---
 * 
 * === Tileset-Related Notetags ===
 * 
 * ---
 * 
 * <Taller By x: id>
 * 
 * - Used for: Tileset Notetags
 * - Changes any page B, C, D, E tile marked by terrain tag 'id' to be taller
 *   by 'x' tiles.
 *   - Replace 'x' with a number representing the tiles to be taller by.
 *   - Replace 'id' with a number representing the Terrain Tag you will use to
 *     mark this tile with in the Database editor.
 * - When placing these tiles on the map, all you have to do is just place the
 *   bottom tile.
 *   - ie.: For a tree that's one tile taller, just place the tile at the
 *     bottom where you see the trunk.
 *   - Then, in-game, the tree will appear taller by one tile as marked.
 * - Depending on the priority settings, the tile will appear on different
 *   layers.
 *   - O will place the tile on the below player layer.
 *   - X will place the tile on the same level as the player.
 *   - ★ will place the tile on the above player layer.
 *   - O/X layer tiles have a special property where tall sprites standing in
 *     front of it will no longer clip the top of the sprite, while sprites
 *     standing behind it will be covered by it.
 *   - The X layer sprite will only have a hitbox of 1x1 at the base.
 * - This does not work with events using tiles as graphics. Instead, if you
 *   want to do similar, use the Event & Movement Core's <Tile Expand> notetags
 *   for better control.
 * 
 * ---
 *
 * === JavaScript Notetags: Basic, X, and S Parameters ===
 *
 * The following are notetags made for users with JavaScript knowledge. These
 * notetags are primarily aimed at Basic, X, and S Parameters.
 *
 * ---
 *
 * <JS param Plus: code>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs 'code' to change the 'param' plus value.
 * - Replace 'param' with 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI',
 *   or 'LUK' to determine which parameter to modify.
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   plus amount for the parameter's total calculation.
 * - This is used to calculate the 'plus' portion in the Parameter Settings =>
 *   Basic Parameter => Formula.
 *
 * ---
 *
 * <JS param Rate: code>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs 'code' to change the 'param' rate value.
 * - Replace 'param' with 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI',
 *   or 'LUK' to determine which parameter to modify.
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   param rate amount for the parameter's total calculation.
 * - This is used to calculate the 'paramRate' portion in Parameter Settings =>
 *   Basic Parameter => Formula.
 *
 * ---
 *
 * <JS param Flat: code>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs 'code' to change the 'param' flat value.
 * - Replace 'param' with 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI',
 *   or 'LUK' to determine which parameter to modify.
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   flat bonus amount for the parameter's total calculation.
 * - This is used to calculate the 'flatBonus' portion in Parameter Settings =>
 *   Basic Parameter => Formula.
 *
 * ---
 *
 * <JS param Max: code>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs 'code' to determine what the max cap for 'param' should be. If there
 *   are multiple max caps available to the unit, then the highest is selected.
 * - Replace 'param' with 'MaxHP', 'MaxMP', 'ATK', 'DEF', 'MAT', 'MDF', 'AGI',
 *   or 'LUK' to determine which parameter to modify.
 * - Replace 'code' with JavaScript code to determine the max cap for the
 *   desired parameter.
 *
 * ---
 *
 * <JS xparam Plus: code>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs 'code' to change the 'xparam' plus value.
 * - Replace 'xparam' with 'HIT', 'EVA', 'CRI', 'CEV', 'MEV', 'MRF', 'CNT',
 *   'HRG', 'MRG', 'TRG' to determine which X parameter to modify.
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   plus amount for the X parameter's total calculation.
 * - This is used to calculate the 'plus' portion in the Parameter Settings =>
 *   X Parameter => Formula.
 *
 * ---
 *
 * <JS xparam Rate: code>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs 'code' to change the 'xparam' rate value.
 * - Replace 'xparam' with 'HIT', 'EVA', 'CRI', 'CEV', 'MEV', 'MRF', 'CNT',
 *   'HRG', 'MRG', 'TRG' to determine which X parameter to modify.
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   param rate amount for the X parameter's total calculation.
 * - This is used to calculate the 'paramRate' portion in Parameter Settings =>
 *   X Parameter => Formula.
 *
 * ---
 *
 * <JS xparam Flat: code>
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs 'code' to change the 'xparam' flat value.
 * - Replace 'xparam' with 'HIT', 'EVA', 'CRI', 'CEV', 'MEV', 'MRF', 'CNT',
 *   'HRG', 'MRG', 'TRG' to determine which X parameter to modify.
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   flat bonus amount for the X parameter's total calculation.
 * - This is used to calculate the 'flatBonus' portion in Parameter Settings =>
 *   X Parameter => Formula.
 *
 * ---
 *
 * <JS sparam Plus: code>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs 'code' to change the 'sparam' plus value.
 * - Replace 'sparam' with 'TGR', 'GRD', 'REC', 'PHA', 'MCR', 'TCR', 'PDR',
 *   'MDR', 'FDR', 'EXR' to determine which S parameter to modify.
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   plus amount for the S parameter's total calculation.
 * - This is used to calculate the 'plus' portion in the Parameter Settings =>
 *   S Parameter => Formula.
 *
 * ---
 *
 * <JS sparam Rate: code>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs 'code' to change the 'sparam' rate value.
 * - Replace 'sparam' with 'TGR', 'GRD', 'REC', 'PHA', 'MCR', 'TCR', 'PDR',
 *   'MDR', 'FDR', 'EXR' to determine which S parameter to modify.
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   param rate amount for the S parameter's total calculation.
 * - This is used to calculate the 'paramRate' portion in Parameter Settings =>
 *   S Parameter => Formula.
 *
 * ---
 *
 * <JS sparam Flat: code>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs 'code' to change the 'sparam' flat value.
 * - Replace 'sparam' with 'TGR', 'GRD', 'REC', 'PHA', 'MCR', 'TCR', 'PDR',
 *   'MDR', 'FDR', 'EXR' to determine which S parameter to modify.
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   flat bonus amount for the S parameter's total calculation.
 * - This is used to calculate the 'flatBonus' portion in Parameter Settings =>
 *   S Parameter => Formula.
 *
 * ---
 * 
 * === Battle Setting-Related Notetags ===
 * 
 * These tags will change the settings for battle regardless of how the battle
 * system is set up normally. Insert these tags in either the noteboxes of maps
 * or the names of troops for them to take effect. If both are present for a
 * specific battle, then priority goes to the setting found in the troop name.
 * 
 * ---
 * 
 * <FV>
 * <Front View>
 * <Battle View: FV>
 * <Battle View: Front View>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the perspective of battle to front view for this specific map or
 *   battle.
 * - Make sure you have the enemy image files available in the img/enemies/
 *   folder as they will used instead of the "sv_enemies" graphics.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 * 
 * <SV>
 * <Side View>
 * <Battle View: SV>
 * <Battle View: Side View>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the perspective of battle to side view for this specific map or
 *   battle.
 * - Make sure you have the enemy image files available in the img/sv_enemies/
 *   folder as they will used instead of the "enemies" graphics.
 * - Make sure your actors have "sv_actor" graphics attached to them.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 * 
 * <DTB>
 * <Battle System: DTB>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle system to the default battle system (DTB).
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 * 
 * <TPB Active>
 * <ATB Active>
 * <Battle System: TPB Active>
 * <Battle System: ATB Active>
 * 
 * <TPB Wait>
 * <ATB Wait>
 * <Battle System: TPB Wait>
 * <Battle System: ATB Wait>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle system to the time progress battle system (TPB) or
 *   active turn battle system (ATB) if you have VisuMZ_2_BattleSystemATB
 *   installed for the game project.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 * 
 * <BTB>
 * <Battle System: BTB>
 * 
 * <CTB>
 * <Battle System: CTB>
 * 
 * <ETB>
 * <Battle System: ETB>
 * 
 * <FTB>
 * <Battle System: FTB>
 * 
 * <OTB>
 * <Battle System: OTB>
 * 
 * <PTB>
 * <Battle System: PTB>
 * 
 * <STB>
 * <Battle System: STB>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle system to the respective battle system as long as you
 *   have those plugins installed in the current project.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 * 
 * <Grid>
 * <Battle Grid>
 * 
 * <No Grid>
 * <No Battle Grid>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Requires VisuMZ_2_BattleGridSystem!
 * - Changes the battle system to utilize the Battle Grid System or not.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * - If none of these notetags or comment tags are found, refer to the default
 *   settings found in the Plugin Parameters.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Animation Commands ===
 * 
 * ---
 * 
 * Animation: Play at Coordinate
 * - Plays an animation on the screen at a specific x, y coordinate even if
 *   there is no sprite attached.
 * 
 *   Animation ID:
 *   - Plays this animation.
 * 
 *   Coordinates:
 * 
 *     X:
 *     Y:
 *     - X/Y coordinate used for the animation.
 *       You may use JavaScript code.
 * 
 *   Mirror Animation?:
 *   - Mirror the animation?
 * 
 *   Mute Animation?:
 *   - Mute the animation?
 * 
 * ---
 * 
 * === Audio Plugin Commands ===
 * 
 * ---
 * 
 * Audio: Change Current BGM Volume
 * - Changes the current BGM volume without changing any of the current BGM's
 *   other properties and without restarting the BGM.
 * 
 *   Volume:
 *   - Change the current BGM's volume to what amount?
 *   - You may use JavaScript code.
 *   - Use numbers from 0 to 100.
 * 
 * ---
 * 
 * Audio: Change Current BGM Pitch
 * - Changes the current BGM pitch without changing any of the current BGM's
 *   other properties and without restarting the BGM.
 * 
 *   Pitch:
 *   - Change the current BGM's pitch to what amount?
 *   - You may use JavaScript code.
 *   - Use numbers from 50 to 150.
 * 
 * ---
 * 
 * Audio: Change Current BGM Pan
 * - Changes the current BGM pan without changing any of the current BGM's
 *   other properties and without restarting the BGM.
 * 
 *   Pan:
 *   - Change the current BGM's pan to what amount?
 *   - You may use JavaScript code.
 *   - Use numbers from -100 to 100.
 * 
 * ---
 * 
 * Audio: Change Current BGM Volume
 * - Changes the current BGM volume without changing any of the current BGM's
 *   other properties and without restarting the BGM.
 * 
 *   Volume:
 *   - Change the current BGM's volume to what amount?
 *   - You may use JavaScript code.
 *   - Use numbers from 0 to 100.
 * 
 * ---
 * 
 * Audio: Change Current BGM Pitch
 * - Changes the current BGM pitch without changing any of the current BGM's
 *   other properties and without restarting the BGM.
 * 
 *   Pitch:
 *   - Change the current BGM's pitch to what amount?
 *   - You may use JavaScript code.
 *   - Use numbers from 50 to 150.
 * 
 * ---
 * 
 * Audio: Change Current BGM Pan
 * - Changes the current BGM pan without changing any of the current BGM's
 *   other properties and without restarting the BGM.
 * 
 *   Pan:
 *   - Change the current BGM's pan to what amount?
 *   - You may use JavaScript code.
 *   - Use numbers from -100 to 100.
 * 
 * ---
 * 
 * === Debug Plugin Commands ===
 * 
 * ---
 * 
 * Debug: Current Controller ID
 * - PLAY TEST ONLY.
 * - Shows current controller ID in debug console.
 * - If you press a key on the keyboard, this data will be erased.
 * - Also copies to computer clipboard if possible.
 * 
 * ---
 * 
 * === Export Plugin Commands ===
 * 
 * ---
 * 
 * Export: All Maps Text
 * - PLAY TEST ONLY. Exports all of the text from all maps,
 *   their events, event pages, and any associated Common Events.
 * 
 *   - Exports 'Show Text' event commands.
 *   - Exports 'Show Choices' event commands.
 *   - Exports 'Show Scrolling Text' event commands.
 *   - Exports 'Comments' event commands.
 *   - Only the raw text will be exported.
 *   - Only usable during Play Test.
 * 
 * ---
 * 
 * Export: All Troops Text
 * - PLAY TEST ONLY. Exports all of the text from all troops,
 *   their event pages, and any associated Common Events.
 * 
 *   - Exports 'Show Text' event commands.
 *   - Exports 'Show Choices' event commands.
 *   - Exports 'Show Scrolling Text' event commands.
 *   - Exports 'Comments' event commands.
 *   - Only the raw text will be exported.
 *   - Only usable during Play Test.
 * 
 * ---
 * 
 * Export: Current Map Text
 * - PLAY TEST ONLY. Exports all of the text on the current map,
 *   its events, the event pages, and any associated Common Events.
 * 
 *   - Exports 'Show Text' event commands.
 *   - Exports 'Show Choices' event commands.
 *   - Exports 'Show Scrolling Text' event commands.
 *   - Exports 'Comments' event commands.
 *   - Only the raw text will be exported.
 *   - Only usable during Play Test.
 *   - If not in battle, this Plugin Command will not work.
 * 
 * ---
 * 
 * Export: Current Troop Text
 * - PLAY TEST ONLY. Exports all of the text on the current troop,
 *   the troop's event pages, and any associated Common Events.
 * 
 *   - Exports 'Show Text' event commands.
 *   - Exports 'Show Choices' event commands.
 *   - Exports 'Show Scrolling Text' event commands.
 *   - Exports 'Comments' event commands.
 *   - Only the raw text will be exported.
 *   - Only usable during Play Test.
 *   - If not in battle, this Plugin Command will not work.
 * 
 * ---
 * 
 * === Game Plugin Commands ===
 * 
 * ---
 *
 * Game: Open URL
 * - Opens a website URL from the game.
 *
 *   URL:
 *   - Where do you want to take the player?
 *
 * ---
 * 
 * === Gold Plugin Commands ===
 * 
 * ---
 *
 * Gold: Gain/Lose
 * - Allows you to give/take more gold than the event editor limit.
 *
 *   Value:
 *   - How much gold should the player gain/lose?
 *   - Use negative values to remove gold.
 *
 * ---
 * 
 * === Map Plugin Commands ===
 * 
 * ---
 * 
 * Map: Once Parallel
 * - Plays a Common Event parallel to the event once without repeating itself
 *   when done.
 * - Map only!
 * 
 *   Common Event ID:
 *   - The ID of the parallel Common Event to play.
 *   - Does NOT repeat itself when finished.
 *   - When exiting map scene or changing maps, all Once Parallels are cleared.
 *   - Once Parallels are not retained upon reentering the scene or map.
 *   - Once Parallels are not stored in memory and cannot be saved.
 * 
 * ---
 * 
 * === Picture Plugin Commands ===
 * 
 * ---
 * 
 * Picture: Coordinates Mode
 * - Play Test Mode only! Gets the coordinates of a specific picture as you
 *   move it across the screen.
 * 
 *   Picture ID: 
 *   - The ID of the pictures to track the coordinates of.
 * 
 * ---
 *
 * Picture: Easing Type
 * - Changes the easing type to a number of options.
 *
 *   Picture ID:
 *   - Which picture do you wish to apply this easing to?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 *   Instructions:
 *   - Insert this Plugin Command after a "Move Picture" event command.
 *   - Turn off "Wait for Completion" in the "Move Picture" event.
 *   - You may have to add in your own "Wait" event command after.
 *
 * ---
 * 
 * Picture: Erase All
 * - Erases all pictures on the screen because it's extremely tedious to do it
 *   one by one.
 * 
 * ---
 * 
 * Picture: Erase Range
 * - Erases all pictures within a range of numbers because it's extremely
 *   tedious to do it one by one.
 * 
 *   Starting ID:
 *   - The starting ID of the pictures to erase.
 * 
 *   Ending ID:
 *   - The ending ID of the pictures to erase.
 * 
 * ---
 * 
 * Picture: Rotate by Angle
 * - Rotates target picture by a amount angle over a set duration instead of
 *   continuously.
 * 
 *   Picture ID Number:
 *   - What is the ID of the picture you wish to rotate?
 *   - Use a number between 1 and 100.
 *   - You may use JavaScript code.
 * 
 *   Adjust Angle:
 *   - What is the angle you wish to rotate the picture by?
 *   - Use degrees (360 degrees per full rotation).
 *   - You may use JavaScript code.
 * 
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 * 
 *   Duration:
 *   - Duration of rotation effect in frames.
 *   - 60 frames = 1 second.
 *   - You may use JavaScript code.
 * 
 *   Wait for Completion:
 *   - Wait until completion before moving onto the next event?
 * 
 * ---
 * 
 * Picture: Rotate to Angle
 * - Rotates target picture to a certain angle over a set duration
 *   instead of continuously.
 * 
 *   Picture ID Number:
 *   - What is the ID of the picture you wish to rotate?
 *   - Use a number between 1 and 100.
 *   - You may use JavaScript code.
 * 
 *   Target Angle:
 *   - What is the target angle you wish to rotate the picture?
 *   - Use degrees (360 degrees per full rotation).
 *   - You may use JavaScript code.
 * 
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 * 
 *   Duration:
 *   - Duration of rotation effect in frames.
 *   - 60 frames = 1 second.
 *   - You may use JavaScript code.
 * 
 *   Wait for Completion:
 *   - Wait until completion before moving onto the next event?
 * 
 * ---
 * 
 * Picture: Show Icon
 * - Shows an icon instead of a picture image.
 * - The picture icon can be controlled like any other picture.
 * 
 *   General:
 *
 *     Picture ID Number:
 *     - What is the ID of the picture you wish to show at?
 *     - Use a number between 1 and 100.
 *     - You may use JavaScript code.
 *
 *     Icon Index:
 *     - Select the icon index to use for this picture.
 *     - You may use JavaScript code.
 *
 *     Smooth Icon?:
 *     - This will make the icon smoothed out or pixelated.
 * 
 *   Picture Settings:
 * 
 *     Position:
 *
 *       Origin:
 *       - What is the origin of this picture icon?
 *         - Upper Left
 *         - Center
 *
 *       Position X:
 *       - X coordinate of the picture.
 *       - You may use JavaScript code.
 *
 *       Position Y:
 *       - Y coordinate of the picture.
 *       - You may use JavaScript code.
 * 
 *     Scale:
 *
 *       Width %:
 *       - Horizontal scale of the picture.
 *       - You may use JavaScript code.
 *       - 100 is 100%
 *
 *       Height %:
 *       - Vertical scale of the picture.
 *       - You may use JavaScript code.
 *       - 100 is 100%
 * 
 *     Blend:
 *
 *       Opacity:
 *       - Insert a number to determine opacity level.
 *       - Use a number between 0 and 255.
 *       - You may use JavaScript code.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the picture?
 * 
 * ---
 * 
 * === Screen Shake Plugin Commands ===
 * 
 * ---
 * 
 * Screen Shake: Custom:
 * - Creates a custom screen shake effect and also sets the following uses of
 *   screen shake to this style.
 * 
 *   Shake Style:
 *   - Select shake style type.
 *   - Original
 *   - Random
 *   - Horizontal
 *   - Vertical
 * 
 *   Power:
 *   - Power level for screen shake.
 * 
 *   Speed:
 *   - Speed level for screen shake.
 * 
 *   Duration:
 *   - Duration of screenshake.
 *   - You can use code as well.
 * 
 *   Wait for Completion:
 *   - Wait until completion before moving onto the next event?
 * 
 * ---
 * 
 * === Switch Plugin Commands ===
 * 
 * ---
 * 
 * Switches: Randomize ID(s)
 * - Select specific Switch ID's to randomize ON/OFF.
 * 
 *   Switch ID(s):
 *   - Select which Switch ID(s) to toggle.
 * 
 *   Chance for ON:
 *   - Chance out of 100 that determines the switches to be ON.
 * 
 * ---
 *
 * Switches: Randomize Range
 * - Select specific Switch ID Range to randomize ON/OFF.
 * - The ratio determines the ON/OFF distribution.
 *
 *   Starting ID:
 *   - The starting ID of the Switch to toggle.
 *
 *   Ending ID:
 *   - The ending ID of the Switch to toggle.
 *
 *   Chance for ON:
 *   - Chance out of 100 that determines the switches to be ON.
 *
 * ---
 *
 * Switches: Toggle ID(s)
 * - Select specific Switch ID's to toggle ON/OFF.
 * - ON becomes OFF. OFF becomes ON.
 *
 *   Switch ID(s):
 *   - Select which Switch ID(s) to toggle.
 *
 * ---
 *
 * Switches: Toggle Range
 * - Select specific Switch ID Range to toggle ON/OFF.
 * - ON becomes OFF. OFF becomes ON.
 *
 *   Starting ID:
 *   - The starting ID of the Switch to toggle.
 *
 *   Ending ID:
 *   - The ending ID of the Switch to toggle.
 *
 * ---
 * 
 * === System Plugin Commands ===
 * 
 * ---
 *
 * System: Battle System Change
 * - Switch to a different battle system in-game.
 * - Some battle systems REQUIRE their specific plugins!
 *
 *   Change To:
 *   - Choose which battle system to switch to.
 *     - Database Default (Use game database setting)
 *     - -
 *     - DTB: Default Turn Battle
 *     - TPB Active: Time Progress Battle (Active)
 *     - TPB Wait: Time Progress Battle (Wait)
 *     - -
 *     - BTB: Brave Turn Battle (Req VisuMZ_2_BattleSystemBTB)
 *     - CTB: Charge Turn Battle (Req VisuMZ_2_BattleSystemCTB)
 *     - OTB: Order Turn Battle (Req VisuMZ_2_BattleSystemOTB)
 *     - STB: Standard Turn Battle (Req VisuMZ_2_BattleSystemSTB)
 *
 * ---
 * 
 * System: Load Images
 * - Allows you to (pre) load up images ahead of time.
 *
 *   img/animations/:
 *   img/battlebacks1/:
 *   img/battlebacks2/:
 *   img/enemies/:
 *   img/faces/:
 *   img/parallaxes/:
 *   img/pictures/:
 *   img/sv_actors/:
 *   img/sv_enemies/:
 *   img/system/:
 *   img/tilesets/:
 *   img/titles1/:
 *   img/titles2/:
 *   - Which files do you wish to load from this directory?
 * 
 * ---
 *
 * System: Main Font Size
 * - Set the game's main font size.
 *
 *   Change To:
 *   - Change the font size to this number.
 *
 * ---
 *
 * System: Side View Battle
 * - Switch between Front View or Side View for battle.
 *
 *   Change To:
 *   - Choose which view type to switch to.
 *
 * ---
 *
 * System: Window Padding
 * - Change the game's window padding amount.
 *
 *   Change To:
 *   - Change the game's standard window padding to this value.
 *
 * ---
 * 
 * === Text Popup Command ===
 * 
 * ---
 * 
 * Text Popup: Show Text
 * - Adds text to a text popup window to briefly appear.
 * - Multiple text popups will be queued.
 * - Does not halt the game and works parallel to game activity.
 * 
 *   Text:
 *   - Write the text that you want to appear here.
 *   - You may use text codes.
 * 
 * ---
 * 
 * === Variable Plugin Commands ===
 * 
 * ---
 * 
 * Variable: JS Eval
 * - Pick a variable ID and value to alter through JS.
 * - Allows one line of code for variable ID and operand.
 * - Functions like RM2k3's Variable Pointers.
 * 
 *   Variable ID:
 *   - This is the target variable to alter.
 *   - You may use JavaScript.
 *   - ie: $gameVariables.value(1)
 * 
 *   Operation Type:
 *   - What operation do you wish to use for this Plugin Command?
 * 
 *   Operand Modifier:
 *   - Value to be used in calculating the target variable.
 *   - You may use JavaScript.
 *   - ie: $gameVariables.value(1)
 * 
 * ---
 * 
 * Variable: JS Block
 * - Pick a variable ID and value to alter through JS.
 * - Allows JS block code for variable ID and operand.
 * - Functions like RM2k3's Variable Pointers.
 * 
 *   Variable ID:
 *   - This is the target variable to alter.
 *   - You may use JavaScript.
 *   - ie: $gameVariables.value(1)
 * 
 *   Operation Type:
 *   - What operation do you wish to use for this Plugin Command?
 * 
 *   Operand Modifier:
 *   - Value to be used in calculating the target variable.
 *   - You may use JavaScript.
 *   - ie: $gameVariables.value(1)
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Quality of Life Settings
 * ============================================================================
 *
 * A variety of (optional) settings and changes are added with the Core Engine
 * to improve the quality of life for both the game devs and players alike.
 *
 * ---
 *
 * Play Test
 * 
 *   New Game on Boot:
 *   - Automatically start a new game on Play Test?
 *   - Only enabled during Play Test.
 *
 *   No Play Test Mode:
 *   - Force the game to be out of Play Test mode when play testing.
 * 
 *   Open Console on Boot:
 *   - Open the Debug Console upon booting up your game?
 *   - Only enabled during Play Test.
 *
 *   F6: Toggle Sound:
 *   - F6 Key Function: Turn on all sound to 100% or to 0%, toggling between
 *     the two.
 *   - Only enabled during Play Test.
 *
 *   F7: Toggle Fast Mode:
 *   - F7 Key Function: Toggle fast mode.
 *   - Only enabled during Play Test.
 * 
 *   CTRL + n: Quick Load:
 *   - CTRL + a number from 1 to 9 will yield a quick load of that safe file.
 *   - Does not count auto saves.
 *
 *   New Game > Common Event:
 *   - Runs a common event each time a new game is started.
 *   - Only enabled during Play Test.
 *
 * ---
 * 
 * Battle Test
 * 
 *   Add Item Type:
 *   Add Weapon Type:
 *   Add Armor Type:
 *   - Add copies of each database item, weapon, and/or armor?
 *   - Effective only during battle test.
 * 
 *   Added Quantity:
 *   - Determines how many items are added during a battle test instead of
 *     the maximum amount.
 * 
 *   Shift+R: Recover All:
 *   - For Play Test only!
 *   - During battle, pressing SHIFT + R will refill the whole party's HP
 *     and MP and status.
 * 
 *   Shift+T: Full TP
 *   - For Play Test only! 
 *   - During battle, pressing SHIFT + T will refill the whole party's TP.
 * 
 * ---
 *
 * Digit Grouping
 *
 *   Standard Text:
 *   - Make numbers like 1234567 appear like 1,234,567 for standard text
 *     inside windows?
 *
 *   Ex Text:
 *   - Make numbers like 1234567 appear like 1,234,567 for ex text,
 *     written through drawTextEx (like messages)?
 *
 *   Damage Sprites:
 *   - Make numbers like 1234567 appear like 1,234,567 for in-battle
 *     damage sprites?
 *
 *   Gauge Sprites:
 *   - Make numbers like 1234567 appear like 1,234,567 for visible gauge
 *     sprites such as HP, MP, and TP gauges?
 * 
 *   Country/Locale
 *   - Base the digit grouping on which country/locale?
 *   - This will follow all of the digit grouping rules found here:
 *     https://www.w3schools.com/JSREF/jsref_tolocalestring_number.asp
 *
 * ---
 *
 * Player Benefit
 *
 *   Encounter Rate Min:
 *   - Minimum number of steps the player can take without any
 *     random encounters.
 *
 *   Escape Always:
 *   - If the player wants to escape a battle, let them escape the battle
 *     with 100% chance.
 *
 *   Accuracy Formula:
 *   - Accuracy formula calculation change to
 *     Skill Hit% * (User HIT - Target EVA) for better results.
 *
 *   Accuracy Boost:
 *   - Boost HIT and EVA rates in favor of the player.
 *
 *   Level Up -> Full HP:
 *   Level Up -> Full MP:
 *   - Recovers full HP or MP when an actor levels up.
 *
 * ---
 * 
 * Picture-Related
 * 
 *   Anti-Zoom Pictures:
 *   - If on, prevents pictures from being affected by zoom.
 * 
 *   Picture Containers > Detach in Battle:
 *   - If detached, picture container will be separated from the spriteset
 *     while on the battle scene.
 *   - This will prevent any visual effects that alter the entire spriteset
 *     from affecting the detached picture container.
 * 
 *   Picture Containers > Detach in Map:
 *   - If detached, picture container will be separated from the spriteset
 *     while on the map scene.
 *   - This will prevent any visual effects that alter the entire spriteset
 *     from affecting the detached picture container.
 * 
 * ---
 *
 * Misc
 * 
 *   Animation: Mirror Offset X:
 *   - When animations are mirrored, mirror their Offset X values, too.
 *   - The animation name tags <Mirror Offset X> and <No Mirror Offset X> will
 *     override this effect for that specific animation.
 *
 *   Font Shadows:
 *   - If on, text uses shadows instead of outlines.
 *
 *   Font Smoothing:
 *   - If on, smoothes fonts shown in-game.
 * 
 *   Font Width Fix:
 *   - Fixes the font width issue with instant display non-monospaced fonts
 *     in the Message Window.
 *
 *   Key Item Protection:
 *   - If on, prevents Key Items from being able to be sold and from being
 *     able to be consumed.
 * 
 *   Map Name Text Code:
 *   - If on, map names will use text codes.
 *   - If off, only the raw map name will be used.
 *
 *   Modern Controls:
 *   - If on, allows usage of the Home/End buttons.
 *   - Home would scroll to the first item on a list.
 *   - End would scroll to the last item on a list.
 *   - Shift + Up would page up.
 *   - Shift + Down would page down.
 *
 *   MV Animation Rate:
 *   - Adjusts the rate at which MV animations play.
 *   - Default: 4.
 *   - Lower for faster.
 *   - Higher for slower.
 * 
 *   NewGame > CommonEvent:
 *   - Runs a common event each time a new game during any session is started.
 *   - Applies to all types of sessions, play test or not.
 *
 *   No Tile Shadows:
 *   - Removes tile shadows from being displayed in-game.
 *
 *   Pixel Image Rendering:
 *   - If on, pixelates the image rendering (for pixel games).
 *
 *   Require Focus?
 *   - Requires the game to be focused? If the game isn't focused, it will
 *     pause if it's not the active window.
 * 
 *   Shortcut Scripts:
 *   - Enables shortcut-based script variables and functions that can be used
 *     for script calls.
 *   - Shortcut list enabled for this is as follows:
 * 
 *     $commonEvent(id)
 *     - Queues a common event.
 *     - This does not interrupt the current event to run the desired common
 *       event. Any queued common events will run after the current event list
 *       has finished.
 *     - Replace 'id' with the ID of the common event you wish to queue.
 *     - Common events only run in the map scene and battle scene.
 * 
 *     $onceParallel(id)
 *     - Runs a common event in the background as a once parallel event.
 *     - Once parallel events will run in the background like a parallel
 *       process, except that it does not repeat after finishing.
 *     - Replace 'id' with the ID of the common event you wish to run.
 *     - Only works in the map scene and battle scene. Battle scene usage will
 *       require VisuMZ_1_BattleCore.
 * 
 *     $scene
 *     - Returns current scene.
 * 
 *     $spriteset
 *     - Returns current scene's spriteset if there is one.
 * 
 *     $subject
 *     - Returns last recorded identity of the battle's subject/user.
 * 
 *     $targets
 *     - Returns last recorded targets marked in battle.
 * 
 *     $target
 *     - Returns last recorded target marked in battle.
 *     - Works better with VisuMZ_1_BattleCore.
 * 
 *     $event
 *     - Returns currently initiated map event.
 *
 *   Smart Event Collision:
 *   - Makes events only able to collide with one another if they're
 *    'Same as characters' priority.
 * 
 *   Subfolder Name Purge:
 *   - Purge subfolder name from Plugin Parameters when reading data to let
 *     Plugin Commands work properly.
 *   - This is for plugins (such as the VisuMZ library) that utilize dynamic
 *     name registrations for Plugin Commands. Turn this on if you plan on
 *     using subfolders with VisuMZ plugins.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle System
 * ============================================================================
 * 
 * Choose which battle system to use for your game.
 * 
 * Some battle systems REQUIRE their specific plugins! This means if you do not
 * have the required battle system plugin installed, it will not change over.
 * The Core Engine plugin does not contain data for all of the battle systems
 * inside its code.
 * 
 * ---
 * 
 *   Database Default (Use game database setting)
 * 
 *   -
 * 
 *   DTB: Default Turn Battle
 *   TPB Active: Time Progress Battle (Active)
 *   TPB Wait: Time Progress Battle (Wait)
 * 
 *   -
 * 
 *   BTB: Brave Turn Battle (Req VisuMZ_2_BattleSystemBTB)
 *   CTB: Charge Turn Battle (Req VisuMZ_2_BattleSystemCTB)
 *   ETB: Energy Turn Battle (Req VisuMZ_2_BattleSystemETB)
 *   FTB: Free Turn Battle (Req VisuMZ_2_BattleSystemFTB)
 *   OTB: Order Turn Battle (Req VisuMZ_2_BattleSystemOTB)
 *   PTB: Press Turn Battle (Req VisuMZ_2_BattleSystemPTB)
 *   STB: Standard Turn Battle (Req VisuMZ_2_BattleSystemSTB)
 * 
 *   -
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Color Settings
 * ============================================================================
 *
 * These settings allow you, the game dev, to have more control over which
 * colors appear for what conditions found in the game. You can use regular
 * numbers to use the colors predetermined by the game's Window Skin or you
 * can use the #rrggbb format for a hex color code.
 * 
 * If the game's Window Skin is changed mid-game, the colors used will still be
 * based off the default Window Skin's colors. This is due to storing them in a
 * cache and preventing extra processing and reduces lag.
 *
 * You can find out what hex codes belong to which color from this website:
 * https://htmlcolorcodes.com/
 *
 * ---
 *
 * Basic Colors
 * - These are colors that almost never change and are used globally throughout
 *   the in-game engine.
 *
 *   Normal:
 *   System:
 *   Crisis:
 *   Death:
 *   Gauge Back:
 *   HP Gauge:
 *   MP Gauge:
 *   MP Cost:
 *   Power Up:
 *   Power Down:
 *   CT Gauge:
 *   TP Gauge:
 *   Pending Color:
 *   EXP Gauge:
 *   MaxLv Gauge:
 *   - Use #rrggbb for custom colors or regular numbers
 *   for text colors from the Window Skin.
 *
 * ---
 *
 * Alpha Colors:
 * - These are colors that have a bit of transparency to them and are specified
 *   by the 'rgba(red, green, blue, alpha)' format.
 * - Replace 'red' with a number between 0-255 (integer).
 * - Replace 'green' with a number between 0-255 (integer).
 * - Replace 'blue' with a number between 0-255 (integer).
 * - Replace 'alpha' with a number between 0 and 1 (decimal).
 * 
 *   Window Font Outline:
 *   Gauge Number Outline:
 *   Dim Color:
 *   Item Back Color:
 *   - Colors with a bit of alpha settings.
 *   - Format rgba(0-255, 0-255, 0-255, 0-1)
 *
 * ---
 *
 * Conditional Colors:
 * - These require a bit of JavaScript knowledge. These determine what colors
 *   to use under which situations and uses such as different values of HP, MP,
 *   TP, for comparing equipment, and determine damage popup colors.
 * 
 *   JS: Actor HP Color:
 *   JS: Actor MP Color:
 *   JS: Actor TP Color:
 *   - Code used for determining what HP, MP, or TP color to use for actors.
 *
 *   JS: Parameter Change:
 *   - Code used for determining whatcolor to use for parameter changes.
 *
 *   JS: Damage Colors:
 *   - Code used for determining what color to use for damage types.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Gold Settings
 * ============================================================================
 *
 * Gold is the main currency in RPG Maker MZ. The settings provided here will
 * determine how Gold appears in the game and certain behaviors Gold has.
 *
 * ---
 *
 * Gold Settings
 *
 *   Gold Max:
 *   - Maximum amount of Gold the party can hold.
 *   - Default 99999999
 *
 *   Gold Font Size:
 *   - Font size used for displaying Gold inside Gold Windows.
 *   - Default: 26
 *
 *   Gold Icon:
 *   - Icon used to represent Gold.
 *   - Use 0 for no icon.
 *
 *   Gold Overlap:
 *   - Text used too much Gold to fit in the window.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Image Loading
 * ============================================================================
 *
 * Not all images are loaded at once in-game. RPG Maker MZ uses asynchronous
 * loading which means images are loaded when needed. This may cause delays in
 * when you want certain images to appear. However, if an image is loaded
 * beforehand, they can be used immediately provided they aren't removed from
 * the image cache.
 *
 * ---
 *
 * Image Loading
 *
 *   img/animations/:
 *   img/battlebacks1/:
 *   img/battlebacks2/:
 *   img/enemies/:
 *   img/faces/:
 *   img/parallaxes/:
 *   img/pictures/:
 *   img/sv_actors/:
 *   img/sv_enemies/:
 *   img/system/:
 *   img/tilesets/:
 *   img/titles1/:
 *   img/titles2/:
 *   - Which files do you wish to load from this directory upon starting
 *     up the game?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Keyboard Input Settings
 * ============================================================================
 *
 * Settings for the game that utilize keyboard input. These are primarily for
 * the name input scene (Scene_Name) and the number input event command. These
 * settings have only been tested on English keyboards and may or may not be
 * compatible with other languages, so please disable these features if they do
 * not fit in with your game.
 * 
 * If a controller is connected upon entering the name change scene, it will
 * use the default manual-entry mode instead of the keyboard-entry mode. If a
 * controller button is pressed during the keyboard-entry mode, it will
 * automatically switch to the manual-entry mode.
 * 
 * This plugin does not provide support for controllers that are undetected by
 * RPG Maker MZ's default controller support.
 *
 * ---
 * 
 * Controls
 * 
 *   WASD Movement:
 *   - Enables or disables WASD movement for your game project.
 *   - Moves the W page down button to E.
 * 
 *   R Button: Dash Toggle:
 *   - Enables or disables R button as an Always Dash option toggle.
 * 
 * ---
 *
 * Name Input
 * 
 *   Enable?:
 *   - Enables keyboard input for name entry.
 *   - Only tested with English keyboards.
 * 
 *   Default Mode:
 *   - Select default mode when entering the scene.
 *     - Default - Uses Arrow Keys to select letters.
 *     - Keyboard - Uses Keyboard to type in letters.
 * 
 *   QWERTY Layout:
 *   - Uses the QWERTY layout for manual entry.
 * 
 *   Keyboard Message:
 *   - The message displayed when allowing keyboard entry.
 *   - You may use text codes here.
 * 
 *   Banned Words:
 *   - Players cannot use these words for names.
 *   - These include words inside the names.
 *   - If a banned word is used, a buzzer sound will play.
 *
 * ---
 *
 * Number Input
 * 
 *   Enable?:
 *   - Enables keyboard input for number entry.
 *   - Only tested with English keyboards.
 *
 * ---
 * 
 * Button Assist
 * 
 *   Finish Entry:
 *   - Text used to describe finish entry.
 * 
 *   Page Change:
 *   - Text used to describe character page changing.
 * 
 *   Switch to Keyboard:
 *   - Text used to describe the keyboard switch.
 * 
 *   Switch To Manual:
 *   - Text used to describe the manual entry switch.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Menu Background Settings
 * ============================================================================
 *
 * These settings in the Plugin Parameters allow you to adjust the background
 * images used for each of the scenes. The images will be taken from the game
 * project folders img/titles1/ and img/titles2/ to load into the game.
 *
 * These settings are only available to scenes found within the Main Menu, the
 * Shop scene, and the Actor Naming scene.
 *
 * ---
 *
 * Menu Background Settings:
 * 
 *   Blur Strength:
 *   - Strength used for menu background snapshots.
 *   - Default: 8. Higher is stronger. Lower is weaker.
 *
 *   Scene_Menu:
 *   Scene_Item:
 *   Scene_Skill:
 *   Scene_Equip:
 *   Scene_Status:
 *   Scene_Options:
 *   Scene_Save:
 *   Scene_Load:
 *   Scene_GameEnd:
 *   Scene_Shop:
 *   Scene_Name:
 *   - Individual background settings for the scene.
 *
 *   Scene_Unlisted
 *   - Individual background settings for any scenes that aren't listed above.
 *
 * ---
 *
 * Background Settings
 *
 *   Snapshop Opacity:
 *   - Snapshot opacity for the scene.
 *
 *   Background 1:
 *   - Filename used for the bottom background image.
 *   - Leave empty if you don't wish to use one.
 *
 *   Background 2:
 *   - Filename used for the upper background image.
 *   - Leave empty if you don't wish to use one.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Menu Button Assist Window
 * ============================================================================
 *
 * In most modern RPG's, there exist small windows on the screen which tell the
 * player what the control schemes are for that scene. This plugin gives you
 * the option to add that window to the menu scenes in the form of a Button
 * Assist Window.
 *
 * ---
 *
 * General
 * 
 *   Enable:
 *   - Enable the Menu Button Assist Window.
 * 
 *   Location:
 *   - Determine the location of the Button Assist Window.
 *   - Requires Plugin Parameters => UI => Side Buttons ON.
 *
 *   Background Type:
 *   - Select background type for this window.
 * 
 *   Split "Escape":
 *   - Used ONLY for those making their own custom keyboard key input maps.
 *   - "Split" option makes separate instances of "Cancel" and "Menu" keys.
 *   - "Don't" option will consolidate both into "Escape" keys.
 *
 * ---
 *
 * Text
 * 
 *   Text Format:
 *   - Format on how the buttons are displayed.
 *   - Text codes allowed. %1 - Key, %2 - Text
 * 
 *   Multi-Key Format:
 *   - Format for actions with multiple keys.
 *   - Text codes allowed. %1 - Key 1, %2 - Key 2
 * 
 *   OK Text:
 *   Cancel Text:
 *   Switch Actor Text:
 *   - Default text used to display these various actions.
 *
 * ---
 *
 * Keys
 * 
 *   Key: Unlisted Format:
 *   - If a key is not listed below, use this format.
 *   - Text codes allowed. %1 - Key
 * 
 *   Key: Up:
 *   Key: Down:
 *   Key: Left:
 *   Key: Right:
 *   Key: Shift:
 *   Key: Tab:
 *   Key: A through Z:
 *   - How this key is shown in-game.
 *   - Text codes allowed.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Controller Button Assist Settings
 * ============================================================================
 *
 * These are sub-settings for the Button Assist Window Plugin Parameters. Where
 * the Button Assist Window Plugin Parameters are focused on keyboard entries,
 * these sections are focused on gamepad controllers.
 * 
 * Add multiple gamepads to the list to give them different button assist text.
 * If a gamepad is being used but not listed here, the button assist text will
 * default to the keyboard version.
 * 
 * For those looking for more information regarding controllers, visit this
 * site: https://gamepad-tester.com/
 *
 * ---
 *
 * ID Information
 * 
 *   Controller ID Name:
 *   - Exact string used for this controller ID.
 *   - Plugin Command "Debug: Current Controller ID" for ID help.
 *   - Example: Xbox 360 Controller (XInput STANDARD GAMEPAD)
 * 
 *   Similarity Match:
 *   - Partial string used to check for controller ID.
 *   - Plugin Command "Debug: Current Controller ID" for ID help.
 *   - This check occurs secondary to the exact name.
 *   - Example: Xbox
 *
 * ---
 *
 * Directions
 * 
 *   Up:
 *   Left:
 *   Right:
 *   Down:
 *   - How this button is shown in-game.
 *   - Text codes allowed.
 *
 * ---
 *
 * Actions
 * 
 *   OK:
 *   Cancel:
 *   Menu:
 *   Shift:
 *   Page Up:
 *   Page Down:
 *   - How this button is shown in-game.
 *   - Text codes allowed.
 *   - *NOTE*: Controllers use a different mapping scheme from keyboards.
 *     - The "cancel" button is separate from the "menu" button though, for the
 *       majority of the button assist window help text, we'll be referring to
 *       the cancel button usually.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Menu Layout Settings
 * ============================================================================
 *
 * These settings allow you to rearrange the positions of the scenes accessible
 * from the Main Menu, the Shop scene, and the Actor Naming scene. This will
 * require you to have some JavaScript knowledge to make the windows work the
 * way you would like.
 *
 * ---
 *
 * Menu Layout Settings
 *
 *   Scene_Title:
 *   Scene_Menu:
 *   Scene_Item:
 *   Scene_Skill:
 *   Scene_Equip:
 *   Scene_Status:
 *   Scene_Options:
 *   Scene_Save:
 *   Scene_Load:
 *   Scene_GameEnd:
 *   Scene_Shop:
 *   Scene_Name:
 *   - Various options on adjusting the selected scene.
 *
 * ---
 *
 * Scene Window Settings
 *
 *   Background Type:
 *   - Selects the background type for the selected window.
 *   - Window
 *   - Dim
 *   - Transparent
 *
 *   JS: X, Y, W, H
 *   - Code used to determine the dimensions for the selected window.
 *
 * ---
 *
 * Scene_Title Settings
 * - The following are settings unique to Scene_Title.
 *
 * Title Screen
 *
 *   Document Title Format:
 *   - Format to display text in document title.
 *   - %1 - Main Title, %2 - Subtitle, %3 - Version
 *
 *   Subtitle:
 *   - Subtitle to be displayed under the title name.
 *   
 *   Version:
 *   - Version to be display in the title screen corner.
 *   
 *   JS: Draw Title:
 *   - Code used to draw the game title.
 *   
 *   JS: Draw Subtitle:
 *   - Code used to draw the game subtitle.
 *   
 *   JS: Draw Version:
 *   - Code used to draw the game version.
 *   
 *   Button Fade Speed:
 *   - Speed at which the buttons fade in at (1-255).
 *
 * ---
 *
 * Scene_GameEnd Settings
 * - The following are settings unique to Scene_GameEnd.
 *   
 *   Command Window List:
 *   - Window commands used by the title screen.
 *   - Add new commands here.
 *
 * ---
 *
 * Command Window List
 * - This is found under Scene_Title and Scene_GameEnd settings.
 *
 *   Symbol:
 *   - The symbol used for this command.
 * 
 *   STR: Text:
 *   - Displayed text used for this title command.
 *   - If this has a value, ignore the JS: Text version.
 * 
 *   JS: Text:
 *   - JavaScript code used to determine string used for the displayed name.
 * 
 *   JS: Show:
 *   - JavaScript code used to determine if the item is shown or not.
 * 
 *   JS: Enable:
 *   - JavaScript code used to determine if the item is enabled or not.
 * 
 *   JS: Ext:
 *   - JavaScript code used to determine any ext data that should be added.
 * 
 *   JS: Run Code:
 *   - JavaScript code that runs once this command is selected.
 * 
 * ---
 *
 * Title Picture Buttons:
 * - This is found under Scene_Title settings.
 * 
 *   Picture's Filename:
 *   - Filename used for the picture.
 *
 *   Button URL:
 *   - URL for the button to go to upon being clicked.
 *
 *   JS: Position:
 *   - JavaScript code that helps determine the button's Position.
 *
 *   JS: On Load:
 *   - JavaScript code that runs once this button bitmap is loaded.
 *
 *   JS: Run Code:
 *   - JavaScript code that runs once this button is pressed.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Parameter Settings
 * ============================================================================
 *
 * A battler's parameters, or stats as some devs know them as, are the values
 * that determine how a battler performs. These settings allow you to alter
 * their behaviors and give boosts to trait objects in a controlled manner.
 *
 * ---
 *
 * Parameter Settings
 *
 *   Displayed Parameters
 *   - A list of the parameters that will be displayed in-game.
 *   - Shown in the Equip Menu.
 *   - Shown in the Status Menu.
 *
 *   Extended Parameters
 *   - The list shown in extended scenes (for other VisuStella plugins).
 *
 * ---
 *
 * === Basic Parameters ===
 *
 * MHP - MaxHP
 * - This is the maximum health points value. The amount of health points (HP)
 * a battler has determines whether or not the battler is in a living state or
 * a dead state. If the HP value is above 0, then the battler is living. If it
 * is 0 or below, the battler is in a dead state unless the battler has a way
 * to counteract death (usually through immortality). When the battler takes
 * damage, it is usually dealt to the HP value and reduces it. If the battler
 * is healed, then the HP value is increased. The MaxHP value determines what's
 * the maximum amount the HP value can be held at, meaning the battler cannot
 * be healed past that point.
 *
 * MMP - MaxMP
 * - This is the maximum magic points value. Magic points (MP) are typically
 * used for the cost of skills and spells in battle. If the battler has enough
 * MP to fit the cost of the said skill, the battler is able to use the said
 * skill provided that all of the skill's other conditions are met. If not, the
 * battler is then unable to use the skill. Upon using a skill that costs MP,
 * the battler's MP is reduced. However, the battler's MP can be recovered and
 * results in a gain of MP. The MaxMP value determines what is the maximum
 * amount the MP value can be held at, meaning the battler cannot recover MP
 * past the MaxMP value.
 *
 * ATK - Attack
 * - This is the attack value of the battler. By default, this stat is used for
 * the purpose of damage calculations only, and is typically used to represent
 * the battler's physical attack power. Given normal damage formulas, higher
 * values mean higher damage output for physical attacks.
 *
 * DEF - Defense
 * - This is the defense value of the battler. By default, this stat is used
 * for the purpose of damage calculations only, and is typically used to
 * represent the battler's physical defense. Given normal damage formulas,
 * higher values mean less damage received from physical attacks.
 *
 * MAT - Magic Attack
 * - This is the magic attack value of the battler. By default, this stat is
 * used for the purpose of damage calculations only, and is typically used to
 * represent the battler's magical attack power. Given normal damage formulas,
 * higher values mean higher damage output for magical attacks.
 *
 * MDF - Magic Defense
 * - This is the magic defense value of the battler. By default, this stat is
 * used for the purpose of damage calculations only, and is typically used to
 * represent the battler's magical defense. Given normal damage formulas,
 * higher values mean less damage received from magical attacks.
 *
 * AGI - Agility
 * - This is the agility value of the battler. By default, this stat is used to
 * determine battler's position in the battle turn's order. Given a normal turn
 * calculation formula, the higher the value, the faster the battler is, and
 * the more likely the battler will have its turn earlier in a turn.
 *
 * LUK - Luck
 * - This is the luck value of the battler. By default, this stat is used to
 * affect the success rate of states, buffs, and debuffs applied by the battler
 * and received by the battler. If the user has a higher LUK value, the state,
 * buff, or debuff is more likely to succeed. If the target has a higher LUK
 * value, then the state, buff, or debuff is less likely to succeed.
 *
 * ---
 *
 * Basic Parameters
 * 
 *   Show Actor Level?:
 *   - Show the actor level when displaying actors?
 *   - Affects for most windows in-game.
 *
 *   HP Crisis Rate:
 *   - HP Ratio at which a battler can be considered in crisis mode.
 *
 *   JS: Formula:
 *   - Formula used to determine the total value all 8 basic parameters:
 *   - MaxHP, MaxMP, ATK, DEF, MAT, MDF, AGI, LUK.
 *
 * Parameter Caps:
 *
 *   MaxHP Cap:
 *   MaxMP Cap:
 *   ATK Cap:
 *   DEF Cap:
 *   MAT Cap:
 *   MDF Cap:
 *   AGI Cap:
 *   LUK Cap:
 *   - Formula used to determine the selected parameter's cap.
 *   - These settings DO NOT raise the editor's maximum values. If you want to
 *     raise an enemy's maximum parameter value past their default cap, use the
 *     associated notetag for them instead.
 *
 * ---
 *
 * === X Parameters ===
 *
 * HIT - Hit Rate%
 * - This determines the physical hit success rate of the any physical action.
 * All physical attacks make a check through the HIT rate to see if the attack
 * will connect. If the HIT value passes the randomizer check, the attack will
 * connect. If the HIT value fails to pass the randomizer check, the attack
 * will be considered a MISS.
 *
 * EVA - Evasion Rate%
 * - This determines the physical evasion rate against any incoming physical
 * actions. If the HIT value passes, the action is then passed to the EVA check
 * through a randomizer check. If the randomizer check passes, the physical
 * attack is evaded and will fail to connect. If the randomizer check passes,
 * the attempt to evade the action will fail and the action connects.
 *
 * CRI - Critical Hit Rate%
 * - Any actions that enable Critical Hits will make a randomizer check with
 * this number. If the randomizer check passes, extra damage will be carried
 * out by the initiated action. If the randomizer check fails, no extra damage
 * will be added upon the action.
 *
 * CEV - Critical Evasion Rate%
 * - This value is put against the Critical Hit Rate% in a multiplicative rate.
 * If the Critical Hit Rate is 90% and the Critical Evasion Rate is
 * 20%, then the randomizer check will make a check against 72% as the values
 * are calculated by the source code as CRI * (1 - CEV), therefore, with values
 * as 0.90 * (1 - 0.20) === 0.72.
 *
 * MEV - Magic Evasion Rate%
 * - Where EVA is the evasion rate against physical actions, MEV is the evasion
 * rate against magical actions. As there is not magical version of HIT, the
 * MEV value will always be bit against when a magical action is initiated. If
 * the randomizer check passes for MEV, the magical action will not connect. If
 * the randomizer check fails for MEV, the magical action will connect.
 *
 * MRF - Magic Reflect Rate%
 * - If a magical action connects and passes, there is a chance the magical
 * action can be bounced back to the caster. That chance is the Magic Reflect
 * Rate. If the randomizer check for the Magic Reflect Rate passes, then the
 * magical action is bounced back to the caster, ignoring the caster's Magic
 * Evasion Rate. If the randomizer check for the Magic Reflect Rate fails, then
 * the magical action will connect with its target.
 *
 * CNT - Counter Attack Rate%
 * - If a physical action connects and passes, there is a chance the physical
 * action can be avoided and a counter attack made by the user will land on the
 * attacking unit. This is the Counter Attack Rate. If the randomizer check for
 * the Counter Attack Rate passes, the physical action is evaded and the target
 * will counter attack the user. If the randomizer check fails, the physical
 * action will connect to the target.
 *
 * HRG - HP% Regeneration
 * - During a battler's regeneration phase, the battler will regenerate this
 * percentage of its MaxHP as gained HP with a 100% success rate.
 *
 * MRG - MP% Regeneration
 * - During a battler's regeneration phase, the battler will regenerate this
 * percentage of its MaxMP as gained MP with a 100% success rate.
 *
 * TRG - TP% Regeneration
 * - During a battler's regeneration phase, the battler will regenerate this
 * percentage of its MaxTP as gained TP with a 100% success rate.
 *
 * ---
 *
 * X Parameters
 *
 *   JS: Formula:
 *   - Formula used to determine the total value all 10 X parameters:
 *   - HIT, EVA, CRI, CEV, MEV, MRF, CNT, HRG, MRG, TRG.
 *
 * Vocabulary
 *
 *   HIT:
 *   EVA:
 *   CRI:
 *   CEV:
 *   MEV:
 *   MRF:
 *   CNT:
 *   HRG:
 *   MRG:
 *   TRG:
 *   - In-game vocabulary used for the selected X Parameter.
 *
 * ---
 *
 * === S Parameters ===
 *
 * TGR - Target Rate
 * - Against the standard enemy, the Target Rate value determines the odds of
 * an enemy specifically targeting the user for a single target attack. At 0%,
 * the enemy will almost never target the user. At 100%, it will have normal
 * targeting opportunity. At 100%+, the user will have an increased chance of
 * being targeted.
 * *NOTE: For those using the Battle A.I. Core, any actions that have specific
 * target conditions will bypass the TGR rate.
 *
 * GRD - Guard Effect
 * - This is the effectiveness of guarding. This affects the guard divisor
 * value of 2. At 100% GRD, damage will become 'damage / (2 * 1.00)'. At 50%
 * GRD, damage will become 'damage / (2 * 0.50)'. At 200% GRD, damage will
 * become 'damage / (2 * 2.00)' and so forth.
 *
 * REC - Recovery Effect
 * - This is how effective heals are towards the user. The higher the REC rate,
 * the more the user is healed. If a spell were to heal for 100 and the user
 * has 300% REC, then the user is healed for 300 instead.
 *
 * PHA - Pharmacology
 * - This is how effective items are when used by the user. The higher the PHA
 * rate, the more effective the item effect. If the user is using a Potion that
 * recovers 100% on a target ally and the user has 300% PHA, then the target
 * ally will receive healing for 300 instead.
 *
 * MCR - MP Cost Rate
 * - This rate affects how much MP skills with an MP Cost will require to use.
 * If the user has 100% MCR, then the MP Cost will be standard. If the user has
 * 50% MCR, then all skills that cost MP will cost only half the required MP.
 * If the user has 200% MCR, then all skills will cost 200% their MP cost.
 *
 * TCR - TP Charge Rate
 * - This rate affects how much TP skills with an TP will charge when gaining
 * TP through various actions. At 100%, TP will charge normally. At 50%, TP
 * will charge at half speed. At 200%, TP will charge twice as fast.
 *
 * PDR - Physical Damage Rate
 * - This rate affects how much damage the user will take from physical damage.
 * If the user has 100% PDR, then the user takes the normal amount. If the user
 * has 50% PDR, then all physical damage dealt to the user is halved. If the
 * user has 200% PDR, then all physical damage dealt to the user is doubled.
 *
 * MDR - Magical Damage Rate
 * - This rate affects how much damage the user will take from magical damage.
 * If the user has 100% MDR, then the user takes the normal amount. If the user
 * has 50% MDR, then all magical damage dealt to the user is halved. If the
 * user has 200% MDR, then all magical damage dealt to the user is doubled.
 *
 * FDR - Floor Damage Rate
 * - On the field map, this alters how much damage the user will take when the
 * player walks over a tile that damages the party. The FDR value only affects
 * the damage dealt to the particular actor and not the whole party. If FDR is
 * at 100%, then the user takes the full damage. If FDR is at 50%, then only
 * half of the damage goes through. If FDR is at 200%, then floor damage is
 * doubled for that actor.
 *
 * EXR - Experience Rate
 * - This determines the amount of experience gain the user whenever the user
 * gains any kind of EXP. At 100% EXR, the rate of experience gain is normal.
 * At 50%, the experience gain is halved. At 200%, the experience gain for the
 * user is doubled.
 *
 * ---
 *
 * S Parameters
 *
 *   JS: Formula
 *   - Formula used to determine the total value all 10 S parameters:
 *   - TGR, GRD, REC, PHA, MCR, TCR, PDR, MDR, FDR, EXR.
 *
 * Vocabulary
 *
 *   TGR:
 *   GRD:
 *   REC:
 *   PHA:
 *   MCR:
 *   TCR:
 *   PDR:
 *   MDR:
 *   FDR:
 *   EXR:
 *   - In-game vocabulary used for the selected S Parameter.
 *
 * ---
 *
 * Icons
 * 
 *   Draw Icons?
 *   - Draw icons next to parameter names?
 *
 *   MaxHP, MaxMP, ATK, DEF, MAT, MDF, AGI, LUK:
 *   HIT, EVA, CRI, CEV, MEV, MRF, CNT, HRG, MRG, TRG:
 *   TGR, GRD, REC, PHA, MCR, TCR, PDR, MDR, FDR, EXR:
 *   - Icon used for the selected parameter.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Custom Parameters Settings
 * ============================================================================
 *
 * As of version 1.07, you can add Custom Parameters to your game if RPG Maker
 * MZ's default set of parameters isn't enough for you. These parameters can
 * have variable functionality depending on how you code it. More importantly,
 * these are compatible with the VisuStella MZ menus and the VisuStella Core
 * Engine's Parameters settings.
 * 
 * For clarification, these settings do NOT create brand-new parameters for you
 * to use and add to your game nor are the bonuses supported by other plugins
 * in the VisuStella MZ library. These settings exist to function as a bridge
 * for non-VisuStella MZ plugins that have created their own parameter values
 * and to show them inside VisuStella menus.
 *
 * ---
 *
 * Custom Parameter
 * 
 *   Parameter Name:
 *   - What's the parameter's name?
 *   - Used for VisuStella MZ menus.
 * 
 *   Abbreviation:
 *   - What abbreviation do you want to use for the parameter?
 *   - Do not use special characters. Avoid numbers if possible.
 * 
 *   Icon:
 *   - What icon do you want to use to represent this parameter?
 *   - Used for VisuStella MZ menus.
 * 
 *   Type:
 *   - What kind of number value will be returned with this parameter?
 *     - Integer (Whole Numbers Only)
 *     - Float (Decimals are Allowed)
 * 
 *   JS: Value:
 *   - Run this code when this parameter is to be returned.
 *
 * ---
 * 
 * Instructions on Adding Custom Parameters to VisuStella Menus
 * 
 * In the Core Engine and Elements and Status Menu Core plugins, there are
 * plugin parameter fields for you to insert the parameters you want displayed
 * and visible to the player.
 * 
 * Insert in those the abbreviation of the custom parameter. For example, if
 * you want to add the "Strength" custom parameter and the abbreviation is
 * "str", then add "str" to the Core Engine/Elements and Status Menu Core's
 * plugin parameter field for "Strength" to appear in-game. Case does not
 * matter here so you can insert "str" or "STR" and it will register all the
 * same to make them appear in-game.
 * 
 * ---
 * 
 * Instructions on Using Custom Parameters as Mechanics
 * 
 * If you want to use a custom parameter in, say, a damage formula, refer to
 * the abbreviation you have set for the custom parameter. For example, if you
 * want to call upon the "Strength" custom parameter's value and its set
 * abbreviation is "str", then refer to it as such. This is case sensitive.
 * 
 * An example damage formula would be something like the following if using
 * "str" for "Strength" and "con" for "Constitution":
 * 
 *   a.str - b.con
 * 
 * These values are attached to the Game_Battlerbase prototype class.
 * 
 * ---
 * 
 * Instructions on Setting Custom Parameter Values
 * 
 * This requires JavaScript knowledge. There is no way around it. Whatever code
 * you insert into the "JS: Value" field will return the value desired. The
 * 'user' variable will refer to the Game_Battlerbase prototype object in which
 * the information is to be drawn from.
 * 
 * Depending on the "type" you've set for the Custom Parameter, the returned
 * value will be rounded using Math.round for integers and left alone if set as
 * a float number.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Screen Resolution Settings
 * ============================================================================
 *
 * Alter various properties to make the game look better for varying screen
 * resolutions. This is mostly for RPG Maker MZ version 1.3.0 and up where the
 * Troops tab has been updated to match the screen resolution settings found in
 * the System 2 Database tab.
 *
 * ---
 * 
 * Maps
 * 
 *   Scroll Lock Small X?:
 *   Scroll Lock Small Y?:
 *   - Automatically scroll lock X/Y scrolling if the map is too small?
 *   - Useful for 1280x720 resolutions when the map is 27 tiles wide.
 *     - This will get rid of the subtle scrolling when moving from one half of
 *       the screen to the other.
 *   - This setting will be disabled if the map is zoomed in.
 * 
 *   Locked Display X?:
 *   Locked Display Y?:
 *   - What display X/Y value do you want for auto-scroll locked maps?
 *   - Use a number between 0 and 1 for best results.
 * 
 * ---
 *
 * Troops
 * 
 *   Reposition Actors:
 *   - Update the position of actors in battle if the screen resolution
 *     has changed to become larger than 816x624.
 *   - Ignore if using the VisuStella MZ Battle Core.
 *   - When using the VisuStella MZ Battle Core, adjust the position through
 *     Battle Core > Parameters > Actor Battler Settings > JS: Home Position
 *
 *   Reposition Enemies:
 *   - Update the position of enemies in battle if the screen resolution
 *     has changed to become larger than 816x624.
 * 
 *     For MZ 1.3.0+?:
 *     - Both this parameter and its parent parameter need to be on when using
 *       RPG Maker MZ 1.3.0+.
 *     - If the Core Script is below 1.3.0, this setting is ignored. This does
 *       not take into account what version the editor is on. Pay attention to
 *       that as the plugin will not auto adjust for it.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Screen Shake Settings
 * ============================================================================
 *
 * Get more screen shake effects into your game!
 * 
 * These effects have been added by Aries of Sheratan!
 *
 * ---
 *
 * Settings
 * 
 *   Default Style:
 *   - The default style used for screen shakes.
 *   - Original
 *   - Random
 *   - Horizontal
 *   - Vertical
 * 
 *   JS: Original Style:
 *   JS: Random Style
 *   JS: Horizontal Style
 *   JS: Vertical Style
 *   - This code gives you control over screen shake for this screen
 *     shake style.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Title Command List Settings
 * ============================================================================
 *
 * This plugin parameter allows you to adjust the commands that appear on the
 * title screen. Some JavaScript knowledge is needed.
 *
 * ---
 *
 * Title Command
 * 
 *   Symbol:
 *   - The symbol used for this command.
 * 
 *   STR: Text:
 *   - Displayed text used for this title command.
 *   - If this has a value, ignore the JS: Text version.
 * 
 *   JS: Text:
 *   - JavaScript code used to determine string used for the displayed name.
 * 
 *   JS: Show:
 *   - JavaScript code used to determine if the item is shown or not.
 * 
 *   JS: Enable:
 *   - JavaScript code used to determine if the item is enabled or not.
 * 
 *   JS: Ext:
 *   - JavaScript code used to determine any ext data that should be added.
 * 
 *   JS: Run Code:
 *   - JavaScript code that runs once this command is selected.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Title Picture Buttons Settings
 * ============================================================================
 *
 * These allow you to insert picture buttons on your title screen that can
 * send users to various links on the internet when clicked.
 *
 * ---
 *
 * Settings
 * 
 *   Picture's Filename:
 *   - Filename used for the picture.
 * 
 *   Button URL:
 *   - URL for the button to go to upon being clicked.
 * 
 *   JS: Position:
 *   - JavaScript code that helps determine the button's Position.
 * 
 *   JS: On Load:
 *   - JavaScript code that runs once this button bitmap is loaded.
 * 
 *   JS: Run Code:
 *   - JavaScript code that runs once this button is pressed.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: UI Settings
 * ============================================================================
 *
 * In previous iterations of RPG Maker, the Core Engine would allow you to
 * change the screen resolution. In MZ, that functionality is provided by
 * default but a number of UI settings still remain. These settings allow you
 * adjust how certain in-game objects and menus are displayed.
 *
 * ---
 *
 * UI Area
 *
 *   Fade Speed:
 *   - Default fade speed for transitions.
 *
 *   Box Margin:
 *   - Set the margin in pixels for the screen borders.
 *
 *   Command Window Width:
 *   - Sets the width for standard Command Windows.
 *
 *   Bottom Help Window:
 *   - Put the Help Window at the bottom of the screen?
 *
 *   Right Aligned Menus:
 *   - Put most command windows to the right side of the screen.
 *
 *   Show Buttons:
 *   - Show clickable buttons in your game?
 * 
 *     Show Cancel Button:
 *     Show Menu Button:
 *     Show Page Up/Down:
 *     Show Number Buttons:
 *     - Show/hide these respective buttons if the above is enabled.
 *     - If 'Show Buttons' is false, these will be hidden no matter what.
 *
 *   Button Area Height:
 *   - Sets the height for the button area.
 *
 *   Bottom Buttons:
 *   - Put the buttons at the bottom of the screen?
 *
 *   Side Buttons:
 *   - Push buttons to the side of the UI if there is room.
 * 
 *   State Icons Non-Frame:
 *   - Replace sprite frame system for non-frame.
 *   - Better for any instances where icons are zoomed.
 *
 * ---
 *
 * Larger Resolutions
 *
 * ---
 *
 * Menu Objects
 *
 *   Level -> EXP Gauge:
 *   - Draw an EXP Gauge under the drawn level.
 *
 *   Parameter Arrow:
 *   - The arrow used to show changes in the parameter values.
 *
 * ---
 *
 * Text Code Support
 *
 *   Class Names:
 *   - Make class names support text codes?
 *
 *   Nicknames:
 *   - Make nicknames support text codes?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Window Settings
 * ============================================================================
 *
 * Adjust the default settings of the windows in-game. This ranges from things
 * such as the line height (to better fit your font size) to the opacity level
 * (to fit your window skins).
 * 
 * These settings also allow you to add scroll bars to scrollable windows,
 * letting the player know how much of the window's contents there are left for
 * scrolling. The scroll bar can be enabled, disabled, have its thickness
 * changed, colors changed, etc.
 *
 * ---
 *
 * Window Defaults
 * 
 *   Enable Masking:
 *   - Enable window masking (windows hide other windows behind them)?
 *   - WARNING: Turning it on can obscure data.
 * 
 *   Correct Skin Bleed:
 *   - Allows you to enable/disable the window skin bleeding correction for
 *     those who wish to use the 95 calculator instead of 96 to augment higher
 *     and larger screen resolutions.
 *   - Read the "Bug Fixes" section if you don't understand what the window
 *     skin bleeding problem is.
 * 
 *   Line Height:
 *   - Default line height used for standard windows.
 *   - Avoid using odd numbers.
 *   - Visuals in RPG Maker and general game dev don't work well with odd
 *     numbers so avoid them unless you want your game's visuals to behave
 *     inconsistently.
 * 
 *   Item Padding:
 *   - Default line padding used for standard windows.
 *   - Avoid using odd numbers.
 *   - Visuals in RPG Maker and general game dev don't work well with odd
 *     numbers so avoid them unless you want your game's visuals to behave
 *     inconsistently.
 * 
 *   Back Opacity:
 *   - Default back opacity used for standard windows.
 *   - As of version 1.3.0, this is no longer needed.
 *   - This will still work for lower versions.
 * 
 *   Translucent Opacity:
 *   - Default translucent opacity used for standard windows.
 * 
 *   Window Opening Speed:
 *   - Default open speed used for standard windows.
 *   - Default: 32 (Use a number between 0-255)
 * 
 *   Column Spacing:
 *   - Default column spacing for selectable windows.
 *   - Default: 8
 * 
 *   Row Spacing:
 *   - Default row spacing for selectable windows.
 *   - Default: 4
 *
 * ---
 * 
 * Scroll Bar
 * 
 *   Show Scroll Bar?:
 *   - Show the scroll bar for scrollable windows?
 * 
 *   Thickness:
 *   - How thick do you want the scroll bar to be?
 * 
 *   Offset:
 *   - How much do you want to offset the scroll bar by?
 * 
 *   Bar Body Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Off Bar Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Off Bar Opacity:
 *   - What opacity value do you want the off bar opacity to be?
 *   - Use a number between 0 and 255.
 * 
 * ---
 * 
 * Selectable Items:
 * 
 *   Show Background?:
 *   - Selectable menu items have dark boxes behind them. Show them?
 * 
 *   Item Height Padding:
 *   - Default padding for selectable items.
 *   - Avoid using odd numbers.
 *   - Visuals in RPG Maker and general game dev don't work well with odd
 *     numbers so avoid them unless you want your game's visuals to behave
 *     inconsistently.
 * 
 *   JS: Draw Background:
 *   - Code used to draw the background rectangle behind clickable menu objects
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: JS: Quick Functions
 * ============================================================================
 * 
 * WARNING: This feature is highly experimental! Use it at your own risk!
 * 
 * JavaScript Quick Functions allow you to quickly declare functions in the
 * global namespace for ease of access. It's so that these functions can be
 * used in Script Calls, Control Variable Script Inputs, Conditional Branch
 * Script Inputs, Damage Formulas, and more.
 * 
 * ---
 * 
 * JS: Quick Function
 * 
 *   Function Name:
 *   - The function's name in the global namespace.
 *   - Will not overwrite functions/variables of the same name.
 * 
 *   JS: Code:
 *   - Run this code when using the function.
 * 
 * ---
 * 
 * If you have a Function Name of "Example", then typing "Example()" in a
 * Script Call, Conditional Branch Script Input, or similar field will yield
 * whatever the code is instructed to return.
 * 
 * If a function or variable of a similar name already exists in the global
 * namespace, then the quick function will be ignored and not created.
 * 
 * If a quick function contains bad code that would otherwise crash the game,
 * a fail safe has been implemented to prevent it from doing so, display an
 * error log, and then return a 0 value.
 * 
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 *
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.85: October 17, 2024
 * * Feature Updates!
 * ** Updated to fit RPG Maker MZ version 1.8.1 better.
 * 
 * Version 1.84: August 29, 2024
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New notetags added by Arisu:
 * *** Tileset Notetag: <Taller By x: id>
 * **** Changes any page B, C, D, E tile marked by terrain tag 'id' to be
 *      taller by 'x' tiles.
 * **** When placing these tiles on the map, all you have to do is just place
 *      the bottom tile.
 * ***** ie.: For a tree that's one tile taller, just place the tile at the
 *       bottom where you see the trunk. Then, in-game, the tree will appear
 *       taller by one tile as marked.
 * **** O/X layer tiles have a special property where tall sprites standing in
 *      front of it will no longer clip the top of the sprite, while sprites
 *      standing behind it will be covered by it.
 * **** This does not work with events using tiles as graphics. Instead, if
 *      you want to do similar, use the Event & Movement Core's <Tile Expand>
 *      notetags for better control.
 * 
 * Version 1.83: June 13, 2024
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Updated documentation for <param Max: x> notetag.
 * *** This does not set the max cap to be lower than the default cap.
 * * New Feature!
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > UI Settings > State Icons Non-Frame
 * **** Replace sprite frame system for non-frame.
 * **** Better for any instances where icons are zoomed.
 * 
 * Version 1.82: April 18, 2024
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Added failsafe for $textPopup when some windows have not been initialized
 *    and requesting the text popup.
 * * New Feature!
 * ** New Plugin Parameter and playtest shortcut added by Arisu:
 * *** Plugin Parameters > QoL Settings > Playtest > CTRL + n: Quick Load
 * **** CTRL + a number from 1 to 9 will yield a quick load of that save file.
 * **** Does not count auto saves.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.81: February 15, 2024
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added for future plugin: VisuMZ_2_BattleGridSystem
 * *** <Grid>
 * *** <No Grid>
 * **** Requires the future plugin VisuMZ_2_BattleGridSystem!
 * **** Read the help section for more information on these.
 * ** New Plugin Parameter added by Arisu:
 * *** Plugin Parameters > Window > Correct Skin Bleed
 * **** Allows you to enable/disable the window skin bleeding correction for
 *      those who wish to use the 95 calculator instead of 96 to augment higher
 *      and larger screen resolutions.
 * **** Read the "Bug Fixes" section if you don't understand what the window
 *      skin bleeding problem is.
 * 
 * Version 1.80: January 18, 2024
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Auto Save After New Game
 * **** Normally, when starting a new game through the "New Game" option, there
 *      is no auto save trigger. However, if you start a new game or load a
 *      saved game, then go to the Game End screen, return back to the title
 *      screen, then start a New Game, the auto save trigger occurs when it
 *      shouldn't. The Core Engine will now patch this and prevent the trigger
 *      from taking place.
 * 
 * Version 1.79: November 16, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Plugin Command added by Arisu:
 * ** Text Popup: Show Text
 * *** Adds text to a text popup window to briefly appear.
 * *** Multiple text popups will be queued.
 * *** Does not halt the game and works parallel to game activity.
 * 
 * Version 1.78: October 12, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Olivia and sponsored by AndyL:
 * *** QoL Settings > Battle Test > Shift+R: Recover All
 * **** For Play Test only! During battle, pressing SHIFT + R will refill the
 *      whole party's HP and MP and status.
 * *** QoL Settings > Battle Test > Shift+T: Full TP
 * **** For Play Test only! During battle, pressing SHIFT + T will refill the
 *      whole party's TP.
 * 
 * Version 1.77: August 17, 2023
 * * Bug Fixes!
 * ** Fixed a bug that would cause the BGS related Plugin Commands to crash.
 *    Fix made by Arisu.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Scroll-Linked Pictures now work if the image file are in a folder within
 *    the img/pictures/ folder without the folder needing a ! at the start.
 * * New Features!
 * ** New Plugin Commands added by Arisu:
 * *** Picture: Rotate by Angle
 * **** Rotates target picture by a amount angle over a set duration instead of
 *      continuously.
 * **** View help file for more information on the Plugin Command.
 * *** Picture: Rotate to Angle
 * **** Rotates target picture to a certain angle over a set duration instead
 *      of continuously.
 * **** View help file for more information on the Plugin Command.
 * ** New Plugin Parameter added by Irina:
 * *** Parameters > Menu Button Assist > General > Split "Escape":
 * **** Used ONLY for those making their own custom keyboard key input maps.
 * **** "Split" option makes separate instances of "Cancel" and "Menu" keys.
 * **** "Don't" option will consolidate both into "Escape" keys.
 * 
 * Version 1.76: June 15, 2023
 * * Bug Fixes!
 * ** Fixed a bug that displayed the incorrect button press key for name input
 *    processing's cancel action. Fix made by Olivia.
 * 
 * Version 1.75: March 16, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** In Scene_Name, when using the Keyboard Input, the button assist windows
 *    will no longer display the keyboard shortcuts for Ok and Cancel, but
 *    instead, show them for ENTER and BKSP. Update made by Arisu.
 * ** In Scene_Name, when manual inputting, the Page Up/Dn keys are now
 *    displayed to show changing character pages.
 * * New Features!
 * ** New Plugin Parameters added by Arisu and sponsored by AndyL:
 * *** Params > Keyboard Input > Button Assist > Finish Entry
 * **** Text used to describe finish entry.
 * *** Params > Keyboard Input > Button Assist > Page Change
 * **** Text used to describe changing character pages.
 * *** Params > Window Settings > Scroll Bar
 * **** These settings also allow you to add scroll bars to scrollable windows,
 *      letting the player know how much of the window's contents there are
 *      left for scrolling. The scroll bar can be enabled, disabled, have its
 *      thickness changed, colors changed, etc.
 * 
 * Version 1.74: February 16, 2023
 * * Compatibility Update!
 * ** Plugin Commands for: Audio: Change Current BGM/BGS Volume/Pitch/Pan
 *    should now work properly with the updated RPG Maker MZ version and
 *    WebAudio changes. Update made by Arisu.
 * 
 * Version 1.73: January 20, 2023
 * * Compatibility Update!
 * ** Added better Effekseer version compatibility.
 * 
 * Version 1.72: December 15, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Skill List Active After Party Member Change
 * **** If the skill list is active (ie. the player can move the cursor around)
 *      and the party member currently being viewed is changed via the button
 *      commands, then previously, RPG Maker MZ would still have that window be
 *      active despite having the cursor hidden temporarily. Upon pressing
 *      direction buttons, the cursor reveals itself and both the skill type
 *      window and skill list window are both active, making way for lots of
 *      potential problems to happen.
 * ** Water Tile Bug
 * *** It seems like there's a new bug that occurs if you create a tileset from
 *     scratch in RPG Maker MZ version 1.5.0+ and version 1.6.0+! What this bug
 *     does is it causes many tiles to become water tiles without intending to.
 *     You can find this out by turning off all the plugins in your project,
 *     putting a Ship or Boat on what are normally ground tiles, and then
 *     seeing the Ship or Boat traverse through it.
 * *** There are two ways to fix this. We cannot fix it through code in this
 *     plugin as it's a problem that involves the tileset json data there are
 *     ways to work around it so that you can get the proper water-flags to go
 *     where they need to be at.
 * **** 1. Copy a working un-bugged tileset onto the currently bugged one and
 *      reapply the tile features like passability, terrain tags, etc. This
 *      will make sure the water-passability tiles get copied over correctly.
 * **** 2. If you're on RPG Maker MZ version 1.5.0 or above, select a working
 *      un-bugged tileset (usually a pre-existing tileset when a new project is
 *      made), click the "Copy Page" button, go to the bugged tileset and press
 *      "Paste Page". You'll have to reapply any different properties like
 *      passabilities and terrain tags, but the water tile flags should now be
 *      working properly.
 * *** The plugin will not fix the problem itself since flag data is delicate
 *     and should not be tampered with midgame as the changes made by the
 *     plugin might not match the desired settings.
 * *** This plugin, however, will also send out an alert message when coming
 *     across such a tile. Pay attention to it and do one of the following two
 *     steps above to fix the problem.
 * * Documentation Update!
 * ** Added "Skill List Active After Party Member Change" section to the
 *    "Important Changes: Bug Fixes" section of the help file.
 * ** Added "Water Tile Bug" section to the "Important Changes: Bug Fixes"
 *    section of the help file.
 * ** Help file updated for new features.
 * * New Feature!
 * ** New Plugin Parameter added by Irina:
 * *** Plugin Parameters > Menu Backgrounds > Blur Strength
 * **** Strength used for menu background snapshots.
 * 
 * Version 1.71: November 10, 2022
 * * Bug Fixes!
 * ** Title Command Window should now allow for more than 4 custom commands
 *    without hidden commands. Fix made by Irina.
 * ** Fixed a problem with repeating animations from Visual State Effects
 *    causing softlocks. Fix made by Olivia.
 * 
 * Version 1.70: October 6, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** A texture check will now occur for sprites that are being removed and
 *     destroyed in order to prevent crashes. In the off chance that someone
 *     creates a sprite through a script call and removes it through such, the
 *     likelihood of this occurance becomes higher. This makes the destroy
 *     property take into account a texture check in order to see if the sprite
 *     removal is taking extra steps and will reduce those extra steps.
 * * Documentation Update!
 * ** Added "Sprite Removal and Destroy Crash" section to the "Important
 *    Changes: Bug Fixes" section.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.69: September 8, 2022
 * * Bug Fixes!
 * ** Fixed the combination of Button Assist Location: Top with Help Location:
 *    Bottom combination not working properly. Fix made by Irina.
 * 
 * Version 1.68: August 4, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Commands added by Olivia and sponsored by Archeia:
 * *** Audio: Change Current BGM Volume
 * *** Audio: Change Current BGM Pitch
 * *** Audio: Change Current BGM Pan
 * *** Audio: Change Current BGS Volume
 * *** Audio: Change Current BGS Pitch
 * *** Audio: Change Current BGS Pan
 * **** Changes the current BGM/BGS volume/pitch/pan without changing any of
 *      the current BGM/BGS's other properties and without restarting BGM/BGS.
 * 
 * Version 1.67: July 28, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added notes for Line Height and Item Padding parameters:
 * *** Avoid using odd numbers.
 * *** Visuals in RPG Maker and general game dev don't work well with odd
 *     numbers so avoid them unless you want your game's visuals to behave
 *     inconsistently.
 * *** This setting will be disabled if the map is zoomed in.
 * * New Features!
 * ** New map notetags added by Irina and sponsored by AndyL:
 * *** <Scroll Lock X>
 * *** <Scroll Lock X: x>
 * *** <Scroll Lock Y>
 * *** <Scroll Lock Y: y>
 * **** Causes the map to not scroll left/right(x) or up/down(y). Useful for
 *      when maps are just slightly smaller than normal and the tiny scrolling
 *      is distracting.
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Screen Resolution > Maps > Scroll Lock Small X?
 * *** Plugin Parameters > Screen Resolution > Maps > Scroll Lock Small Y?
 * *** Plugin Parameters > Screen Resolution > Maps > Locked Display X?
 * *** Plugin Parameters > Screen Resolution > Maps > Locked Display Y?
 * **** Automatically scroll locks small maps to prevent them from scrolling
 *      horizontally/vertically. Useful for 1280x720 resolutions when the map
 *      is 27 tiles wide. This will get rid of the subtle scrolling when moving
 *      from one half of the screen to the other.
 * **** This setting will be disabled if the map is zoomed in.
 * * Feature Update!
 * ** Warnings added to Line Height and Item Padding parameters:
 * *** Avoid using odd numbers.
 * *** Visuals in RPG Maker and general game dev don't work well with odd
 *     numbers so avoid them unless you want your game's visuals to behave
 *     inconsistently.
 * 
 * Version 1.66: July 14, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Debug Console Refresh Bug
 * **** When pressing F5 to refresh while the debug console (DevTools) is open,
 *      some graphics will fail to load properly. This started occurring since
 *      the RPG Maker MZ 1.5.0 update and the code for loading the images has
 *      now been reverted to the 1.4.4 version where it was last stable.
 * * Documentation Update!
 * ** Help file updated for new major bug fix.
 * 
 * Version 1.65: June 30, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Irina:
 * *** Plugin Parameters > Parameter Settings > Show Actor Level?
 * **** Show the actor level when displaying actors?
 * **** Used for most windows in-game.
 * 
 * Version 1.64: June 9, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Command made by Arisu and sponsored by
 *    ImGonnaPutMyGameOnXboxAndYouCantStopMe:
 * *** Debug: Current Controller ID
 * **** PLAY TEST ONLY. Shows current controller ID in debug console.
 * **** Also copies to computer clipboard if possible.
 * ** New Plugin Parameters made by Arisu and sponsored by
 *    ImGonnaPutMyGameOnXboxAndYouCantStopMe:
 * *** Subsettings for Button Assist Window: Controller Button Assist
 * **** These are sub-settings for the Button Assist Window Plugin Parameters.
 *      Where the Button Assist Window Plugin Parameters are focused on
 *      keyboard entries, these sections are focused on gamepad controllers.
 * **** Add multiple gamepads to the list to give them different button assist
 *      text. If a gamepad is being used but not listed here, the button assist
 *      text will default to the keyboard version.
 * 
 * Version 1.63: May 2, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Irina:
 * *** Plugin Parameters > QoL Settings > Misc > Map Name Text Code
 * **** If on, map names will use text codes.
 * **** If off, only the raw map name will be used.
 * * Feature Update!
 * ** The map name text code change will no longer be on forcefully. It is now
 *    something that can be toggled by Plugin Parameters. Update by Irina.
 * 
 * Version 1.62: April 28, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Commands added by Arisu and sponsored by Archeia:
 * *** Variable: JS Eval
 * **** Pick a variable ID and value to alter through JS.
 * **** Allows one line of code for variable ID and operand.
 * **** Functions like RM2k3's Variable Pointers.
 * *** Variable: JS Block
 * **** Pick a variable ID and value to alter through JS.
 * **** Allows JS block code for variable ID and operand.
 * **** Functions like RM2k3's Variable Pointers.
 * ** Map names can now use text codes. Made by Arisu and sponsored by Archeia.
 * 
 * Version 1.61: April 21, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Battle Forced End Action Crash
 * **** Depending on various circumstances, currently active battlers can be
 *      cleared from the battle system at will due to a number of reasons.
 *      However, if it just so happens that the targets are cleared, too, with
 *      actions remaining, then a crash will follow up. This plugin will
 *      prevent that change. Fix made by Olivia.
 * 
 * Version 1.60: April 14, 2022
 * * Bug Fixes!
 * ** Number Input window will now respond to Home/End keys properly.
 *    Fix made by Olivia.
 * 
 * Version 1.59: April 7, 2022
 * * Compatibility Update!
 * ** RPG Maker MZ 1.4.4 compatibility update!
 * *** "Shutdown" command should now be more compatible with other aspects of
 *     the client when running from Node JS client on other OS's.
 * 
 * Version 1.58: March 24, 2022
 * * Feature Update!
 * ** Plugin Commands now have separators for easier selection.
 * 
 * Version 1.57: March 3, 2022
 * * Compatibility Update!
 * ** The "Shutdown" command from the title screen should now be compatible
 *    with RPG Maker MZ 1.4.4 and up. Update made by Olivia.
 * 
 * Version 1.56: February 10, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New features added by Arisu and sponsored by Anon:
 * *** Plugin Parameters > QoL > Misc > Shortcut Scripts
 * **** Enables shortcut-based script variables and functions that can be used
 *      for script calls.
 * **** Shortcut list enabled for this is as follows:
 * ***** $commonEvent(id), $onceParallel(id), $scene, $spriteset, $subject, 
 *       $targets, $target, $event
 * ***** For more information on how to use them, review the help file.
 * 
 * Version 1.55: January 27, 2022
 * * Feature Update!
 * ** Once Parallels for the map are now able to update even while other events
 *    are running. Update made by Arisu.
 * 
 * Version 1.54: January 13, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Overly-Protective Substitute
 * *** When an ally with critical health is being targeted by a friendly non-
 *     Certain Hit skill (such as a heal or buff) and another ally has the
 *     substitute state, the other ally would "protect" the originally targeted
 *     ally and take the heal or buff.
 * *** The new changed behavior is that now, substitute will not trigger for
 *     any actions whose scope targets allies.
 * *** Fix made by Olivia.
 * * Documentation Update!
 * ** Added documentation for new MZ Bug: Overly-Protective Substitute.
 * * Feature Update!
 * ** Added a failsafe for those who did not update the plugin parameter
 *    settings and are using MV Animations.
 * 
 * Version 1.53: December 30, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Notetag added by Olivia:
 * *** <Rate: x>
 * **** Allows you to adjust the update for this MV Animation.
 * ***** Does NOT work with Effekseer animations.
 * **** The lower the number, the faster.
 * **** Replace 'x' with a number representing the animation update rate.
 * ***** Default rate: 4.
 * ***** Minimum rate: 1.
 * ***** Maximum rate: 10.
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Qualify of Life Settings > MV Animation Rate
 * **** Adjusts the rate at which MV animations play.
 * **** Default: 4. Lower for faster. Higher for slower.
 * * Optimization Update!
 * ** MV Animations should run more optimized.
 * 
 * Version 1.52: December 16, 2021
 * * Compatibility Update!
 * ** RPG Maker MZ 1.4.0 compatibility update!
 * *** MV Animations played on screen level will now show up properly in the
 *     center of the screen.
 * 
 * Version 1.51: December 9, 2021
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** In the battle status windows, whenever actor names are displayed, the
 *     bitmap used to display their name text do not extend vertically all the
 *     way, causing letters like lowercase "Q" and "G" to be cut off, making
 *     them hard to distinguish from one another. The Core Engine will remedy
 *     this by extending the bitmap to allow enough room. Fix made by Irina.
 * 
 * Version 1.50: November 4, 2021
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** By default, if the attack skill is sealed via a trait and an actor has
 *     auto-battle, the action can still be used via auto-battle. This is now
 *     fixed and actors should not be able to attack via auto-battle if their
 *     attack ability is sealed. Fix made by Yanfly.
 * * Documentation Update!
 * ** Help file updated for new RPG Maker MZ bug fix.
 * 
 * Version 1.49: October 28, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New Plugin Command added by Arisu and sponsored by Anon:
 * *** Map: Once Parallel
 * **** Plays a Common Event parallel to the event once without repeating
 *      itself when done. Map only!
 * **** When exiting map scene or changing maps, all Once Parallels are cleared
 * **** Once Parallels are not retained upon reentering the scene or map.
 * **** Once Parallels are not stored in memory and cannot be saved.
 * 
 * Version 1.48: October 21, 2021
 * * Feature Update!
 * ** Bitmap.blt function will now have source coordinates and destination X
 *    and Y coordinates rounded to prevent blurring. Update made by Olivia.
 * 
 * Version 1.47: October 14, 2021
 * * Bug Fixes!
 * ** Prevents Number Input window from having a NaN value due to holding down
 *    the fast forward key. Fix made by Arisu.
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New Plugin Parameter added by Yanfly:
 * *** Plugin Parameters > QoL Settings > Misc > Font Width Fix
 * **** Fixes the font width issue with non-monospaced fonts in the Message
 *      Window. This is now an optional fix.
 * 
 * Version 1.46: September 23, 2021
 * * Documentation Update!
 * ** Added line to Plugin Command: "System: Battle System Change":
 * *** Some battle systems REQUIRE their specific plugins!
 * ** Added lines to "Plugin Parameters: Battle System":
 * *** Some battle systems REQUIRE their specific plugins! This means if you do
 *     not have the required battle system plugin installed, it will not change
 *     over. The Core Engine plugin does not contain data for all of the battle
 *     systems inside its code.
 * 
 * Version 1.45: September 17, 2021
 * * Bug Fixes!
 * ** Fixed a problem with "Picture: Coordinates Mode" to properly utilize the
 *    correct picture ID. Fix made by Arisu.
 * ** RPG Maker MZ Bug Fix:
 * *** Instant Text Discrepancy for Window_Message
 * **** Window_Message displays text differently when it draws letters one by
 *      one versus when the text is displayed instantly. This isn't noticeable
 *      with the default font, but it's very visible when using something like
 *      Arial. The error is due to Bitmap.measureTextWidth yielding a rounded
 *      value per letter versus per word. The Core Engine will provide a bug
 *      fix that will single out the cause and make it so that only
 *      Window_Message will not utilize any round number values when
 *      determining the width of each letter, whether or not it is shown
 *      instantly. This change will only affect Window_Message and not any
 *      other window in order to prevent unintended side effects.
 * **** Fix made by Yanfly.
 * * Compatibility Update!
 * ** RPG Maker MZ 1.3.3 compatibility.
 * *** Updated how gauges are drawn.
 * * Documentation Update!
 * ** Help file updated for new RPG Maker MZ bug fix.
 * 
 * Version 1.44: August 20, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Command added by Irina and sponsored by Anon.
 * *** "Animation: Play at Coordinate"
 * **** Plays an animation on the screen at a specific x, y coordinate even if
 *      there is no sprite attached.
 * 
 * Version 1.43: July 23, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Command added by Irina and sponsored by Archeia!
 * *** "Picture: Coordinates Mode"
 * **** Play Test Mode only!
 * **** Gets the coordinates of a specific picture as you move it across the
 *      screen.
 * **** Helpful for those who don't want to do guess work on the screen
 *      coordinates when it comes to placing down pictures.
 * 
 * Version 1.42: July 16, 2021
 * * Documentation Update
 * ** Added text to "Plugin Parameters: Color Settings" for clarification:
 * *** If the game's Window Skin is changed mid-game, the colors used will
 *     still be based off the default Window Skin's colors. This is due to
 *     storing them in a cache and preventing extra processing and reduces lag.
 * 
 * Version 1.41: July 2, 2021
 * * Compatibility Update
 * ** Further compatibility update with RPG Maker MZ 1.3.0+.
 * * Documentation Update
 * ** Added extra notes to "Important Changes: Bug Fixes" section for the
 *    "Window Skin Bleeding" bug:
 * *** This bug is fixed in the core scripts for RPG Maker MZ v1.3.0+.
 * 
 * Version 1.40: June 25, 2021
 * * Compatibility Update
 * ** Compatibility update with RPG Maker MZ 1.3.0+.
 * * Documentation Update:
 * ** Plugin Parameters > Window Settings > Back Opacity
 * *** As of version 1.3.0, this is no longer needed.
 * *** This will still work for lower versions.
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Window Skin Bleeding fix updated to newest version.
 * * New Plugin Parameters added:
 * ** Plugin Parmaeters > Screen Resolution Settings
 * *** These settings have been moved from the UI settings to be its own thing.
 * **** This is mostly for RPG Maker MZ version 1.3.0 and up where the Troops
 *      tab has been updated to match the screen resolution settings found in
 *      the System 2 Database tab.
 * *** Reposition Enemies > For MZ 1.3.0+?
 * **** Both of these plugin parameters need to be set to true in order for the
 *      repositioning to work for MZ v1.3.0.
 * **** If the Core Script is below 1.3.0, this setting is ignored. This does
 *      not take into account what version the editor is on. Pay attention to
 *      that as the plugin will not auto adjust for it.
 * 
 * Version 1.39: June 18, 2021
 * * Bug Fixes!
 * ** Number Inputs should now work with the controller if keyboard Number
 *    Input is enabled. Fix made by Olivia.
 * ** RPG Maker Bug: Termination Clear Effects
 * *** In RPG Maker MZ, requesting an animation while transitioning between
 *     scenes, such as going from the map scene to the battle scene, can cause
 *     crashes. This is because the animation queue does not take off
 *     immediately and will likely register incorrect targets for the scene.
 *     This plugin will forcefully clear any registered animations and balloon
 *     effects when terminating a scene in order to prevent crashes.
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <Battle View: x> Troop Name tags can now work with comment tags.
 * ** <Battle System: x> Troop Name tags can now work with comment tags.
 * *** Updates made by Irina.
 * 
 * Version 1.38: June 11, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Command added by Irina and sponsored by Caz!
 * *** Picture: Show Icon
 * **** Shows an icon instead of a picture image.
 * **** The picture icon can be controlled like any other picture.
 * 
 * Version 1.37: May 21, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Commands added by Arisu:
 * *** Switches: Randomize ID(s)
 * *** Switches: Randomize Range
 * *** Switches: Toggle ID(s)
 * *** Switches: Toggle Range
 * **** These Plugin Commands allow you to randomize the ON/OFF positions of
 *      switches or toggle them so that they flip their ON/OFF status.
 * 
 * Version 1.36: May 14, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Commands added by Irina:
 * *** Export: All Maps Text
 * *** Export: All Troops Text
 * *** Export: Current Map Text
 * *** Export: Current Troop Text
 * **** Play Test Only Plugin Commands. These Plugin Commands are used for
 *      extracting all messages, show choices, comments, and scrolling text to
 *      parse and export them as a TXT file. Useful for getting a game's script
 *      to a voice actor or voice actress.
 * 
 * Version 1.35: May 7, 2021
 * * Documentation Update!
 * ** Added the following text to "Parameter Settings" Plugin Parameters for
 *    extra clarity regarding Parameter Caps:
 * *** These settings DO NOT raise the editor's maximum values. If you want to
 *     raise an enemy's maximum parameter value past their default cap, use the
 *     associated notetag for them instead.
 * 
 * Version 1.34: April 23, 2021
 * * Bug Fixes!
 * ** For the vanilla Equip Status window, custom parameters with integer
 *    values will now show up as integers and not percentiles. Fix by Olivia.
 * * Documentation Update!
 * ** Added clarity to the <param: x> notetag for enemies.
 * *** This notetag does NOT work with X Parameters, S Parameters, or any
 *     custom parameters. This notetag ONLY works with the base parameters.
 * 
 * Version 1.33: April 9, 2021
 * * Bug Fixes!
 * ** RPG Maker MZ Bug: Window Skin Bleeding
 * *** Since the v1.2.0 update, Window.prototype._refreshBack's frame value has
 *     been set from 96 to 95. This results in the window skin bleeding past
 *     the window's intended borders. The Core Engine now reverts this change
 *     to prevent the bleeding effect from happening.
 * * Feature Update!
 * ** "Encounter Rate Minimum" now has a valid minimum value of 1. Update made
 *    by Olivia.
 * 
 * Version 1.32: April 2, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Yanfly:
 * *** Plugin Parameters > QoL Settings > Battle Test > Add Item Type
 * *** Plugin Parameters > QoL Settings > Battle Test > Add Weapon Type
 * *** Plugin Parameters > QoL Settings > Battle Test > Add Armor Type
 * *** Plugin Parameters > QoL Settings > Battle Test > Added Quantity
 * **** By default, RPG Maker MZ only adds 99 of items and not weapons or armor
 *      making it awkward for testing specific battle mechanics. These settings
 *      allow you to add in custom amounts of items, weapons, and/or armors if
 *      you so wish.
 * 
 * Version 1.31: March 26, 2021
 * * Feature Update!
 * ** Title screen buttons will now become fully opaque when hovered over them
 *    instead of only when pressed. Update made by Yanfly.
 * 
 * Version 1.30: March 19, 2021
 * * Bug Fixes!
 * ** RPG Maker MZ Bug: Invisible Battle Sprites
 * *** If you removed a party member during battle and added that exact party
 *     member back into the same slot, their sprite would appear invisible. The
 *     VisuStella Core Engine will fix this problem and prevent it from
 *     happening. Fix made by Olivia.
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Arisu:
 * *** Plugin Parameters > QoL Settings > Misc > Ani: Mirror Offset
 * **** When animations are mirrored, mirror their Offset X values, too.
 * ** New animation name tags added by Arisu:
 * *** <Mirror Offset X> and <No Mirror Offset X>
 * **** If these text tags are placed in an animation's name, it will cause the
 *      offset X value to be mirrored when the animation is mirrored or have it
 *      ignored despite being mirrored.
 * 
 * Version 1.29: March 12, 2021
 * * Bug Fixes!
 * ** RPG Maker MZ Bug: Interactable window client area does not conform to the
 *    window's declared scale when the scale is anything but 1.0. This will now
 *    be fixed through this plugin. Fix made by Olivia.
 * * Documentation Update!
 * ** Added documentation for new RPG Maker MZ bug fixes!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** Name Input should be more controller-friendly. If a controller is
 *    connected upon entering the name change scene, it will use the default
 *    manual-entry mode instead of the keyboard-entry mode. If a controller
 *    button is pressed during the keyboard-entry mode, it will automatically
 *    switch to the manual-entry mode.
 * ** This plugin does not provide support for controllers that are undetected
 *    by RPG Maker MZ's default controller support.
 * ** This feature was already implemented since version 1.27 but wasn't
 *    documented so here we are. Update made by Irina.
 * 
 * Version 1.28: March 5, 2021
 * * Bug Fixes!
 * ** RPG Maker MZ Bug: The arrows drawn by a window skin will no longer by
 *    placed on a half pixel when a window's size is an odd number. This would
 *    cause sprite tearing problems and look awful. Fix made by Irina.
 * * Documentation Update!
 * ** Added documentation for new RPG Maker MZ bug fixes!
 * 
 * Version 1.27: February 26, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Moved "Show Scrolling Text, additional functionality" section from Bug
 *    Fixes to Major Changes as it was placed in the wrong section.
 * * New Features!
 * ** New Plugin Parameter added by Yanfly.
 * *** Plugin Parameters > Keyboard Input > Name Input > Banned Words
 * **** Insert words you don't want your players to use for character names.
 * 
 * Version 1.26: February 19, 2021
 * * Bug Fixes!
 * ** Certain Plugin Parameters no longer have settings that restrict them to
 *    a maximum of 1. Fix made by Arisu.
 * * Feature Update!
 * ** Changed the default value for a New Game > Common Event upon Play Testing
 *    to 0 to prevent confusion. Update made by Arisu.
 * 
 * Version 1.25: February 5, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** Show Scrolling Text, additional functionality added by Arisu
 * *** The event command "Show Scrolling Text" now has additional functionality
 *     as long as the VisuStella MZ Core Engine is installed. If the game dev
 *     inserts "// Script Call" (without the quotes) inside the scrolling text,
 *     then the entirity of the Show Scrolling Text event command will be ran
 *     as a giant script call event command.
 * *** The reason why this functionality is added is because the "Script..."
 *     event command contains only 12 lines maximum. This means for any script
 *     call larger than 12 lines of code cannot be done by normal means as each
 *     script call is ran as a separate instance.
 * *** By repurposing the "Show Scrolling Text" event command to be able to
 *     function as an extended "Script..." event command, such a thing is now
 *     possible with less hassle and more lines to code with.
 * *** This effect does not occur if the Show Scrolling Text event command does
 *     not have "// Script Call" in its contents.
 * 
 * Version 1.24: January 29, 2021
 * * Documentation Update!
 * ** Plugin Parameters: Custom Parameters Settings added the following note:
 * *** For clarification, these settings do NOT create brand-new parameters for
 *     you to use and add to your game nor are the bonuses supported by other
 *     plugins in the VisuStella MZ library. These settings exist to function
 *     as a bridge for non-VisuStella MZ plugins that have created their own
 *     parameter values and to show them inside VisuStella menus.
 * * Feature Update!
 * ** Default JS Plugin Parameter for the Title Command: "Shutdown" now has a
 *    note in it that reads: "Do NOT use this command with mobile devices or
 *    browser games. All it does is cause the game to display a blank, black
 *    canvas which the player is unable to do anything with. It does NOT force
 *    close the browser tab nor the app."
 * *** This is also why this command is disabled by default for any non-NodeJS
 *     client deployed game versions.
 * ** Disabled some bug fixes made by the Core Engine for the default RMMZ code
 *    base since the 1.1.1 version now contains those very same fixes.
 * 
 * Version 1.23: January 22, 2021
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.22: January 15, 2021
 * * Documentation Update!
 * ** Added documentation for new RPG Maker MZ bug fixes!
 * * Bug Fixes!
 * ** RPG Maker MZ Bug: Sprite_Timer is added to the spriteset for the parent
 *    scene, making it affected by any filers, zooms, and/or blurs, hindering
 *    its readability.
 * 
 * Version 1.21: January 8, 2021
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Plugin Parameters > Keyboard Input > Controls > WASD Movement
 * *** Plugin Parameters > Keyboard Input > Controls > R Button: Dash Toggle
 * 
 * Version 1.20: January 1, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.19: December 25, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s) and feature updates!
 * * Bug Fixes!
 * ** Fixed typo inside of the comments inside the JS: Quick Functions.
 * * Feature Update!
 * ** Plugin Parameters > Color Settings > Outline Color is now renamed to
 *    Font Outline.
 * * New Features!
 * ** New Plugin Parameters added by Shaz!
 * *** Plugin Parameters > Color Settings > Gauge Number Outline
 * 
 * Version 1.18: December 18, 2020
 * * Bug Fixes!
 * ** Compatible string text from the Items and Equips Core will no longer
 *    register MaxHP and MaxMP as percentile values for the info window.
 * ** RPG Maker MZ Bug: Gamepads no longer go rapidfire after a cleared input.
 *    There is now a period of delay for gamepads after an input clear.
 * ** RPG Maker MZ Bug: Unusable items on an individual-actor basis will no
 *    longer be overwritten by party-based usability for battle. Fix by Yanfly.
 * ** RPG Maker MV animations will no longer crash for unplayable sound
 *    effects. Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * ** Added documentation for new RPG Maker MZ bug fixes!
 * * New Features!
 * ** New Plugin Parameters added by Yanfly!
 * *** Plugin Parameters > Button Assist > Key: Shift
 * *** Plugin Parameters > Button Assist > Key: Tab
 * **** These let you assign text codes to the Shift and Tab buttons for the
 *      Button Assist windows.
 * *** Plugin Parameters > QoL Settings > Misc > NewGame > CommonEvent
 * **** For an all version (including non-play test) common event to start new
 *      games with.
 * 
 * Version 1.17: December 11, 2020
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.16: December 4, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** Button Assist Window for the change name scene will now default to "Tab"
 *    for switching between both modes. Update made by Yanfly.
 * * New Features!
 * ** New Plugin Parameter added by Yanfly:
 * *** Plugin Parameters > Keyboard Input > Default Mode
 * **** Select default mode when entering the scene.
 * 
 * Version 1.15: November 29, 2020
 * * Bug Fixes!
 * ** Pressing "Enter" in the change name scene while the actor's name is
 *    completely empty will no longer result in endless buzzer sounds. Fix made
 *    by Arisu.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** For the name change scene, the "Tab" key now also lets the user switch
 *    between the two modes. Update made by Yanfly.
 * * New Features!
 * ** Two new plugin parameters added to Keyboard Input:
 * *** "Switch To Keyboard" and "Switch To Manual"
 * **** These determine the text used for the button assist window when
 *      switching between the two modes. Update made by Yanfly.
 * **** Button Assist window now takes into consideration for these texts.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.14: November 22, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Plugin Command added by Yanfly!
 * *** System: Load Images
 * **** Allows you to (pre) load up images ahead of time.
 * 
 * Version 1.13: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.12: November 8, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** Screen Shake Plugin Parameters and JS: Quick Function Plugin Parameters
 *    have been taken off experimental status.
 * * New Features!
 * ** New plugin parameters added by Arisu.
 * *** Plugin Parameters > Keyboard Input
 * **** Settings for the game that utilize keyboard input. These are primarily
 *      for the name input scene (Scene_Name) and the number input event
 *      command. These settings have only been tested on English keyboards and
 *      may or may not be compatible with other languages, so please disable
 *      these features if they do not fit in with your game.
 * 
 * Version 1.11: November 1, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Feature Update!
 * ** Bitmap smoothing now takes into consideration for rounding coordinates.
 *    Update made by Irina.
 * 
 * Version 1.10: October 25, 2020
 * * Feature Update!
 * ** Sprite animation location now adjusts position relative to the sprite's
 *    scale, too. Update made by Arisu.
 *
 * Version 1.09: October 18, 2020
 * * Bug Fixes!
 * ** RPG Maker MZ Bug: Auto Battle Lock Up. Fixed by Yanfly.
 * *** If an auto battle Actor fights against an enemy whose DEF/MDF is too
 *     high, they will not use any actions at all. This can cause potential
 *     game freezing and softlocks. This plugin will change that and have them
 *     default to a regular Attack.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.08: October 11, 2020
 * * Feature Update!
 * ** Altered sprite bitmaps via the various draw functions will now be marked
 *    as modified and will automatically purge themselves from graphical memory
 *    upon a sprite's removal to free up more resources. Change made by Yanfly.
 * ** Picture Sprite Origin anchors are now tied to the Game_Picture show and
 *    move commands instead of the Game_Interpretter commands. Change by Arisu.
 * 
 * Version 1.07: October 4, 2020
 * * Documentation Update!
 * ** New documentation added for the new Plugin Parameter category:
 *    "Custom Parameters".
 * * New Features!
 * ** New Plugin Parameter "Custom Parameters" added by Yanfly.
 * *** Create custom parameters for your game! These will appear in
 *     VisuStella MZ menus.
 * 
 * Version 1.06: September 27, 2020
 * * Bug Fixes!
 * ** Battler evasion pose can now occur if there is a miss. These were made
 *    separate in RPG Maker MZ and misses didn't enable the evasion pose. Fix
 *    made by Olivia.
 * * New Features!
 * ** New notetags for Maps and name tags for Troops added by Yanfly!
 * *** <Frontview>, <Sideview> to change the battle view for that specific map,
 *     or troop regardless of what other settings are.
 * *** <DTB>, <TPB Active>, <TPB Wait> to change the battle system for that
 *     specific map or troop regardless of what other settings are.
 * 
 * Version 1.05: September 20, 2020
 * * Bug Fixes!
 * ** <Level: x> notetag for enemies is now fixed! Fix made by Arisu.
 * * Documentation Update!
 * ** Documentation added for the new "System: Battle System Change" Plugin
 *    Command and removed the old "System: Set Time Progress Battle".
 * * Feature Update!
 * ** The Plugin Command "System: Set Time Progress Battle" has been replaced
 *    with "System: Battle System Change" instead. This is to accommodate
 *    future plugins that allow for different battle systems. Added by Yanfly.
 * *** If you have previously used "System: Set Time Progress Battle", please
 *     replace them. We apologize for the inconvenience.
 * * New Features!
 * ** In the Core Engine's plugin parameters, you can now set the Battle System
 *    used. This will default to whatever is the game database's setting. This
 *    feature is used for the future when new battle systems are made. Feature
 *    added by Yanfly.
 * 
 * Version 1.04: September 13, 2020
 * * Documentation Update!
 * ** Added new documentation for the "Title Command List" and Title Picture
 *    Buttons" plugin parameters. They now have a dedicated section each.
 * * Feature Updates!
 * ** Moved the "Title Command List" and "Title Picture Buttons" parameters
 *    from the Menu Layout > Title settings. They were far too hidden away and
 *    users had a hard time finding them. Update made by Yanfly.
 * *** Users who have customized these settings before will need to readjust
 *     them again. We apologize for the inconvenience.
 * 
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** Having QoL > Modern Controls disabled (why would you) used to prevent the
 *    down button from working. It works again. Fix made by Yanfly.
 * * New Feature!
 * ** Plugin default settings now come with a "Game End" option on the title
 *    screen. For those updating from version 1.02 or order, you can add this
 *    in by opening the Core Engine > Plugin Parameters > Menu Layout Settings
 *    > press "delete" on Scene_Title > open it up, then the new settings will
 *    fill in automatically.
 * * New Experimental Feature Added:
 * ** Screen Shake Settings added to the Plugin Parameters.
 * *** Screen Shake: Custom Plugin Command added!
 * *** Credit to Aries of Sheratan, who gave us permission to use her formula.
 * *** We'll be expanding on more screen shaking options in the future.
 * * Optimization Update
 * ** Digit Grouping now works more efficiently.
 * 
 * Version 1.02: August 30, 2020
 * * New Feature!
 * ** New Plugin Command: "Picture: Erase All". Added by Olivia.
 * *** Erases all pictures on the screen because it's extremely tedious to do
 *     it one by one.
 * ** New Plugin Command: "Picture: Erase Range"
 * *** Erases all pictures within a range of numbers because it's extremely
 *     tedious to do it one by one.
 * * Optimization Update
 * ** Added a more accurate means of parsing numbers for Digit Grouping.
 * ** Window_Base.prototype.textSizeEx now stores data to a cache.
 * * Documentation Update
 * ** Added a section to Major Changes: New Hard-Coded Features on
 *    Digit Grouping and explaining its intricacies.
 * ** Added a note to Plugin Parameters > UI > Reposition Actors to ignore the
 *    setting if using the Battle Core.
 * 
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** Digit grouping fixed to allow text codes to detect values larger than
 *    1000. Fix made by Olivia and Yanfly.
 * ** Param Plus, Rate, Flat notetags fixed. Fix made by Yanfly.
 * * New Experimental Feature Added:
 * ** JS: Quick Functions found in the Plugin Parameters
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Animation
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command AnimationPoint
 * @text Animation: Play at Coordinate
 * @desc Plays an animation on the screen at a specific x, y
 * coordinate even if there is no sprite attached.
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Plays this animation.
 * @default 1
 * 
 * @arg Coordinates
 *
 * @arg pointX:eval
 * @text X
 * @parent Coordinates
 * @desc X coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg pointY:eval
 * @text Y
 * @parent Coordinates
 * @desc Y coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @arg Mirror:eval
 * @text Mirror Animation?
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation?
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the animation?
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Audio
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command AudioChangeBgmVolume
 * @text Audio: Change Current BGM Volume
 * @desc Changes the current BGM volume without changing any of the
 * current BGM's other properties and without restarting the BGM.
 *
 * @arg volume:eval
 * @text Volume
 * @desc Change the current BGM's volume to what amount?
 * You may use JavaScript code. Use numbers from 0 to 100.
 * @default 100
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command AudioChangeBgmPitch
 * @text Audio: Change Current BGM Pitch
 * @desc Changes the current BGM pitch without changing any of the
 * current BGM's other properties and without restarting the BGM.
 *
 * @arg pitch:eval
 * @text Pitch
 * @desc Change the current BGM's pitch to what amount?
 * You may use JavaScript code. Use numbers from 50 to 150.
 * @default 100
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command AudioChangeBgmPan
 * @text Audio: Change Current BGM Pan
 * @desc Changes the current BGM pan without changing any of the
 * current BGM's other properties and without restarting the BGM.
 *
 * @arg pan:eval
 * @text Pan
 * @desc Change the current BGM's pan to what amount?
 * You may use JavaScript code. Use numbers from -100 to 100.
 * @default 0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command AudioChangeBgsVolume
 * @text Audio: Change Current BGS Volume
 * @desc Changes the current BGS volume without changing any of the
 * current BGS's other properties and without restarting the BGS.
 *
 * @arg volume:eval
 * @text Volume
 * @desc Change the current BGS's volume to what amount?
 * You may use JavaScript code. Use numbers from 0 to 100.
 * @default 100
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command AudioChangeBgsPitch
 * @text Audio: Change Current BGS Pitch
 * @desc Changes the current BGS pitch without changing any of the
 * current BGS's other properties and without restarting the BGS.
 *
 * @arg pitch:eval
 * @text Pitch
 * @desc Change the current BGS's pitch to what amount?
 * You may use JavaScript code. Use numbers from 50 to 150.
 * @default 100
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command AudioChangeBgsPan
 * @text Audio: Change Current BGS Pan
 * @desc Changes the current BGS pan without changing any of the
 * current BGS's other properties and without restarting the BGS.
 *
 * @arg pan:eval
 * @text Pan
 * @desc Change the current BGS's pan to what amount?
 * You may use JavaScript code. Use numbers from -100 to 100.
 * @default 0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Debug
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command DebugConsoleLastControllerID
 * @text Debug: Current Controller ID
 * @desc PLAY TEST ONLY. Shows current controller ID in debug console.
 * Also copies to computer clipboard if possible.
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Export
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ExportAllMapText
 * @text Export: All Maps Text
 * @desc PLAY TEST ONLY. Exports all of the text from all maps,
 * their events, event pages, and any associated Common Events.
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ExportAllTroopText
 * @text Export: All Troops Text
 * @desc PLAY TEST ONLY. Exports all of the text from all troops,
 * their event pages, and any associated Common Events.
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ExportCurMapText
 * @text Export: Current Map Text
 * @desc PLAY TEST ONLY. Exports all of the text on the current map,
 * its events, the event pages, and any associated Common Events.
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ExportCurTroopText
 * @text Export: Current Troop Text
 * @desc PLAY TEST ONLY. Exports all of the text on the current troop,
 * the troop's event pages, and any associated Common Events.
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Game
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command OpenURL
 * @text Game: Open URL
 * @desc Opens a website URL from the game.
 *
 * @arg URL:str
 * @text URL
 * @desc Where do you want to take the player?
 * @default https://www.google.com/
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Gold
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command GoldChange
 * @text Gold: Gain/Lose
 * @desc Allows you to give/take more gold than the event editor limit.
 *
 * @arg value:eval
 * @text Value
 * @desc How much gold should the player gain/lose?
 * Use negative values to remove gold. You may use JS.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Map
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MapOnceParallel
 * @text Map: Once Parallel
 * @desc Plays a Common Event parallel to the event once without
 * repeating itself when done. Map only!
 *
 * @arg CommonEventID:num
 * @text Common Event ID
 * @type common_event
 * @desc The ID of the parallel Common Event to play.
 * Does NOT repeat itself when finished.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Picture
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command PictureCoordinatesMode
 * @text Picture: Coordinates Mode
 * @desc Play Test Mode only! Gets the coordinates of a specific
 * picture as you move it across the screen.
 *
 * @arg PictureID:num
 * @text Picture ID
 * @type number
 * @min 1
 * @max 100
 * @desc The ID of the pictures to track the coordinates of.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command PictureEasingType
 * @text Picture: Easing Type
 * @desc Changes the easing type to a number of options.
 *
 * @arg pictureId:num
 * @text Picture ID
 * @type number
 * @min 1
 * @max 100
 * @desc Which picture do you wish to apply this easing to?
 * @default 1
 *
 * @arg easingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default Linear
 *
 * @arg LineBreak
 * @text ------------------------
 * @default --------------------------------
 *
 * @arg Instructions1
 * @text Instructions
 * @default Insert this Plugin Command after
 *
 * @arg Instructions2
 * @text -
 * @default a "Move Picture" event command.
 * 
 * @arg Instructions3
 * @text -
 * @default Turn off "Wait for Completion"
 *
 * @arg Instructions4
 * @text -
 * @default in the "Move Picture" event.
 *
 * @arg Instructions5
 * @text -
 * @default You may have to add in your own
 *
 * @arg Instructions6
 * @text -
 * @default "Wait" event command after.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command PictureEraseAll
 * @text Picture: Erase All
 * @desc Erases all pictures on the screen because it's extremely
 * tedious to do it one by one.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command PictureEraseRange
 * @text Picture: Erase Range
 * @desc Erases all pictures within a range of numbers because it's
 * extremely tedious to do it one by one.
 *
 * @arg StartID:num
 * @text Starting ID
 * @type number
 * @min 1
 * @max 100
 * @desc The starting ID of the pictures to erase.
 * @default 1
 *
 * @arg EndingID:num
 * @text Ending ID
 * @type number
 * @min 1
 * @max 100
 * @desc The ending ID of the pictures to erase.
 * @default 100
 *
 * @ --------------------------------------------------------------------------
 *
 * @command PictureRotateBy
 * @text Picture: Rotate By Angle
 * @desc Rotates target picture by a amount angle over a set duration
 * instead of continuously.
 * 
 * @arg PictureID:eval
 * @text Picture ID Number
 * @desc What is the ID of the picture you wish to rotate? Use a
 * number between 1 and 100. You may use JavaScript code.
 * @default 1
 * 
 * @arg AdjustAngle:eval
 * @text Adjust Angle
 * @desc What is the angle you wish to rotate the picture by?
 * Use degrees (360 degrees per full rotation).
 * @default 0
 *
 * @arg easingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default Linear
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration of rotation effect in frames.
 * 60 frames = 1 second. You may use JavaScript code.
 * @default 60
 *
 * @arg Wait:eval
 * @text Wait for Completion
 * @parent Duration:eval
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until completion before moving onto the next event?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command PictureRotate
 * @text Picture: Rotate to Angle
 * @desc Rotates target picture to a certain angle over a set duration
 * instead of continuously.
 * 
 * @arg PictureID:eval
 * @text Picture ID Number
 * @desc What is the ID of the picture you wish to rotate? Use a
 * number between 1 and 100. You may use JavaScript code.
 * @default 1
 * 
 * @arg TargetAngle:eval
 * @text Target Angle
 * @desc What is the target angle you wish to rotate the picture?
 * Use degrees (360 degrees per full rotation).
 * @default 0
 *
 * @arg easingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default Linear
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration of rotation effect in frames.
 * 60 frames = 1 second. You may use JavaScript code.
 * @default 60
 *
 * @arg Wait:eval
 * @text Wait for Completion
 * @parent Duration:eval
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until completion before moving onto the next event?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 * 
 * @command PictureShowIcon
 * @text Picture: Show Icon
 * @desc Shows an icon instead of a picture image.
 * The picture icon can be controlled like any other picture.
 * 
 * @arg General
 * 
 * @arg PictureID:eval
 * @text Picture ID Number
 * @parent General
 * @desc What is the ID of the picture you wish to show at? Use a
 * number between 1 and 100. You may use JavaScript code.
 * @default 1
 * 
 * @arg IconIndex:eval
 * @text Icon Index
 * @parent General
 * @desc Select the icon index to use for this picture.
 * You may use JavaScript code.
 * @default 23
 *
 * @arg Smooth:eval
 * @text Smooth Icon?
 * @parent General
 * @type boolean
 * @on Smooth
 * @off Pixelate
 * @desc This will make the icon smoothed out or pixelated.
 * @default false
 * 
 * @arg PictureSettings
 * @text Picture Settings
 *
 * @arg Settings:struct
 * @text Settings
 * @parent PictureSettings
 * @type struct<ShowPicture>
 * @desc Alter the settings for how the picture will be shown.
 * @default {"Position":"","Origin:num":"0","PositionX:eval":"0","PositionY:eval":"0","Scale":"","ScaleX:eval":"100","ScaleY:eval":"100","Blend":"","Opacity:eval":"255","BlendMode:num":"0"}
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_ScreenShake
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ScreenShake
 * @text Screen Shake: Custom
 * @desc Creates a custom screen shake effect and also sets
 * the following uses of screen shake to this style.
 *
 * @arg Type:str
 * @text Shake Style
 * @type select
 * @option Original
 * @value original
 * @option Random
 * @value random
 * @option Horizontal
 * @value horizontal
 * @option Vertical
 * @value vertical
 * @desc Select shake style type.
 * @default random
 *
 * @arg Power:num
 * @text Power
 * @type number
 * @min 1
 * @max 9
 * @desc Power level for screen shake.
 * @default 5
 *
 * @arg Speed:num
 * @text Speed
 * @type number
 * @min 1
 * @max 9
 * @desc Speed level for screen shake.
 * @default 5
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Duration of screenshake.
 * You can use code as well.
 * @default 60
 *
 * @arg Wait:eval
 * @text Wait for Completion
 * @parent Duration:eval
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until completion before moving onto the next event?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Switch
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SwitchRandomizeOne
 * @text Switches: Randomize ID(s)
 * @desc Select specific Switch ID's to randomize ON/OFF.
 *
 * @arg IDs:arraynum
 * @text Switch ID(s)
 * @type switch[]
 * @desc Select which Switch ID(s) to toggle.
 * @default ["1"]
 *
 * @arg Chance:num
 * @text Chance for ON
 * @type number
 * @min 1
 * @max 100
 * @desc Chance out of 100 that determines the switches to be ON.
 * @default 50
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SwitchRandomizeRange
 * @text Switches: Randomize Range
 * @desc Select specific Switch ID Range to randomize ON/OFF.
 * The ratio determines the ON/OFF distribution.
 *
 * @arg StartID:num
 * @text Starting ID
 * @type switch
 * @desc The starting ID of the Switch to toggle.
 * @default 1
 *
 * @arg EndingID:num
 * @text Ending ID
 * @type switch
 * @desc The ending ID of the Switch to toggle.
 * @default 20
 *
 * @arg Chance:num
 * @text Chance for ON
 * @type number
 * @min 1
 * @max 100
 * @desc Chance out of 100 that determines the switches to be ON.
 * @default 50
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SwitchToggleOne
 * @text Switches: Toggle ID(s)
 * @desc Select specific Switch ID's to toggle ON/OFF.
 * ON becomes OFF. OFF becomes ON.
 *
 * @arg IDs:arraynum
 * @text Switch ID(s)
 * @type switch[]
 * @desc Select which Switch ID(s) to toggle.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SwitchToggleRange
 * @text Switches: Toggle Range
 * @desc Select specific Switch ID Range to toggle ON/OFF.
 * ON becomes OFF. OFF becomes ON.
 *
 * @arg StartID:num
 * @text Starting ID
 * @type switch
 * @desc The starting ID of the Switch to toggle.
 * @default 1
 *
 * @arg EndingID:num
 * @text Ending ID
 * @type switch
 * @desc The ending ID of the Switch to toggle.
 * @default 20
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_System
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemSetBattleSystem
 * @text System: Battle System Change
 * @desc Switch to a different battle system in-game.
 * Some battle systems REQUIRE their specific plugins!
 *
 * @arg option:str
 * @text Change To
 * @type select
 * @option Database Default (Use game database setting)
 * @value database
 * @option -
 * @value database
 * @option DTB: Default Turn Battle
 * @value dtb
 * @option TPB Active: Time Progress Battle (Active)
 * @value tpb active
 * @option TPB Wait: Time Progress Battle (Wait)
 * @value tpb wait
 * @option -
 * @value database
 * @option BTB: Brave Turn Battle (Req VisuMZ_2_BattleSystemBTB)
 * @value btb
 * @option CTB: Charge Turn Battle (Req VisuMZ_2_BattleSystemCTB)
 * @value ctb
 * @option ETB: Energy Turn Battle (Req VisuMZ_2_BattleSystemETB)
 * @value etb
 * @option FTB: Free Turn Battle (Req VisuMZ_2_BattleSystemFTB)
 * @value ftb
 * @option OTB: Order Turn Battle (Req VisuMZ_2_BattleSystemOTB)
 * @value otb
 * @option PTB: Press Turn Battle (Req VisuMZ_2_BattleSystemPTB)
 * @value ptb
 * @option STB: Standard Turn Battle (Req VisuMZ_2_BattleSystemSTB)
 * @value stb
 * @desc Choose which battle system to switch to.
 * @default database
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemLoadImages
 * @text System: Load Images
 * @desc Allows you to (pre) load up images ahead of time.
 *
 * @arg animations:arraystr
 * @text img/animations/
 * @type file[]
 * @dir img/animations/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg battlebacks1:arraystr
 * @text img/battlebacks1/
 * @type file[]
 * @dir img/battlebacks1/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg battlebacks2:arraystr
 * @text img/battlebacks2/
 * @type file[]
 * @dir img/battlebacks2/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg characters:arraystr
 * @text img/characters/
 * @type file[]
 * @dir img/characters/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg enemies:arraystr
 * @text img/enemies/
 * @type file[]
 * @dir img/enemies/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg faces:arraystr
 * @text img/faces/
 * @type file[]
 * @dir img/faces/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg parallaxes:arraystr
 * @text img/parallaxes/
 * @type file[]
 * @dir img/parallaxes/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg pictures:arraystr
 * @text img/pictures/
 * @type file[]
 * @dir img/pictures/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg sv_actors:arraystr
 * @text img/sv_actors/
 * @type file[]
 * @dir img/sv_actors/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg sv_enemies:arraystr
 * @text img/sv_enemies/
 * @type file[]
 * @dir img/sv_enemies/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg system:arraystr
 * @text img/system/
 * @type file[]
 * @dir img/system/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg tilesets:arraystr
 * @text img/tilesets/
 * @type file[]
 * @dir img/tilesets/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg titles1:arraystr
 * @text img/titles1/
 * @type file[]
 * @dir img/titles1/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @arg titles2:arraystr
 * @text img/titles2/
 * @type file[]
 * @dir img/titles2/
 * @desc Which files do you wish to load from this directory?
 * @default []
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemSetFontSize
 * @text System: Main Font Size
 * @desc Set the game's main font size.
 *
 * @arg option:num
 * @text Change To
 * @type number
 * @min 1
 * @desc Change the font size to this number.
 * @default 26
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemSetSideView
 * @text System: Side View Battle
 * @desc Switch between Front View or Side View for battle.
 *
 * @arg option:str
 * @text Change To
 * @type select
 * @option Front View
 * @value Front View
 * @option Side View
 * @value Side View
 * @option Toggle
 * @value Toggle
 * @desc Choose which view type to switch to.
 * @default Toggle
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemSetWindowPadding
 * @text System: Window Padding
 * @desc Change the game's window padding amount.
 *
 * @arg option:num
 * @text Change To
 * @type number
 * @min 1
 * @desc Change the game's standard window padding to this value.
 * Default: 12
 * @default 12
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_TextPopup
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command TextPopupShow
 * @text Text Popup: Show Text
 * @desc Adds text to a text popup window to briefly appear.
 * Multiple text popups will be queued.
 *
 * @arg text:json
 * @text Text
 * @type note
 * @desc Write the text that you want to appear here.
 * You may use text codes.
 * @default "Insert message here."
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Variable
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command VariableEvalReference
 * @text Variable: JS Eval
 * @desc Pick a variable ID and value to alter through JS.
 * Functions like RM2k3's Variable Pointers.
 *
 * @arg id:eval
 * @text Variable ID
 * @desc This is the target variable to alter.
 * You may use JavaScript. ie: $gameVariables.value(1)
 * @default 1
 *
 * @arg operation:str
 * @text Operation Type
 * @type select
 * @option Set
 * @value =
 * @option Add
 * @value +
 * @option Sub
 * @value -
 * @option Mul
 * @value *
 * @option Div
 * @value /
 * @option Mod
 * @value %
 * @desc What operation do you wish to use for this Plugin Command?
 * @default =
 *
 * @arg operand:eval
 * @text Operand Modifier
 * @desc Value to be used in calculating the target variable.
 * You may use JavaScript. ie: $gameVariables.value(1)
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command VariableJsBlock
 * @text Variable: JS Block
 * @desc Pick a variable ID and value to alter through JS.
 * Functions like RM2k3's Variable Pointers.
 *
 * @arg id:func
 * @text Variable ID
 * @type note
 * @desc This is the target variable to alter.
 * You may use JavaScript. ie: $gameVariables.value(1)
 * @default "// Declare Variables\nlet varID = 1;\n\n// Perform Calculations\n\n// Return Variable ID\nreturn varID;"
 *
 * @arg operation:str
 * @text Operation Type
 * @type select
 * @option Set
 * @value =
 * @option Add
 * @value +
 * @option Sub
 * @value -
 * @option Mul
 * @value *
 * @option Div
 * @value /
 * @option Mod
 * @value %
 * @desc What operation do you wish to use for this Plugin Command?
 * @default =
 *
 * @arg operand:func
 * @text Operand Modifier
 * @type note
 * @desc Value to be used in calculating the target variable.
 * You may use JavaScript. ie: $gameVariables.value(1)
 * @default "// Declare Variables\nlet value = 0;\n\n// Perform Calculations\n\n// Return Variable ID\nreturn value;"
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_End
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param CoreEngine
 * @default Plugin Parameters
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param QoL:struct
 * @text Quality of Life Settings
 * @type struct<QoLSettings>
 * @desc Quality of Life settings for both developers and players.
 * @default {"PlayTest":"","NewGameBoot:eval":"false","ForceNoPlayTest:eval":"false","OpenConsole:eval":"true","F6key:eval":"true","F7key:eval":"true","NewGameCommonEvent:num":"0","BattleTest":"","BTestItems:eval":"true","BTestWeapons:eval":"true","BTestArmors:eval":"true","BTestAddedQuantity:num":"90","ShiftR_Toggle:eval":"true","ShiftT_Toggle:eval":"true","DigitGrouping":"","DigitGroupingStandardText:eval":"true","DigitGroupingExText:eval":"true","DigitGroupingDamageSprites:eval":"true","DigitGroupingGaugeSprites:eval":"true","DigitGroupingLocale:str":"en-US","PlayerBenefit":"","EncounterRateMinimum:num":"10","EscapeAlways:eval":"true","ImprovedAccuracySystem:eval":"true","AccuracyBoost:eval":"true","LevelUpFullHp:eval":"true","LevelUpFullMp:eval":"true","Pictures":"","AntiZoomPictures:eval":"true","PictureContainers":"","DetachBattlePictureContainer:eval":"false","DetachMapPictureContainer:eval":"false","Misc":"","AnimationMirrorOffset:eval":"false","AutoStretch:str":"default","FontShadows:eval":"false","FontSmoothing:eval":"true","FontWidthFix:eval":"true","KeyItemProtect:eval":"true","MapNameTextCode:eval":"true","ModernControls:eval":"true","MvAnimationRate:num":"4","NewGameCommonEventAll:num":"0","NoTileShadows:eval":"false","PixelateImageRendering:eval":"false","RequireFocus:eval":"false","ShortcutScripts:eval":"true","SmartEventCollisionPriority:eval":"true","SubfolderParse:eval":"true"}
 * 
 * @param BattleSystem:str
 * @text Battle System
 * @type select
 * @option Database Default (Use game database setting)
 * @value database
 * @option -
 * @value database
 * @option DTB: Default Turn Battle
 * @value dtb
 * @option TPB Active: Time Progress Battle (Active)
 * @value tpb active
 * @option TPB wait: Time Progress Battle (Wait)
 * @value tpb wait
 * @option -
 * @value database
 * @option BTB: Brave Turn Battle (Req VisuMZ_2_BattleSystemBTB)
 * @value btb
 * @option CTB: Charge Turn Battle (Req VisuMZ_2_BattleSystemCTB)
 * @value ctb
 * @option ETB: Energy Turn Battle (Req VisuMZ_2_BattleSystemETB)
 * @value etb
 * @option FTB: Free Turn Battle (Req VisuMZ_2_BattleSystemFTB)
 * @value ftb
 * @option OTB: Order Turn Battle (Req VisuMZ_2_BattleSystemOTB)
 * @value otb
 * @option PTB: Press Turn Battle (Req VisuMZ_2_BattleSystemPTB)
 * @value ptb
 * @option STB: Standard Turn Battle (Req VisuMZ_2_BattleSystemSTB)
 * @value stb
 * @desc Choose which battle system to use for your game.
 * Some battle systems REQUIRE their specific plugins!
 * @default database
 *
 * @param Color:struct
 * @text Color Settings
 * @type struct<Color>
 * @desc Change the colors used for in-game text.
 * @default {"BasicColors":"","ColorNormal:str":"0","ColorSystem:str":"16","ColorCrisis:str":"17","ColorDeath:str":"18","ColorGaugeBack:str":"19","ColorHPGauge1:str":"20","ColorHPGauge2:str":"21","ColorMPGauge1:str":"22","ColorMPGauge2:str":"23","ColorMPCost:str":"23","ColorPowerUp:str":"24","ColorPowerDown:str":"25","ColorCTGauge1:str":"26","ColorCTGauge2:str":"27","ColorTPGauge1:str":"28","ColorTPGauge2:str":"29","ColorTPCost:str":"29","ColorPending:str":"#2a847d","ColorExpGauge1:str":"30","ColorExpGauge2:str":"31","ColorMaxLvGauge1:str":"14","ColorMaxLvGauge2:str":"6","AlphaColors":"","OutlineColor:str":"rgba(0, 0, 0, 0.6)","DimColor1:str":"rgba(0, 0, 0, 0.6)","DimColor2:str":"rgba(0, 0, 0, 0)","ItemBackColor1:str":"rgba(32, 32, 32, 0.5)","ItemBackColor2:str":"rgba(0, 0, 0, 0.5)","ConditionalColors":"","ActorHPColor:func":"\"// Set the variables used in this function.\\nlet actor = arguments[0];\\n\\n// Check if the actor exists. If not, return normal.\\nif (!actor) {\\n    return this.normalColor();\\n\\n// If the actor is dead, return death color.\\n} else if (actor.isDead()) {\\n    return this.deathColor();\\n\\n// If the actor is dying, return crisis color.\\n} else if (actor.isDying()) {\\n    return this.crisisColor();\\n\\n// Otherwise, return the normal color.\\n} else {\\n    return this.normalColor();\\n}\"","ActorMPColor:func":"\"// Set the variables used in this function.\\nlet actor = arguments[0];\\n\\n// Check if the actor exists. If not, return normal.\\nif (!actor) {\\n    return this.normalColor();\\n\\n// If MP rate is below 25%, return crisis color.\\n} else if (actor.mpRate() < 0.25) {\\n    return this.crisisColor();\\n\\n// Otherwise, return the normal color.\\n} else {\\n    return this.normalColor();\\n}\"","ActorTPColor:func":"\"// Set the variables used in this function.\\nlet actor = arguments[0];\\n\\n// Check if the actor exists. If not, return normal.\\nif (!actor) {\\n    return this.normalColor();\\n\\n// If TP rate is below 25%, return crisis color.\\n} else if (actor.tpRate() < 0.25) {\\n    return this.crisisColor();\\n\\n// Otherwise, return the normal color.\\n} else {\\n    return this.normalColor();\\n}\"","ParamChange:func":"\"// Set the variables used in this function.\\nlet change = arguments[0];\\n\\n// If a positive change, use power up color.\\nif (change > 0) {\\n    return this.powerUpColor();\\n\\n// If a negative change, use power down color.\\n} else if (change < 0) {\\n    return this.powerDownColor();\\n\\n// Otherwise, return the normal color.\\n} else {\\n    return this.normalColor();\\n}\"","DamageColor:func":"\"// Set the variables used in this function.\\nlet colorType = arguments[0];\\n\\n// Check the value of the color type\\n// and return an appropriate color.\\nswitch (colorType) {\\n\\n    case 0: // HP damage\\n        return \\\"#ffffff\\\";\\n\\n    case 1: // HP recover\\n        return \\\"#b9ffb5\\\";\\n\\n    case 2: // MP damage\\n        return \\\"#bb88bb\\\";\\n\\n    case 3: // MP recover\\n        return \\\"#80b0ff\\\";\\n\\n    default:\\n        return \\\"#808080\\\";\\n}\""}
 *
 * @param Gold:struct
 * @text Gold Settings
 * @type struct<Gold>
 * @desc Change up how gold operates and is displayed in-game.
 * @default {"GoldMax:num":"999999999","GoldFontSize:num":"24","GoldIcon:num":"314","GoldOverlap:str":"A Lot","ItemStyle:eval":"true"}
 *
 * @param ImgLoad:struct
 * @text Image Loading
 * @type struct<ImgLoad>
 * @desc Game images that will be loaded upon booting up the game.
 * Use this responsibly!!!
 * @default {"animations:arraystr":"[]","battlebacks1:arraystr":"[]","battlebacks2:arraystr":"[]","characters:arraystr":"[]","enemies:arraystr":"[]","faces:arraystr":"[]","parallaxes:arraystr":"[]","pictures:arraystr":"[]","sv_actors:arraystr":"[]","sv_enemies:arraystr":"[]","system:arraystr":"[\"Balloon\",\"IconSet\"]","tilesets:arraystr":"[]","titles1:arraystr":"[]","titles2:arraystr":"[]"}
 *
 * @param KeyboardInput:struct
 * @text Keyboard Input
 * @type struct<KeyboardInput>
 * @desc Settings for the game that utilize keyboard input.
 * @default {"Controls":"","WASD:eval":"false","DashToggleR:eval":"false","NameInput":"","EnableNameInput:eval":"true","DefaultMode:str":"keyboard","QwertyLayout:eval":"true","NameInputMessage:eval":"\"Type in this character's name.\\nPress \\\\c[5]ENTER\\\\c[0] when you're done.\\n\\n-or-\\n\\nPress \\\\c[5]arrow keys\\\\c[0]/\\\\c[5]TAB\\\\c[0] to switch\\nto manual character entry.\\n\\nPress \\\\c[5]ESC\\\\c[0]/\\\\c[5]TAB\\\\c[0] to use to keyboard.\"","NumberInput":"","EnableNumberInput:eval":"true","ButtonAssist":"","Keyboard:str":"Keyboard","Manual:str":"Manual"}
 *
 * @param MenuBg:struct
 * @text Menu Background Settings
 * @type struct<MenuBg>
 * @desc Change how menu backgrounds look for each scene.
 * @default {"Scene_Menu:struct":"{\"SnapshotOpacity:num\":\"192\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}","Scene_Item:struct":"{\"SnapshotOpacity:num\":\"192\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}","Scene_Skill:struct":"{\"SnapshotOpacity:num\":\"192\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}","Scene_Equip:struct":"{\"SnapshotOpacity:num\":\"192\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}","Scene_Status:struct":"{\"SnapshotOpacity:num\":\"192\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}","Scene_Options:struct":"{\"SnapshotOpacity:num\":\"192\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}","Scene_Save:struct":"{\"SnapshotOpacity:num\":\"192\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}","Scene_Load:struct":"{\"SnapshotOpacity:num\":\"192\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}","Scene_GameEnd:struct":"{\"SnapshotOpacity:num\":\"128\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}","Scene_Shop:struct":"{\"SnapshotOpacity:num\":\"192\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}","Scene_Name:struct":"{\"SnapshotOpacity:num\":\"192\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}","Scene_Unlisted:struct":"{\"SnapshotOpacity:num\":\"192\",\"BgFilename1:str\":\"\",\"BgFilename2:str\":\"\"}"}
 *
 * @param ButtonAssist:struct
 * @text Menu Button Assist Window
 * @type struct<ButtonAssist>
 * @desc Settings pertaining to the Button Assist window found in in-game menus.
 * @default {"General":"","Enable:eval":"true","Location:str":"bottom","BgType:num":"0","Text":"","TextFmt:str":"%1:%2","MultiKeyFmt:str":"%1/%2","OkText:str":"Select","CancelText:str":"Back","SwitchActorText:str":"Switch Ally","Keys":"","KeyUnlisted:str":"\\}❪%1❫\\{","KeyUP:str":"^","KeyDOWN:str":"v","KeyLEFT:str":"<<","KeyRIGHT:str":">>","KeySHIFT:str":"\\}❪SHIFT❫\\{","KeyTAB:str":"\\}❪TAB❫\\{","KeyA:str":"A","KeyB:str":"B","KeyC:str":"C","KeyD:str":"D","KeyE:str":"E","KeyF:str":"F","KeyG:str":"G","KeyH:str":"H","KeyI:str":"I","KeyJ:str":"J","KeyK:str":"K","KeyL:str":"L","KeyM:str":"M","KeyN:str":"N","KeyO:str":"O","KeyP:str":"P","KeyQ:str":"Q","KeyR:str":"R","KeyS:str":"S","KeyT:str":"T","KeyU:str":"U","KeyV:str":"V","KeyW:str":"W","KeyX:str":"X","KeyY:str":"Y","KeyZ:str":"Z"}
 *
 * @param ControllerButtons:arraystruct
 * @text Controller Button Assist
 * @parent ButtonAssist:struct
 * @type struct<ControllerButtons>[]
 * @desc Make different icons appear for the Button Assist window when using different controllers.
 * @default []
 *
 * @param MenuLayout:struct
 * @text Menu Layout Settings
 * @type struct<MenuLayout>
 * @desc Change how menu layouts look for each scene.
 * @default {"Title:struct":"{\"TitleScreen\":\"\",\"DocumentTitleFmt:str\":\"%1: %2 - Version %3\",\"Subtitle:str\":\"Subtitle\",\"Version:str\":\"0.00\",\"drawGameTitle:func\":\"\\\"const x = 20;\\\\nconst y = Graphics.height / 4;\\\\nconst maxWidth = Graphics.width - x * 2;\\\\nconst text = $dataSystem.gameTitle;\\\\nconst bitmap = this._gameTitleSprite.bitmap;\\\\nbitmap.fontFace = $gameSystem.mainFontFace();\\\\nbitmap.outlineColor = \\\\\\\"black\\\\\\\";\\\\nbitmap.outlineWidth = 8;\\\\nbitmap.fontSize = 72;\\\\nbitmap.drawText(text, x, y, maxWidth, 48, \\\\\\\"center\\\\\\\");\\\"\",\"drawGameSubtitle:func\":\"\\\"const x = 20;\\\\nconst y = Graphics.height / 4 + 72;\\\\nconst maxWidth = Graphics.width - x * 2;\\\\nconst text = Scene_Title.subtitle;\\\\nconst bitmap = this._gameTitleSprite.bitmap;\\\\nbitmap.fontFace = $gameSystem.mainFontFace();\\\\nbitmap.outlineColor = \\\\\\\"black\\\\\\\";\\\\nbitmap.outlineWidth = 6;\\\\nbitmap.fontSize = 48;\\\\nbitmap.drawText(text, x, y, maxWidth, 48, \\\\\\\"center\\\\\\\");\\\"\",\"drawGameVersion:func\":\"\\\"const bitmap = this._gameTitleSprite.bitmap;\\\\nconst x = 0;\\\\nconst y = Graphics.height - 20;\\\\nconst width = Math.round(Graphics.width / 4);\\\\nconst height = 20;\\\\nconst c1 = ColorManager.dimColor1();\\\\nconst c2 = ColorManager.dimColor2();\\\\nconst text = 'Version ' + Scene_Title.version;\\\\nbitmap.gradientFillRect(x, y, width, height, c1, c2);\\\\nbitmap.fontFace = $gameSystem.mainFontFace();\\\\nbitmap.outlineColor = \\\\\\\"black\\\\\\\";\\\\nbitmap.outlineWidth = 3;\\\\nbitmap.fontSize = 16;\\\\nbitmap.drawText(text, x + 4, y, Graphics.width, height, \\\\\\\"left\\\\\\\");\\\"\",\"CommandRect:func\":\"\\\"const offsetX = $dataSystem.titleCommandWindow.offsetX;\\\\nconst offsetY = $dataSystem.titleCommandWindow.offsetY;\\\\nconst rows = this.commandWindowRows();\\\\nconst width = this.mainCommandWidth();\\\\nconst height = this.calcWindowHeight(rows, true);\\\\nconst x = (Graphics.boxWidth - width) / 2 + offsetX;\\\\nconst y = Graphics.boxHeight - height - 96 + offsetY;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"ButtonFadeSpeed:num\":\"4\"}","MainMenu:struct":"{\"CommandWindow\":\"\",\"CommandBgType:num\":\"0\",\"CommandRect:func\":\"\\\"const width = this.mainCommandWidth();\\\\nconst height = this.mainAreaHeight() - this.goldWindowRect().height;\\\\nconst x = this.isRightInputMode() ? Graphics.boxWidth - width : 0;\\\\nconst y = this.mainAreaTop();\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"GoldWindow\":\"\",\"GoldBgType:num\":\"0\",\"GoldRect:func\":\"\\\"const rows = 1;\\\\nconst width = this.mainCommandWidth();\\\\nconst height = this.calcWindowHeight(rows, true);\\\\nconst x = this.isRightInputMode() ? Graphics.boxWidth - width : 0;\\\\nconst y = this.mainAreaBottom() - height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"StatusWindow\":\"\",\"StatusBgType:num\":\"0\",\"StatusRect:func\":\"\\\"const width = Graphics.boxWidth - this.mainCommandWidth();\\\\nconst height = this.mainAreaHeight();\\\\nconst x = this.isRightInputMode() ? 0 : Graphics.boxWidth - width;\\\\nconst y = this.mainAreaTop();\\\\nreturn new Rectangle(x, y, width, height);\\\"\"}","ItemMenu:struct":"{\"HelpWindow\":\"\",\"HelpBgType:num\":\"0\",\"HelpRect:func\":\"\\\"const x = 0;\\\\nconst y = this.helpAreaTop();\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.helpAreaHeight();\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"CategoryWindow\":\"\",\"CategoryBgType:num\":\"0\",\"CategoryRect:func\":\"\\\"const x = 0;\\\\nconst y = this.mainAreaTop();\\\\nconst rows = 1;\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.calcWindowHeight(rows, true);\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"ItemWindow\":\"\",\"ItemBgType:num\":\"0\",\"ItemRect:func\":\"\\\"const x = 0;\\\\nconst y = this._categoryWindow.y + this._categoryWindow.height;\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.mainAreaBottom() - y;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"ActorWindow\":\"\",\"ActorBgType:num\":\"0\",\"ActorRect:func\":\"\\\"const x = 0;\\\\nconst y = this.mainAreaTop();\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.mainAreaHeight();\\\\nreturn new Rectangle(x, y, width, height);\\\"\"}","SkillMenu:struct":"{\"HelpWindow\":\"\",\"HelpBgType:num\":\"0\",\"HelpRect:func\":\"\\\"const x = 0;\\\\nconst y = this.helpAreaTop();\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.helpAreaHeight();\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"SkillTypeWindow\":\"\",\"SkillTypeBgType:num\":\"0\",\"SkillTypeRect:func\":\"\\\"const rows = 3;\\\\nconst width = this.mainCommandWidth();\\\\nconst height = this.calcWindowHeight(rows, true);\\\\nconst x = this.isRightInputMode() ? Graphics.boxWidth - width : 0;\\\\nconst y = this.mainAreaTop();\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"StatusWindow\":\"\",\"StatusBgType:num\":\"0\",\"StatusRect:func\":\"\\\"const width = Graphics.boxWidth - this.mainCommandWidth();\\\\nconst height = this._skillTypeWindow.height;\\\\nconst x = this.isRightInputMode() ? 0 : Graphics.boxWidth - width;\\\\nconst y = this.mainAreaTop();\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"ItemWindow\":\"\",\"ItemBgType:num\":\"0\",\"ItemRect:func\":\"\\\"const x = 0;\\\\nconst y = this._statusWindow.y + this._statusWindow.height;\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.mainAreaHeight() - this._statusWindow.height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"ActorWindow\":\"\",\"ActorBgType:num\":\"0\",\"ActorRect:func\":\"\\\"const x = 0;\\\\nconst y = this.mainAreaTop();\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.mainAreaHeight();\\\\nreturn new Rectangle(x, y, width, height);\\\"\"}","EquipMenu:struct":"{\"HelpWindow\":\"\",\"HelpBgType:num\":\"0\",\"HelpRect:func\":\"\\\"const x = 0;\\\\nconst y = this.helpAreaTop();\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.helpAreaHeight();\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"StatusWindow\":\"\",\"StatusBgType:num\":\"0\",\"StatusRect:func\":\"\\\"const x = 0;\\\\nconst y = this.mainAreaTop();\\\\nconst width = this.statusWidth();\\\\nconst height = this.mainAreaHeight();\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"CommandWindow\":\"\",\"CommandBgType:num\":\"0\",\"CommandRect:func\":\"\\\"const x = this.statusWidth();\\\\nconst y = this.mainAreaTop();\\\\nconst rows = 1;\\\\nconst width = Graphics.boxWidth - this.statusWidth();\\\\nconst height = this.calcWindowHeight(rows, true);\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"SlotWindow\":\"\",\"SlotBgType:num\":\"0\",\"SlotRect:func\":\"\\\"const commandWindowRect = this.commandWindowRect();\\\\nconst x = this.statusWidth();\\\\nconst y = commandWindowRect.y + commandWindowRect.height;\\\\nconst width = Graphics.boxWidth - this.statusWidth();\\\\nconst height = this.mainAreaHeight() - commandWindowRect.height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"ItemWindow\":\"\",\"ItemBgType:num\":\"0\",\"ItemRect:func\":\"\\\"return this.slotWindowRect();\\\"\"}","StatusMenu:struct":"{\"ProfileWindow\":\"\",\"ProfileBgType:num\":\"0\",\"ProfileRect:func\":\"\\\"const width = Graphics.boxWidth;\\\\nconst height = this.profileHeight();\\\\nconst x = 0;\\\\nconst y = this.mainAreaBottom() - height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"StatusWindow\":\"\",\"StatusBgType:num\":\"0\",\"StatusRect:func\":\"\\\"const x = 0;\\\\nconst y = this.mainAreaTop();\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.statusParamsWindowRect().y - y;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"StatusParamsWindow\":\"\",\"StatusParamsBgType:num\":\"0\",\"StatusParamsRect:func\":\"\\\"const width = this.statusParamsWidth();\\\\nconst height = this.statusParamsHeight();\\\\nconst x = 0;\\\\nconst y = this.mainAreaBottom() - this.profileHeight() - height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"StatusEquipWindow\":\"\",\"StatusEquipBgType:num\":\"0\",\"StatusEquipRect:func\":\"\\\"const width = Graphics.boxWidth - this.statusParamsWidth();\\\\nconst height = this.statusParamsHeight();\\\\nconst x = this.statusParamsWidth();\\\\nconst y = this.mainAreaBottom() - this.profileHeight() - height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\"}","OptionsMenu:struct":"{\"OptionsWindow\":\"\",\"OptionsBgType:num\":\"0\",\"OptionsRect:func\":\"\\\"const n = Math.min(this.maxCommands(), this.maxVisibleCommands());\\\\nconst width = 400;\\\\nconst height = this.calcWindowHeight(n, true);\\\\nconst x = (Graphics.boxWidth - width) / 2;\\\\nconst y = (Graphics.boxHeight - height) / 2;\\\\nreturn new Rectangle(x, y, width, height);\\\"\"}","SaveMenu:struct":"{\"HelpWindow\":\"\",\"HelpBgType:num\":\"0\",\"HelpRect:func\":\"\\\"const x = 0;\\\\nconst y = this.mainAreaTop();\\\\nconst rows = 1;\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.calcWindowHeight(rows, false);\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"ListWindow\":\"\",\"ListBgType:num\":\"0\",\"ListRect:func\":\"\\\"const x = 0;\\\\nconst y = this.mainAreaTop() + this._helpWindow.height;\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.mainAreaHeight() - this._helpWindow.height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\"}","LoadMenu:struct":"{\"HelpWindow\":\"\",\"HelpBgType:num\":\"0\",\"HelpRect:func\":\"\\\"const x = 0;\\\\nconst y = this.mainAreaTop();\\\\nconst rows = 1;\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.calcWindowHeight(rows, false);\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"ListWindow\":\"\",\"ListBgType:num\":\"0\",\"ListRect:func\":\"\\\"const x = 0;\\\\nconst y = this.mainAreaTop() + this._helpWindow.height;\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.mainAreaHeight() - this._helpWindow.height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\"}","GameEnd:struct":"{\"CommandList:arraystruct\":\"[\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"toTitle\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.toTitle;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return null;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CallHandlerJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"SceneManager._scene.commandToTitle();\\\\\\\\\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"Symbol:str\\\\\\\":\\\\\\\"cancel\\\\\\\",\\\\\\\"TextStr:str\\\\\\\":\\\\\\\"Untitled\\\\\\\",\\\\\\\"TextJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return TextManager.cancel;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ShowJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"EnableJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return true;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"ExtJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"return null;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"CallHandlerJS:func\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"SceneManager._scene.popScene();\\\\\\\\\\\\\\\"\\\\\\\"}\\\"]\",\"CommandBgType:num\":\"0\",\"CommandRect:func\":\"\\\"const rows = 2;\\\\nconst width = this.mainCommandWidth();\\\\nconst height = this.calcWindowHeight(rows, true);\\\\nconst x = (Graphics.boxWidth - width) / 2;\\\\nconst y = (Graphics.boxHeight - height) / 2;\\\\nreturn new Rectangle(x, y, width, height);\\\"\"}","ShopMenu:struct":"{\"HelpWindow\":\"\",\"HelpBgType:num\":\"0\",\"HelpRect:func\":\"\\\"const wx = 0;\\\\nconst wy = this.helpAreaTop();\\\\nconst ww = Graphics.boxWidth;\\\\nconst wh = this.helpAreaHeight();\\\\nreturn new Rectangle(wx, wy, ww, wh);\\\"\",\"GoldWindow\":\"\",\"GoldBgType:num\":\"0\",\"GoldRect:func\":\"\\\"const rows = 1;\\\\nconst width = this.mainCommandWidth();\\\\nconst height = this.calcWindowHeight(rows, true);\\\\nconst x = Graphics.boxWidth - width;\\\\nconst y = this.mainAreaTop();\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"CommandWindow\":\"\",\"CommandBgType:num\":\"0\",\"CommandRect:func\":\"\\\"const x = 0;\\\\nconst y = this.mainAreaTop();\\\\nconst rows = 1;\\\\nconst width = this._goldWindow.x;\\\\nconst height = this.calcWindowHeight(rows, true);\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"DummyWindow\":\"\",\"DummyBgType:num\":\"0\",\"DummyRect:func\":\"\\\"const x = 0;\\\\nconst y = this._commandWindow.y + this._commandWindow.height;\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.mainAreaHeight() - this._commandWindow.height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"NumberWindow\":\"\",\"NumberBgType:num\":\"0\",\"NumberRect:func\":\"\\\"const x = 0;\\\\nconst y = this._dummyWindow.y;\\\\nconst width = Graphics.boxWidth - this.statusWidth();\\\\nconst height = this._dummyWindow.height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"StatusWindow\":\"\",\"StatusBgType:num\":\"0\",\"StatusRect:func\":\"\\\"const width = this.statusWidth();\\\\nconst height = this._dummyWindow.height;\\\\nconst x = Graphics.boxWidth - width;\\\\nconst y = this._dummyWindow.y;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"BuyWindow\":\"\",\"BuyBgType:num\":\"0\",\"BuyRect:func\":\"\\\"const x = 0;\\\\nconst y = this._dummyWindow.y;\\\\nconst width = Graphics.boxWidth - this.statusWidth();\\\\nconst height = this._dummyWindow.height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"CategoryWindow\":\"\",\"CategoryBgType:num\":\"0\",\"CategoryRect:func\":\"\\\"const x = 0;\\\\nconst y = this._dummyWindow.y;\\\\nconst rows = 1;\\\\nconst width = Graphics.boxWidth;\\\\nconst height = this.calcWindowHeight(rows, true);\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"SellWindow\":\"\",\"SellBgType:num\":\"0\",\"SellRect:func\":\"\\\"const x = 0;\\\\nconst y = this._categoryWindow.y + this._categoryWindow.height;\\\\nconst width = Graphics.boxWidth;\\\\nconst height =\\\\n    this.mainAreaHeight() -\\\\n    this._commandWindow.height -\\\\n    this._categoryWindow.height;\\\\nreturn new Rectangle(x, y, width, height);\\\"\"}","NameMenu:struct":"{\"EditWindow\":\"\",\"EditBgType:num\":\"0\",\"EditRect:func\":\"\\\"const rows = 9;\\\\nconst inputWindowHeight = this.calcWindowHeight(rows, true);\\\\nconst padding = $gameSystem.windowPadding();\\\\nconst width = 600;\\\\nconst height = Math.min(ImageManager.faceHeight + padding * 2, this.mainAreaHeight() - inputWindowHeight);\\\\nconst x = (Graphics.boxWidth - width) / 2;\\\\nconst y = (this.mainAreaHeight() - (height + inputWindowHeight)) / 2 + this.mainAreaTop();\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"InputWindow\":\"\",\"InputBgType:num\":\"0\",\"InputRect:func\":\"\\\"const x = this._editWindow.x;\\\\nconst y = this._editWindow.y + this._editWindow.height;\\\\nconst rows = 9;\\\\nconst width = this._editWindow.width;\\\\nconst height = this.calcWindowHeight(rows, true);\\\\nreturn new Rectangle(x, y, width, height);\\\"\"}"}
 *
 * @param Param:struct
 * @text Parameter Settings
 * @type struct<Param>
 * @desc Change up the limits of parameters and how they're calculated.
 * @default {"DisplayedParams:arraystr":"[\"ATK\",\"DEF\",\"MAT\",\"MDF\",\"AGI\",\"LUK\"]","ExtDisplayedParams:arraystr":"[\"MaxHP\",\"MaxMP\",\"ATK\",\"DEF\",\"MAT\",\"MDF\",\"AGI\",\"LUK\"]","BasicParameters":"","CrisisRate:num":"0.25","BasicParameterFormula:func":"\"// Determine the variables used in this calculation.\\nlet paramId = arguments[0];\\nlet base = this.paramBase(paramId);\\nlet plus = this.paramPlus(paramId);\\nlet paramRate = this.paramRate(paramId);\\nlet buffRate = this.paramBuffRate(paramId);\\nlet flatBonus = this.paramFlatBonus(paramId);\\n\\n// Formula to determine total parameter value.\\nlet value = (base + plus) * paramRate * buffRate + flatBonus;\\n\\n// Determine the limits\\nconst maxValue = this.paramMax(paramId);\\nconst minValue = this.paramMin(paramId);\\n\\n// Final value\\nreturn Math.round(value.clamp(minValue, maxValue));\"","BasicParamCaps":"","BasicActorParamCaps":"","BasicActorParamMax0:str":"9999","BasicActorParamMax1:str":"9999","BasicActorParamMax2:str":"999","BasicActorParamMax3:str":"999","BasicActorParamMax4:str":"999","BasicActorParamMax5:str":"999","BasicActorParamMax6:str":"999","BasicActorParamMax7:str":"999","BasicEnemyParamCaps":"","BasicEnemyParamMax0:str":"999999","BasicEnemyParamMax1:str":"9999","BasicEnemyParamMax2:str":"999","BasicEnemyParamMax3:str":"999","BasicEnemyParamMax4:str":"999","BasicEnemyParamMax5:str":"999","BasicEnemyParamMax6:str":"999","BasicEnemyParamMax7:str":"999","XParameters":"","XParameterFormula:func":"\"// Determine the variables used in this calculation.\\nlet xparamId = arguments[0];\\nlet base = this.traitsSum(Game_BattlerBase.TRAIT_XPARAM, xparamId);\\nlet plus = this.xparamPlus(xparamId);\\nlet paramRate = this.xparamRate(xparamId);\\nlet flatBonus = this.xparamFlatBonus(xparamId);\\n\\n// Formula to determine total parameter value.\\nlet value = (base + plus) * paramRate + flatBonus;\\n\\n// Final value\\nreturn value;\"","XParamVocab":"","XParamVocab0:str":"Hit","XParamVocab1:str":"Evasion","XParamVocab2:str":"Critical Rate","XParamVocab3:str":"Critical Evade","XParamVocab4:str":"Magic Evade","XParamVocab5:str":"Magic Reflect","XParamVocab6:str":"Counter","XParamVocab7:str":"HP Regen","XParamVocab8:str":"MP Regen","XParamVocab9:str":"TP Regen","SParameters":"","SParameterFormula:func":"\"// Determine the variables used in this calculation.\\nlet sparamId = arguments[0];\\nlet base = this.traitsPi(Game_BattlerBase.TRAIT_SPARAM, sparamId);\\nlet plus = this.sparamPlus(sparamId);\\nlet paramRate = this.sparamRate(sparamId);\\nlet flatBonus = this.sparamFlatBonus(sparamId);\\n\\n// Formula to determine total parameter value.\\nlet value = (base + plus) * paramRate + flatBonus;\\n\\n// Final value\\nreturn value;\"","SParamVocab":"","SParamVocab0:str":"Aggro","SParamVocab1:str":"Guard","SParamVocab2:str":"Recovery","SParamVocab3:str":"Item Effect","SParamVocab4:str":"MP Cost","SParamVocab5:str":"TP Charge","SParamVocab6:str":"Physical DMG","SParamVocab7:str":"Magical DMG","SParamVocab8:str":"Floor DMG","SParamVocab9:str":"EXP Gain","Icons":"","DrawIcons:eval":"true","IconParam0:str":"84","IconParam1:str":"165","IconParam2:str":"76","IconParam3:str":"81","IconParam4:str":"101","IconParam5:str":"133","IconParam6:str":"140","IconParam7:str":"87","IconXParam0:str":"102","IconXParam1:str":"82","IconXParam2:str":"78","IconXParam3:str":"82","IconXParam4:str":"171","IconXParam5:str":"222","IconXParam6:str":"77","IconXParam7:str":"72","IconXParam8:str":"72","IconXParam9:str":"72","IconSParam0:str":"5","IconSParam1:str":"128","IconSParam2:str":"72","IconSParam3:str":"176","IconSParam4:str":"165","IconSParam5:str":"164","IconSParam6:str":"76","IconSParam7:str":"79","IconSParam8:str":"141","IconSParam9:str":"73"}
 *
 * @param CustomParam:arraystruct
 * @text Custom Parameters
 * @parent Param:struct
 * @type struct<CustomParam>[]
 * @desc Create custom parameters for your game!
 * These will appear in VisuStella MZ menus.
 * @default ["{\"ParamName:str\":\"Strength\",\"Abbreviation:str\":\"str\",\"Icon:num\":\"77\",\"Type:str\":\"integer\",\"ValueJS:json\":\"\\\"// Declare Constants\\\\nconst user = this;\\\\n\\\\n// Calculations\\\\nreturn (user.atk * 0.75) + (user.def * 0.25);\\\"\"}","{\"ParamName:str\":\"Dexterity\",\"Abbreviation:str\":\"dex\",\"Icon:num\":\"82\",\"Type:str\":\"integer\",\"ValueJS:json\":\"\\\"// Declare Constants\\\\nconst user = this;\\\\n\\\\n// Calculations\\\\nreturn (user.agi * 0.75) + (user.atk * 0.25);\\\"\"}","{\"ParamName:str\":\"Constitution\",\"Abbreviation:str\":\"con\",\"Icon:num\":\"81\",\"Type:str\":\"integer\",\"ValueJS:json\":\"\\\"// Declare Constants\\\\nconst user = this;\\\\n\\\\n// Calculations\\\\nreturn (user.def * 0.75) + (user.mdf * 0.25);\\\"\"}","{\"ParamName:str\":\"Intelligence\",\"Abbreviation:str\":\"int\",\"Icon:num\":\"79\",\"Type:str\":\"integer\",\"ValueJS:json\":\"\\\"// Declare Constants\\\\nconst user = this;\\\\n\\\\n// Calculations\\\\nreturn (user.mat * 0.75) + (user.mdf * 0.25);\\\"\"}","{\"ParamName:str\":\"Wisdom\",\"Abbreviation:str\":\"wis\",\"Icon:num\":\"72\",\"Type:str\":\"integer\",\"ValueJS:json\":\"\\\"// Declare Constants\\\\nconst user = this;\\\\n\\\\n// Calculations\\\\nreturn (user.mdf * 0.75) + (user.luk * 0.25);\\\"\"}","{\"ParamName:str\":\"Charisma\",\"Abbreviation:str\":\"cha\",\"Icon:num\":\"84\",\"Type:str\":\"integer\",\"ValueJS:json\":\"\\\"// Declare Constants\\\\nconst user = this;\\\\n\\\\n// Calculations\\\\nreturn (user.luk * 0.75) + (user.agi * 0.25);\\\"\"}"]
 *
 * @param ScreenResolution:struct
 * @text Screen Resolution Settings
 * @type struct<ScreenResolution>
 * @desc Alter various properties to make the game look better for varying screen resolutions.
 * @default {"Maps":"","AutoScrollLockX:eval":"true","AutoScrollLockY:eval":"true","DisplayLockX:num":"0.15625","DisplayLockY:num":"0.00000","Troops":"","RepositionActors:eval":"true","RepositionEnemies:eval":"true","RepositionEnemies130:eval":"false"}
 *
 * @param ScreenShake:struct
 * @text Screen Shake Settings
 * @type struct<ScreenShake>
 * @desc Get more screen shake effects into your game!
 * @default {"DefaultStyle:str":"random","originalJS:func":"\"// Calculation\\nthis.x += Math.round($gameScreen.shake());\"","randomJS:func":"\"// Calculation\\n// Original Formula by Aries of Sheratan\\nconst power = $gameScreen._shakePower * 0.75;\\nconst speed = $gameScreen._shakeSpeed * 0.60;\\nconst duration = $gameScreen._shakeDuration;\\nthis.x += Math.round(Math.randomInt(power) - Math.randomInt(speed)) * (Math.min(duration, 30) * 0.5);\\nthis.y += Math.round(Math.randomInt(power) - Math.randomInt(speed)) * (Math.min(duration, 30) * 0.5);\"","horzJS:func":"\"// Calculation\\n// Original Formula by Aries of Sheratan\\nconst power = $gameScreen._shakePower * 0.75;\\nconst speed = $gameScreen._shakeSpeed * 0.60;\\nconst duration = $gameScreen._shakeDuration;\\nthis.x += Math.round(Math.randomInt(power) - Math.randomInt(speed)) * (Math.min(duration, 30) * 0.5);\"","vertJS:func":"\"// Calculation\\n// Original Formula by Aries of Sheratan\\nconst power = $gameScreen._shakePower * 0.75;\\nconst speed = $gameScreen._shakeSpeed * 0.60;\\nconst duration = $gameScreen._shakeDuration;\\nthis.y += Math.round(Math.randomInt(power) - Math.randomInt(speed)) * (Math.min(duration, 30) * 0.5);\""}
 *
 * @param TitleCommandList:arraystruct
 * @text Title Command List
 * @type struct<Command>[]
 * @desc Window commands used by the title screen.
 * Add new commands here.
 * @default ["{\"Symbol:str\":\"newGame\",\"TextStr:str\":\"Untitled\",\"TextJS:func\":\"\\\"return TextManager.newGame;\\\"\",\"ShowJS:func\":\"\\\"return true;\\\"\",\"EnableJS:func\":\"\\\"return true;\\\"\",\"ExtJS:func\":\"\\\"return null;\\\"\",\"CallHandlerJS:func\":\"\\\"SceneManager._scene.commandNewGame();\\\"\"}","{\"Symbol:str\":\"continue\",\"TextStr:str\":\"Untitled\",\"TextJS:func\":\"\\\"return TextManager.continue_;\\\"\",\"ShowJS:func\":\"\\\"return true;\\\"\",\"EnableJS:func\":\"\\\"return DataManager.isAnySavefileExists();\\\"\",\"ExtJS:func\":\"\\\"return null;\\\"\",\"CallHandlerJS:func\":\"\\\"SceneManager._scene.commandContinue();\\\"\"}","{\"Symbol:str\":\"options\",\"TextStr:str\":\"Untitled\",\"TextJS:func\":\"\\\"return TextManager.options;\\\"\",\"ShowJS:func\":\"\\\"return true;\\\"\",\"EnableJS:func\":\"\\\"return true;\\\"\",\"ExtJS:func\":\"\\\"return null;\\\"\",\"CallHandlerJS:func\":\"\\\"SceneManager._scene.commandOptions();\\\"\"}","{\"Symbol:str\":\"shutdown\",\"TextStr:str\":\"Untitled\",\"TextJS:func\":\"\\\"return TextManager.gameEnd;\\\"\",\"ShowJS:func\":\"\\\"return Utils.isNwjs();\\\"\",\"EnableJS:func\":\"\\\"return true;\\\"\",\"ExtJS:func\":\"\\\"return null;\\\"\",\"CallHandlerJS:func\":\"\\\"SceneManager.exit();\\\\n\\\\n// Note!\\\\n// Do NOT use this command with mobile devices or\\\\n// browser games. All it does is cause the game to\\\\n// display a blank, black canvas which the player\\\\n// is unable to do anything with. It does NOT force\\\\n// close the browser tab nor the app.\\\"\"}"]
 *
 * @param TitlePicButtons:arraystruct
 * @text Title Picture Buttons
 * @type struct<TitlePictureButton>[]
 * @desc Buttons that can be inserted into the title screen.
 * Add new title buttons here.
 * @default []
 *
 * @param UI:struct
 * @text UI Settings
 * @type struct<UI>
 * @desc Change up various in-game UI aspects.
 * @default {"UIArea":"","FadeSpeed:num":"24","BoxMargin:num":"4","CommandWidth:num":"240","BottomHelp:eval":"false","RightMenus:eval":"true","ShowButtons:eval":"true","cancelShowButton:eval":"true","menuShowButton:eval":"true","pagedownShowButton:eval":"true","numberShowButton:eval":"true","ButtonHeight:num":"52","BottomButtons:eval":"false","SideButtons:eval":"true","MenuObjects":"","LvExpGauge:eval":"true","ParamArrow:str":"→","TextCodeSupport":"","TextCodeClassNames:eval":"true","TextCodeNicknames:eval":"true"}
 *
 * @param Window:struct
 * @text Window Settings
 * @type struct<Window>
 * @desc Adjust various in-game window settings.
 * @default {"WindowDefaults":"","EnableMasking:eval":"false","LineHeight:num":"36","ItemPadding:num":"8","BackOpacity:num":"192","TranslucentOpacity:num":"160","OpenSpeed:num":"32","ColSpacing:num":"8","RowSpacing:num":"4","ScrollBar":"","ShowScrollBar:eval":"true","BarThickness:num":"2","BarOffset:num":"+2","BarBodyColor:str":"0","OffBarColor:str":"7","OffBarOpacity:num":"128","SelectableItems":"","ShowItemBackground:eval":"true","ItemHeight:num":"8","DrawItemBackgroundJS:func":"\"const rect = arguments[0];\\nconst c1 = ColorManager.itemBackColor1();\\nconst c2 = ColorManager.itemBackColor2();\\nconst x = rect.x;\\nconst y = rect.y;\\nconst w = rect.width;\\nconst h = rect.height;\\nthis.contentsBack.gradientFillRect(x, y, w, h, c1, c2, true);\\nthis.contentsBack.strokeRect(x, y, w, h, c1);\"","TextPopup":"","DurationPerChat:num":"1.5","MinDuration:num":"90","MaxDuration:num":"300"}
 *
 * @param jsQuickFunc:arraystruct
 * @text JS: Quick Functions
 * @type struct<jsQuickFunc>[]
 * @desc Create quick JavaScript functions available from the
 * global namespace. Use with caution and moderation!!!
 * @default ["{\"FunctionName:str\":\"Example\",\"CodeJS:json\":\"\\\"// Insert this as a function anywhere you can input code\\\\n// such as Script Calls or Conditional Branch Scripts.\\\\n\\\\n// Process Code\\\\nreturn 'Example';\\\"\"}","{\"FunctionName:str\":\"Bad  Code  Name\",\"CodeJS:json\":\"\\\"// If a function name has spaces in them, the spaces will\\\\n// be removed. \\\\\\\"Bad  Code  Name\\\\\\\" becomes \\\\\\\"BadCodeName\\\\\\\".\\\\n\\\\n// Process Code\\\\nOhNoItsBadCode()\\\\n\\\\n// If a function has bad code, a fail safe will catch the\\\\n// error and display it in the console.\\\"\"}","{\"FunctionName:str\":\"RandomNumber\",\"CodeJS:json\":\"\\\"// This generates a random number from 0 to itself.\\\\n// Example: RandomNumber(10)\\\\n\\\\n// Process Code\\\\nconst number = (arguments[0] || 0) + 1;\\\\nreturn Math.floor(number * Math.random());\\\"\"}","{\"FunctionName:str\":\"RandomBetween\",\"CodeJS:json\":\"\\\"// This generates a random number between two arguments.\\\\n// Example: RandomBetween(5, 10)\\\\n\\\\n// Process Code\\\\nlet min = Math.min(arguments[0] || 0, arguments[1] || 0);\\\\nlet max = Math.max(arguments[0] || 0, arguments[1] || 0);\\\\nreturn Math.floor(Math.random() * (max - min + 1) + min);\\\"\"}","{\"FunctionName:str\":\"RandomFrom\",\"CodeJS:json\":\"\\\"// Selects a number from the list of inserted numbers.\\\\n// Example: RandomFrom(5, 10, 15, 20)\\\\n\\\\n// Process Code\\\\nreturn arguments[Math.randomInt(arguments.length)];\\\"\"}"]
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Quality of Life Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~QoLSettings:
 *
 * @param PlayTest
 * @text Play Test
 *
 * @param NewGameBoot:eval
 * @text New Game on Boot
 * @parent PlayTest
 * @type boolean
 * @on Start New Game
 * @off Keep Title Screen
 * @desc Automatically start a new game on Play Test?
 * Only enabled during Play Test.
 * @default false
 *
 * @param ForceNoPlayTest:eval
 * @text No Play Test Mode
 * @parent PlayTest
 * @type boolean
 * @on Cancel Play Test
 * @off Keep Play Test
 * @desc Force the game to be out of Play Test mode when play testing.
 * @default false
 *
 * @param OpenConsole:eval
 * @text Open Console on Boot
 * @parent PlayTest
 * @type boolean
 * @on Open
 * @off Don't Open
 * @desc Open the Debug Console upon booting up your game?
 * Only enabled during Play Test.
 * @default true
 *
 * @param F6key:eval
 * @text F6: Toggle Sound
 * @parent PlayTest
 * @type boolean
 * @on Enable
 * @off Don't
 * @desc F6 Key Function: Turn on all sound to 100% or to 0%,
 * toggling between the two.
 * @default true
 *
 * @param F7key:eval
 * @text F7: Toggle Fast Mode
 * @parent PlayTest
 * @type boolean
 * @on Enable
 * @off Don't
 * @desc F7 Key Function: Toggle fast mode.
 * @default true
 *
 * @param CtrlQuickLoad:eval
 * @text CTRL + n: Quick Load
 * @parent PlayTest
 * @type boolean
 * @on Enable
 * @off Don't
 * @desc CTRL + a number from 1 to 9 will yield a quick load of
 * that safe file. Does not count auto saves.
 * @default true
 *
 * @param NewGameCommonEvent:num
 * @text NewGame > CommonEvent
 * @parent PlayTest
 * @type common_event
 * @desc Runs a common event each time a new game during play test
 * session is started.
 * @default 0
 *
 * @param BattleTest
 * @text Battle Test
 *
 * @param BTestItems:eval
 * @text Add Item Type
 * @parent BattleTest
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add copies of each database item?
 * Effective only during battle test.
 * @default true
 *
 * @param BTestWeapons:eval
 * @text Add Weapon Type
 * @parent BattleTest
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add copies of each database weapon?
 * Effective only during battle test.
 * @default true
 *
 * @param BTestArmors:eval
 * @text Add Armor Type
 * @parent BattleTest
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add copies of each database armor?
 * Effective only during battle test.
 * @default true
 *
 * @param BTestAddedQuantity:num
 * @text Added Quantity
 * @parent BattleTest
 * @type number
 * @min 1
 * @desc Determines how many items are added during a battle test instead of the maximum amount.
 * @default 90
 *
 * @param ShiftR_Toggle:eval
 * @text Shift+R: Recover All
 * @parent BattleTest
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc For Play Test only! During battle, pressing SHIFT + R will refill the whole party's HP and MP and status.
 * @default true
 *
 * @param ShiftT_Toggle:eval
 * @text Shift+T: Full TP
 * @parent BattleTest
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc For Play Test only! During battle, pressing SHIFT + T will refill the whole party's TP.
 * @default true
 *
 * @param DigitGrouping
 * @text Digit Grouping
 *
 * @param DigitGroupingStandardText:eval
 * @text Standard Text
 * @parent DigitGrouping
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Make numbers like 1234567 appear like 1,234,567 for
 * standard text inside windows?
 * @default true
 *
 * @param DigitGroupingExText:eval
 * @text Ex Text
 * @parent DigitGrouping
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Make numbers like 1234567 appear like 1,234,567 for
 * ex text, written through drawTextEx (like messages)?
 * @default true
 *
 * @param DigitGroupingDamageSprites:eval
 * @text Damage Sprites
 * @parent DigitGrouping
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Make numbers like 1234567 appear like 1,234,567 for
 * in-battle damage sprites?
 * @default true
 *
 * @param DigitGroupingGaugeSprites:eval
 * @text Gauge Sprites
 * @parent DigitGrouping
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Make numbers like 1234567 appear like 1,234,567 for
 * visible gauge sprites such as HP, MP, and TP gauges?
 * @default true
 *
 * @param DigitGroupingLocale:str
 * @text Country/Locale
 * @parent DigitGrouping
 * @type combo
 * @option ar-SA
 * @option bn-BD
 * @option bn-IN
 * @option cs-CZ
 * @option da-DK
 * @option de-AT
 * @option de-CH
 * @option de-DE
 * @option el-GR
 * @option en-AU
 * @option en-CA
 * @option en-GB
 * @option en-IE
 * @option en-IN
 * @option en-NZ
 * @option en-US
 * @option en-ZA
 * @option es-AR
 * @option es-CL
 * @option es-CO
 * @option es-ES
 * @option es-MX
 * @option es-US
 * @option fi-FI
 * @option fr-BE
 * @option fr-CA
 * @option fr-CH
 * @option fr-FR
 * @option he-IL
 * @option hi-IN
 * @option hu-HU
 * @option id-ID
 * @option it-CH
 * @option it-IT
 * @option jp-JP
 * @option ko-KR
 * @option nl-BE
 * @option nl-NL
 * @option no-NO
 * @option pl-PL
 * @option pt-BR
 * @option pt-PT
 * @option ro-RO
 * @option ru-RU
 * @option sk-SK
 * @option sv-SE
 * @option ta-IN
 * @option ta-LK
 * @option th-TH
 * @option tr-TR
 * @option zh-CN
 * @option zh-HK
 * @option zh-TW
 * @desc Base the digit grouping on which country/locale?
 * @default en-US
 *
 * @param PlayerBenefit
 * @text Player Benefit
 *
 * @param EncounterRateMinimum:num
 * @text Encounter Rate Min
 * @parent PlayerBenefit
 * @min 1
 * @desc Minimum number of steps the player can take without any random encounters.
 * @default 10
 *
 * @param EscapeAlways:eval
 * @text Escape Always
 * @parent PlayerBenefit
 * @type boolean
 * @on Always
 * @off Default
 * @desc If the player wants to escape a battle, let them escape the battle with 100% chance.
 * @default true
 *
 * @param ImprovedAccuracySystem:eval
 * @text Accuracy Formula
 * @parent PlayerBenefit
 * @type boolean
 * @on Improve
 * @off Default
 * @desc Accuracy formula calculation change to
 * Skill Hit% * (User HIT - Target EVA) for better results.
 * @default true
 *
 * @param AccuracyBoost:eval
 * @text Accuracy Boost
 * @parent PlayerBenefit
 * @type boolean
 * @on Boost
 * @off Default
 * @desc Boost HIT and EVA rates in favor of the player.
 * @default true
 *
 * @param LevelUpFullHp:eval
 * @text Level Up -> Full HP
 * @parent PlayerBenefit
 * @type boolean
 * @on Heal
 * @off Default
 * @desc Recovers full HP when an actor levels up.
 * @default true
 *
 * @param LevelUpFullMp:eval
 * @text Level Up -> Full MP
 * @parent PlayerBenefit
 * @type boolean
 * @on Heal
 * @off Default
 * @desc Recovers full MP when an actor levels up.
 * @default true
 *
 * @param Pictures
 * @text Picture-Related
 *
 * @param AntiZoomPictures:eval
 * @text Anti-Zoom Pictures
 * @parent Pictures
 * @type boolean
 * @on Anti-Zoom
 * @off Normal
 * @desc If on, prevents pictures from being affected by zoom.
 * @default true
 * 
 * @param PictureContainers
 * @text Picture Containers
 * @parent Pictures
 *
 * @param DetachBattlePictureContainer:eval
 * @text Detach in Battle
 * @parent PictureContainers
 * @type boolean
 * @on Detach
 * @off Normal
 * @desc If detached, picture container will be separated from
 * the spriteset while on the battle scene.
 * @default false
 *
 * @param DetachMapPictureContainer:eval
 * @text Detach in Map
 * @parent PictureContainers
 * @type boolean
 * @on Detach
 * @off Normal
 * @desc If detached, picture container will be separated from
 * the spriteset while on the map scene.
 * @default false
 *
 * @param Misc
 * @text Misc
 *
 * @param AnimationMirrorOffset:eval
 * @text Ani: Mirror Offset
 * @parent Misc
 * @type boolean
 * @on Mirror
 * @off Don't Mirror
 * @desc When animations are mirrored,
 * mirror their Offset X values, too.
 * @default false
 *
 * @param AutoStretch:str
 * @text Auto-Stretch
 * @parent Misc
 * @type select
 * @option Default
 * @value default
 * @option Stretch
 * @value stretch
 * @option Normal
 * @value normal
 * @desc Automatically stretch the game to fit the size of the client?
 * @default default
 *
 * @param FontShadows:eval
 * @text Font Shadows
 * @parent Misc
 * @type boolean
 * @on Shadows
 * @off Outlines
 * @desc If on, text uses shadows instead of outlines.
 * @default false
 *
 * @param FontSmoothing:eval
 * @text Font Smoothing
 * @parent Misc
 * @type boolean
 * @on Smooth
 * @off None
 * @desc If on, smoothes fonts shown in-game.
 * @default true
 *
 * @param FontWidthFix:eval
 * @text Font Width Fix
 * @parent Misc
 * @type boolean
 * @on Fix
 * @off Default
 * @desc Fixes the font width issue with instant display
 * non-monospaced fonts in the Message Window.
 * @default true
 *
 * @param KeyItemProtect:eval
 * @text Key Item Protection
 * @parent Misc
 * @type boolean
 * @on Unsellable
 * @off Sellable
 * @desc If on, prevents Key Items from being able to be sold and from being able to be consumed.
 * @default true
 *
 * @param MapNameTextCode:eval
 * @text Map Name Text Code
 * @parent Misc
 * @type boolean
 * @on Text Codes
 * @off Raw Text
 * @desc If on, map names will use text codes.
 * If off, only the raw map name will be used.
 * @default true
 *
 * @param ModernControls:eval
 * @text Modern Controls
 * @parent Misc
 * @type boolean
 * @on Enable
 * @off Default
 * @desc If on, allows usage of the Home/End buttons as well as other modern configs. Affects other VisuStella plugins.
 * @default true
 *
 * @param MvAnimationRate:num
 * @text MV Animation Rate
 * @parent Misc
 * @min 1
 * @max 10
 * @desc Adjusts the rate at which MV animations play.
 * Default: 4. Lower for faster. Higher for slower.
 * @default 4
 *
 * @param NewGameCommonEventAll:num
 * @text NewGame > CommonEvent
 * @parent Misc
 * @type common_event
 * @desc Runs a common event each time a new game during any session is started.
 * @default 0
 *
 * @param NoTileShadows:eval
 * @text No Tile Shadows
 * @parent Misc
 * @type boolean
 * @on Disable Tile Shadows
 * @off Default
 * @desc Removes tile shadows from being displayed in-game.
 * @default false
 *
 * @param PixelateImageRendering:eval
 * @text Pixel Image Rendering
 * @parent Misc
 * @type boolean
 * @on Pixelate
 * @off Smooth
 * @desc If on, pixelates the image rendering (for pixel games).
 * @default false
 *
 * @param RequireFocus:eval
 * @text Require Focus?
 * @parent Misc
 * @type boolean
 * @on Require
 * @off No Requirement
 * @desc Requires the game to be focused? If the game isn't
 * focused, it will pause if it's not the active window.
 * @default true
 *
 * @param ShortcutScripts:eval
 * @text Shortcut Scripts
 * @parent Misc
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enables shortcut-based scripts.
 * View the helpfile for more information.
 * @default true
 *
 * @param SmartEventCollisionPriority:eval
 * @text Smart Event Collision
 * @parent Misc
 * @type boolean
 * @on Only Same Level
 * @off Default
 * @desc Makes events only able to collide with one another if they're 'Same as characters' priority.
 * @default true
 *
 * @param SubfolderParse:eval
 * @text Subfolder Name Purge
 * @parent Misc
 * @type boolean
 * @on Purge Subfolders Names
 * @off Don't Purge Name
 * @desc Purge subfolder name from Plugin Parameters when reading
 * data to let Plugin Commands work properly.
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Color Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Color:
 *
 * @param BasicColors
 * @text Basic Colors
 *
 * @param ColorNormal:str
 * @text Normal
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 0
 *
 * @param ColorSystem:str
 * @text System
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 16
 *
 * @param ColorCrisis:str
 * @text Crisis
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 17
 *
 * @param ColorDeath:str
 * @text Death
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 18
 *
 * @param ColorGaugeBack:str
 * @text Gauge Back
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 19
 *
 * @param ColorHPGauge1:str
 * @text HP Gauge 1
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 20
 *
 * @param ColorHPGauge2:str
 * @text HP Gauge 2
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 21
 *
 * @param ColorMPGauge1:str
 * @text MP Gauge 1
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 22
 *
 * @param ColorMPGauge2:str
 * @text MP Gauge 2
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 23
 *
 * @param ColorMPCost:str
 * @text MP Cost
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 23
 *
 * @param ColorPowerUp:str
 * @text Power Up
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 24
 *
 * @param ColorPowerDown:str
 * @text Power Down
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 25
 *
 * @param ColorCTGauge1:str
 * @text CT Gauge 1
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 26
 *
 * @param ColorCTGauge2:str
 * @text CT Gauge 2
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 27
 *
 * @param ColorTPGauge1:str
 * @text TP Gauge 1
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 28
 *
 * @param ColorTPGauge2:str
 * @text TP Gauge 2
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 29
 *
 * @param ColorTPCost:str
 * @text TP Cost
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 29
 *
 * @param ColorPending:str
 * @text Pending Color
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #2a847d
 *
 * @param ColorExpGauge1:str
 * @text EXP Gauge 1
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 30
 *
 * @param ColorExpGauge2:str
 * @text EXP Gauge 2
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 31
 *
 * @param ColorMaxLvGauge1:str
 * @text MaxLv Gauge 1
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 14
 *
 * @param ColorMaxLvGauge2:str
 * @text MaxLv Gauge 2
 * @parent BasicColors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 6
 *
 * @param AlphaColors
 * @text Alpha Colors
 *
 * @param OutlineColor:str
 * @text Window Font Outline
 * @parent AlphaColors
 * @desc Colors with a bit of alpha settings.
 * Format rgba(0-255, 0-255, 0-255, 0-1)
 * @default rgba(0, 0, 0, 0.6)
 *
 * @param OutlineColorGauge:str
 * @text Gauge Number Outline
 * @parent AlphaColors
 * @desc Colors with a bit of alpha settings.
 * Format rgba(0-255, 0-255, 0-255, 0-1)
 * @default rgba(0, 0, 0, 1.0)
 *
 * @param DimColor1:str
 * @text Dim Color 1
 * @parent AlphaColors
 * @desc Colors with a bit of alpha settings.
 * Format rgba(0-255, 0-255, 0-255, 0-1)
 * @default rgba(0, 0, 0, 0.6)
 *
 * @param DimColor2:str
 * @text Dim Color 2
 * @parent AlphaColors
 * @desc Colors with a bit of alpha settings.
 * Format rgba(0-255, 0-255, 0-255, 0-1)
 * @default rgba(0, 0, 0, 0)
 *
 * @param ItemBackColor1:str
 * @text Item Back Color 1
 * @parent AlphaColors
 * @desc Colors with a bit of alpha settings.
 * Format rgba(0-255, 0-255, 0-255, 0-1)
 * @default rgba(32, 32, 32, 0.5)
 *
 * @param ItemBackColor2:str
 * @text Item Back Color 2
 * @parent AlphaColors
 * @desc Colors with a bit of alpha settings.
 * Format rgba(0-255, 0-255, 0-255, 0-1)
 * @default rgba(0, 0, 0, 0.5)
 *
 * @param ConditionalColors
 * @text Conditional Colors
 *
 * @param ActorHPColor:func
 * @text JS: Actor HP Color
 * @type note
 * @parent ConditionalColors
 * @desc Code used for determining what HP color to use for actors.
 * @default "// Set the variables used in this function.\nlet actor = arguments[0];\n\n// Check if the actor exists. If not, return normal.\nif (!actor) {\n    return this.normalColor();\n\n// If the actor is dead, return death color.\n} else if (actor.isDead()) {\n    return this.deathColor();\n\n// If the actor is dying, return crisis color.\n} else if (actor.isDying()) {\n    return this.crisisColor();\n\n// Otherwise, return the normal color.\n} else {\n    return this.normalColor();\n}"
 *
 * @param ActorMPColor:func
 * @text JS: Actor MP Color
 * @type note
 * @parent ConditionalColors
 * @desc Code used for determining what MP color to use for actors.
 * @default "// Set the variables used in this function.\nlet actor = arguments[0];\n\n// Check if the actor exists. If not, return normal.\nif (!actor) {\n    return this.normalColor();\n\n// If MP rate is below 25%, return crisis color.\n} else if (actor.mpRate() < 0.25) {\n    return this.crisisColor();\n\n// Otherwise, return the normal color.\n} else {\n    return this.normalColor();\n}"
 *
 * @param ActorTPColor:func
 * @text JS: Actor TP Color
 * @type note
 * @parent ConditionalColors
 * @desc Code used for determining what TP color to use for actors.
 * @default "// Set the variables used in this function.\nlet actor = arguments[0];\n\n// Check if the actor exists. If not, return normal.\nif (!actor) {\n    return this.normalColor();\n\n// If TP rate is below 25%, return crisis color.\n} else if (actor.tpRate() < 0.25) {\n    return this.crisisColor();\n\n// Otherwise, return the normal color.\n} else {\n    return this.normalColor();\n}"
 *
 * @param ParamChange:func
 * @text JS: Parameter Change
 * @type note
 * @parent ConditionalColors
 * @desc Code used for determining whatcolor to use for parameter changes.
 * @default "// Set the variables used in this function.\nlet change = arguments[0];\n\n// If a positive change, use power up color.\nif (change > 0) {\n    return this.powerUpColor();\n\n// If a negative change, use power down color.\n} else if (change < 0) {\n    return this.powerDownColor();\n\n// Otherwise, return the normal color.\n} else {\n    return this.normalColor();\n}"
 *
 * @param DamageColor:func
 * @text JS: Damage Colors
 * @type note
 * @parent ConditionalColors
 * @desc Code used for determining what color to use for damage types.
 * @default "// Set the variables used in this function.\nlet colorType = arguments[0];\n\n// Check the value of the color type\n// and return an appropriate color.\nswitch (colorType) {\n\n    case 0: // HP damage\n        return \"#ffffff\";\n\n    case 1: // HP recover\n        return \"#b9ffb5\";\n\n    case 2: // MP damage\n        return \"#bb88bb\";\n\n    case 3: // MP recover\n        return \"#80b0ff\";\n\n    default:\n        return \"#808080\";\n}"
 */
/* ----------------------------------------------------------------------------
 * Gold Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Gold:
 *
 * @param GoldMax:num
 * @text Gold Max
 * @type num
 * @min 1
 * @desc Maximum amount of Gold the party can hold.
 * Default 99999999
 * @default 99999999
 *
 * @param GoldFontSize:num
 * @text Gold Font Size
 * @type number
 * @min 1
 * @desc Font size used for displaying Gold inside Gold Windows.
 * Default: 26
 * @default 24
 *
 * @param GoldIcon:num
 * @text Gold Icon
 * @desc Icon used to represent Gold.
 * Use 0 for no icon.
 * @default 314
 *
 * @param GoldOverlap:str
 * @text Gold Overlap
 * @desc Text used too much Gold to fit in the window.
 * @default A Lot
 *
 * @param ItemStyle:eval
 * @text Item Style
 * @type boolean
 * @on Enable
 * @off Normal
 * @desc Draw gold in the item style?
 * ie: Icon, Label, Value
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Image Loading Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ImgLoad:
 *
 * @param animations:arraystr
 * @text img/animations/
 * @type file[]
 * @dir img/animations/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param battlebacks1:arraystr
 * @text img/battlebacks1/
 * @type file[]
 * @dir img/battlebacks1/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param battlebacks2:arraystr
 * @text img/battlebacks2/
 * @type file[]
 * @dir img/battlebacks2/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param characters:arraystr
 * @text img/characters/
 * @type file[]
 * @dir img/characters/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param enemies:arraystr
 * @text img/enemies/
 * @type file[]
 * @dir img/enemies/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param faces:arraystr
 * @text img/faces/
 * @type file[]
 * @dir img/faces/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param parallaxes:arraystr
 * @text img/parallaxes/
 * @type file[]
 * @dir img/parallaxes/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param pictures:arraystr
 * @text img/pictures/
 * @type file[]
 * @dir img/pictures/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param sv_actors:arraystr
 * @text img/sv_actors/
 * @type file[]
 * @dir img/sv_actors/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param sv_enemies:arraystr
 * @text img/sv_enemies/
 * @type file[]
 * @dir img/sv_enemies/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param system:arraystr
 * @text img/system/
 * @type file[]
 * @dir img/system/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default ["Balloon","IconSet"]
 *
 * @param tilesets:arraystr
 * @text img/tilesets/
 * @type file[]
 * @dir img/tilesets/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param titles1:arraystr
 * @text img/titles1/
 * @type file[]
 * @dir img/titles1/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 * @param titles2:arraystr
 * @text img/titles2/
 * @type file[]
 * @dir img/titles2/
 * @desc Which files do you wish to load from this directory upon
 * starting up the game?
 * @default []
 *
 */
/* ----------------------------------------------------------------------------
 * Keyboard Input Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~KeyboardInput:
 *
 * @param Controls
 *
 * @param WASD:eval
 * @text WASD Movement
 * @parent Controls
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enables or disables WASD movement for your game project.
 * Moves the W page down button to E.
 * @default false
 *
 * @param DashToggleR:eval
 * @text R Button: Dash Toggle
 * @parent Controls
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enables or disables R button as an Always Dash option toggle.
 * @default false
 *
 * @param NameInput
 * @text Name Input
 *
 * @param EnableNameInput:eval
 * @text Enable?
 * @parent NameInput
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enables keyboard input for name entry.
 * Only tested with English keyboards.
 * @default true
 * 
 * @param DefaultMode:str
 * @text Default Mode
 * @parent NameInput
 * @type select
 * @option Default - Uses Arrow Keys to select letters.
 * @value default
 * @option Keyboard - Uses Keyboard to type in letters.
 * @value keyboard
 * @desc Select default mode when entering the scene.
 * @default keyboard
 *
 * @param QwertyLayout:eval
 * @text QWERTY Layout
 * @parent NameInput
 * @type boolean
 * @on QWERTY Layout
 * @off ABCDEF Layout
 * @desc Uses the QWERTY layout for manual entry.
 * @default true
 *
 * @param NameInputMessage:eval
 * @text Keyboard Message
 * @parent NameInput
 * @type note
 * @desc The message displayed when allowing keyboard entry.
 * You may use text codes here.
 * @default "Type in this character's name.\nPress \\c[5]ENTER\\c[0] when you're done.\n\n-or-\n\nPress \\c[5]arrow keys\\c[0]/\\c[5]TAB\\c[0] to switch\nto manual character entry.\n\nPress \\c[5]ESC\\c[0]/\\c[5]TAB\\c[0] to use to keyboard."
 * 
 * @param BannedWords:arraystr
 * @text Banned Words
 * @parent NameInput
 * @type string[]
 * @desc Players cannot use these words for names.
 * These include words inside the names.
 * @default []
 *
 * @param NumberInput
 * @text Number Input
 *
 * @param EnableNumberInput:eval
 * @text Enable?
 * @parent NumberInput
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enables keyboard input for number entry.
 * Only tested with English keyboards.
 * @default true
 *
 * @param ButtonAssist
 * @text Button Assist
 * 
 * @param Finish:str
 * @text Finish Entry
 * @parent ButtonAssist
 * @desc Text used to describe finish entry.
 * @default Finish
 * 
 * @param PageChange:str
 * @text Page Change
 * @parent ButtonAssist
 * @desc Text used to describe character page changing.
 * @default Page
 * 
 * @param Keyboard:str
 * @text Switch To Keyboard
 * @parent ButtonAssist
 * @desc Text used to describe the keyboard switch.
 * @default Keyboard
 * 
 * @param Manual:str
 * @text Switch To Manual
 * @parent ButtonAssist
 * @desc Text used to describe the manual entry switch.
 * @default Manual
 *
 */
/* ----------------------------------------------------------------------------
 * Menu Background Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MenuBg:
 * 
 * @param BlurStrength:num
 * @text Blur Strength
 * @desc Strength used for menu background snapshots.
 * Default: 8. Higher is stronger. Lower is weaker.
 * @default 8
 *
 * @param Scene_Menu:struct
 * @text Scene_Menu
 * @type struct<BgSettings>
 * @desc The individual background settings for this scene.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Scene_Item:struct
 * @text Scene_Item
 * @type struct<BgSettings>
 * @desc The individual background settings for this scene.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Scene_Skill:struct
 * @text Scene_Skill
 * @type struct<BgSettings>
 * @desc The individual background settings for this scene.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Scene_Equip:struct
 * @text Scene_Equip
 * @type struct<BgSettings>
 * @desc The individual background settings for this scene.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Scene_Status:struct
 * @text Scene_Status
 * @type struct<BgSettings>
 * @desc The individual background settings for this scene.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Scene_Options:struct
 * @text Scene_Options
 * @type struct<BgSettings>
 * @desc The individual background settings for this scene.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Scene_Save:struct
 * @text Scene_Save
 * @type struct<BgSettings>
 * @desc The individual background settings for this scene.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Scene_Load:struct
 * @text Scene_Load
 * @type struct<BgSettings>
 * @desc The individual background settings for this scene.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Scene_GameEnd:struct
 * @text Scene_GameEnd
 * @type struct<BgSettings>
 * @desc The individual background settings for this scene.
 * @default {"SnapshotOpacity:num":"128","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Scene_Shop:struct
 * @text Scene_Shop
 * @type struct<BgSettings>
 * @desc The individual background settings for this scene.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Scene_Name:struct
 * @text Scene_Name
 * @type struct<BgSettings>
 * @desc The individual background settings for this scene.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Scene_Unlisted:struct
 * @text Scene_Unlisted
 * @type struct<BgSettings>
 * @desc The individual background settings for any scenes that aren't listed here.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 */
/* ----------------------------------------------------------------------------
 * Background Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BgSettings:
 *
 * @param SnapshotOpacity:num
 * @text Snapshop Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc Snapshot opacity for the scene.
 * @default 192
 *
 * @param BgFilename1:str
 * @text Background 1
 * @type file
 * @dir img/titles1/
 * @desc Filename used for the bottom background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 * @param BgFilename2:str
 * @text Background 2
 * @type file
 * @dir img/titles2/
 * @desc Filename used for the upper background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 */
/* ----------------------------------------------------------------------------
 * Menu Button Assist Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ButtonAssist:
 *
 * @param General
 *
 * @param Enable:eval
 * @text Enable
 * @parent General
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Enable the Menu Button Assist Window.
 * @default true
 *
 * @param Location:str
 * @text Location
 * @parent General
 * @type select
 * @option Top of Screen
 * @value top
 * @option Bottom of Screen
 * @value bottom
 * @desc Determine the location of the Button Assist Window.
 * Requires Plugin Parameters => UI => Side Buttons ON.
 * @default bottom
 *
 * @param BgType:num
 * @text Background Type
 * @parent General
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param SplitEscape:eval
 * @text Split "Escape"
 * @parent General
 * @type boolean
 * @on Split
 * @off Don't
 * @desc "Split" makes separate instances of "Cancel" and "Menu".
 * "Don't" will consolidate both into "Escape".
 * @default false
 *
 * @param Text
 *
 * @param TextFmt:str
 * @text Text Format
 * @parent Text
 * @desc Format on how the buttons are displayed.
 * Text codes allowed. %1 - Key, %2 - Text
 * @default %1:%2
 *
 * @param MultiKeyFmt:str
 * @text Multi-Key Format
 * @parent Text
 * @desc Format for actions with multiple keys.
 * Text codes allowed. %1 - Key 1, %2 - Key 2
 * @default %1/%2
 *
 * @param OkText:str
 * @text OK Text
 * @parent Text
 * @desc Default text used to display OK Key Action.
 * Text codes allowed.
 * @default Select
 *
 * @param CancelText:str
 * @text Cancel Text
 * @parent Text
 * @desc Default text used to display Cancel Key Action.
 * Text codes allowed.
 * @default Back
 *
 * @param SwitchActorText:str
 * @text Switch Actor Text
 * @parent Text
 * @desc Default text used to display Switch Actor Action.
 * Text codes allowed.
 * @default Switch Ally
 *
 * @param Keys
 *
 * @param KeyUnlisted:str
 * @text Key: Unlisted Format
 * @parent Keys
 * @desc If a key is not listed below, use this format.
 * Text codes allowed. %1 - Key
 * @default \}❪%1❫\{
 *
 * @param KeyUP:str
 * @text Key: Up
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default ^
 *
 * @param KeyDOWN:str
 * @text Key: Down
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default v
 *
 * @param KeyLEFT:str
 * @text Key: Left
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default <<
 *
 * @param KeyRIGHT:str
 * @text Key: Right
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default >>
 *
 * @param KeySHIFT:str
 * @text Key: Shift
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default \}❪SHIFT❫\{
 *
 * @param KeyTAB:str
 * @text Key: Tab
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default \}❪TAB❫\{
 *
 * @param KeyA:str
 * @text Key: A
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default A
 *
 * @param KeyB:str
 * @text Key: B
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default B
 *
 * @param KeyC:str
 * @text Key: C
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default C
 *
 * @param KeyD:str
 * @text Key: D
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default D
 *
 * @param KeyE:str
 * @text Key: E
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default E
 *
 * @param KeyF:str
 * @text Key: F
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default F
 *
 * @param KeyG:str
 * @text Key: G
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default G
 *
 * @param KeyH:str
 * @text Key: H
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default H
 *
 * @param KeyI:str
 * @text Key: I
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default I
 *
 * @param KeyJ:str
 * @text Key: J
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default J
 *
 * @param KeyK:str
 * @text Key: K
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default K
 *
 * @param KeyL:str
 * @text Key: L
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default L
 *
 * @param KeyM:str
 * @text Key: M
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default M
 *
 * @param KeyN:str
 * @text Key: N
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default N
 *
 * @param KeyO:str
 * @text Key: O
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default O
 *
 * @param KeyP:str
 * @text Key: P
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default P
 *
 * @param KeyQ:str
 * @text Key: Q
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default Q
 *
 * @param KeyR:str
 * @text Key: R
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default R
 *
 * @param KeyS:str
 * @text Key: S
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default S
 *
 * @param KeyT:str
 * @text Key: T
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default T
 *
 * @param KeyU:str
 * @text Key: U
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default U
 *
 * @param KeyV:str
 * @text Key: V
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default V
 *
 * @param KeyW:str
 * @text Key: W
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default W
 *
 * @param KeyX:str
 * @text Key: X
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default X
 *
 * @param KeyY:str
 * @text Key: Y
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default Y
 *
 * @param KeyZ:str
 * @text Key: Z
 * @parent Keys
 * @desc How this key is shown in-game.
 * Text codes allowed.
 * @default Z
 *
 */
/* ----------------------------------------------------------------------------
 * Controller Buttons Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ControllerButtons:
 *
 * @param ID
 * @text ID Information
 *
 * @param Name:str
 * @text Controller ID Name
 * @parent ID
 * @desc Exact string used for this controller ID. Plugin Command
 * "Debug: Current Controller ID" for ID help.
 * @default Untitled
 *
 * @param Match:str
 * @text Similarity Match
 * @parent ID
 * @desc Similar text used for this controller ID. Plugin Command
 * "Debug: Current Controller ID" for ID help.
 * @default Untitled
 * 
 * @param Directions
 *
 * @param up:str
 * @text Up
 * @parent Directions
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default 
 *
 * @param left:str
 * @text Left
 * @parent Directions
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default 
 *
 * @param right:str
 * @text Right
 * @parent Directions
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default 
 *
 * @param down:str
 * @text Down
 * @parent Directions
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default 
 * 
 * @param Actions
 *
 * @param ok:str
 * @text OK
 * @parent Actions
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default 
 *
 * @param cancel:str
 * @text Cancel
 * @parent Actions
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default 
 *
 * @param menu:str
 * @text Menu
 * @parent Actions
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default 
 *
 * @param shift:str
 * @text Shift
 * @parent Actions
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default 
 *
 * @param pageup:str
 * @text Page Up
 * @parent Actions
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default 
 *
 * @param pagedown:str
 * @text Page Down
 * @parent Actions
 * @desc How this button is shown in-game.
 * Text codes allowed.
 * @default 
 *
 */
/* ----------------------------------------------------------------------------
 * Menu Layout Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MenuLayout:
 *
 * @param Title:struct
 * @text Scene_Title
 * @parent SceneSettings
 * @type struct<Title>
 * @desc Various options on adjusting the Title Scene.
 * @default {"TitleScreen":"","DocumentTitleFmt:str":"%1: %2 - Version %3","Subtitle:str":"Subtitle","Version:str":"0.00","drawGameTitle:func":"\"const x = 20;\\nconst y = Graphics.height / 4;\\nconst maxWidth = Graphics.width - x * 2;\\nconst text = $dataSystem.gameTitle;\\nconst bitmap = this._gameTitleSprite.bitmap;\\nbitmap.fontFace = $gameSystem.mainFontFace();\\nbitmap.outlineColor = \\\"black\\\";\\nbitmap.outlineWidth = 8;\\nbitmap.fontSize = 72;\\nbitmap.drawText(text, x, y, maxWidth, 48, \\\"center\\\");\"","drawGameSubtitle:func":"\"const x = 20;\\nconst y = Graphics.height / 4 + 72;\\nconst maxWidth = Graphics.width - x * 2;\\nconst text = Scene_Title.subtitle;\\nconst bitmap = this._gameTitleSprite.bitmap;\\nbitmap.fontFace = $gameSystem.mainFontFace();\\nbitmap.outlineColor = \\\"black\\\";\\nbitmap.outlineWidth = 6;\\nbitmap.fontSize = 48;\\nbitmap.drawText(text, x, y, maxWidth, 48, \\\"center\\\");\"","drawGameVersion:func":"\"const bitmap = this._gameTitleSprite.bitmap;\\nconst x = 0;\\nconst y = Graphics.height - 20;\\nconst width = Math.round(Graphics.width / 4);\\nconst height = 20;\\nconst c1 = ColorManager.dimColor1();\\nconst c2 = ColorManager.dimColor2();\\nconst text = 'Version ' + Scene_Title.version;\\nbitmap.gradientFillRect(x, y, width, height, c1, c2);\\nbitmap.fontFace = $gameSystem.mainFontFace();\\nbitmap.outlineColor = \\\"black\\\";\\nbitmap.outlineWidth = 3;\\nbitmap.fontSize = 16;\\nbitmap.drawText(text, x + 4, y, Graphics.width, height, \\\"left\\\");\"","CommandRect:func":"\"const offsetX = $dataSystem.titleCommandWindow.offsetX;\\nconst offsetY = $dataSystem.titleCommandWindow.offsetY;\\nconst rows = this.commandWindowRows();\\nconst width = this.mainCommandWidth();\\nconst height = this.calcWindowHeight(rows, true);\\nconst x = (Graphics.boxWidth - width) / 2 + offsetX;\\nconst y = Graphics.boxHeight - height - 96 + offsetY;\\nreturn new Rectangle(x, y, width, height);\"","ButtonFadeSpeed:num":"4"}
 *
 * @param MainMenu:struct
 * @text Scene_Menu
 * @parent SceneSettings
 * @type struct<MainMenu>
 * @desc Various options on adjusting the Main Menu Scene.
 * @default {"CommandWindow":"","CommandBgType:num":"0","CommandRect:func":"\"const width = this.mainCommandWidth();\\nconst height = this.mainAreaHeight() - this.goldWindowRect().height;\\nconst x = this.isRightInputMode() ? Graphics.boxWidth - width : 0;\\nconst y = this.mainAreaTop();\\nreturn new Rectangle(x, y, width, height);\"","GoldWindow":"","GoldBgType:num":"0","GoldRect:func":"\"const rows = 1;\\nconst width = this.mainCommandWidth();\\nconst height = this.calcWindowHeight(rows, true);\\nconst x = this.isRightInputMode() ? Graphics.boxWidth - width : 0;\\nconst y = this.mainAreaBottom() - height;\\nreturn new Rectangle(x, y, width, height);\"","StatusWindow":"","StatusBgType:num":"0","StatusRect:func":"\"const width = Graphics.boxWidth - this.mainCommandWidth();\\nconst height = this.mainAreaHeight();\\nconst x = this.isRightInputMode() ? 0 : Graphics.boxWidth - width;\\nconst y = this.mainAreaTop();\\nreturn new Rectangle(x, y, width, height);\""}
 *
 * @param ItemMenu:struct
 * @text Scene_Item
 * @parent SceneSettings
 * @type struct<ItemMenu>
 * @desc Various options on adjusting the Item Menu Scene.
 * @default {"HelpWindow":"","HelpBgType:num":"0","HelpRect:func":"\"const x = 0;\\nconst y = this.helpAreaTop();\\nconst width = Graphics.boxWidth;\\nconst height = this.helpAreaHeight();\\nreturn new Rectangle(x, y, width, height);\"","CategoryWindow":"","CategoryBgType:num":"0","CategoryRect:func":"\"const x = 0;\\nconst y = this.mainAreaTop();\\nconst rows = 1;\\nconst width = Graphics.boxWidth;\\nconst height = this.calcWindowHeight(rows, true);\\nreturn new Rectangle(x, y, width, height);\"","ItemWindow":"","ItemBgType:num":"0","ItemRect:func":"\"const x = 0;\\nconst y = this._categoryWindow.y + this._categoryWindow.height;\\nconst width = Graphics.boxWidth;\\nconst height = this.mainAreaBottom() - y;\\nreturn new Rectangle(x, y, width, height);\"","ActorWindow":"","ActorBgType:num":"0","ActorRect:func":"\"const x = 0;\\nconst y = this.mainAreaTop();\\nconst width = Graphics.boxWidth;\\nconst height = this.mainAreaHeight();\\nreturn new Rectangle(x, y, width, height);\""}
 *
 * @param SkillMenu:struct
 * @text Scene_Skill
 * @parent SceneSettings
 * @type struct<SkillMenu>
 * @desc Various options on adjusting the Skill Menu Scene.
 * @default {"HelpWindow":"","HelpBgType:num":"0","HelpRect:func":"\"const x = 0;\\nconst y = this.helpAreaTop();\\nconst width = Graphics.boxWidth;\\nconst height = this.helpAreaHeight();\\nreturn new Rectangle(x, y, width, height);\"","SkillTypeWindow":"","SkillTypeBgType:num":"0","SkillTypeRect:func":"\"const rows = 3;\\nconst width = this.mainCommandWidth();\\nconst height = this.calcWindowHeight(rows, true);\\nconst x = this.isRightInputMode() ? Graphics.boxWidth - width : 0;\\nconst y = this.mainAreaTop();\\nreturn new Rectangle(x, y, width, height);\"","StatusWindow":"","StatusBgType:num":"0","StatusRect:func":"\"const width = Graphics.boxWidth - this.mainCommandWidth();\\nconst height = this._skillTypeWindow.height;\\nconst x = this.isRightInputMode() ? 0 : Graphics.boxWidth - width;\\nconst y = this.mainAreaTop();\\nreturn new Rectangle(x, y, width, height);\"","ItemWindow":"","ItemBgType:num":"0","ItemRect:func":"\"const x = 0;\\nconst y = this._statusWindow.y + this._statusWindow.height;\\nconst width = Graphics.boxWidth;\\nconst height = this.mainAreaHeight() - this._statusWindow.height;\\nreturn new Rectangle(x, y, width, height);\"","ActorWindow":"","ActorBgType:num":"0","ActorRect:func":"\"const x = 0;\\nconst y = this.mainAreaTop();\\nconst width = Graphics.boxWidth;\\nconst height = this.mainAreaHeight();\\nreturn new Rectangle(x, y, width, height);\""}
 *
 * @param EquipMenu:struct
 * @text Scene_Equip
 * @parent SceneSettings
 * @type struct<EquipMenu>
 * @desc Various options on adjusting the Equip Menu Scene.
 * @default {"HelpWindow":"","HelpBgType:num":"0","HelpRect:func":"\"const x = 0;\\nconst y = this.helpAreaTop();\\nconst width = Graphics.boxWidth;\\nconst height = this.helpAreaHeight();\\nreturn new Rectangle(x, y, width, height);\"","StatusWindow":"","StatusBgType:num":"0","StatusRect:func":"\"const x = 0;\\nconst y = this.mainAreaTop();\\nconst width = this.statusWidth();\\nconst height = this.mainAreaHeight();\\nreturn new Rectangle(x, y, width, height);\"","CommandWindow":"","CommandBgType:num":"0","CommandRect:func":"\"const x = this.statusWidth();\\nconst y = this.mainAreaTop();\\nconst rows = 1;\\nconst width = Graphics.boxWidth - this.statusWidth();\\nconst height = this.calcWindowHeight(rows, true);\\nreturn new Rectangle(x, y, width, height);\"","SlotWindow":"","SlotBgType:num":"0","SlotRect:func":"\"const commandWindowRect = this.commandWindowRect();\\nconst x = this.statusWidth();\\nconst y = commandWindowRect.y + commandWindowRect.height;\\nconst width = Graphics.boxWidth - this.statusWidth();\\nconst height = this.mainAreaHeight() - commandWindowRect.height;\\nreturn new Rectangle(x, y, width, height);\"","ItemWindow":"","ItemBgType:num":"0","ItemRect:func":"\"return this.slotWindowRect();\""}
 *
 * @param StatusMenu:struct
 * @text Scene_Status
 * @parent SceneSettings
 * @type struct<StatusMenu>
 * @desc Various options on adjusting the Status Menu Scene.
 * @default {"ProfileWindow":"","ProfileBgType:num":"0","ProfileRect:func":"\"const width = Graphics.boxWidth;\\nconst height = this.profileHeight();\\nconst x = 0;\\nconst y = this.mainAreaBottom() - height;\\nreturn new Rectangle(x, y, width, height);\"","StatusWindow":"","StatusBgType:num":"0","StatusRect:func":"\"const x = 0;\\nconst y = this.mainAreaTop();\\nconst width = Graphics.boxWidth;\\nconst height = this.statusParamsWindowRect().y - y;\\nreturn new Rectangle(x, y, width, height);\"","StatusParamsWindow":"","StatusParamsBgType:num":"0","StatusParamsRect:func":"\"const width = this.statusParamsWidth();\\nconst height = this.statusParamsHeight();\\nconst x = 0;\\nconst y = this.mainAreaBottom() - this.profileHeight() - height;\\nreturn new Rectangle(x, y, width, height);\"","StatusEquipWindow":"","StatusEquipBgType:num":"0","StatusEquipRect:func":"\"const width = Graphics.boxWidth - this.statusParamsWidth();\\nconst height = this.statusParamsHeight();\\nconst x = this.statusParamsWidth();\\nconst y = this.mainAreaBottom() - this.profileHeight() - height;\\nreturn new Rectangle(x, y, width, height);\""}
 *
 * @param OptionsMenu:struct
 * @text Scene_Options
 * @parent SceneSettings
 * @type struct<OptionsMenu>
 * @desc Various options on adjusting the Options Menu Scene.
 * @default {"OptionsWindow":"","OptionsBgType:num":"0","OptionsRect:func":"\"const n = Math.min(this.maxCommands(), this.maxVisibleCommands());\\nconst width = 400;\\nconst height = this.calcWindowHeight(n, true);\\nconst x = (Graphics.boxWidth - width) / 2;\\nconst y = (Graphics.boxHeight - height) / 2;\\nreturn new Rectangle(x, y, width, height);\""}
 *
 * @param SaveMenu:struct
 * @text Scene_Save
 * @parent SceneSettings
 * @type struct<SaveMenu>
 * @desc Various options on adjusting the Save Menu Scene.
 * @default {"HelpWindow":"","HelpBgType:num":"0","HelpRect:func":"\"const x = 0;\\nconst y = this.mainAreaTop();\\nconst rows = 1;\\nconst width = Graphics.boxWidth;\\nconst height = this.calcWindowHeight(rows, false);\\nreturn new Rectangle(x, y, width, height);\"","ListWindow":"","ListBgType:num":"0","ListRect:func":"\"const x = 0;\\nconst y = this.mainAreaTop() + this._helpWindow.height;\\nconst width = Graphics.boxWidth;\\nconst height = this.mainAreaHeight() - this._helpWindow.height;\\nreturn new Rectangle(x, y, width, height);\""}
 *
 * @param LoadMenu:struct
 * @text Scene_Load
 * @parent SceneSettings
 * @type struct<LoadMenu>
 * @desc Various options on adjusting the Load Menu Scene.
 * @default {"HelpWindow":"","HelpBgType:num":"0","HelpRect:func":"\"const x = 0;\\nconst y = this.mainAreaTop();\\nconst rows = 1;\\nconst width = Graphics.boxWidth;\\nconst height = this.calcWindowHeight(rows, false);\\nreturn new Rectangle(x, y, width, height);\"","ListWindow":"","ListBgType:num":"0","ListRect:func":"\"const x = 0;\\nconst y = this.mainAreaTop() + this._helpWindow.height;\\nconst width = Graphics.boxWidth;\\nconst height = this.mainAreaHeight() - this._helpWindow.height;\\nreturn new Rectangle(x, y, width, height);\""}
 *
 * @param GameEnd:struct
 * @text Scene_GameEnd
 * @parent SceneSettings
 * @type struct<GameEnd>
 * @desc Various options on adjusting the Game End Scene.
 * @default {"CommandList:arraystruct":"[\"{\\\"Symbol:str\\\":\\\"toTitle\\\",\\\"TextStr:str\\\":\\\"Untitled\\\",\\\"TextJS:func\\\":\\\"\\\\\\\"return TextManager.toTitle;\\\\\\\"\\\",\\\"ShowJS:func\\\":\\\"\\\\\\\"return true;\\\\\\\"\\\",\\\"EnableJS:func\\\":\\\"\\\\\\\"return true;\\\\\\\"\\\",\\\"ExtJS:func\\\":\\\"\\\\\\\"return null;\\\\\\\"\\\",\\\"CallHandlerJS:func\\\":\\\"\\\\\\\"SceneManager._scene.commandToTitle();\\\\\\\"\\\"}\",\"{\\\"Symbol:str\\\":\\\"cancel\\\",\\\"TextStr:str\\\":\\\"Untitled\\\",\\\"TextJS:func\\\":\\\"\\\\\\\"return TextManager.cancel;\\\\\\\"\\\",\\\"ShowJS:func\\\":\\\"\\\\\\\"return true;\\\\\\\"\\\",\\\"EnableJS:func\\\":\\\"\\\\\\\"return true;\\\\\\\"\\\",\\\"ExtJS:func\\\":\\\"\\\\\\\"return null;\\\\\\\"\\\",\\\"CallHandlerJS:func\\\":\\\"\\\\\\\"SceneManager._scene.popScene();\\\\\\\"\\\"}\"]","CommandBgType:num":"0","CommandRect:func":"\"const rows = 2;\\nconst width = this.mainCommandWidth();\\nconst height = this.calcWindowHeight(rows, true);\\nconst x = (Graphics.boxWidth - width) / 2;\\nconst y = (Graphics.boxHeight - height) / 2;\\nreturn new Rectangle(x, y, width, height);\""}
 *
 * @param ShopMenu:struct
 * @text Scene_Shop
 * @parent SceneSettings
 * @type struct<ShopMenu>
 * @desc Various options on adjusting the Shop Menu Scene.
 * @default {"HelpWindow":"","HelpBgType:num":"0","HelpRect:func":"\"const wx = 0;\\nconst wy = this.helpAreaTop();\\nconst ww = Graphics.boxWidth;\\nconst wh = this.helpAreaHeight();\\nreturn new Rectangle(wx, wy, ww, wh);\"","GoldWindow":"","GoldBgType:num":"0","GoldRect:func":"\"const rows = 1;\\nconst width = this.mainCommandWidth();\\nconst height = this.calcWindowHeight(rows, true);\\nconst x = Graphics.boxWidth - width;\\nconst y = this.mainAreaTop();\\nreturn new Rectangle(x, y, width, height);\"","CommandWindow":"","CommandBgType:num":"0","CommandRect:func":"\"const x = 0;\\nconst y = this.mainAreaTop();\\nconst rows = 1;\\nconst width = this._goldWindow.x;\\nconst height = this.calcWindowHeight(rows, true);\\nreturn new Rectangle(x, y, width, height);\"","DummyWindow":"","DummyBgType:num":"0","DummyRect:func":"\"const x = 0;\\nconst y = this._commandWindow.y + this._commandWindow.height;\\nconst width = Graphics.boxWidth;\\nconst height = this.mainAreaHeight() - this._commandWindow.height;\\nreturn new Rectangle(x, y, width, height);\"","NumberWindow":"","NumberBgType:num":"0","NumberRect:func":"\"const x = 0;\\nconst y = this._dummyWindow.y;\\nconst width = Graphics.boxWidth - this.statusWidth();\\nconst height = this._dummyWindow.height;\\nreturn new Rectangle(x, y, width, height);\"","StatusWindow":"","StatusBgType:num":"0","StatusRect:func":"\"const width = this.statusWidth();\\nconst height = this._dummyWindow.height;\\nconst x = Graphics.boxWidth - width;\\nconst y = this._dummyWindow.y;\\nreturn new Rectangle(x, y, width, height);\"","BuyWindow":"","BuyBgType:num":"0","BuyRect:func":"\"const x = 0;\\nconst y = this._dummyWindow.y;\\nconst width = Graphics.boxWidth - this.statusWidth();\\nconst height = this._dummyWindow.height;\\nreturn new Rectangle(x, y, width, height);\"","CategoryWindow":"","CategoryBgType:num":"0","CategoryRect:func":"\"const x = 0;\\nconst y = this._dummyWindow.y;\\nconst rows = 1;\\nconst width = Graphics.boxWidth;\\nconst height = this.calcWindowHeight(rows, true);\\nreturn new Rectangle(x, y, width, height);\"","SellWindow":"","SellBgType:num":"0","SellRect:func":"\"const x = 0;\\nconst y = this._categoryWindow.y + this._categoryWindow.height;\\nconst width = Graphics.boxWidth;\\nconst height =\\n    this.mainAreaHeight() -\\n    this._commandWindow.height -\\n    this._categoryWindow.height;\\nreturn new Rectangle(x, y, width, height);\""}
 *
 * @param NameMenu:struct
 * @text Scene_Name
 * @parent SceneSettings
 * @type struct<NameMenu>
 * @desc Various options on adjusting the Actor Rename Scene.
 * @default {"EditWindow":"","EditBgType:num":"0","EditRect:func":"\"const rows = 9;\\nconst inputWindowHeight = this.calcWindowHeight(rows, true);\\nconst padding = $gameSystem.windowPadding();\\nconst width = 600;\\nconst height = Math.min(ImageManager.faceHeight + padding * 2, this.mainAreaHeight() - inputWindowHeight);\\nconst x = (Graphics.boxWidth - width) / 2;\\nconst y = (this.mainAreaHeight() - (height + inputWindowHeight)) / 2 + this.mainAreaTop();\\nreturn new Rectangle(x, y, width, height);\"","InputWindow":"","InputBgType:num":"0","InputRect:func":"\"const x = this._editWindow.x;\\nconst y = this._editWindow.y + this._editWindow.height;\\nconst rows = 9;\\nconst width = this._editWindow.width;\\nconst height = this.calcWindowHeight(rows, true);\\nreturn new Rectangle(x, y, width, height);\""}
 *
 */
/* ----------------------------------------------------------------------------
 * Main Menu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MainMenu:
 *
 * @param CommandWindow
 * @text Command Window
 *
 * @param CommandBgType:num
 * @text Background Type
 * @parent CommandWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param CommandRect:func
 * @text JS: X, Y, W, H
 * @parent CommandWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = this.mainCommandWidth();\nconst height = this.mainAreaHeight() - this.goldWindowRect().height;\nconst x = this.isRightInputMode() ? Graphics.boxWidth - width : 0;\nconst y = this.mainAreaTop();\nreturn new Rectangle(x, y, width, height);"
 *
 * @param GoldWindow
 * @text Gold Window
 *
 * @param GoldBgType:num
 * @text Background Type
 * @parent GoldWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param GoldRect:func
 * @text JS: X, Y, W, H
 * @parent GoldWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const rows = 1;\nconst width = this.mainCommandWidth();\nconst height = this.calcWindowHeight(rows, true);\nconst x = this.isRightInputMode() ? Graphics.boxWidth - width : 0;\nconst y = this.mainAreaBottom() - height;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param StatusWindow
 * @text Status Window
 *
 * @param StatusBgType:num
 * @text Background Type
 * @parent StatusWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusRect:func
 * @text JS: X, Y, W, H
 * @parent StatusWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.boxWidth - this.mainCommandWidth();\nconst height = this.mainAreaHeight();\nconst x = this.isRightInputMode() ? 0 : Graphics.boxWidth - width;\nconst y = this.mainAreaTop();\nreturn new Rectangle(x, y, width, height);"
 *
 */
/* ----------------------------------------------------------------------------
 * Item Menu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ItemMenu:
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpBgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param HelpRect:func
 * @text JS: X, Y, W, H
 * @parent HelpWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.helpAreaTop();\nconst width = Graphics.boxWidth;\nconst height = this.helpAreaHeight();\nreturn new Rectangle(x, y, width, height);"
 *
 * @param CategoryWindow
 * @text Category Window
 *
 * @param CategoryBgType:num
 * @text Background Type
 * @parent CategoryWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param CategoryRect:func
 * @text JS: X, Y, W, H
 * @parent CategoryWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.mainAreaTop();\nconst rows = 1;\nconst width = Graphics.boxWidth;\nconst height = this.calcWindowHeight(rows, true);\nreturn new Rectangle(x, y, width, height);"
 *
 * @param ItemWindow
 * @text Item Window
 *
 * @param ItemBgType:num
 * @text Background Type
 * @parent ItemWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ItemRect:func
 * @text JS: X, Y, W, H
 * @parent ItemWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this._categoryWindow.y + this._categoryWindow.height;\nconst width = Graphics.boxWidth;\nconst height = this.mainAreaBottom() - y;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param ActorWindow
 * @text Actor Window
 *
 * @param ActorBgType:num
 * @text Background Type
 * @parent ActorWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ActorRect:func
 * @text JS: X, Y, W, H
 * @parent ActorWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.mainAreaTop();\nconst width = Graphics.boxWidth;\nconst height = this.mainAreaHeight();\nreturn new Rectangle(x, y, width, height);"
 *
 */
/* ----------------------------------------------------------------------------
 * Skill Menu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~SkillMenu:
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpBgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param HelpRect:func
 * @text JS: X, Y, W, H
 * @parent HelpWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.helpAreaTop();\nconst width = Graphics.boxWidth;\nconst height = this.helpAreaHeight();\nreturn new Rectangle(x, y, width, height);"
 *
 * @param SkillTypeWindow
 * @text Skill Type Window
 *
 * @param SkillTypeBgType:num
 * @text Background Type
 * @parent SkillTypeWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param SkillTypeRect:func
 * @text JS: X, Y, W, H
 * @parent SkillTypeWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const rows = 3;\nconst width = this.mainCommandWidth();\nconst height = this.calcWindowHeight(rows, true);\nconst x = this.isRightInputMode() ? Graphics.boxWidth - width : 0;\nconst y = this.mainAreaTop();\nreturn new Rectangle(x, y, width, height);"
 *
 * @param StatusWindow
 * @text Status Window
 *
 * @param StatusBgType:num
 * @text Background Type
 * @parent StatusWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusRect:func
 * @text JS: X, Y, W, H
 * @parent StatusWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.boxWidth - this.mainCommandWidth();\nconst height = this._skillTypeWindow.height;\nconst x = this.isRightInputMode() ? 0 : Graphics.boxWidth - width;\nconst y = this.mainAreaTop();\nreturn new Rectangle(x, y, width, height);"
 *
 * @param ItemWindow
 * @text Item Window
 *
 * @param ItemBgType:num
 * @text Background Type
 * @parent ItemWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ItemRect:func
 * @text JS: X, Y, W, H
 * @parent ItemWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this._statusWindow.y + this._statusWindow.height;\nconst width = Graphics.boxWidth;\nconst height = this.mainAreaHeight() - this._statusWindow.height;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param ActorWindow
 * @text Actor Window
 *
 * @param ActorBgType:num
 * @text Background Type
 * @parent ActorWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ActorRect:func
 * @text JS: X, Y, W, H
 * @parent ActorWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.mainAreaTop();\nconst width = Graphics.boxWidth;\nconst height = this.mainAreaHeight();\nreturn new Rectangle(x, y, width, height);"
 *
 */
/* ----------------------------------------------------------------------------
 * Equip Menu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~EquipMenu:
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpBgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param HelpRect:func
 * @text JS: X, Y, W, H
 * @parent HelpWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.helpAreaTop();\nconst width = Graphics.boxWidth;\nconst height = this.helpAreaHeight();\nreturn new Rectangle(x, y, width, height);"
 *
 * @param StatusWindow
 * @text Status Window
 *
 * @param StatusBgType:num
 * @text Background Type
 * @parent StatusWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusRect:func
 * @text JS: X, Y, W, H
 * @parent StatusWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.mainAreaTop();\nconst width = this.statusWidth();\nconst height = this.mainAreaHeight();\nreturn new Rectangle(x, y, width, height);"
 *
 * @param CommandWindow
 * @text Command Window
 *
 * @param CommandBgType:num
 * @text Background Type
 * @parent CommandWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param CommandRect:func
 * @text JS: X, Y, W, H
 * @parent CommandWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = this.statusWidth();\nconst y = this.mainAreaTop();\nconst rows = 1;\nconst width = Graphics.boxWidth - this.statusWidth();\nconst height = this.calcWindowHeight(rows, true);\nreturn new Rectangle(x, y, width, height);"
 *
 * @param SlotWindow
 * @text Slot Window
 *
 * @param SlotBgType:num
 * @text Background Type
 * @parent SlotWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param SlotRect:func
 * @text JS: X, Y, W, H
 * @parent SlotWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const commandWindowRect = this.commandWindowRect();\nconst x = this.statusWidth();\nconst y = commandWindowRect.y + commandWindowRect.height;\nconst width = Graphics.boxWidth - this.statusWidth();\nconst height = this.mainAreaHeight() - commandWindowRect.height;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param ItemWindow
 * @text Item Window
 *
 * @param ItemBgType:num
 * @text Background Type
 * @parent ItemWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ItemRect:func
 * @text JS: X, Y, W, H
 * @parent ItemWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "return this.slotWindowRect();"
 *
 */
/* ----------------------------------------------------------------------------
 * Status Menu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~StatusMenu:
 *
 * @param ProfileWindow
 * @text Profile Window
 *
 * @param ProfileBgType:num
 * @text Background Type
 * @parent ProfileWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ProfileRect:func
 * @text JS: X, Y, W, H
 * @parent ProfileWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.boxWidth;\nconst height = this.profileHeight();\nconst x = 0;\nconst y = this.mainAreaBottom() - height;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param StatusWindow
 * @text Status Window
 *
 * @param StatusBgType:num
 * @text Background Type
 * @parent StatusWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusRect:func
 * @text JS: X, Y, W, H
 * @parent StatusWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.mainAreaTop();\nconst width = Graphics.boxWidth;\nconst height = this.statusParamsWindowRect().y - y;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param StatusParamsWindow
 * @text Parameters Window
 *
 * @param StatusParamsBgType:num
 * @text Background Type
 * @parent StatusParamsWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusParamsRect:func
 * @text JS: X, Y, W, H
 * @parent StatusParamsWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = this.statusParamsWidth();\nconst height = this.statusParamsHeight();\nconst x = 0;\nconst y = this.mainAreaBottom() - this.profileHeight() - height;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param StatusEquipWindow
 * @text Equipment Window
 *
 * @param StatusEquipBgType:num
 * @text Background Type
 * @parent StatusEquipWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusEquipRect:func
 * @text JS: X, Y, W, H
 * @parent StatusEquipWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.boxWidth - this.statusParamsWidth();\nconst height = this.statusParamsHeight();\nconst x = this.statusParamsWidth();\nconst y = this.mainAreaBottom() - this.profileHeight() - height;\nreturn new Rectangle(x, y, width, height);"
 *
 */
/* ----------------------------------------------------------------------------
 * Options Menu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~OptionsMenu:
 *
 * @param OptionsWindow
 * @text Options Window
 *
 * @param OptionsBgType:num
 * @text Background Type
 * @parent OptionsWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param OptionsRect:func
 * @text JS: X, Y, W, H
 * @parent OptionsWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const n = Math.min(this.maxCommands(), this.maxVisibleCommands());\nconst width = 400;\nconst height = this.calcWindowHeight(n, true);\nconst x = (Graphics.boxWidth - width) / 2;\nconst y = (Graphics.boxHeight - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 */
/* ----------------------------------------------------------------------------
 * Save Menu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~SaveMenu:
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpBgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param HelpRect:func
 * @text JS: X, Y, W, H
 * @parent HelpWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.mainAreaTop();\nconst rows = 1;\nconst width = Graphics.boxWidth;\nconst height = this.calcWindowHeight(rows, false);\nreturn new Rectangle(x, y, width, height);"
 *
 * @param ListWindow
 * @text List Window
 *
 * @param ListBgType:num
 * @text Background Type
 * @parent ListWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ListRect:func
 * @text JS: X, Y, W, H
 * @parent ListWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.mainAreaTop() + this._helpWindow.height;\nconst width = Graphics.boxWidth;\nconst height = this.mainAreaHeight() - this._helpWindow.height;\nreturn new Rectangle(x, y, width, height);"
 *
 */
/* ----------------------------------------------------------------------------
 * Load Menu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~LoadMenu:
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpBgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param HelpRect:func
 * @text JS: X, Y, W, H
 * @parent HelpWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.mainAreaTop();\nconst rows = 1;\nconst width = Graphics.boxWidth;\nconst height = this.calcWindowHeight(rows, false);\nreturn new Rectangle(x, y, width, height);"
 *
 * @param ListWindow
 * @text List Window
 *
 * @param ListBgType:num
 * @text Background Type
 * @parent ListWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param ListRect:func
 * @text JS: X, Y, W, H
 * @parent ListWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.mainAreaTop() + this._helpWindow.height;\nconst width = Graphics.boxWidth;\nconst height = this.mainAreaHeight() - this._helpWindow.height;\nreturn new Rectangle(x, y, width, height);"
 *
 */
/* ----------------------------------------------------------------------------
 * Game End Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~GameEnd:
 *
 * @param CommandList:arraystruct
 * @text Command Window List
 * @type struct<Command>[]
 * @desc Window commands used by the Game End screen.
 * Add new commands here.
 * @default ["{\"Symbol:str\":\"toTitle\",\"TextStr:str\":\"Untitled\",\"TextJS:func\":\"\\\"return TextManager.toTitle;\\\"\",\"ShowJS:func\":\"\\\"return true;\\\"\",\"EnableJS:func\":\"\\\"return true;\\\"\",\"ExtJS:func\":\"\\\"return null;\\\"\",\"CallHandlerJS:func\":\"\\\"SceneManager._scene.commandToTitle();\\\"\"}","{\"Symbol:str\":\"cancel\",\"TextStr:str\":\"Untitled\",\"TextJS:func\":\"\\\"return TextManager.cancel;\\\"\",\"ShowJS:func\":\"\\\"return true;\\\"\",\"EnableJS:func\":\"\\\"return true;\\\"\",\"ExtJS:func\":\"\\\"return null;\\\"\",\"CallHandlerJS:func\":\"\\\"SceneManager._scene.popScene();\\\"\"}"]
 *
 * @param CommandBgType:num
 * @text Background Type
 * @parent CommandList:arraystruct
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param CommandRect:func
 * @text JS: X, Y, W, H
 * @parent CommandList:arraystruct
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const rows = 2;\nconst width = this.mainCommandWidth();\nconst height = this.calcWindowHeight(rows, true);\nconst x = (Graphics.boxWidth - width) / 2;\nconst y = (Graphics.boxHeight - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 */
/* ----------------------------------------------------------------------------
 * Shop Menu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ShopMenu:
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpBgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param HelpRect:func
 * @text JS: X, Y, W, H
 * @parent HelpWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const wx = 0;\nconst wy = this.helpAreaTop();\nconst ww = Graphics.boxWidth;\nconst wh = this.helpAreaHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param GoldWindow
 * @text Gold Window
 *
 * @param GoldBgType:num
 * @text Background Type
 * @parent GoldWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param GoldRect:func
 * @text JS: X, Y, W, H
 * @parent GoldWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const rows = 1;\nconst width = this.mainCommandWidth();\nconst height = this.calcWindowHeight(rows, true);\nconst x = Graphics.boxWidth - width;\nconst y = this.mainAreaTop();\nreturn new Rectangle(x, y, width, height);"
 *
 * @param CommandWindow
 * @text Command Window
 *
 * @param CommandBgType:num
 * @text Background Type
 * @parent CommandWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param CommandRect:func
 * @text JS: X, Y, W, H
 * @parent CommandWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this.mainAreaTop();\nconst rows = 1;\nconst width = this._goldWindow.x;\nconst height = this.calcWindowHeight(rows, true);\nreturn new Rectangle(x, y, width, height);"
 *
 * @param DummyWindow
 * @text Dummy Window
 *
 * @param DummyBgType:num
 * @text Background Type
 * @parent DummyWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param DummyRect:func
 * @text JS: X, Y, W, H
 * @parent DummyWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this._commandWindow.y + this._commandWindow.height;\nconst width = Graphics.boxWidth;\nconst height = this.mainAreaHeight() - this._commandWindow.height;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param NumberWindow
 * @text Number Window
 *
 * @param NumberBgType:num
 * @text Background Type
 * @parent NumberWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param NumberRect:func
 * @text JS: X, Y, W, H
 * @parent NumberWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this._dummyWindow.y;\nconst width = Graphics.boxWidth - this.statusWidth();\nconst height = this._dummyWindow.height;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param StatusWindow
 * @text Status Window
 *
 * @param StatusBgType:num
 * @text Background Type
 * @parent StatusWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusRect:func
 * @text JS: X, Y, W, H
 * @parent StatusWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = this.statusWidth();\nconst height = this._dummyWindow.height;\nconst x = Graphics.boxWidth - width;\nconst y = this._dummyWindow.y;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param BuyWindow
 * @text Buy Window
 *
 * @param BuyBgType:num
 * @text Background Type
 * @parent BuyWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param BuyRect:func
 * @text JS: X, Y, W, H
 * @parent BuyWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this._dummyWindow.y;\nconst width = Graphics.boxWidth - this.statusWidth();\nconst height = this._dummyWindow.height;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param CategoryWindow
 * @text Category Window
 *
 * @param CategoryBgType:num
 * @text Background Type
 * @parent CategoryWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param CategoryRect:func
 * @text JS: X, Y, W, H
 * @parent CategoryWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this._dummyWindow.y;\nconst rows = 1;\nconst width = Graphics.boxWidth;\nconst height = this.calcWindowHeight(rows, true);\nreturn new Rectangle(x, y, width, height);"
 *
 * @param SellWindow
 * @text Sell Window
 *
 * @param SellBgType:num
 * @text Background Type
 * @parent SellWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param SellRect:func
 * @text JS: X, Y, W, H
 * @parent SellWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = 0;\nconst y = this._categoryWindow.y + this._categoryWindow.height;\nconst width = Graphics.boxWidth;\nconst height =\n    this.mainAreaHeight() -\n    this._commandWindow.height -\n    this._categoryWindow.height;\nreturn new Rectangle(x, y, width, height);"
 *
 */
/* ----------------------------------------------------------------------------
 * Name Menu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~NameMenu:
 *
 * @param EditWindow
 * @text Edit Window
 *
 * @param EditBgType:num
 * @text Background Type
 * @parent EditWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param EditRect:func
 * @text JS: X, Y, W, H
 * @parent EditWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const rows = 9;\nconst inputWindowHeight = this.calcWindowHeight(rows, true);\nconst padding = $gameSystem.windowPadding();\nconst width = 600;\nconst height = Math.min(ImageManager.faceHeight + padding * 2, this.mainAreaHeight() - inputWindowHeight);\nconst x = (Graphics.boxWidth - width) / 2;\nconst y = (this.mainAreaHeight() - (height + inputWindowHeight)) / 2 + this.mainAreaTop();\nreturn new Rectangle(x, y, width, height);"
 *
 * @param InputWindow
 * @text Input Window
 *
 * @param InputBgType:num
 * @text Background Type
 * @parent InputWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param InputRect:func
 * @text JS: X, Y, W, H
 * @parent InputWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const x = this._editWindow.x;\nconst y = this._editWindow.y + this._editWindow.height;\nconst rows = 9;\nconst width = this._editWindow.width;\nconst height = this.calcWindowHeight(rows, true);\nreturn new Rectangle(x, y, width, height);"
 *
 */
/* ----------------------------------------------------------------------------
 * Title Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Title:
 *
 * @param TitleScreen
 * @text Title Screen
 *
 * @param DocumentTitleFmt:str
 * @text Document Title Format
 * @parent TitleScreen
 * @desc Format to display text in document title.
 * %1 - Main Title, %2 - Subtitle, %3 - Version
 * @default %1: %2 - Version %3
 *
 * @param Subtitle:str
 * @text Subtitle
 * @parent TitleScreen
 * @desc Subtitle to be displayed under the title name.
 * @default Subtitle
 *
 * @param Version:str
 * @text Version
 * @parent TitleScreen
 * @desc Version to be display in the title screen corner.
 * @default 0.00
 *
 * @param drawGameTitle:func
 * @text JS: Draw Title
 * @type note
 * @parent TitleScreen
 * @desc Code used to draw the game title.
 * @default "const x = 20;\nconst y = Graphics.height / 4;\nconst maxWidth = Graphics.width - x * 2;\nconst text = $dataSystem.gameTitle;\nconst bitmap = this._gameTitleSprite.bitmap;\nbitmap.fontFace = $gameSystem.mainFontFace();\nbitmap.outlineColor = \"black\";\nbitmap.outlineWidth = 8;\nbitmap.fontSize = 72;\nbitmap.drawText(text, x, y, maxWidth, 48, \"center\");"
 *
 * @param drawGameSubtitle:func
 * @text JS: Draw Subtitle
 * @type note
 * @parent TitleScreen
 * @desc Code used to draw the game subtitle.
 * @default "const x = 20;\nconst y = Graphics.height / 4 + 72;\nconst maxWidth = Graphics.width - x * 2;\nconst text = Scene_Title.subtitle;\nconst bitmap = this._gameTitleSprite.bitmap;\nbitmap.fontFace = $gameSystem.mainFontFace();\nbitmap.outlineColor = \"black\";\nbitmap.outlineWidth = 6;\nbitmap.fontSize = 48;\nbitmap.drawText(text, x, y, maxWidth, 48, \"center\");"
 *
 * @param drawGameVersion:func
 * @text JS: Draw Version
 * @type note
 * @parent TitleScreen
 * @desc Code used to draw the game version.
 * @default "const bitmap = this._gameTitleSprite.bitmap;\nconst x = 0;\nconst y = Graphics.height - 20;\nconst width = Math.round(Graphics.width / 4);\nconst height = 20;\nconst c1 = ColorManager.dimColor1();\nconst c2 = ColorManager.dimColor2();\nconst text = 'Version ' + Scene_Title.version;\nbitmap.gradientFillRect(x, y, width, height, c1, c2);\nbitmap.fontFace = $gameSystem.mainFontFace();\nbitmap.outlineColor = \"black\";\nbitmap.outlineWidth = 3;\nbitmap.fontSize = 16;\nbitmap.drawText(text, x + 4, y, Graphics.width, height, \"left\");"
 *
 * @param CommandRect:func
 * @text JS: X, Y, W, H
 * @parent TitleScreen
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const offsetX = $dataSystem.titleCommandWindow.offsetX;\nconst offsetY = $dataSystem.titleCommandWindow.offsetY;\nconst rows = this.commandWindowRows();\nconst width = this.mainCommandWidth();\nconst height = this.calcWindowHeight(rows, true);\nconst x = (Graphics.boxWidth - width) / 2 + offsetX;\nconst y = Graphics.boxHeight - height - 96 + offsetY;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param ButtonFadeSpeed:num
 * @text Button Fade Speed
 * @parent TitleScreen
 * @type number
 * @min 1
 * @max 255
 * @desc Speed at which the buttons fade in at (1-255).
 * @default 4
 *
 */
/* ----------------------------------------------------------------------------
 * Parameter Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Param:
 *
 * @param DisplayedParams:arraystr
 * @text Displayed Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @option HIT
 * @option EVA
 * @option CRI
 * @option CEV
 * @option MEV
 * @option MRF
 * @option CNT
 * @option HRG
 * @option MRG
 * @option TRG
 * @option TGR
 * @option GRD
 * @option REC
 * @option PHA
 * @option MCR
 * @option TCR
 * @option PDR
 * @option MDR
 * @option FDR
 * @option EXR
 * @desc A list of the parameters that will be displayed in-game.
 * @default ["ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @param ExtDisplayedParams:arraystr
 * @text Extended Parameters
 * @parent DisplayedParams:arraystr
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @option HIT
 * @option EVA
 * @option CRI
 * @option CEV
 * @option MEV
 * @option MRF
 * @option CNT
 * @option HRG
 * @option MRG
 * @option TRG
 * @option TGR
 * @option GRD
 * @option REC
 * @option PHA
 * @option MCR
 * @option TCR
 * @option PDR
 * @option MDR
 * @option FDR
 * @option EXR
 * @desc The list shown in extended scenes (for other VisuStella plugins).
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @param BasicParameters
 * @text Basic Parameters
 *
 * @param ShowActorLevel:eval
 * @text Show Actor Level?
 * @parent BasicParameters
 * @type boolean
 * @on Show
 * @off Don't Show
 * @desc Show the actor level when displaying actors?
 * Affects for most windows in-game.
 * @default true
 *
 * @param CrisisRate:num
 * @text HP Crisis Rate
 * @parent BasicParameters
 * @desc HP Ratio at which a battler can be considered in crisis mode.
 * @default 0.25
 *
 * @param BasicParameterFormula:func
 * @text JS: Formula
 * @parent BasicParameters
 * @type note
 * @desc Formula used to determine the total value all 8 basic parameters: MaxHP, MaxMP, ATK, DEF, MAT, MDF, AGI, LUK.
 * @default "// Determine the variables used in this calculation.\nlet paramId = arguments[0];\nlet base = this.paramBase(paramId);\nlet plus = this.paramPlus(paramId);\nlet paramRate = this.paramRate(paramId);\nlet buffRate = this.paramBuffRate(paramId);\nlet flatBonus = this.paramFlatBonus(paramId);\n\n// Formula to determine total parameter value.\nlet value = (base + plus) * paramRate * buffRate + flatBonus;\n\n// Determine the limits\nconst maxValue = this.paramMax(paramId);\nconst minValue = this.paramMin(paramId);\n\n// Final value\nreturn Math.round(value.clamp(minValue, maxValue));"
 *
 * @param BasicParamCaps
 * @text Parameter Caps
 * @parent BasicParameters
 *
 * @param BasicActorParamCaps
 * @text Actors
 * @parent BasicParamCaps
 *
 * @param BasicActorParamMax0:str
 * @text MaxHP Cap
 * @parent BasicActorParamCaps
 * @desc Formula used to determine MaxHP cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 9999
 *
 * @param BasicActorParamMax1:str
 * @text MaxMP Cap
 * @parent BasicActorParamCaps
 * @desc Formula used to determine MaxMP cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 9999
 *
 * @param BasicActorParamMax2:str
 * @text ATK Cap
 * @parent BasicActorParamCaps
 * @desc Formula used to determine ATK cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param BasicActorParamMax3:str
 * @text DEF Cap
 * @parent BasicActorParamCaps
 * @desc Formula used to determine DEF cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param BasicActorParamMax4:str
 * @text MAT Cap
 * @parent BasicActorParamCaps
 * @desc Formula used to determine MAT cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param BasicActorParamMax5:str
 * @text MDF Cap
 * @parent BasicActorParamCaps
 * @desc Formula used to determine MDF cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param BasicActorParamMax6:str
 * @text AGI Cap
 * @parent BasicActorParamCaps
 * @desc Formula used to determine AGI cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param BasicActorParamMax7:str
 * @text LUK Cap
 * @parent BasicActorParamCaps
 * @desc Formula used to determine LUK cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param BasicEnemyParamCaps
 * @text Enemies
 * @parent BasicParamCaps
 *
 * @param BasicEnemyParamMax0:str
 * @text MaxHP Cap
 * @parent BasicEnemyParamCaps
 * @desc Formula used to determine MaxHP cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999999
 *
 * @param BasicEnemyParamMax1:str
 * @text MaxMP Cap
 * @parent BasicEnemyParamCaps
 * @desc Formula used to determine MaxMP cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 9999
 *
 * @param BasicEnemyParamMax2:str
 * @text ATK Cap
 * @parent BasicEnemyParamCaps
 * @desc Formula used to determine ATK cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param BasicEnemyParamMax3:str
 * @text DEF Cap
 * @parent BasicEnemyParamCaps
 * @desc Formula used to determine DEF cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param BasicEnemyParamMax4:str
 * @text MAT Cap
 * @parent BasicEnemyParamCaps
 * @desc Formula used to determine MAT cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param BasicEnemyParamMax5:str
 * @text MDF Cap
 * @parent BasicEnemyParamCaps
 * @desc Formula used to determine MDF cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param BasicEnemyParamMax6:str
 * @text AGI Cap
 * @parent BasicEnemyParamCaps
 * @desc Formula used to determine AGI cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param BasicEnemyParamMax7:str
 * @text LUK Cap
 * @parent BasicEnemyParamCaps
 * @desc Formula used to determine LUK cap.
 * Use 0 if you don't want a cap for this parameter.
 * @default 999
 *
 * @param XParameters
 * @text X Parameters
 *
 * @param XParameterFormula:func
 * @text JS: Formula
 * @parent XParameters
 * @type note
 * @desc Formula used to determine the total value all 10 X parameters: HIT, EVA, CRI, CEV, MEV, MRF, CNT, HRG, MRG, TRG.
 * @default "// Determine the variables used in this calculation.\nlet xparamId = arguments[0];\nlet base = this.traitsSum(Game_BattlerBase.TRAIT_XPARAM, xparamId);\nlet plus = this.xparamPlus(xparamId);\nlet paramRate = this.xparamRate(xparamId);\nlet flatBonus = this.xparamFlatBonus(xparamId);\n\n// Formula to determine total parameter value.\nlet value = (base + plus) * paramRate + flatBonus;\n\n// Final value\nreturn value;"
 *
 * @param XParamVocab
 * @text Vocabulary
 * @parent XParameters
 *
 * @param XParamVocab0:str
 * @text HIT
 * @parent XParamVocab
 * @desc The in-game vocabulary used for this X Parameter.
 * @default Hit
 *
 * @param XParamVocab1:str
 * @text EVA
 * @parent XParamVocab
 * @desc The in-game vocabulary used for this X Parameter.
 * @default Evasion
 *
 * @param XParamVocab2:str
 * @text CRI
 * @parent XParamVocab
 * @desc The in-game vocabulary used for this X Parameter.
 * @default Crit.Rate
 *
 * @param XParamVocab3:str
 * @text CEV
 * @parent XParamVocab
 * @desc The in-game vocabulary used for this X Parameter.
 * @default Crit.Evade
 *
 * @param XParamVocab4:str
 * @text MEV
 * @parent XParamVocab
 * @desc The in-game vocabulary used for this X Parameter.
 * @default Magic Evade
 *
 * @param XParamVocab5:str
 * @text MRF
 * @parent XParamVocab
 * @desc The in-game vocabulary used for this X Parameter.
 * @default Magic Reflect
 *
 * @param XParamVocab6:str
 * @text CNT
 * @parent XParamVocab
 * @desc The in-game vocabulary used for this X Parameter.
 * @default Counter
 *
 * @param XParamVocab7:str
 * @text HRG
 * @parent XParamVocab
 * @desc The in-game vocabulary used for this X Parameter.
 * @default HP Regen
 *
 * @param XParamVocab8:str
 * @text MRG
 * @parent XParamVocab
 * @desc The in-game vocabulary used for this X Parameter.
 * @default MP Regen
 *
 * @param XParamVocab9:str
 * @text TRG
 * @parent XParamVocab
 * @desc The in-game vocabulary used for this X Parameter.
 * @default TP Regen
 *
 * @param SParameters
 * @text S Parameters
 *
 * @param SParameterFormula:func
 * @text JS: Formula
 * @parent SParameters
 * @type note
 * @desc Formula used to determine the total value all 10 S parameters: TGR, GRD, REC, PHA, MCR, TCR, PDR, MDR, FDR, EXR.
 * @default "// Determine the variables used in this calculation.\nlet sparamId = arguments[0];\nlet base = this.traitsPi(Game_BattlerBase.TRAIT_SPARAM, sparamId);\nlet plus = this.sparamPlus(sparamId);\nlet paramRate = this.sparamRate(sparamId);\nlet flatBonus = this.sparamFlatBonus(sparamId);\n\n// Formula to determine total parameter value.\nlet value = (base + plus) * paramRate + flatBonus;\n\n// Final value\nreturn value;"
 *
 * @param SParamVocab
 * @text Vocabulary
 * @parent SParameters
 *
 * @param SParamVocab0:str
 * @text TGR
 * @parent SParamVocab
 * @desc The in-game vocabulary used for this S Parameter.
 * @default Aggro
 *
 * @param SParamVocab1:str
 * @text GRD
 * @parent SParamVocab
 * @desc The in-game vocabulary used for this S Parameter.
 * @default Guard
 *
 * @param SParamVocab2:str
 * @text REC
 * @parent SParamVocab
 * @desc The in-game vocabulary used for this S Parameter.
 * @default Recovery
 *
 * @param SParamVocab3:str
 * @text PHA
 * @parent SParamVocab
 * @desc The in-game vocabulary used for this S Parameter.
 * @default Item Effect
 *
 * @param SParamVocab4:str
 * @text MCR
 * @parent SParamVocab
 * @desc The in-game vocabulary used for this S Parameter.
 * @default MP Cost
 *
 * @param SParamVocab5:str
 * @text TCR
 * @parent SParamVocab
 * @desc The in-game vocabulary used for this S Parameter.
 * @default TP Charge
 *
 * @param SParamVocab6:str
 * @text PDR
 * @parent SParamVocab
 * @desc The in-game vocabulary used for this S Parameter.
 * @default Physical DMG
 *
 * @param SParamVocab7:str
 * @text MDR
 * @parent SParamVocab
 * @desc The in-game vocabulary used for this S Parameter.
 * @default Magical DMG
 *
 * @param SParamVocab8:str
 * @text FDR
 * @parent SParamVocab
 * @desc The in-game vocabulary used for this S Parameter.
 * @default Floor DMG
 *
 * @param SParamVocab9:str
 * @text EXR
 * @parent SParamVocab
 * @desc The in-game vocabulary used for this S Parameter.
 * @default EXP Gain
 *
 * @param Icons
 * @text Icons
 *
 * @param DrawIcons:eval
 * @text Draw Icons?
 * @parent Icons
 * @type boolean
 * @on Draw
 * @off Don't Draw
 * @desc Draw icons next to parameter names?
 * @default true
 *
 * @param IconParam0:str
 * @text MaxHP
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 84
 *
 * @param IconParam1:str
 * @text MaxMP
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 165
 *
 * @param IconParam2:str
 * @text ATK
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 76
 *
 * @param IconParam3:str
 * @text DEF
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 81
 *
 * @param IconParam4:str
 * @text MAT
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 101
 *
 * @param IconParam5:str
 * @text MDF
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 133
 *
 * @param IconParam6:str
 * @text AGI
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 140
 *
 * @param IconParam7:str
 * @text LUK
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 87
 *
 * @param IconXParam0:str
 * @text HIT
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 102
 *
 * @param IconXParam1:str
 * @text EVA
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 82
 *
 * @param IconXParam2:str
 * @text CRI
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 78
 *
 * @param IconXParam3:str
 * @text CEV
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 82
 *
 * @param IconXParam4:str
 * @text MEV
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 171
 *
 * @param IconXParam5:str
 * @text MRF
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 222
 *
 * @param IconXParam6:str
 * @text CNT
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 77
 *
 * @param IconXParam7:str
 * @text HRG
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 72
 *
 * @param IconXParam8:str
 * @text MRG
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 72
 *
 * @param IconXParam9:str
 * @text TRG
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 72
 *
 * @param IconSParam0:str
 * @text TGR
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 5
 *
 * @param IconSParam1:str
 * @text GRD
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 128
 *
 * @param IconSParam2:str
 * @text REC
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 72
 *
 * @param IconSParam3:str
 * @text PHA
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 176
 *
 * @param IconSParam4:str
 * @text MCR
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 165
 *
 * @param IconSParam5:str
 * @text TCR
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 164
 *
 * @param IconSParam6:str
 * @text PDR
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 76
 *
 * @param IconSParam7:str
 * @text MDR
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 79
 *
 * @param IconSParam8:str
 * @text FDR
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 141
 *
 * @param IconSParam9:str
 * @text EXR
 * @parent Icons
 * @desc Icon used for this parameter.
 * @default 73
 *
 */
/* ----------------------------------------------------------------------------
 * Commands Struct
 * ----------------------------------------------------------------------------
 */
/*~struct~Command:
 *
 * @param Symbol:str
 * @text Symbol
 * @desc The symbol used for this command.
 * @default Symbol
 *
 * @param TextStr:str
 * @text STR: Text
 * @desc Displayed text used for this title command.
 * If this has a value, ignore the JS: Text version.
 * @default Untitled
 *
 * @param TextJS:func
 * @text JS: Text
 * @type note
 * @desc JavaScript code used to determine string used for the displayed name.
 * @default "return 'Text';"
 *
 * @param ShowJS:func
 * @text JS: Show
 * @type note
 * @desc JavaScript code used to determine if the item is shown or not.
 * @default "return true;"
 *
 * @param EnableJS:func
 * @text JS: Enable
 * @type note
 * @desc JavaScript code used to determine if the item is enabled or not.
 * @default "return true;"
 *
 * @param ExtJS:func
 * @text JS: Ext
 * @type note
 * @desc JavaScript code used to determine any ext data that should be added.
 * @default "return null;"
 *
 * @param CallHandlerJS:func
 * @text JS: Run Code
 * @type note
 * @desc JavaScript code that runs once this command is selected.
 * @default ""
 *
 */
/* ----------------------------------------------------------------------------
 * Title Picture Buttons
 * ----------------------------------------------------------------------------
 */
/*~struct~TitlePictureButton:
 *
 * @param PictureFilename:str
 * @text Picture's Filename
 * @type file
 * @dir img/pictures/
 * @desc Filename used for the picture.
 * @default 
 *
 * @param ButtonURL:str
 * @text Button URL
 * @desc URL for the button to go to upon being clicked.
 * @default https://www.google.com/
 *
 * @param PositionJS:func
 * @text JS: Position
 * @type note
 * @desc JavaScript code that helps determine the button's Position.
 * @default "this.x = Graphics.width - this.bitmap.width - 20;\nthis.y = Graphics.height - this.bitmap.height - 20;"
 *
 * @param OnLoadJS:func
 * @text JS: On Load
 * @type note
 * @desc JavaScript code that runs once this button bitmap is loaded.
 * @default "this.opacity = 0;\nthis.visible = true;"
 *
 * @param CallHandlerJS:func
 * @text JS: Run Code
 * @type note
 * @desc JavaScript code that runs once this button is pressed.
 * @default "const url = this._data.ButtonURL;\nVisuMZ.openURL(url);"
 *
 */
/* ----------------------------------------------------------------------------
 * UI Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~UI:
 *
 * @param UIArea
 * @text UI Area
 *
 * @param FadeSpeed:num
 * @text Fade Speed
 * @parent UIArea
 * @desc Default fade speed for transitions.
 * @default 24
 *
 * @param BoxMargin:num
 * @text Box Margin
 * @parent UIArea
 * @type number
 * @min 0
 * @desc Set the margin in pixels for the screen borders.
 * Default: 4
 * @default 4
 *
 * @param CommandWidth:num
 * @text Command Window Width
 * @parent UIArea
 * @type number
 * @min 1
 * @desc Sets the width for standard Command Windows.
 * Default: 240
 * @default 240
 *
 * @param BottomHelp:eval
 * @text Bottom Help Window
 * @parent UIArea
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Put the Help Window at the bottom of the screen?
 * @default false
 *
 * @param RightMenus:eval
 * @text Right Aligned Menus
 * @parent UIArea
 * @type boolean
 * @on Right
 * @off Left
 * @desc Put most command windows to the right side of the screen.
 * @default true
 *
 * @param ShowButtons:eval
 * @text Show Buttons
 * @parent UIArea
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show clickable buttons in your game?
 * This will affect all buttons.
 * @default true
 *
 * @param cancelShowButton:eval
 * @text Show Cancel Button
 * @parent ShowButtons:eval
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show cancel button?
 * If 'Show Buttons' is false, this will be hidden.
 * @default true
 *
 * @param menuShowButton:eval
 * @text Show Menu Button
 * @parent ShowButtons:eval
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show main menu button from the map scene?
 * If 'Show Buttons' is false, this will be hidden.
 * @default true
 *
 * @param pagedownShowButton:eval
 * @text Show Page Up/Down
 * @parent ShowButtons:eval
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show page up/down buttons?
 * If 'Show Buttons' is false, this will be hidden.
 * @default true
 *
 * @param numberShowButton:eval
 * @text Show Number Buttons
 * @parent ShowButtons:eval
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show number adjustment buttons?
 * If 'Show Buttons' is false, this will be hidden.
 * @default true
 *
 * @param ButtonHeight:num
 * @text Button Area Height
 * @parent UIArea
 * @type number
 * @min 1
 * @desc Sets the height for the button area.
 * Default: 52
 * @default 52
 *
 * @param BottomButtons:eval
 * @text Bottom Buttons
 * @parent UIArea
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Put the buttons at the bottom of the screen?
 * @default false
 *
 * @param SideButtons:eval
 * @text Side Buttons
 * @parent UIArea
 * @type boolean
 * @on Side
 * @off Normal
 * @desc Push buttons to the side of the UI if there is room.
 * @default true
 *
 * @param StateIconsNonFrame:eval
 * @text State Icons Non-Frame
 * @parent UIArea
 * @type boolean
 * @on Non-Frame
 * @off Normal
 * @desc Replace sprite frame system for non-frame.
 * Better for any instances where icons are zoomed.
 * @default true
 *
 * @param MenuObjects
 * @text Menu Objects
 *
 * @param LvExpGauge:eval
 * @text Level -> EXP Gauge
 * @parent MenuObjects
 * @type boolean
 * @on Draw Gauge
 * @off Keep As Is
 * @desc Draw an EXP Gauge under the drawn level.
 * @default true
 *
 * @param ParamArrow:str
 * @text Parameter Arrow
 * @parent MenuObjects
 * @desc The arrow used to show changes in the parameter values.
 * @default →
 *
 * @param TextCodeSupport
 * @text Text Code Support
 *
 * @param TextCodeClassNames:eval
 * @text Class Names
 * @parent TextCodeSupport
 * @type boolean
 * @on Suport Text Codes
 * @off Normal Text
 * @desc Make class names support text codes?
 * @default true
 *
 * @param TextCodeNicknames:eval
 * @text Nicknames
 * @parent TextCodeSupport
 * @type boolean
 * @on Suport Text Codes
 * @off Normal Text
 * @desc Make nicknames support text codes?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Window:
 *
 * @param WindowDefaults
 * @text Defaults
 *
 * @param EnableMasking:eval
 * @text Enable Masking
 * @parent WindowDefaults
 * @type boolean
 * @on Masking On
 * @off Masking Off
 * @desc Enable window masking (windows hide other windows behind 
 * them)? WARNING: Turning it on can obscure data.
 * @default false
 *
 * @param CorrectSkinBleeding:eval
 * @text Correct Skin Bleed
 * @parent WindowDefaults
 * @type boolean
 * @on Correct
 * @off Don't Correct
 * @desc Corrects window skin bleeding bug when used with higher
 * screen resolutions?
 * @default true
 *
 * @param LineHeight:num
 * @text Line Height
 * @parent WindowDefaults
 * @desc Default line height used for standard windows.
 * Default: 36. Avoid using odd numbers.
 * @default 36
 *
 * @param ItemPadding:num
 * @text Item Padding
 * @parent WindowDefaults
 * @desc Default line padding used for standard windows.
 * Default: 8. Avoid using odd numbers.
 * @default 8
 *
 * @param BackOpacity:num
 * @text Back Opacity
 * @parent WindowDefaults
 * @desc Default back opacity used for standard windows.
 * Default: 192
 * @default 192
 *
 * @param TranslucentOpacity:num
 * @text Translucent Opacity
 * @parent WindowDefaults
 * @desc Default translucent opacity used for standard windows.
 * Default: 160
 * @default 160
 *
 * @param OpenSpeed:num
 * @text Window Opening Speed
 * @parent WindowDefaults
 * @desc Default open speed used for standard windows.
 * Default: 32 (Use a number between 0-255)
 * @default 32
 * @default 24
 *
 * @param ColSpacing:num
 * @text Column Spacing
 * @parent WindowDefaults
 * @desc Default column spacing for selectable windows.
 * Default: 8
 * @default 8
 *
 * @param RowSpacing:num
 * @text Row Spacing
 * @parent WindowDefaults
 * @desc Default row spacing for selectable windows.
 * Default: 4
 * @default 4
 * 
 * @param ScrollBar
 * @text Scroll Bar
 *
 * @param ShowScrollBar:eval
 * @text Show Scroll Bar?
 * @parent ScrollBar
 * @type boolean
 * @on Show Scroll Bar
 * @off Don't Show
 * @desc Show the scroll bar for scrollable windows?
 * @default true
 *
 * @param BarThickness:num
 * @text Thickness
 * @parent ScrollBar
 * @type number
 * @min 1
 * @desc How thick do you want the scroll bar to be?
 * @default 2
 *
 * @param BarOffset:num
 * @text Offset
 * @parent ScrollBar
 * @desc How much do you want to offset the scroll bar by?
 * @default +2
 *
 * @param BarBodyColor:str
 * @text Bar Body Color
 * @parent ScrollBar
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 0
 *
 * @param OffBarColor:str
 * @text Off Bar Color
 * @parent ScrollBar
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 7
 *
 * @param OffBarOpacity:num
 * @text Off Bar Opacity
 * @parent ScrollBar
 * @type number
 * @min 1
 * @max 255
 * @desc What opacity value do you want the off bar opacity
 * to be? Use a number between 0 and 255.
 * @default 128
 * 
 * @param SelectableItems
 * @text Selectable Items
 *
 * @param ShowItemBackground:eval
 * @text Show Background?
 * @parent SelectableItems
 * @type boolean
 * @on Show Backgrounds
 * @off No Backgrounds
 * @desc Selectable menu items have dark boxes behind them. Show them?
 * @default true
 *
 * @param ItemHeight:num
 * @text Item Height Padding
 * @parent SelectableItems
 * @desc Default padding for selectable items.
 * Default: 8. Avoid using odd numbers.
 * @default 8
 *
 * @param DrawItemBackgroundJS:func
 * @text JS: Draw Background
 * @parent SelectableItems
 * @type note
 * @desc Code used to draw the background rectangle behind clickable menu objects
 * @default "const rect = arguments[0];\nconst c1 = ColorManager.itemBackColor1();\nconst c2 = ColorManager.itemBackColor2();\nconst x = rect.x;\nconst y = rect.y;\nconst w = rect.width;\nconst h = rect.height;\nthis.contentsBack.gradientFillRect(x, y, w, h, c1, c2, true);\nthis.contentsBack.strokeRect(x, y, w, h, c1);"
 *
 * @param TextPopup
 * @text Text Popup Window
 *
 * @param DurationPerChat:num
 * @text Duration Per Text
 * @parent TextPopup
 * @desc What is the increase in duration per text character?
 * @default 1.5
 *
 * @param MinDuration:num
 * @text Minimum Duration
 * @parent TextPopup
 * @type number
 * @min 1
 * @desc Minimum duration for window to stay on the screen.
 * @default 90
 *
 * @param MaxDuration:num
 * @text Maximum Duration
 * @parent TextPopup
 * @type number
 * @min 1
 * @desc Maximum duration for window to stay on the screen.
 * @default 300
 * 
 */
/* ----------------------------------------------------------------------------
 * Screen Resolution Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ScreenResolution:
 *
 * @param Maps
 * 
 * @param AutoScrollLockX:eval
 * @text Scroll Lock Small X?
 * @parent Maps
 * @type boolean
 * @on Auto-Lock
 * @off Keep As Is
 * @desc Automatically scroll lock X scrolling if the map is too small?
 * @default true
 * 
 * @param AutoScrollLockY:eval
 * @text Scroll Lock Small Y?
 * @parent Maps
 * @type boolean
 * @on Auto-Lock
 * @off Keep As Is
 * @desc Automatically scroll lock Y scrolling if the map is too small?
 * @default true
 * 
 * @param DisplayLockX:num
 * @text Locked Display X?
 * @parent Maps
 * @desc What display X value do you want for auto-scroll locked
 * maps? Use a number between 0 and 1 for best results.
 * @default 0.15625
 * 
 * @param DisplayLockY:num
 * @text Locked Display Y?
 * @parent Maps
 * @desc What display Y value do you want for auto-scroll locked
 * maps? Use a number between 0 and 1 for best results.
 * @default 0.00000
 * 
 * @param Troops
 *
 * @param RepositionActors:eval
 * @text Reposition Actors
 * @parent Troops
 * @type boolean
 * @on Reposition
 * @off Keep As Is
 * @desc Update the position of actors in battle if the screen resolution has changed. Ignore if using Battle Core.
 * @default true
 *
 * @param RepositionEnemies:eval
 * @text Reposition Enemies
 * @parent Troops
 * @type boolean
 * @on Reposition
 * @off Keep As Is
 * @desc Update the position of enemies in battle if the screen resolution has changed.
 * @default true
 *
 * @param RepositionEnemies130:eval
 * @text For MZ 1.3.0+?
 * @parent RepositionEnemies:eval
 * @type boolean
 * @on Reposition
 * @off Keep As Is
 * @desc Both this parameter and its parent parameter need to be on when using RPG Maker MZ 1.3.0+.
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Screen Shake Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ScreenShake:
 *
 * @param DefaultStyle:str
 * @text Default Style
 * @type select
 * @option Original
 * @value original
 * @option Random
 * @value random
 * @option Horizontal
 * @value horizontal
 * @option Vertical
 * @value vertical
 * @desc The default style used for screen shakes.
 * @default random
 *
 * @param originalJS:func
 * @text JS: Original Style
 * @type note
 * @desc This code gives you control over screen shake for this
 * screen shake style.
 * @default "// Calculation\nthis.x += Math.round($gameScreen.shake());"
 *
 * @param randomJS:func
 * @text JS: Random Style
 * @type note
 * @desc This code gives you control over screen shake for this
 * screen shake style.
 * @default "// Calculation\n// Original Formula by Aries of Sheratan\nconst power = $gameScreen._shakePower * 0.75;\nconst speed = $gameScreen._shakeSpeed * 0.60;\nconst duration = $gameScreen._shakeDuration;\nthis.x += Math.round(Math.randomInt(power) - Math.randomInt(speed)) * (Math.min(duration, 30) * 0.5);\nthis.y += Math.round(Math.randomInt(power) - Math.randomInt(speed)) * (Math.min(duration, 30) * 0.5);"
 *
 * @param horzJS:func
 * @text JS: Horizontal Style
 * @type note
 * @desc This code gives you control over screen shake for this
 * screen shake style.
 * @default "// Calculation\n// Original Formula by Aries of Sheratan\nconst power = $gameScreen._shakePower * 0.75;\nconst speed = $gameScreen._shakeSpeed * 0.60;\nconst duration = $gameScreen._shakeDuration;\nthis.x += Math.round(Math.randomInt(power) - Math.randomInt(speed)) * (Math.min(duration, 30) * 0.5);"
 *
 * @param vertJS:func
 * @text JS: Vertical Style
 * @type note
 * @desc This code gives you control over screen shake for this
 * screen shake style.
 * @default "// Calculation\n// Original Formula by Aries of Sheratan\nconst power = $gameScreen._shakePower * 0.75;\nconst speed = $gameScreen._shakeSpeed * 0.60;\nconst duration = $gameScreen._shakeDuration;\nthis.y += Math.round(Math.randomInt(power) - Math.randomInt(speed)) * (Math.min(duration, 30) * 0.5);"
 *
 */
/* ----------------------------------------------------------------------------
 * Custom Parameter Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~CustomParam:
 *
 * @param ParamName:str
 * @text Parameter Name
 * @desc What's the parameter's name?
 * Used for VisuStella MZ menus.
 * @default Untitled
 *
 * @param Abbreviation:str
 * @text Abbreviation
 * @parent ParamName:str
 * @desc What abbreviation do you want to use for the parameter?
 * Do not use special characters. Avoid numbers if possible.
 * @default unt
 *
 * @param Icon:num
 * @text Icon
 * @parent ParamName:str
 * @desc What icon do you want to use to represent this parameter?
 * Used for VisuStella MZ menus.
 * @default 160
 *
 * @param Type:str
 * @text Type
 * @parent ParamName:str
 * @type select
 * @option Integer (Whole Numbers Only)
 * @value integer
 * @option Float (Decimals are Allowed)
 * @value float
 * @desc What kind of number value will be returned with this parameter?
 * @default integer
 *
 * @param ValueJS:json
 * @text JS: Value
 * @type note
 * @desc Run this code when this parameter is to be returned.
 * @default "// Declare Constants\nconst user = this;\n\n// Calculations\nreturn 1;"
 *
 */
/* ----------------------------------------------------------------------------
 * Show Picture Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ShowPicture:
 * 
 * @param Position
 *
 * @param Origin:num
 * @text Origin
 * @parent Position
 * @type select
 * @option 0 - Upper Left
 * @value 0
 * @option 1 - Center
 * @value 1
 * @desc What is the origin of this picture icon?
 * @default 0
 *
 * @param PositionX:eval
 * @text Position X
 * @parent Position
 * @desc X coordinate of the picture.
 * You may use JavaScript code.
 * @default 0
 *
 * @param PositionY:eval
 * @text Position Y
 * @parent Position
 * @desc Y coordinate of the picture.
 * You may use JavaScript code.
 * @default 0
 * 
 * @param Scale
 *
 * @param ScaleX:eval
 * @text Width %
 * @parent Scale
 * @desc Horizontal scale of the picture.
 * You may use JavaScript code.
 * @default 100
 *
 * @param ScaleY:eval
 * @text Height %
 * @parent Scale
 * @desc Vertical scale of the picture.
 * You may use JavaScript code.
 * @default 100
 * 
 * @param Blend
 *
 * @param Opacity:eval
 * @text Opacity
 * @parent Blend
 * @desc Insert a number to determine opacity level. Use a
 * number between 0 and 255. You may use JavaScript code.
 * @default 255
 *
 * @param BlendMode:num
 * @text Blend Mode
 * @parent Blend
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the picture?
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * JS Quick Function Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~jsQuickFunc:
 *
 * @param FunctionName:str
 * @text Function Name
 * @desc The function's name in the global namespace.
 * Will not overwrite functions/variables of the same name.
 * @default Untitled
 *
 * @param CodeJS:json
 * @text JS: Code
 * @type note
 * @desc Run this code when using the function.
 * @default "// Insert this as a function anywhere you can input code\n// such as Script Calls or Conditional Branch Scripts.\n\n// Process Code\n"
 *
 */
//=============================================================================

const _0x262cbe=_0x3598;(function(_0x295026,_0x3ce68){const _0x47f811=_0x3598,_0x4ef482=_0x295026();while(!![]){try{const _0x237c82=-parseInt(_0x47f811(0x534))/0x1*(parseInt(_0x47f811(0x365))/0x2)+-parseInt(_0x47f811(0x70e))/0x3*(parseInt(_0x47f811(0x5a4))/0x4)+-parseInt(_0x47f811(0x76a))/0x5+parseInt(_0x47f811(0x363))/0x6*(-parseInt(_0x47f811(0x70f))/0x7)+parseInt(_0x47f811(0x683))/0x8+parseInt(_0x47f811(0x10b))/0x9+parseInt(_0x47f811(0x83b))/0xa*(parseInt(_0x47f811(0x11b))/0xb);if(_0x237c82===_0x3ce68)break;else _0x4ef482['push'](_0x4ef482['shift']());}catch(_0x87affd){_0x4ef482['push'](_0x4ef482['shift']());}}}(_0x4486,0x6d13a));var label=_0x262cbe(0x244),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x262cbe(0x1c7)](function(_0x22f51e){const _0x4a56d1=_0x262cbe;return _0x22f51e[_0x4a56d1(0x3f2)]&&_0x22f51e[_0x4a56d1(0x750)][_0x4a56d1(0x14c)]('['+label+']');})[0x0];VisuMZ[label][_0x262cbe(0x84d)]=VisuMZ[label][_0x262cbe(0x84d)]||{},VisuMZ[_0x262cbe(0x80)]=function(_0x1bb9a3,_0x32052c){const _0x23d9bb=_0x262cbe;for(const _0x21b829 in _0x32052c){if(_0x21b829[_0x23d9bb(0x13e)](/(.*):(.*)/i)){const _0x55ef98=String(RegExp['$1']),_0x3817a6=String(RegExp['$2'])[_0x23d9bb(0x551)]()[_0x23d9bb(0x4a7)]();let _0x58d595,_0x190da9,_0x151cd7;switch(_0x3817a6){case _0x23d9bb(0x2e5):_0x58d595=_0x32052c[_0x21b829]!==''?Number(_0x32052c[_0x21b829]):0x0;break;case'ARRAYNUM':_0x190da9=_0x32052c[_0x21b829]!==''?JSON[_0x23d9bb(0x42f)](_0x32052c[_0x21b829]):[],_0x58d595=_0x190da9[_0x23d9bb(0x2fe)](_0x18754c=>Number(_0x18754c));break;case _0x23d9bb(0x561):_0x58d595=_0x32052c[_0x21b829]!==''?eval(_0x32052c[_0x21b829]):null;break;case'ARRAYEVAL':_0x190da9=_0x32052c[_0x21b829]!==''?JSON[_0x23d9bb(0x42f)](_0x32052c[_0x21b829]):[],_0x58d595=_0x190da9['map'](_0xbe26ab=>eval(_0xbe26ab));break;case'JSON':_0x58d595=_0x32052c[_0x21b829]!==''?JSON[_0x23d9bb(0x42f)](_0x32052c[_0x21b829]):'';break;case _0x23d9bb(0x266):_0x190da9=_0x32052c[_0x21b829]!==''?JSON[_0x23d9bb(0x42f)](_0x32052c[_0x21b829]):[],_0x58d595=_0x190da9[_0x23d9bb(0x2fe)](_0x19b31d=>JSON['parse'](_0x19b31d));break;case _0x23d9bb(0x32c):_0x58d595=_0x32052c[_0x21b829]!==''?new Function(JSON['parse'](_0x32052c[_0x21b829])):new Function(_0x23d9bb(0x672));break;case'ARRAYFUNC':_0x190da9=_0x32052c[_0x21b829]!==''?JSON[_0x23d9bb(0x42f)](_0x32052c[_0x21b829]):[],_0x58d595=_0x190da9['map'](_0x5219d9=>new Function(JSON[_0x23d9bb(0x42f)](_0x5219d9)));break;case'STR':_0x58d595=_0x32052c[_0x21b829]!==''?String(_0x32052c[_0x21b829]):'';break;case _0x23d9bb(0x55f):_0x190da9=_0x32052c[_0x21b829]!==''?JSON['parse'](_0x32052c[_0x21b829]):[],_0x58d595=_0x190da9[_0x23d9bb(0x2fe)](_0x452e8c=>String(_0x452e8c));break;case _0x23d9bb(0x79b):_0x151cd7=_0x32052c[_0x21b829]!==''?JSON[_0x23d9bb(0x42f)](_0x32052c[_0x21b829]):{},_0x1bb9a3[_0x55ef98]={},VisuMZ['ConvertParams'](_0x1bb9a3[_0x55ef98],_0x151cd7);continue;case'ARRAYSTRUCT':_0x190da9=_0x32052c[_0x21b829]!==''?JSON[_0x23d9bb(0x42f)](_0x32052c[_0x21b829]):[],_0x58d595=_0x190da9[_0x23d9bb(0x2fe)](_0x21bce0=>VisuMZ[_0x23d9bb(0x80)]({},JSON[_0x23d9bb(0x42f)](_0x21bce0)));break;default:continue;}_0x1bb9a3[_0x55ef98]=_0x58d595;}}return _0x1bb9a3;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x264)]=SceneManager[_0x262cbe(0x29d)],SceneManager[_0x262cbe(0x29d)]=function(){const _0xd3a519=_0x262cbe;VisuMZ[_0xd3a519(0x244)][_0xd3a519(0x264)][_0xd3a519(0x77c)](this);if(Utils[_0xd3a519(0xea)]>=_0xd3a519(0x491)){if(typeof nw===_0xd3a519(0x6c1))nw[_0xd3a519(0x46e)]['quit']();}},(_0x419f12=>{const _0x1a1d3b=_0x262cbe,_0x1595a5=_0x419f12[_0x1a1d3b(0x84e)];for(const _0x10cd33 of dependencies){if(!Imported[_0x10cd33]){alert(_0x1a1d3b(0x338)[_0x1a1d3b(0x94)](_0x1595a5,_0x10cd33)),SceneManager[_0x1a1d3b(0x29d)]();break;}}const _0xf7daa=_0x419f12['description'];if(_0xf7daa[_0x1a1d3b(0x13e)](/\[Version[ ](.*?)\]/i)){const _0x51be48=Number(RegExp['$1']);_0x51be48!==VisuMZ[label]['version']&&(alert(_0x1a1d3b(0x742)[_0x1a1d3b(0x94)](_0x1595a5,_0x51be48)),SceneManager[_0x1a1d3b(0x29d)]());}if(_0xf7daa[_0x1a1d3b(0x13e)](/\[Tier[ ](\d+)\]/i)){const _0x2849f6=Number(RegExp['$1']);_0x2849f6<tier?(alert(_0x1a1d3b(0x419)[_0x1a1d3b(0x94)](_0x1595a5,_0x2849f6,tier)),SceneManager[_0x1a1d3b(0x29d)]()):tier=Math[_0x1a1d3b(0x256)](_0x2849f6,tier);}VisuMZ[_0x1a1d3b(0x80)](VisuMZ[label][_0x1a1d3b(0x84d)],_0x419f12[_0x1a1d3b(0x5d7)]);})(pluginData),((()=>{const _0x3d1469=_0x262cbe;if(VisuMZ['CoreEngine'][_0x3d1469(0x84d)][_0x3d1469(0x754)]['SubfolderParse']??!![])for(const _0x1b7941 in $plugins){const _0x1ec9e2=$plugins[_0x1b7941];_0x1ec9e2[_0x3d1469(0x84e)]['match'](/(.*)\/(.*)/i)&&(_0x1ec9e2[_0x3d1469(0x84e)]=String(RegExp['$2'][_0x3d1469(0x4a7)]()));}})()),PluginManager[_0x262cbe(0x6f5)](pluginData['name'],_0x262cbe(0x7b3),_0x35beb2=>{const _0x35ba45=_0x262cbe;if(!SceneManager[_0x35ba45(0x207)])return;if(!SceneManager[_0x35ba45(0x207)][_0x35ba45(0x2aa)])return;VisuMZ[_0x35ba45(0x80)](_0x35beb2,_0x35beb2);const _0x52d0a9=Math[_0x35ba45(0x38d)](_0x35beb2[_0x35ba45(0x1f5)]),_0x2c99f3=Math['round'](_0x35beb2[_0x35ba45(0x164)]);$gameTemp['requestPointAnimation'](_0x52d0a9,_0x2c99f3,_0x35beb2['AnimationID'],_0x35beb2['Mirror'],_0x35beb2[_0x35ba45(0x6af)]);}),PluginManager['registerCommand'](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x850),_0x3ce03a=>{const _0x560785=_0x262cbe;VisuMZ[_0x560785(0x80)](_0x3ce03a,_0x3ce03a);const _0x156696=Math[_0x560785(0x38d)](_0x3ce03a[_0x560785(0x665)])[_0x560785(0x565)](0x0,0x64),_0x4b2137=AudioManager[_0x560785(0x201)];_0x4b2137&&(_0x4b2137['volume']=_0x156696,_0x4b2137['pos']=AudioManager['_bgmBuffer']['seek'](),AudioManager[_0x560785(0x2fd)](_0x4b2137),AudioManager['playBgm'](_0x4b2137,_0x4b2137[_0x560785(0x520)]),AudioManager[_0x560785(0x174)][_0x560785(0x763)](_0x4b2137['pos']));}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],'AudioChangeBgmPitch',_0x42a1bc=>{const _0x37b120=_0x262cbe;VisuMZ[_0x37b120(0x80)](_0x42a1bc,_0x42a1bc);const _0x2ef0fd=Math[_0x37b120(0x38d)](_0x42a1bc['pitch'])[_0x37b120(0x565)](0x32,0x96),_0x2954c5=AudioManager['_currentBgm'];_0x2954c5&&(_0x2954c5['pitch']=_0x2ef0fd,_0x2954c5[_0x37b120(0x520)]=AudioManager[_0x37b120(0x174)][_0x37b120(0x721)](),AudioManager['updateBgmParameters'](_0x2954c5),AudioManager[_0x37b120(0x45a)](_0x2954c5,_0x2954c5[_0x37b120(0x520)]),AudioManager[_0x37b120(0x174)]['_startPlaying'](_0x2954c5['pos']));}),PluginManager[_0x262cbe(0x6f5)](pluginData['name'],_0x262cbe(0x7e4),_0x546c71=>{const _0x50dcf0=_0x262cbe;VisuMZ[_0x50dcf0(0x80)](_0x546c71,_0x546c71);const _0x5a761d=Math[_0x50dcf0(0x38d)](_0x546c71[_0x50dcf0(0x336)])[_0x50dcf0(0x565)](-0x64,0x64),_0x5e6608=AudioManager[_0x50dcf0(0x201)];_0x5e6608&&(_0x5e6608[_0x50dcf0(0x336)]=_0x5a761d,_0x5e6608[_0x50dcf0(0x520)]=AudioManager['_bgmBuffer']['seek'](),AudioManager[_0x50dcf0(0x2fd)](_0x5e6608),AudioManager[_0x50dcf0(0x45a)](_0x5e6608,_0x5e6608[_0x50dcf0(0x520)]),AudioManager[_0x50dcf0(0x174)]['_startPlaying'](_0x5e6608[_0x50dcf0(0x520)]));}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],'AudioChangeBgsVolume',_0x1a1079=>{const _0x533661=_0x262cbe;VisuMZ[_0x533661(0x80)](_0x1a1079,_0x1a1079);const _0x324731=Math[_0x533661(0x38d)](_0x1a1079[_0x533661(0x665)])['clamp'](0x0,0x64),_0x3988e8=AudioManager[_0x533661(0xb4)];_0x3988e8&&(_0x3988e8[_0x533661(0x665)]=_0x324731,_0x3988e8['pos']=AudioManager[_0x533661(0x713)][_0x533661(0x721)](),AudioManager[_0x533661(0x6e3)](_0x3988e8),AudioManager['playBgs'](_0x3988e8,_0x3988e8[_0x533661(0x520)]),AudioManager['_bgsBuffer'][_0x533661(0x763)](_0x3988e8[_0x533661(0x520)]));}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x324),_0x337ae5=>{const _0x472c12=_0x262cbe;VisuMZ[_0x472c12(0x80)](_0x337ae5,_0x337ae5);const _0x52f0e6=Math['round'](_0x337ae5[_0x472c12(0x47a)])['clamp'](0x32,0x96),_0x3f5f50=AudioManager['_currentBgs'];_0x3f5f50&&(_0x3f5f50[_0x472c12(0x47a)]=_0x52f0e6,_0x3f5f50[_0x472c12(0x520)]=AudioManager[_0x472c12(0x713)][_0x472c12(0x721)](),AudioManager[_0x472c12(0x6e3)](_0x3f5f50),AudioManager[_0x472c12(0x10d)](_0x3f5f50,_0x3f5f50[_0x472c12(0x520)]),AudioManager[_0x472c12(0x713)][_0x472c12(0x763)](_0x3f5f50[_0x472c12(0x520)]));}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x540),_0x118d5e=>{const _0x16e495=_0x262cbe;VisuMZ[_0x16e495(0x80)](_0x118d5e,_0x118d5e);const _0x33f0ff=Math[_0x16e495(0x38d)](_0x118d5e[_0x16e495(0x336)])[_0x16e495(0x565)](-0x64,0x64),_0x17f4cb=AudioManager['_currentBgs'];_0x17f4cb&&(_0x17f4cb[_0x16e495(0x336)]=_0x33f0ff,_0x17f4cb[_0x16e495(0x520)]=AudioManager[_0x16e495(0x713)][_0x16e495(0x721)](),AudioManager[_0x16e495(0x6e3)](_0x17f4cb),AudioManager[_0x16e495(0x10d)](_0x17f4cb,_0x17f4cb['pos']),AudioManager[_0x16e495(0x713)]['_startPlaying'](_0x17f4cb[_0x16e495(0x520)]));}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x18d),_0x30cff0=>{const _0x267179=_0x262cbe;if(!$gameTemp['isPlaytest']())return;const _0x830ee0=Input[_0x267179(0x81c)]();console[_0x267179(0x254)](_0x830ee0);}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],'ExportAllMapText',_0x286540=>{const _0x426745=_0x262cbe;if(!$gameTemp[_0x426745(0x5ee)]())return;if(!Utils['isNwjs']())return;SceneManager[_0x426745(0x207)][_0x426745(0x2a8)]=![],VisuMZ[_0x426745(0x244)][_0x426745(0x4d6)]();}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x4c4),_0x5a70d5=>{const _0x3ddf3c=_0x262cbe;if(!$gameTemp[_0x3ddf3c(0x5ee)]())return;if(!Utils[_0x3ddf3c(0x612)]())return;SceneManager[_0x3ddf3c(0x207)][_0x3ddf3c(0x2a8)]=![],VisuMZ['CoreEngine'][_0x3ddf3c(0x3cc)]();}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x795),_0x14b303=>{const _0x49fec2=_0x262cbe;if(!$gameTemp[_0x49fec2(0x5ee)]())return;if(!Utils[_0x49fec2(0x612)]())return;if(!$gameMap)return;if($gameMap[_0x49fec2(0x250)]()<=0x0)return;VisuMZ['ConvertParams'](_0x14b303,_0x14b303);const _0x30f784=_0x49fec2(0x709)['format']($gameMap[_0x49fec2(0x250)]()[_0x49fec2(0x681)](0x3)),_0x5bd63d=VisuMZ[_0x49fec2(0x244)][_0x49fec2(0x240)]($gameMap[_0x49fec2(0x250)]());VisuMZ[_0x49fec2(0x244)][_0x49fec2(0x334)](_0x5bd63d,_0x30f784,!![]);}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x7aa),_0x5f2aab=>{const _0x2db585=_0x262cbe;if(!$gameTemp[_0x2db585(0x5ee)]())return;if(!Utils[_0x2db585(0x612)]())return;if(!$gameParty[_0x2db585(0xd0)]())return;VisuMZ['ConvertParams'](_0x5f2aab,_0x5f2aab);const _0x2c976e=_0x2db585(0x53e)[_0x2db585(0x94)]($gameTroop[_0x2db585(0x65a)][_0x2db585(0x681)](0x4)),_0xc5da5a=VisuMZ[_0x2db585(0x244)][_0x2db585(0x265)]($gameTroop[_0x2db585(0x65a)]);VisuMZ['CoreEngine'][_0x2db585(0x334)](_0xc5da5a,_0x2c976e,!![]);}),VisuMZ[_0x262cbe(0x244)]['ExportString']=function(_0x5033f7,_0x41a6da,_0x5d255f){const _0x107f94=_0x262cbe,_0x2f94db=require('fs');let _0xc0506f='Exported_Script_%1.txt'[_0x107f94(0x94)](_0x41a6da||'0');_0x2f94db[_0x107f94(0x4a1)](_0xc0506f,_0x5033f7,_0x21c5d1=>{const _0x180f35=_0x107f94;if(_0x21c5d1)throw err;else _0x5d255f&&alert(_0x180f35(0x440)[_0x180f35(0x94)](_0xc0506f));});},VisuMZ[_0x262cbe(0x244)]['ExportStrFromAllMaps']=function(){const _0x56ce9a=_0x262cbe,_0x3f5709=[];for(const _0x49b42d of $dataMapInfos){if(!_0x49b42d)continue;_0x3f5709['push'](_0x49b42d['id']);}const _0x43e4ae=_0x3f5709[_0x56ce9a(0x3c3)]*0x64+Math[_0x56ce9a(0x508)](0x64);alert(_0x56ce9a(0x26e)[_0x56ce9a(0x94)](_0x43e4ae)),this[_0x56ce9a(0x25a)]=[],this[_0x56ce9a(0x6e1)]=$dataMap;for(const _0x534295 of _0x3f5709){VisuMZ[_0x56ce9a(0x244)]['loadMapData'](_0x534295);}setTimeout(VisuMZ[_0x56ce9a(0x244)][_0x56ce9a(0x16f)][_0x56ce9a(0x75d)](this),_0x43e4ae);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x5e0)]=function(_0x23761f){const _0x43d5d3=_0x262cbe,_0x235f6b=_0x43d5d3(0x288)['format'](_0x23761f[_0x43d5d3(0x681)](0x3)),_0x425130=new XMLHttpRequest(),_0x292f02=_0x43d5d3(0x5b7)+_0x235f6b;_0x425130[_0x43d5d3(0x703)]('GET',_0x292f02),_0x425130[_0x43d5d3(0x18c)](_0x43d5d3(0x6cc)),_0x425130[_0x43d5d3(0x536)]=()=>this[_0x43d5d3(0x315)](_0x425130,_0x23761f,_0x235f6b,_0x292f02),_0x425130[_0x43d5d3(0x2a0)]=()=>DataManager['onXhrError'](_0x43d5d3(0xb3),_0x235f6b,_0x292f02),_0x425130['send']();},VisuMZ[_0x262cbe(0x244)]['storeMapData']=function(_0x1720f3,_0x2c484a,_0x58d444,_0x1a8f6f){const _0x2c7f82=_0x262cbe;$dataMap=JSON[_0x2c7f82(0x42f)](_0x1720f3[_0x2c7f82(0x11d)]),DataManager[_0x2c7f82(0x7b4)]($dataMap),this[_0x2c7f82(0x25a)][_0x2c484a]=VisuMZ[_0x2c7f82(0x244)][_0x2c7f82(0x240)](_0x2c484a),$dataMap=this[_0x2c7f82(0x6e1)];},VisuMZ[_0x262cbe(0x244)]['exportAllMapStrings']=function(){const _0x16a869=_0x262cbe,_0x4bf652='AllMaps';this['_storedMapText'][_0x16a869(0x261)](undefined)['remove']('')['remove'](null);const _0x25e07e=this['_storedMapText'][_0x16a869(0x6ef)](_0x16a869(0x4be))[_0x16a869(0x4a7)]();VisuMZ[_0x16a869(0x244)][_0x16a869(0x334)](_0x25e07e,_0x4bf652,!![]),SceneManager[_0x16a869(0x207)][_0x16a869(0x2a8)]=!![];},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x240)]=function(_0x45303c){const _0x1b4ada=_0x262cbe;if(!$dataMap)return'';let _0x1e50e6='█'[_0x1b4ada(0x1c5)](0x46)+'\x0a\x0a',_0x28b81b='═'[_0x1b4ada(0x1c5)](0x46)+'\x0a\x0a',_0x472e93='';this[_0x1b4ada(0x643)]=0x0;for(const _0xbf8a9c of $dataMap[_0x1b4ada(0x768)]){if(!_0xbf8a9c)continue;let _0x57d8fd=_0xbf8a9c['id'],_0x250954=_0xbf8a9c[_0x1b4ada(0x84e)],_0x1d609a=_0xbf8a9c[_0x1b4ada(0x74a)];for(const _0x598106 of _0x1d609a){const _0x4d45c8=_0x1d609a[_0x1b4ada(0x13d)](_0x598106)+0x1;let _0x2185bb=_0x28b81b+_0x1b4ada(0x5ab),_0xf504ce=VisuMZ[_0x1b4ada(0x244)][_0x1b4ada(0x2c6)](_0x598106[_0x1b4ada(0x145)]);if(_0xf504ce[_0x1b4ada(0x3c3)]>0x0){if(_0x472e93[_0x1b4ada(0x3c3)]>0x0)_0x472e93+=_0x28b81b+'\x0a\x0a\x0a\x0a\x0a';else{const _0x2eeb54=$dataMapInfos[_0x45303c][_0x1b4ada(0x84e)];_0x472e93+=_0x1e50e6+'〖〖〖\x20Map\x20%1:\x20%2\x20Script\x20〗〗〗\x0a\x0a'['format'](_0x45303c,_0x2eeb54||'Unnamed')+_0x1e50e6;}_0x472e93+=_0x2185bb[_0x1b4ada(0x94)](_0x57d8fd,_0x250954,_0x4d45c8,_0xf504ce);}}}return _0x472e93[_0x1b4ada(0x3c3)]>0x0&&(_0x472e93+=_0x28b81b),_0x472e93;},VisuMZ['CoreEngine'][_0x262cbe(0x3cc)]=function(){const _0x4ee727=_0x262cbe,_0x22f839=$dataTroops[_0x4ee727(0x3c3)]*0xa+Math[_0x4ee727(0x508)](0xa);alert(_0x4ee727(0x6d3)['format'](_0x22f839));const _0x2f58d8=[];for(const _0x258371 of $dataTroops){if(!_0x258371)continue;const _0x2732cd=_0x258371['id'];_0x2f58d8[_0x2732cd]=VisuMZ[_0x4ee727(0x244)][_0x4ee727(0x265)](_0x2732cd);}setTimeout(VisuMZ[_0x4ee727(0x244)][_0x4ee727(0x2ad)]['bind'](this,_0x2f58d8),_0x22f839);},VisuMZ[_0x262cbe(0x244)]['ExtractStrFromTroop']=function(_0x41db8f){const _0xc34070=_0x262cbe;if(!$dataTroops[_0x41db8f])return'';let _0x12c6fe='█'[_0xc34070(0x1c5)](0x46)+'\x0a\x0a',_0x4c4cf4='═'[_0xc34070(0x1c5)](0x46)+'\x0a\x0a',_0xd96c2a='';this[_0xc34070(0x643)]=0x0;const _0x5a9fb5=$dataTroops[_0x41db8f];let _0x53368a=_0x5a9fb5[_0xc34070(0x74a)];for(const _0x29dcb6 of _0x53368a){const _0x1daadf=_0x53368a[_0xc34070(0x13d)](_0x29dcb6)+0x1;let _0x2f095f=_0x4c4cf4+_0xc34070(0x1f8),_0x35d671=VisuMZ[_0xc34070(0x244)][_0xc34070(0x2c6)](_0x29dcb6[_0xc34070(0x145)]);_0x35d671[_0xc34070(0x3c3)]>0x0&&(_0xd96c2a[_0xc34070(0x3c3)]>0x0?_0xd96c2a+=_0x4c4cf4+_0xc34070(0x4be):_0xd96c2a+=_0x12c6fe+'〖〖〖\x20Troop\x20%1:\x20%2\x20Script\x20〗〗〗\x0a\x0a'['format'](_0x41db8f,_0x5a9fb5['name']||_0xc34070(0x4d9))+_0x12c6fe,_0xd96c2a+=_0x2f095f[_0xc34070(0x94)](_0x1daadf,_0x35d671));}return _0xd96c2a[_0xc34070(0x3c3)]>0x0&&(_0xd96c2a+=_0x4c4cf4),_0xd96c2a;},VisuMZ['CoreEngine'][_0x262cbe(0x2ad)]=function(_0x2b6580){const _0x5c578b=_0x262cbe,_0x5ede18='AllTroops';_0x2b6580['remove'](undefined)['remove']('')['remove'](null);const _0x5e9ebd=_0x2b6580['join'](_0x5c578b(0x4be))['trim']();VisuMZ[_0x5c578b(0x244)][_0x5c578b(0x334)](_0x5e9ebd,_0x5ede18,!![]),SceneManager[_0x5c578b(0x207)][_0x5c578b(0x2a8)]=!![];},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x2c6)]=function(_0x127ee3){const _0x176cfa=_0x262cbe;let _0x5ec5d9='\x0a'+'─'['repeat'](0x46)+'\x0a',_0x547125='\x0a'+'┄'['repeat'](0x46)+'\x0a',_0x1374cd='';for(const _0x415874 of _0x127ee3){if(!_0x415874)continue;if(_0x415874[_0x176cfa(0xd8)]===0x65)_0x1374cd+=_0x5ec5d9+'\x0a',_0x1374cd+=_0x176cfa(0x5bb),_0x415874[_0x176cfa(0x5d7)][0x4]!==''&&_0x415874[_0x176cfa(0x5d7)][0x4]!==undefined&&(_0x1374cd+='【%1】\x0a'[_0x176cfa(0x94)](_0x415874['parameters'][0x4]));else{if(_0x415874[_0x176cfa(0xd8)]===0x191)_0x1374cd+=_0x176cfa(0x10c)[_0x176cfa(0x94)](_0x415874['parameters'][0x0]);else{if(_0x415874[_0x176cfa(0xd8)]===0x192)_0x1374cd+=_0x5ec5d9,_0x1374cd+=_0x176cfa(0x17a)[_0x176cfa(0x94)](_0x547125,_0x415874[_0x176cfa(0x5d7)][0x0]+0x1,_0x415874[_0x176cfa(0x5d7)][0x1]);else{if(_0x415874[_0x176cfa(0xd8)]===0x193)_0x1374cd+=_0x5ec5d9,_0x1374cd+=_0x176cfa(0xfb)[_0x176cfa(0x94)](_0x547125);else{if(_0x415874[_0x176cfa(0xd8)]===0x194)_0x1374cd+=_0x5ec5d9,_0x1374cd+=_0x176cfa(0x280)[_0x176cfa(0x94)](_0x547125);else{if(_0x415874[_0x176cfa(0xd8)]===0x69)_0x1374cd+=_0x5ec5d9+'\x0a',_0x1374cd+=_0x176cfa(0x52b);else{if(_0x415874[_0x176cfa(0xd8)]===0x6c)_0x1374cd+=_0x5ec5d9+'\x0a',_0x1374cd+='》Comment《\x0a%1\x0a'[_0x176cfa(0x94)](_0x415874['parameters'][0x0]);else{if(_0x415874[_0x176cfa(0xd8)]===0x198)_0x1374cd+=_0x176cfa(0x10c)[_0x176cfa(0x94)](_0x415874[_0x176cfa(0x5d7)][0x0]);else{if(_0x415874[_0x176cfa(0xd8)]===0x75){const _0xb95492=$dataCommonEvents[_0x415874[_0x176cfa(0x5d7)][0x0]];if(_0xb95492&&this[_0x176cfa(0x643)]<=0xa){this[_0x176cfa(0x643)]++;let _0x26ca4f=VisuMZ['CoreEngine'][_0x176cfa(0x2c6)](_0xb95492[_0x176cfa(0x145)]);_0x26ca4f[_0x176cfa(0x3c3)]>0x0&&(_0x1374cd+=_0x5ec5d9,_0x1374cd+=_0x547125,_0x1374cd+=_0x176cfa(0x5c0)[_0x176cfa(0x94)](_0xb95492['id'],_0xb95492[_0x176cfa(0x84e)]),_0x1374cd+=_0x547125,_0x1374cd+=_0x26ca4f,_0x1374cd+=_0x547125,_0x1374cd+=_0x176cfa(0x79)[_0x176cfa(0x94)](_0xb95492['id'],_0xb95492['name']),_0x1374cd+=_0x547125),this['_commonEventLayers']--;}}}}}}}}}}}return _0x1374cd['length']>0x0&&(_0x1374cd+=_0x5ec5d9),_0x1374cd;},PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x249),_0x2a8a3a=>{const _0x396d30=_0x262cbe;VisuMZ[_0x396d30(0x80)](_0x2a8a3a,_0x2a8a3a);const _0x222ca0=_0x2a8a3a[_0x396d30(0x445)];VisuMZ[_0x396d30(0x2e0)](_0x222ca0);}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],'GoldChange',_0x3c1763=>{const _0x1d0b79=_0x262cbe;VisuMZ[_0x1d0b79(0x80)](_0x3c1763,_0x3c1763);const _0x17d358=_0x3c1763[_0x1d0b79(0x531)]||0x0;$gameParty[_0x1d0b79(0x252)](_0x17d358);}),PluginManager[_0x262cbe(0x6f5)](pluginData['name'],_0x262cbe(0x402),_0x3f0f3c=>{const _0x5a287d=_0x262cbe;if(!SceneManager[_0x5a287d(0x62f)]())return;VisuMZ['ConvertParams'](_0x3f0f3c,_0x3f0f3c);const _0x1f0b6a=_0x3f0f3c['CommonEventID'];SceneManager[_0x5a287d(0x207)][_0x5a287d(0x589)](_0x1f0b6a);}),PluginManager['registerCommand'](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x82e),_0x2f6ebd=>{const _0x4fe855=_0x262cbe;if(!$gameTemp[_0x4fe855(0x5ee)]())return;if(!Utils['isNwjs']())return;VisuMZ[_0x4fe855(0x80)](_0x2f6ebd,_0x2f6ebd);const _0x7a0a72=_0x2f6ebd[_0x4fe855(0x16c)]||0x1;$gameTemp['_pictureCoordinatesMode']=_0x7a0a72;}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x2f6),_0x4c5164=>{const _0x4c9f87=_0x262cbe;VisuMZ[_0x4c9f87(0x80)](_0x4c5164,_0x4c5164);const _0x1e185d=_0x4c5164[_0x4c9f87(0x1ff)]||0x1,_0x5287da=_0x4c5164['easingType']||_0x4c9f87(0x7c1),_0x3fdcfe=$gameScreen[_0x4c9f87(0x766)](_0x1e185d);_0x3fdcfe&&_0x3fdcfe[_0x4c9f87(0x2dc)](_0x5287da);}),PluginManager['registerCommand'](pluginData[_0x262cbe(0x84e)],'PictureEraseAll',_0x50c4e5=>{const _0x2dfa24=_0x262cbe;for(let _0x3f4455=0x1;_0x3f4455<=0x64;_0x3f4455++){$gameScreen[_0x2dfa24(0x4c2)](_0x3f4455);}}),PluginManager['registerCommand'](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x528),_0x3ba7bf=>{const _0x11c527=_0x262cbe;VisuMZ['ConvertParams'](_0x3ba7bf,_0x3ba7bf);const _0x330626=Math[_0x11c527(0x5d0)](_0x3ba7bf[_0x11c527(0x4d0)],_0x3ba7bf['EndingID']),_0x53b84d=Math[_0x11c527(0x256)](_0x3ba7bf[_0x11c527(0x4d0)],_0x3ba7bf[_0x11c527(0x357)]);for(let _0x679d5=_0x330626;_0x679d5<=_0x53b84d;_0x679d5++){$gameScreen[_0x11c527(0x4c2)](_0x679d5);}}),PluginManager[_0x262cbe(0x6f5)](pluginData['name'],'PictureRotateBy',_0x4730cc=>{const _0x4789e9=_0x262cbe;VisuMZ['ConvertParams'](_0x4730cc,_0x4730cc);const _0x439b56=Math[_0x4789e9(0x38d)](_0x4730cc['PictureID'])[_0x4789e9(0x565)](0x1,0x64),_0x4d678a=-Number(_0x4730cc[_0x4789e9(0x27c)]||0x0),_0x31f44a=Math[_0x4789e9(0x256)](_0x4730cc[_0x4789e9(0x1fd)]||0x0,0x0),_0x332cb2=_0x4730cc['easingType']||_0x4789e9(0x7c1),_0x2fb102=_0x4730cc[_0x4789e9(0x328)],_0x135033=$gameScreen[_0x4789e9(0x766)](_0x439b56);if(!_0x135033)return;_0x135033['changeAnglePlusData'](_0x4d678a,_0x31f44a,_0x332cb2);if(_0x2fb102){const _0x587f5d=$gameTemp[_0x4789e9(0x482)]();if(_0x587f5d)_0x587f5d[_0x4789e9(0x125)](_0x31f44a);}}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x825),_0x3ac029=>{const _0x526277=_0x262cbe;VisuMZ[_0x526277(0x80)](_0x3ac029,_0x3ac029);const _0x4715d1=Math[_0x526277(0x38d)](_0x3ac029['PictureID'])['clamp'](0x1,0x64),_0x1e1655=-Number(_0x3ac029['TargetAngle']||0x0),_0x4e3c5b=Math[_0x526277(0x256)](_0x3ac029['Duration']||0x0,0x0),_0x69fa2c=_0x3ac029[_0x526277(0x74f)]||'Linear',_0x9265e7=_0x3ac029[_0x526277(0x328)],_0x2c6379=$gameScreen[_0x526277(0x766)](_0x4715d1);if(!_0x2c6379)return;_0x2c6379[_0x526277(0x470)](_0x1e1655,_0x4e3c5b,_0x69fa2c);if(_0x9265e7){const _0x4ec151=$gameTemp[_0x526277(0x482)]();if(_0x4ec151)_0x4ec151[_0x526277(0x125)](_0x4e3c5b);}}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],'PictureShowIcon',_0x584dd6=>{const _0x4c4750=_0x262cbe;VisuMZ['ConvertParams'](_0x584dd6,_0x584dd6);const _0x17c86f=Math[_0x4c4750(0x38d)](_0x584dd6[_0x4c4750(0x16c)])[_0x4c4750(0x565)](0x1,0x64),_0xffbd3d=_0x584dd6[_0x4c4750(0x84d)],_0x3c72c3=_0xffbd3d[_0x4c4750(0x2cf)][_0x4c4750(0x565)](0x0,0x1),_0xcf0601=Math[_0x4c4750(0x38d)](_0xffbd3d[_0x4c4750(0x506)]||0x0),_0x28232b=Math['round'](_0xffbd3d[_0x4c4750(0x5c6)]||0x0),_0x5d88f7=Math['round'](_0xffbd3d[_0x4c4750(0x5bf)]||0x0),_0x4bc833=Math[_0x4c4750(0x38d)](_0xffbd3d[_0x4c4750(0x732)]||0x0),_0x3eba06=Math[_0x4c4750(0x38d)](_0xffbd3d[_0x4c4750(0x5e4)])[_0x4c4750(0x565)](0x0,0xff),_0x3ac883=_0xffbd3d[_0x4c4750(0x764)],_0x42e6eb=_0x4c4750(0x3cd),_0x1cf593=_0x584dd6[_0x4c4750(0x656)]?_0x4c4750(0x656):_0x4c4750(0x7b6),_0x263052=_0x42e6eb[_0x4c4750(0x94)](_0x584dd6['IconIndex'],_0x1cf593);$gameScreen[_0x4c4750(0x59b)](_0x17c86f,_0x263052,_0x3c72c3,_0xcf0601,_0x28232b,_0x5d88f7,_0x4bc833,_0x3eba06,_0x3ac883);}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x67e),_0x1e2b1c=>{const _0x52567c=_0x262cbe;VisuMZ[_0x52567c(0x80)](_0x1e2b1c,_0x1e2b1c);const _0x41f73a=_0x1e2b1c[_0x52567c(0x2c1)]||_0x52567c(0x571),_0x2e33b0=_0x1e2b1c['Power'][_0x52567c(0x565)](0x1,0x9),_0x585327=_0x1e2b1c['Speed']['clamp'](0x1,0x9),_0x4fcf6e=_0x1e2b1c[_0x52567c(0x1fd)]||0x1,_0x58b2a8=_0x1e2b1c['Wait'];$gameScreen[_0x52567c(0x347)](_0x41f73a),$gameScreen[_0x52567c(0x5d9)](_0x2e33b0,_0x585327,_0x4fcf6e);if(_0x58b2a8){const _0x1fe7b7=$gameTemp[_0x52567c(0x482)]();if(_0x1fe7b7)_0x1fe7b7[_0x52567c(0x125)](_0x4fcf6e);}}),PluginManager[_0x262cbe(0x6f5)](pluginData['name'],'SwitchRandomizeOne',_0x23666e=>{const _0x5d058c=_0x262cbe;if($gameParty['inBattle']())return;VisuMZ[_0x5d058c(0x80)](_0x23666e,_0x23666e);const _0x312771=_0x23666e['IDs'],_0x520f5d=(_0x23666e['Chance']||0x0)/0x64;for(const _0x19942f of _0x312771){const _0x1b3827=Math['random']()<=_0x520f5d;$gameSwitches[_0x5d058c(0x55c)](_0x19942f,_0x1b3827);}}),PluginManager[_0x262cbe(0x6f5)](pluginData['name'],_0x262cbe(0x2d8),_0x548460=>{const _0x4cd75a=_0x262cbe;if($gameParty[_0x4cd75a(0xd0)]())return;VisuMZ[_0x4cd75a(0x80)](_0x548460,_0x548460);const _0x5f343d=Math[_0x4cd75a(0x5d0)](_0x548460[_0x4cd75a(0x4d0)],_0x548460['EndingID']),_0x396e02=Math[_0x4cd75a(0x256)](_0x548460[_0x4cd75a(0x4d0)],_0x548460[_0x4cd75a(0x357)]),_0x53e6ca=(_0x548460[_0x4cd75a(0x6c5)]||0x0)/0x64;for(let _0x53c56d=_0x5f343d;_0x53c56d<=_0x396e02;_0x53c56d++){const _0x1942e6=Math[_0x4cd75a(0x571)]()<=_0x53e6ca;$gameSwitches[_0x4cd75a(0x55c)](_0x53c56d,_0x1942e6);}}),PluginManager['registerCommand'](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x5de),_0x3d8f2c=>{const _0x2d5716=_0x262cbe;if($gameParty['inBattle']())return;VisuMZ[_0x2d5716(0x80)](_0x3d8f2c,_0x3d8f2c);const _0x1c74b0=_0x3d8f2c[_0x2d5716(0x302)];for(const _0x41a24c of _0x1c74b0){const _0x2fa864=$gameSwitches['value'](_0x41a24c);$gameSwitches[_0x2d5716(0x55c)](_0x41a24c,!_0x2fa864);}}),PluginManager[_0x262cbe(0x6f5)](pluginData['name'],_0x262cbe(0x670),_0x413fe7=>{const _0x862def=_0x262cbe;if($gameParty[_0x862def(0xd0)]())return;VisuMZ[_0x862def(0x80)](_0x413fe7,_0x413fe7);const _0x2215bd=Math[_0x862def(0x5d0)](_0x413fe7[_0x862def(0x4d0)],_0x413fe7[_0x862def(0x357)]),_0x45c731=Math[_0x862def(0x256)](_0x413fe7[_0x862def(0x4d0)],_0x413fe7[_0x862def(0x357)]);for(let _0x35a0c9=_0x2215bd;_0x35a0c9<=_0x45c731;_0x35a0c9++){const _0x41b458=$gameSwitches[_0x862def(0x531)](_0x35a0c9);$gameSwitches['setValue'](_0x35a0c9,!_0x41b458);}}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x558),_0x71b64f=>{const _0x371cfe=_0x262cbe;VisuMZ[_0x371cfe(0x80)](_0x71b64f,_0x71b64f);const _0x373580=_0x71b64f[_0x371cfe(0x5e2)]||0x1;$gameSystem['setMainFontSize'](_0x373580);}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],'SystemSetSideView',_0x214eae=>{const _0x5093a3=_0x262cbe;if($gameParty[_0x5093a3(0xd0)]())return;VisuMZ['ConvertParams'](_0x214eae,_0x214eae);const _0xd72c66=_0x214eae[_0x5093a3(0x5e2)];if(_0xd72c66[_0x5093a3(0x13e)](/Front/i))$gameSystem[_0x5093a3(0x833)](![]);else _0xd72c66[_0x5093a3(0x13e)](/Side/i)?$gameSystem[_0x5093a3(0x833)](!![]):$gameSystem['setSideView'](!$gameSystem[_0x5093a3(0x525)]());}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x6ff),_0x5265f2=>{const _0x3183f1=_0x262cbe;if($gameParty['inBattle']())return;VisuMZ[_0x3183f1(0x80)](_0x5265f2,_0x5265f2);const _0x4e2dab=[_0x3183f1(0x3c6),_0x3183f1(0x34d),'me','se'];for(const _0x1b7bd8 of _0x4e2dab){const _0x37ee6a=_0x5265f2[_0x1b7bd8],_0x58b742=_0x3183f1(0x2b1)[_0x3183f1(0x94)](_0x1b7bd8);for(const _0x2aaeed of _0x37ee6a){AudioManager[_0x3183f1(0x514)](_0x58b742,_0x2aaeed);}}}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x63f),_0x540473=>{const _0x1c0039=_0x262cbe;if($gameParty[_0x1c0039(0xd0)]())return;VisuMZ[_0x1c0039(0x80)](_0x540473,_0x540473);const _0x22e96b=[_0x1c0039(0x661),_0x1c0039(0x74b),_0x1c0039(0x2fc),'characters',_0x1c0039(0x5f3),_0x1c0039(0x562),_0x1c0039(0x74d),_0x1c0039(0x1ed),_0x1c0039(0x231),_0x1c0039(0x495),_0x1c0039(0x269),'tilesets','titles1',_0x1c0039(0x77e)];for(const _0x3d8c8d of _0x22e96b){const _0x552198=_0x540473[_0x3d8c8d],_0x50cb01=_0x1c0039(0x6eb)['format'](_0x3d8c8d);for(const _0x312314 of _0x552198){ImageManager[_0x1c0039(0x19b)](_0x50cb01,_0x312314);}}}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x7cb),_0x2d0188=>{const _0x3c9b2f=_0x262cbe;if($gameParty[_0x3c9b2f(0xd0)]())return;VisuMZ[_0x3c9b2f(0x80)](_0x2d0188,_0x2d0188);const _0x20565b=_0x2d0188[_0x3c9b2f(0x5e2)][_0x3c9b2f(0x551)]()['trim'](),_0x2ddbe9=VisuMZ[_0x3c9b2f(0x244)][_0x3c9b2f(0x5c4)](_0x20565b);$gameSystem['setBattleSystem'](_0x2ddbe9);}),VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x5c4)]=function(_0x313f6c){const _0x24e041=_0x262cbe;_0x313f6c=_0x313f6c||_0x24e041(0x62a),_0x313f6c=String(_0x313f6c)['toUpperCase']()[_0x24e041(0x4a7)]();switch(_0x313f6c){case _0x24e041(0x21d):return 0x0;case _0x24e041(0x36f):Imported['VisuMZ_1_OptionsCore']&&(ConfigManager['atbActive']=!![]);return 0x1;case'TPB\x20WAIT':Imported[_0x24e041(0x628)]&&(ConfigManager[_0x24e041(0x569)]=![]);return 0x2;case _0x24e041(0x283):if(Imported[_0x24e041(0x2de)])return'CTB';break;case _0x24e041(0x41d):if(Imported[_0x24e041(0x718)])return'STB';break;case _0x24e041(0x723):if(Imported[_0x24e041(0x383)])return'BTB';break;case _0x24e041(0x56f):if(Imported[_0x24e041(0xc2)])return _0x24e041(0x56f);break;case'OTB':if(Imported['VisuMZ_2_BattleSystemOTB'])return _0x24e041(0x31e);break;case _0x24e041(0x22f):if(Imported[_0x24e041(0x72f)])return _0x24e041(0x22f);break;case _0x24e041(0x7f3):if(Imported['VisuMZ_2_BattleSystemPTB'])return _0x24e041(0x7f3);break;}return $dataSystem['battleSystem'];},PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x584),_0x4f9259=>{const _0x38dabf=_0x262cbe;VisuMZ[_0x38dabf(0x80)](_0x4f9259,_0x4f9259);const _0xb6cab2=_0x4f9259['option']||0x1;$gameSystem[_0x38dabf(0x262)](_0xb6cab2);}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],'TextPopupShow',_0x37708b=>{VisuMZ['ConvertParams'](_0x37708b,_0x37708b);const _0x116cd5=_0x37708b['text']||'';$textPopup(_0x116cd5);}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],'VariableEvalReference',_0x237460=>{const _0x3c51cb=_0x262cbe;VisuMZ[_0x3c51cb(0x80)](_0x237460,_0x237460);const _0x494d6a=_0x237460['id']||0x1,_0x5e2a92=_0x237460['operation'],_0x16bbff=_0x237460[_0x3c51cb(0x2a3)]||0x0;let _0x2a67de=$gameVariables[_0x3c51cb(0x531)](_0x494d6a)||0x0;switch(_0x5e2a92){case'=':_0x2a67de=_0x16bbff;break;case'+':_0x2a67de+=_0x16bbff;break;case'-':_0x2a67de-=_0x16bbff;break;case'*':_0x2a67de*=_0x16bbff;break;case'/':_0x2a67de/=_0x16bbff;break;case'%':_0x2a67de%=_0x16bbff;break;}_0x2a67de=_0x2a67de||0x0,$gameVariables['setValue'](_0x494d6a,_0x2a67de);}),PluginManager[_0x262cbe(0x6f5)](pluginData[_0x262cbe(0x84e)],_0x262cbe(0x434),_0x2d24d3=>{const _0x4f2a01=_0x262cbe;VisuMZ[_0x4f2a01(0x80)](_0x2d24d3,_0x2d24d3);const _0x471c97=_0x2d24d3['id']()||0x1,_0x599a52=_0x2d24d3[_0x4f2a01(0x1c3)],_0x50e4a1=_0x2d24d3[_0x4f2a01(0x2a3)]()||0x0;let _0x4f0b3f=$gameVariables['value'](_0x471c97)||0x0;switch(_0x599a52){case'=':_0x4f0b3f=_0x50e4a1;break;case'+':_0x4f0b3f+=_0x50e4a1;break;case'-':_0x4f0b3f-=_0x50e4a1;break;case'*':_0x4f0b3f*=_0x50e4a1;break;case'/':_0x4f0b3f/=_0x50e4a1;break;case'%':_0x4f0b3f%=_0x50e4a1;break;}_0x4f0b3f=_0x4f0b3f||0x0,$gameVariables[_0x4f2a01(0x55c)](_0x471c97,_0x4f0b3f);}),VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x351)]=Scene_Boot[_0x262cbe(0x800)][_0x262cbe(0x355)],Scene_Boot['prototype'][_0x262cbe(0x355)]=function(){const _0x565337=_0x262cbe;VisuMZ[_0x565337(0x244)]['Scene_Boot_onDatabaseLoaded']['call'](this),this['process_VisuMZ_CoreEngine_RegExp'](),this[_0x565337(0x685)](),this[_0x565337(0x31c)](),this[_0x565337(0x5ed)](),this[_0x565337(0x7a6)](),this['process_VisuMZ_CoreEngine_ControllerButtons'](),VisuMZ[_0x565337(0x5da)]();},VisuMZ['CoreEngine']['RegExp']={},Scene_Boot[_0x262cbe(0x800)]['process_VisuMZ_CoreEngine_RegExp']=function(){const _0x4132a0=_0x262cbe,_0x2a33ec=[_0x4132a0(0x92),_0x4132a0(0x154),_0x4132a0(0x658),_0x4132a0(0x353),_0x4132a0(0xbd),_0x4132a0(0x1d1),'AGI',_0x4132a0(0x162)],_0x3793b2=[_0x4132a0(0x7c6),_0x4132a0(0xc0),_0x4132a0(0x2c3),_0x4132a0(0x483),_0x4132a0(0x30c),_0x4132a0(0x542),_0x4132a0(0xe8),_0x4132a0(0x657),_0x4132a0(0x4b8),_0x4132a0(0x4f5)],_0x5f289a=[_0x4132a0(0x182),_0x4132a0(0x370),_0x4132a0(0x424),_0x4132a0(0x7c),_0x4132a0(0x2ef),'TCR','PDR',_0x4132a0(0x755),'FDR',_0x4132a0(0x659)],_0xf35cc1=[_0x2a33ec,_0x3793b2,_0x5f289a],_0x1d711f=[_0x4132a0(0x346),_0x4132a0(0x582),_0x4132a0(0x85a),'Max',_0x4132a0(0x5a7),'Rate1',_0x4132a0(0x56d),'Flat','Flat1',_0x4132a0(0x687)];for(const _0xb17026 of _0xf35cc1){let _0x145505='';if(_0xb17026===_0x2a33ec)_0x145505='param';if(_0xb17026===_0x3793b2)_0x145505='xparam';if(_0xb17026===_0x5f289a)_0x145505=_0x4132a0(0xe2);for(const _0x7a2b26 of _0x1d711f){let _0x297505=_0x4132a0(0x64c)['format'](_0x145505,_0x7a2b26);VisuMZ[_0x4132a0(0x244)][_0x4132a0(0x168)][_0x297505]=[],VisuMZ[_0x4132a0(0x244)]['RegExp'][_0x297505+'JS']=[];let _0x422f4e='<%1\x20%2:[\x20]';if([_0x4132a0(0x346),'Flat']['includes'](_0x7a2b26))_0x422f4e+='([\x5c+\x5c-]\x5cd+)>';else{if(['Plus1',_0x4132a0(0x43a)]['includes'](_0x7a2b26))_0x422f4e+=_0x4132a0(0x4b6);else{if([_0x4132a0(0x85a),_0x4132a0(0x687)][_0x4132a0(0x14c)](_0x7a2b26))_0x422f4e+=_0x4132a0(0x463);else{if(_0x7a2b26==='Max')_0x422f4e+=_0x4132a0(0x185);else{if(_0x7a2b26==='Rate1')_0x422f4e+='(\x5cd+)([%％])>';else _0x7a2b26===_0x4132a0(0x56d)&&(_0x422f4e+=_0x4132a0(0x4ca));}}}}for(const _0x46bd9f of _0xb17026){let _0x5dca72=_0x7a2b26[_0x4132a0(0x641)](/[\d+]/g,'')[_0x4132a0(0x551)]();const _0x515cfc=_0x422f4e[_0x4132a0(0x94)](_0x46bd9f,_0x5dca72);VisuMZ['CoreEngine']['RegExp'][_0x297505][_0x4132a0(0x4ea)](new RegExp(_0x515cfc,'i'));const _0xf49e08=_0x4132a0(0x50f)['format'](_0x46bd9f,_0x5dca72);VisuMZ[_0x4132a0(0x244)][_0x4132a0(0x168)][_0x297505+'JS']['push'](new RegExp(_0xf49e08,'i'));}}}},Scene_Boot[_0x262cbe(0x800)]['process_VisuMZ_CoreEngine_Notetags']=function(){const _0x5cdb9b=_0x262cbe;if(VisuMZ[_0x5cdb9b(0x5da)])return;},Scene_Boot[_0x262cbe(0x800)][_0x262cbe(0x31c)]=function(){const _0x1ad287=_0x262cbe,_0x48c7a5=VisuMZ[_0x1ad287(0x244)]['Settings'];_0x48c7a5['QoL']['OpenConsole']&&VisuMZ[_0x1ad287(0x8a)](!![]);_0x48c7a5['QoL']['ModernControls']&&(Input[_0x1ad287(0x49a)][0x23]=_0x1ad287(0x49d),Input[_0x1ad287(0x49a)][0x24]='home');if(_0x48c7a5[_0x1ad287(0x153)]){const _0x5d8f90=_0x48c7a5[_0x1ad287(0x153)];_0x5d8f90[_0x1ad287(0x1fb)]=_0x5d8f90[_0x1ad287(0x1fb)]||_0x1ad287(0x39e),_0x5d8f90['KeyTAB']=_0x5d8f90[_0x1ad287(0x779)]||_0x1ad287(0x66b);}_0x48c7a5[_0x1ad287(0x67f)][_0x1ad287(0xf1)]&&(Input[_0x1ad287(0x49a)][0x57]='up',Input[_0x1ad287(0x49a)][0x41]='left',Input[_0x1ad287(0x49a)][0x53]=_0x1ad287(0x557),Input[_0x1ad287(0x49a)][0x44]=_0x1ad287(0x7d9),Input[_0x1ad287(0x49a)][0x45]='pagedown'),_0x48c7a5[_0x1ad287(0x67f)]['DashToggleR']&&(Input[_0x1ad287(0x49a)][0x52]=_0x1ad287(0x56c)),_0x48c7a5[_0x1ad287(0x778)][_0x1ad287(0x3e9)]=_0x48c7a5['Param']['DisplayedParams'][_0x1ad287(0x2fe)](_0x4c469b=>_0x4c469b[_0x1ad287(0x551)]()[_0x1ad287(0x4a7)]()),_0x48c7a5[_0x1ad287(0x778)][_0x1ad287(0x4a8)]=_0x48c7a5[_0x1ad287(0x778)][_0x1ad287(0x4a8)]['map'](_0x4a9cf7=>_0x4a9cf7[_0x1ad287(0x551)]()[_0x1ad287(0x4a7)]()),_0x48c7a5['QoL']['ShiftR_Toggle']=_0x48c7a5[_0x1ad287(0x754)]['ShiftR_Toggle']??!![],_0x48c7a5[_0x1ad287(0x754)][_0x1ad287(0x39f)]=_0x48c7a5[_0x1ad287(0x754)][_0x1ad287(0x39f)]??!![];},Scene_Boot[_0x262cbe(0x800)][_0x262cbe(0x5ed)]=function(){this['process_VisuMZ_CoreEngine_jsQuickFunctions']();},Scene_Boot[_0x262cbe(0x800)][_0x262cbe(0x684)]=function(){const _0x73fe48=_0x262cbe,_0x9f1d08=VisuMZ[_0x73fe48(0x244)][_0x73fe48(0x84d)]['jsQuickFunc'];for(const _0x51dcc4 of _0x9f1d08){const _0x49909f=_0x51dcc4[_0x73fe48(0xd4)][_0x73fe48(0x641)](/[ ]/g,''),_0x42fdfc=_0x51dcc4[_0x73fe48(0x29a)];VisuMZ[_0x73fe48(0x244)]['createJsQuickFunction'](_0x49909f,_0x42fdfc);}},VisuMZ[_0x262cbe(0x244)]['createJsQuickFunction']=function(_0x34415a,_0x4a5c4d){const _0x27d652=_0x262cbe;if(!!window[_0x34415a]){if($gameTemp[_0x27d652(0x5ee)]())console[_0x27d652(0x254)](_0x27d652(0x149)[_0x27d652(0x94)](_0x34415a));}const _0x130d43=_0x27d652(0x607)[_0x27d652(0x94)](_0x34415a,_0x4a5c4d);window[_0x34415a]=new Function(_0x130d43);},Scene_Boot[_0x262cbe(0x800)][_0x262cbe(0x7a6)]=function(){const _0x35c6a8=_0x262cbe,_0x2444e0=VisuMZ[_0x35c6a8(0x244)][_0x35c6a8(0x84d)]['CustomParam'];if(!_0x2444e0)return;for(const _0x2fa5c3 of _0x2444e0){if(!_0x2fa5c3)continue;VisuMZ[_0x35c6a8(0x244)]['createCustomParameter'](_0x2fa5c3);}},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x7dd)]={},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x393)]={},VisuMZ['CoreEngine'][_0x262cbe(0x36a)]={},VisuMZ['CoreEngine'][_0x262cbe(0x3dd)]={},VisuMZ['CoreEngine'][_0x262cbe(0x51f)]=function(_0x2889f0){const _0x4a45bf=_0x262cbe,_0x598bea=_0x2889f0[_0x4a45bf(0x66a)],_0x27e19a=_0x2889f0[_0x4a45bf(0x1f2)],_0x1063b3=_0x2889f0['Icon'],_0x3056d0=_0x2889f0[_0x4a45bf(0x2c1)],_0x5be9de=new Function(_0x2889f0[_0x4a45bf(0x5c1)]);VisuMZ['CoreEngine'][_0x4a45bf(0x7dd)][_0x598bea['toUpperCase']()[_0x4a45bf(0x4a7)]()]=_0x27e19a,VisuMZ[_0x4a45bf(0x244)][_0x4a45bf(0x393)][_0x598bea[_0x4a45bf(0x551)]()[_0x4a45bf(0x4a7)]()]=_0x1063b3,VisuMZ[_0x4a45bf(0x244)][_0x4a45bf(0x36a)][_0x598bea[_0x4a45bf(0x551)]()[_0x4a45bf(0x4a7)]()]=_0x3056d0,VisuMZ[_0x4a45bf(0x244)][_0x4a45bf(0x3dd)][_0x598bea['toUpperCase']()[_0x4a45bf(0x4a7)]()]=_0x598bea,Object[_0x4a45bf(0x1b7)](Game_BattlerBase[_0x4a45bf(0x800)],_0x598bea,{'get'(){const _0x19ff3b=_0x4a45bf,_0x1993c9=_0x5be9de['call'](this);return _0x3056d0===_0x19ff3b(0x25d)?Math[_0x19ff3b(0x38d)](_0x1993c9):_0x1993c9;}});},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x7d5)]={},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x629)]={},Scene_Boot[_0x262cbe(0x800)][_0x262cbe(0xab)]=function(){const _0x453b1c=_0x262cbe,_0x49ff5a=VisuMZ[_0x453b1c(0x244)]['Settings'][_0x453b1c(0x7d5)];for(const _0x3a95f0 of _0x49ff5a){const _0xf2f2e9=(_0x3a95f0['Name']||'')[_0x453b1c(0x218)]()[_0x453b1c(0x4a7)](),_0x29d71e=(_0x3a95f0[_0x453b1c(0x60f)]||'')[_0x453b1c(0x218)]()[_0x453b1c(0x4a7)]();VisuMZ[_0x453b1c(0x244)][_0x453b1c(0x7d5)][_0xf2f2e9]=_0x3a95f0,VisuMZ[_0x453b1c(0x244)]['ControllerMatches'][_0x29d71e]=_0xf2f2e9;}},VisuMZ[_0x262cbe(0x5da)]=function(){const _0x2dcc96=_0x262cbe;for(const _0x25c0eb of $dataActors){if(_0x25c0eb)VisuMZ[_0x2dcc96(0x6a2)](_0x25c0eb);}for(const _0x574b98 of $dataClasses){if(_0x574b98)VisuMZ[_0x2dcc96(0x502)](_0x574b98);}for(const _0x34d55f of $dataSkills){if(_0x34d55f)VisuMZ[_0x2dcc96(0x15b)](_0x34d55f);}for(const _0x525f17 of $dataItems){if(_0x525f17)VisuMZ[_0x2dcc96(0x70a)](_0x525f17);}for(const _0x2e88b2 of $dataWeapons){if(_0x2e88b2)VisuMZ[_0x2dcc96(0x79c)](_0x2e88b2);}for(const _0x8642f8 of $dataArmors){if(_0x8642f8)VisuMZ[_0x2dcc96(0x1db)](_0x8642f8);}for(const _0x30512c of $dataEnemies){if(_0x30512c)VisuMZ[_0x2dcc96(0x448)](_0x30512c);}for(const _0x4c1190 of $dataStates){if(_0x4c1190)VisuMZ[_0x2dcc96(0x603)](_0x4c1190);}for(const _0x36234d of $dataTilesets){if(_0x36234d)VisuMZ[_0x2dcc96(0x169)](_0x36234d);}},VisuMZ[_0x262cbe(0x6a2)]=function(_0x3f19c5){},VisuMZ[_0x262cbe(0x502)]=function(_0x326e2e){},VisuMZ[_0x262cbe(0x15b)]=function(_0x9ed46){},VisuMZ[_0x262cbe(0x70a)]=function(_0x22cbcf){},VisuMZ[_0x262cbe(0x79c)]=function(_0x3166e5){},VisuMZ[_0x262cbe(0x1db)]=function(_0x512270){},VisuMZ[_0x262cbe(0x448)]=function(_0x166431){},VisuMZ[_0x262cbe(0x603)]=function(_0x5396ad){},VisuMZ[_0x262cbe(0x169)]=function(_0x3dbb73){},VisuMZ[_0x262cbe(0x244)]['ParseActorNotetags']=VisuMZ[_0x262cbe(0x6a2)],VisuMZ[_0x262cbe(0x6a2)]=function(_0x611905){const _0x5e2bb7=_0x262cbe;VisuMZ[_0x5e2bb7(0x244)][_0x5e2bb7(0x6a2)][_0x5e2bb7(0x77c)](this,_0x611905);const _0x16f5de=_0x611905[_0x5e2bb7(0x215)];if(_0x16f5de[_0x5e2bb7(0x13e)](/<MAX LEVEL:[ ](\d+)>/i)){_0x611905[_0x5e2bb7(0x32e)]=Number(RegExp['$1']);if(_0x611905['maxLevel']===0x0)_0x611905[_0x5e2bb7(0x32e)]=Number[_0x5e2bb7(0x379)];}_0x16f5de[_0x5e2bb7(0x13e)](/<INITIAL LEVEL:[ ](\d+)>/i)&&(_0x611905[_0x5e2bb7(0x481)]=Math['min'](Number(RegExp['$1']),_0x611905[_0x5e2bb7(0x32e)]));},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x502)]=VisuMZ[_0x262cbe(0x502)],VisuMZ[_0x262cbe(0x502)]=function(_0x2477f2){const _0x1fa9c9=_0x262cbe;VisuMZ[_0x1fa9c9(0x244)][_0x1fa9c9(0x502)][_0x1fa9c9(0x77c)](this,_0x2477f2);if(_0x2477f2[_0x1fa9c9(0x519)])for(const _0x3923ea of _0x2477f2['learnings']){_0x3923ea[_0x1fa9c9(0x215)][_0x1fa9c9(0x13e)](/<LEARN AT LEVEL:[ ](\d+)>/i)&&(_0x3923ea[_0x1fa9c9(0xb5)]=Math[_0x1fa9c9(0x256)](Number(RegExp['$1']),0x1));}},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x448)]=VisuMZ[_0x262cbe(0x448)],VisuMZ[_0x262cbe(0x448)]=function(_0xd27d95){const _0x58a874=_0x262cbe;VisuMZ['CoreEngine'][_0x58a874(0x448)][_0x58a874(0x77c)](this,_0xd27d95),_0xd27d95[_0x58a874(0xb5)]=0x1;const _0x2cc2fe=_0xd27d95[_0x58a874(0x215)];if(_0x2cc2fe['match'](/<LEVEL:[ ](\d+)>/i))_0xd27d95['level']=Number(RegExp['$1']);if(_0x2cc2fe[_0x58a874(0x13e)](/<MAXHP:[ ](\d+)>/i))_0xd27d95[_0x58a874(0x34f)][0x0]=Number(RegExp['$1']);if(_0x2cc2fe['match'](/<MAXMP:[ ](\d+)>/i))_0xd27d95[_0x58a874(0x34f)][0x1]=Number(RegExp['$1']);if(_0x2cc2fe[_0x58a874(0x13e)](/<ATK:[ ](\d+)>/i))_0xd27d95[_0x58a874(0x34f)][0x2]=Number(RegExp['$1']);if(_0x2cc2fe[_0x58a874(0x13e)](/<DEF:[ ](\d+)>/i))_0xd27d95[_0x58a874(0x34f)][0x3]=Number(RegExp['$1']);if(_0x2cc2fe[_0x58a874(0x13e)](/<MAT:[ ](\d+)>/i))_0xd27d95[_0x58a874(0x34f)][0x4]=Number(RegExp['$1']);if(_0x2cc2fe['match'](/<MDF:[ ](\d+)>/i))_0xd27d95[_0x58a874(0x34f)][0x5]=Number(RegExp['$1']);if(_0x2cc2fe[_0x58a874(0x13e)](/<AGI:[ ](\d+)>/i))_0xd27d95[_0x58a874(0x34f)][0x6]=Number(RegExp['$1']);if(_0x2cc2fe[_0x58a874(0x13e)](/<LUK:[ ](\d+)>/i))_0xd27d95[_0x58a874(0x34f)][0x7]=Number(RegExp['$1']);if(_0x2cc2fe[_0x58a874(0x13e)](/<EXP:[ ](\d+)>/i))_0xd27d95['exp']=Number(RegExp['$1']);if(_0x2cc2fe[_0x58a874(0x13e)](/<GOLD:[ ](\d+)>/i))_0xd27d95[_0x58a874(0x405)]=Number(RegExp['$1']);},VisuMZ[_0x262cbe(0x244)]['Graphics_defaultStretchMode']=Graphics[_0x262cbe(0x4b5)],Graphics[_0x262cbe(0x4b5)]=function(){const _0x5a4b01=_0x262cbe;switch(VisuMZ[_0x5a4b01(0x244)][_0x5a4b01(0x84d)][_0x5a4b01(0x754)]['AutoStretch']){case _0x5a4b01(0x298):return!![];case _0x5a4b01(0x91):return![];default:return VisuMZ[_0x5a4b01(0x244)][_0x5a4b01(0x25c)]['call'](this);}},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x735)]=Graphics[_0x262cbe(0x1ec)],Graphics[_0x262cbe(0x1ec)]=function(_0xf1d7aa,_0x53198b,_0x481742=null){const _0x2678af=_0x262cbe;VisuMZ[_0x2678af(0x244)][_0x2678af(0x735)][_0x2678af(0x77c)](this,_0xf1d7aa,_0x53198b,_0x481742),VisuMZ[_0x2678af(0x8a)](![]);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x58c)]=Graphics[_0x262cbe(0x45c)],Graphics[_0x262cbe(0x45c)]=function(_0x1bbb82){const _0x35320d=_0x262cbe;VisuMZ[_0x35320d(0x244)]['Graphics_centerElement'][_0x35320d(0x77c)](this,_0x1bbb82),this['_centerElementCoreEngine'](_0x1bbb82);},Graphics[_0x262cbe(0x6e2)]=function(_0x45529d){const _0x1b4c6e=_0x262cbe;VisuMZ[_0x1b4c6e(0x244)]['Settings'][_0x1b4c6e(0x754)][_0x1b4c6e(0x5ff)]&&(_0x45529d['style'][_0x1b4c6e(0x592)]='none');VisuMZ['CoreEngine']['Settings']['QoL'][_0x1b4c6e(0x2e1)]&&(_0x45529d[_0x1b4c6e(0x32b)][_0x1b4c6e(0x3ac)]=_0x1b4c6e(0x1d0));const _0x2f0d5f=Math['max'](0x0,Math[_0x1b4c6e(0x431)](_0x45529d[_0x1b4c6e(0x80a)]*this['_realScale'])),_0x416cc8=Math[_0x1b4c6e(0x256)](0x0,Math[_0x1b4c6e(0x431)](_0x45529d['height']*this['_realScale']));_0x45529d[_0x1b4c6e(0x32b)][_0x1b4c6e(0x80a)]=_0x2f0d5f+'px',_0x45529d['style'][_0x1b4c6e(0x100)]=_0x416cc8+'px';},VisuMZ['CoreEngine'][_0x262cbe(0xca)]=Bitmap[_0x262cbe(0x800)]['initialize'],Bitmap[_0x262cbe(0x800)][_0x262cbe(0x1ad)]=function(_0x35a673,_0x3b2889){const _0x4fd6b2=_0x262cbe;VisuMZ['CoreEngine'][_0x4fd6b2(0xca)][_0x4fd6b2(0x77c)](this,_0x35a673,_0x3b2889),this[_0x4fd6b2(0x27e)]=!(VisuMZ[_0x4fd6b2(0x244)]['Settings'][_0x4fd6b2(0x754)]['PixelateImageRendering']??!![]);},Bitmap['prototype']['markCoreEngineModified']=function(){const _0x13b1dd=_0x262cbe;this[_0x13b1dd(0x6f7)]=!![];},VisuMZ['CoreEngine'][_0x262cbe(0x200)]=Sprite[_0x262cbe(0x800)][_0x262cbe(0x80c)],Sprite[_0x262cbe(0x800)][_0x262cbe(0x80c)]=function(){const _0x191abb=_0x262cbe;if(this[_0x191abb(0x3bb)])VisuMZ['CoreEngine'][_0x191abb(0x200)]['call'](this);this[_0x191abb(0x4ec)]();},Sprite[_0x262cbe(0x800)]['destroyCoreEngineMarkedBitmaps']=function(){const _0x5220fb=_0x262cbe;if(!this[_0x5220fb(0x2a9)])return;if(!this[_0x5220fb(0x2a9)][_0x5220fb(0x6f7)])return;this[_0x5220fb(0x2a9)][_0x5220fb(0x3f7)]&&!this[_0x5220fb(0x527)]['_baseTexture'][_0x5220fb(0x57c)]&&this[_0x5220fb(0x2a9)][_0x5220fb(0x80c)]();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x2a6)]=Bitmap[_0x262cbe(0x800)][_0x262cbe(0x397)],Bitmap['prototype'][_0x262cbe(0x397)]=function(_0x14a90c,_0x267317){const _0x41d01d=_0x262cbe;VisuMZ[_0x41d01d(0x244)][_0x41d01d(0x2a6)][_0x41d01d(0x77c)](this,_0x14a90c,_0x267317),this[_0x41d01d(0x5b4)]();},VisuMZ['CoreEngine'][_0x262cbe(0x572)]=Bitmap['prototype']['blt'],Bitmap[_0x262cbe(0x800)][_0x262cbe(0x649)]=function(_0x44f6ff,_0x583266,_0x2c5790,_0x3cd88c,_0x4c0729,_0x410813,_0x1379a4,_0x45ee1a,_0x477d33){const _0x150669=_0x262cbe;_0x583266=Math[_0x150669(0x38d)](_0x583266),_0x2c5790=Math['round'](_0x2c5790),_0x3cd88c=Math[_0x150669(0x38d)](_0x3cd88c),_0x4c0729=Math[_0x150669(0x38d)](_0x4c0729),_0x410813=Math['round'](_0x410813),_0x1379a4=Math[_0x150669(0x38d)](_0x1379a4),VisuMZ['CoreEngine'][_0x150669(0x572)][_0x150669(0x77c)](this,_0x44f6ff,_0x583266,_0x2c5790,_0x3cd88c,_0x4c0729,_0x410813,_0x1379a4,_0x45ee1a,_0x477d33),this[_0x150669(0x5b4)]();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x132)]=Bitmap[_0x262cbe(0x800)][_0x262cbe(0x6c7)],Bitmap[_0x262cbe(0x800)][_0x262cbe(0x6c7)]=function(_0x4e6184,_0x5d9e64,_0x5cd463,_0x39a241){const _0x355c6c=_0x262cbe;VisuMZ[_0x355c6c(0x244)][_0x355c6c(0x132)]['call'](this,_0x4e6184,_0x5d9e64,_0x5cd463,_0x39a241),this['markCoreEngineModified']();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x214)]=Bitmap[_0x262cbe(0x800)][_0x262cbe(0x46a)],Bitmap['prototype'][_0x262cbe(0x46a)]=function(_0x3698ef,_0x9995a1,_0x3b3c9c,_0x2ff16c,_0xdd4229){const _0x25de70=_0x262cbe;VisuMZ['CoreEngine'][_0x25de70(0x214)][_0x25de70(0x77c)](this,_0x3698ef,_0x9995a1,_0x3b3c9c,_0x2ff16c,_0xdd4229),this['markCoreEngineModified']();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x73d)]=Bitmap[_0x262cbe(0x800)]['strokeRect'],Bitmap[_0x262cbe(0x800)]['strokeRect']=function(_0xa7b819,_0x1d0866,_0x47ade3,_0x37698f,_0x5e2aee){const _0x49d0c9=_0x262cbe;VisuMZ[_0x49d0c9(0x244)][_0x49d0c9(0x73d)][_0x49d0c9(0x77c)](this,_0xa7b819,_0x1d0866,_0x47ade3,_0x37698f,_0x5e2aee),this[_0x49d0c9(0x5b4)]();},VisuMZ['CoreEngine'][_0x262cbe(0x1d5)]=Bitmap[_0x262cbe(0x800)][_0x262cbe(0x6ee)],Bitmap[_0x262cbe(0x800)][_0x262cbe(0x6ee)]=function(_0x1b6775,_0x3d6e11,_0xe65e4a,_0x539398,_0x428334,_0x3af0b2,_0x101325){const _0x1365bc=_0x262cbe;VisuMZ[_0x1365bc(0x244)]['Bitmap_gradientFillRect']['call'](this,_0x1b6775,_0x3d6e11,_0xe65e4a,_0x539398,_0x428334,_0x3af0b2,_0x101325),this['markCoreEngineModified']();},VisuMZ['CoreEngine'][_0x262cbe(0x28b)]=Bitmap[_0x262cbe(0x800)][_0x262cbe(0x4d8)],Bitmap['prototype'][_0x262cbe(0x4d8)]=function(_0x3ff34e,_0x52040f,_0x50c919,_0x3237a3){const _0x59ff2d=_0x262cbe;_0x3ff34e=Math['round'](_0x3ff34e),_0x52040f=Math[_0x59ff2d(0x38d)](_0x52040f),_0x50c919=Math[_0x59ff2d(0x38d)](_0x50c919),VisuMZ[_0x59ff2d(0x244)][_0x59ff2d(0x28b)]['call'](this,_0x3ff34e,_0x52040f,_0x50c919,_0x3237a3),this[_0x59ff2d(0x5b4)]();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x6e5)]=Bitmap[_0x262cbe(0x800)][_0x262cbe(0x1f4)],Bitmap['prototype'][_0x262cbe(0x1f4)]=function(_0x32d6a6){const _0x15edbc=_0x262cbe;return Math[_0x15edbc(0x4c7)](VisuMZ[_0x15edbc(0x244)][_0x15edbc(0x6e5)]['call'](this,_0x32d6a6));},VisuMZ[_0x262cbe(0x244)]['Bitmap_drawText']=Bitmap[_0x262cbe(0x800)][_0x262cbe(0x549)],Bitmap[_0x262cbe(0x800)][_0x262cbe(0x549)]=function(_0xdab96c,_0x328fa0,_0x4764f1,_0xe62342,_0x3d25fd,_0x16291e){const _0xf95f8=_0x262cbe;_0x328fa0=Math[_0xf95f8(0x38d)](_0x328fa0),_0x4764f1=Math['round'](_0x4764f1),_0xe62342=Math[_0xf95f8(0x4c7)](_0xe62342),_0x3d25fd=Math[_0xf95f8(0x4c7)](_0x3d25fd),VisuMZ[_0xf95f8(0x244)][_0xf95f8(0x4f8)]['call'](this,_0xdab96c,_0x328fa0,_0x4764f1,_0xe62342,_0x3d25fd,_0x16291e),this[_0xf95f8(0x5b4)]();},VisuMZ['CoreEngine']['Bitmap_drawTextOutline']=Bitmap['prototype'][_0x262cbe(0x487)],Bitmap[_0x262cbe(0x800)][_0x262cbe(0x487)]=function(_0x437c5b,_0x16bf69,_0x213124,_0x4aab05){const _0x2b8e7e=_0x262cbe;VisuMZ['CoreEngine'][_0x2b8e7e(0x84d)]['QoL'][_0x2b8e7e(0x430)]?this['_drawTextShadow'](_0x437c5b,_0x16bf69,_0x213124,_0x4aab05):VisuMZ[_0x2b8e7e(0x244)][_0x2b8e7e(0x29f)][_0x2b8e7e(0x77c)](this,_0x437c5b,_0x16bf69,_0x213124,_0x4aab05);},Bitmap[_0x262cbe(0x800)][_0x262cbe(0x366)]=function(_0x5057c4,_0x55a4aa,_0x42658f,_0x3149e2){const _0x44352f=_0x262cbe,_0x143a59=this[_0x44352f(0x545)];_0x143a59[_0x44352f(0x146)]=this['outlineColor'],_0x143a59[_0x44352f(0x57f)](_0x5057c4,_0x55a4aa+0x2,_0x42658f+0x2,_0x3149e2);},VisuMZ['CoreEngine'][_0x262cbe(0x6bf)]=Input[_0x262cbe(0x294)],Input[_0x262cbe(0x294)]=function(){const _0x36491c=_0x262cbe;VisuMZ[_0x36491c(0x244)][_0x36491c(0x6bf)][_0x36491c(0x77c)](this),this[_0x36491c(0x4e0)]=undefined,this[_0x36491c(0xa5)]=undefined,this[_0x36491c(0x54d)]=Input[_0x36491c(0x47d)];},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x21e)]=Input[_0x262cbe(0x64e)],Input[_0x262cbe(0x64e)]=function(){const _0x3bcc8c=_0x262cbe;VisuMZ[_0x3bcc8c(0x244)]['Input_update'][_0x3bcc8c(0x77c)](this);if(this['_gamepadWait'])this[_0x3bcc8c(0x54d)]--;},VisuMZ[_0x262cbe(0x244)]['Input_pollGamepads']=Input['_pollGamepads'],Input[_0x262cbe(0x58f)]=function(){const _0x448a04=_0x262cbe;if(this[_0x448a04(0x54d)])return;VisuMZ['CoreEngine'][_0x448a04(0x2f2)][_0x448a04(0x77c)](this);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x6b4)]=Input[_0x262cbe(0x66e)],Input[_0x262cbe(0x66e)]=function(){const _0x4e5f5b=_0x262cbe;VisuMZ[_0x4e5f5b(0x244)]['Input_setupEventHandlers'][_0x4e5f5b(0x77c)](this),document[_0x4e5f5b(0x849)](_0x4e5f5b(0x3e3),this[_0x4e5f5b(0x1c9)][_0x4e5f5b(0x75d)](this));},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x58a)]=Input['_onKeyDown'],Input[_0x262cbe(0x67c)]=function(_0x313fb0){const _0x496fc8=_0x262cbe;this[_0x496fc8(0xa5)]=_0x313fb0[_0x496fc8(0x78f)],VisuMZ[_0x496fc8(0x244)][_0x496fc8(0x58a)][_0x496fc8(0x77c)](this,_0x313fb0),this[_0x496fc8(0xdd)](null);},Input[_0x262cbe(0x1c9)]=function(_0x352a4c){const _0x308d94=_0x262cbe;this[_0x308d94(0x80f)](_0x352a4c);},Input[_0x262cbe(0x80f)]=function(_0x44ee34){const _0x1ba306=_0x262cbe;this[_0x1ba306(0xa5)]=_0x44ee34[_0x1ba306(0x78f)];let _0x535915=String[_0x1ba306(0x71a)](_0x44ee34[_0x1ba306(0x358)]);this['_inputString']===undefined?this[_0x1ba306(0x4e0)]=_0x535915:this[_0x1ba306(0x4e0)]+=_0x535915;},VisuMZ['CoreEngine'][_0x262cbe(0xa8)]=Input[_0x262cbe(0x642)],Input[_0x262cbe(0x642)]=function(_0x809fd5){const _0xa8b80a=_0x262cbe;if(_0x809fd5===0x8)return![];return VisuMZ[_0xa8b80a(0x244)][_0xa8b80a(0xa8)]['call'](this,_0x809fd5);},Input['isSpecialCode']=function(_0x47d986){const _0xf3068a=_0x262cbe;if(_0x47d986[_0xf3068a(0x13e)](/backspace/i))return this[_0xf3068a(0xa5)]===0x8;if(_0x47d986[_0xf3068a(0x13e)](/enter/i))return this[_0xf3068a(0xa5)]===0xd;if(_0x47d986[_0xf3068a(0x13e)](/escape/i))return this['_inputSpecialKeyCode']===0x1b;},Input['isNumpadPressed']=function(){const _0x2c25cd=_0x262cbe;return[0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39][_0x2c25cd(0x2f7)](this[_0x2c25cd(0xa5)]);},Input['isArrowPressed']=function(){const _0x15e1c8=_0x262cbe;return[0x25,0x26,0x27,0x28]['contains'](this[_0x15e1c8(0xa5)]);},Input[_0x262cbe(0x55a)]=function(){const _0x1b046d=_0x262cbe;if(navigator[_0x1b046d(0x820)]){const _0x1a4580=navigator[_0x1b046d(0x820)]();if(_0x1a4580)for(const _0x53720c of _0x1a4580){if(_0x53720c&&_0x53720c[_0x1b046d(0x48e)])return!![];}}return![];},Input[_0x262cbe(0x1bd)]=function(){const _0x1dc047=_0x262cbe;if(navigator[_0x1dc047(0x820)]){const _0x3703f3=navigator[_0x1dc047(0x820)]();if(_0x3703f3)for(const _0x45a246 of _0x3703f3){if(_0x45a246&&_0x45a246['connected']){if(this[_0x1dc047(0x617)](_0x45a246))return!![];if(this['isGamepadAxisMoved'](_0x45a246))return!![];}}}return![];},Input[_0x262cbe(0x617)]=function(_0x26a240){const _0x5f75f9=_0x262cbe,_0x1e8c7e=_0x26a240[_0x5f75f9(0x259)];for(let _0xabfcd4=0x0;_0xabfcd4<_0x1e8c7e[_0x5f75f9(0x3c3)];_0xabfcd4++){if(_0x1e8c7e[_0xabfcd4][_0x5f75f9(0x7ff)])return!![];}return![];},Input[_0x262cbe(0x823)]=function(_0x54bee6){const _0x17d422=_0x262cbe,_0x183a7e=_0x54bee6[_0x17d422(0x2eb)],_0x4aef27=0.5;if(_0x183a7e[0x0]<-_0x4aef27)return!![];if(_0x183a7e[0x0]>_0x4aef27)return!![];if(_0x183a7e[0x1]<-_0x4aef27)return!![];if(_0x183a7e[0x1]>_0x4aef27)return!![];return![];},Input[_0x262cbe(0x815)]=function(){const _0x5049e0=_0x262cbe;return this[_0x5049e0(0x1ee)]||null;},Input['setLastGamepadUsed']=function(_0x1fbf94){const _0x35a706=_0x262cbe;this[_0x35a706(0x1ee)]=_0x1fbf94;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x165)]=Input['_updateGamepadState'],Input['_updateGamepadState']=function(_0x3cc381){const _0x1df526=_0x262cbe;VisuMZ[_0x1df526(0x244)][_0x1df526(0x165)][_0x1df526(0x77c)](this,_0x3cc381),(this[_0x1df526(0x617)](_0x3cc381)||this[_0x1df526(0x823)](_0x3cc381))&&this[_0x1df526(0xdd)](_0x3cc381);},Input[_0x262cbe(0x81c)]=function(){const _0xc3953e=_0x262cbe;return this[_0xc3953e(0x1ee)]?this['_lastGamepad']['id']:_0xc3953e(0x1ce);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x292)]=Tilemap[_0x262cbe(0x800)]['_addShadow'],Tilemap[_0x262cbe(0x800)][_0x262cbe(0x775)]=function(_0xd02875,_0x1dab98,_0x34fd5c,_0x220b8f){const _0x831965=_0x262cbe;if($gameMap&&$gameMap['areTileShadowsHidden']())return;VisuMZ['CoreEngine'][_0x831965(0x292)][_0x831965(0x77c)](this,_0xd02875,_0x1dab98,_0x34fd5c,_0x220b8f);},Tilemap[_0x262cbe(0x53c)][_0x262cbe(0x800)][_0x262cbe(0x517)]=function(){const _0x204dab=_0x262cbe;this[_0x204dab(0x717)]();for(let _0x2ddc63=0x0;_0x2ddc63<Tilemap['Layer']['MAX_GL_TEXTURES'];_0x2ddc63++){const _0x3bcf0d=new PIXI['BaseTexture']();_0x3bcf0d[_0x204dab(0x7b7)](0x800,0x800),VisuMZ['CoreEngine']['Settings']['QoL'][_0x204dab(0x2e1)]&&(_0x3bcf0d[_0x204dab(0x788)]=PIXI[_0x204dab(0x151)]['NEAREST']),this[_0x204dab(0x47e)][_0x204dab(0x4ea)](_0x3bcf0d);}},WindowLayer['prototype']['isMaskingEnabled']=function(){const _0xc9483a=_0x262cbe;return SceneManager&&SceneManager['_scene']?SceneManager[_0xc9483a(0x207)]['isWindowMaskingEnabled']():!![];},VisuMZ['CoreEngine'][_0x262cbe(0x80d)]=WindowLayer['prototype'][_0x262cbe(0x3e4)],WindowLayer[_0x262cbe(0x800)][_0x262cbe(0x3e4)]=function render(_0x5ac3f0){const _0x180a9c=_0x262cbe;this['isMaskingEnabled']()?VisuMZ[_0x180a9c(0x244)][_0x180a9c(0x80d)]['call'](this,_0x5ac3f0):this[_0x180a9c(0x4cf)](_0x5ac3f0);},WindowLayer['prototype'][_0x262cbe(0x4cf)]=function render(_0x3954c1){const _0x21f974=_0x262cbe;if(!this['visible'])return;const _0x3e6e77=new PIXI['Graphics'](),_0x21d658=_0x3954c1['gl'],_0x2db0df=this[_0x21f974(0x753)][_0x21f974(0x30b)]();_0x3954c1[_0x21f974(0x2c2)][_0x21f974(0x3a8)](),_0x3e6e77['transform']=this[_0x21f974(0x4c8)],_0x3954c1[_0x21f974(0x4e4)][_0x21f974(0x414)](),_0x21d658[_0x21f974(0x4d5)](_0x21d658[_0x21f974(0x65f)]);while(_0x2db0df[_0x21f974(0x3c3)]>0x0){const _0x5545c2=_0x2db0df[_0x21f974(0x597)]();_0x5545c2[_0x21f974(0x856)]&&_0x5545c2[_0x21f974(0x209)]&&_0x5545c2['openness']>0x0&&(_0x21d658[_0x21f974(0x39b)](_0x21d658['EQUAL'],0x0,~0x0),_0x21d658[_0x21f974(0x6da)](_0x21d658['KEEP'],_0x21d658[_0x21f974(0x85c)],_0x21d658[_0x21f974(0x85c)]),_0x5545c2[_0x21f974(0x3e4)](_0x3954c1),_0x3954c1[_0x21f974(0x4e4)][_0x21f974(0x414)](),_0x3e6e77[_0x21f974(0x294)](),_0x21d658['stencilFunc'](_0x21d658[_0x21f974(0x130)],0x1,~0x0),_0x21d658[_0x21f974(0x6da)](_0x21d658[_0x21f974(0x3fd)],_0x21d658[_0x21f974(0x3fd)],_0x21d658[_0x21f974(0x3fd)]),_0x21d658[_0x21f974(0x2f4)](_0x21d658[_0x21f974(0x141)],_0x21d658[_0x21f974(0x738)]),_0x3e6e77['render'](_0x3954c1),_0x3954c1[_0x21f974(0x4e4)][_0x21f974(0x414)](),_0x21d658[_0x21f974(0x2f4)](_0x21d658['ONE'],_0x21d658['ONE_MINUS_SRC_ALPHA']));}_0x21d658['disable'](_0x21d658[_0x21f974(0x65f)]),_0x21d658['clear'](_0x21d658[_0x21f974(0xf5)]),_0x21d658['clearStencil'](0x0),_0x3954c1[_0x21f974(0x4e4)][_0x21f974(0x414)]();for(const _0x421b69 of this[_0x21f974(0x753)]){!_0x421b69[_0x21f974(0x856)]&&_0x421b69[_0x21f974(0x209)]&&_0x421b69['render'](_0x3954c1);}_0x3954c1[_0x21f974(0x4e4)][_0x21f974(0x414)]();},DataManager[_0x262cbe(0x30d)]=function(_0x1fa87a){const _0x213c08=_0x262cbe;return this['isItem'](_0x1fa87a)&&_0x1fa87a[_0x213c08(0x2fb)]===0x2;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x59a)]=DataManager['setupNewGame'],DataManager['setupNewGame']=function(){const _0x12e7bd=_0x262cbe;VisuMZ[_0x12e7bd(0x244)][_0x12e7bd(0x59a)]['call'](this),this['reservePlayTestNewGameCommonEvent'](),this[_0x12e7bd(0x46b)]();},DataManager['reservePlayTestNewGameCommonEvent']=function(){const _0x315e92=_0x262cbe;if($gameTemp[_0x315e92(0x5ee)]()){const _0x516239=VisuMZ[_0x315e92(0x244)][_0x315e92(0x84d)][_0x315e92(0x754)]['NewGameCommonEvent'];if(_0x516239>0x0)$gameTemp[_0x315e92(0x37b)](_0x516239);}},DataManager['reserveNewGameCommonEvent']=function(){const _0x1c67de=_0x262cbe,_0x3b0b9b=VisuMZ[_0x1c67de(0x244)][_0x1c67de(0x84d)][_0x1c67de(0x754)][_0x1c67de(0x2d7)]||0x0;if(_0x3b0b9b>0x0)$gameTemp[_0x1c67de(0x37b)](_0x3b0b9b);},DataManager['createTroopNote']=function(_0xed8232){const _0x3d7220=_0x262cbe,_0x44ec79=$dataTroops[_0xed8232];if(!_0x44ec79)return'';let _0x58d736='';_0x58d736+=_0x44ec79[_0x3d7220(0x84e)];for(const _0x45b52f of _0x44ec79['pages']){for(const _0x597bfd of _0x45b52f['list']){[0x6c,0x198][_0x3d7220(0x14c)](_0x597bfd[_0x3d7220(0xd8)])&&(_0x58d736+='\x0a',_0x58d736+=_0x597bfd[_0x3d7220(0x5d7)][0x0]);}}return _0x58d736;};(VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)]['QoL'][_0x262cbe(0x63a)]??!![])&&($scene=null,VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x228)]=Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x3de)],Scene_Base['prototype'][_0x262cbe(0x3de)]=function(){const _0x424ebf=_0x262cbe;VisuMZ[_0x424ebf(0x244)][_0x424ebf(0x228)]['call'](this),$scene=this;},$spriteset=null,VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x1e4)]=Scene_Map['prototype'][_0x262cbe(0x568)],Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x568)]=function(){const _0x51d43f=_0x262cbe;VisuMZ[_0x51d43f(0x244)]['Scene_Map_createSpriteset']['call'](this),$spriteset=this[_0x51d43f(0x2aa)];},VisuMZ[_0x262cbe(0x244)]['Scene_Battle_createSpriteset']=Scene_Battle[_0x262cbe(0x800)][_0x262cbe(0x568)],Scene_Battle[_0x262cbe(0x800)]['createSpriteset']=function(){const _0x167a83=_0x262cbe;VisuMZ['CoreEngine'][_0x167a83(0x83f)][_0x167a83(0x77c)](this),$spriteset=this[_0x167a83(0x2aa)];},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x8f)]=Scene_Base[_0x262cbe(0x800)]['terminate'],Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x1f1)]=function(){VisuMZ['CoreEngine']['Scene_Base_terminate']['call'](this),$spriteset=null,$subject=null,$targets=null,$target=null;},$subject=null,$targets=null,$target=null,VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x1d9)]=BattleManager[_0x262cbe(0x64e)],BattleManager[_0x262cbe(0x64e)]=function(_0x1dd44e){const _0x2b0be2=_0x262cbe;VisuMZ['CoreEngine'][_0x2b0be2(0x1d9)][_0x2b0be2(0x77c)](this,_0x1dd44e),$subject=this[_0x2b0be2(0x68c)],$targets=this['_targets'],$target=this[_0x2b0be2(0x646)]||this[_0x2b0be2(0x591)][0x0];},$event=null,VisuMZ[_0x262cbe(0x244)]['Game_Event_start']=Game_Event[_0x262cbe(0x800)][_0x262cbe(0x4eb)],Game_Event[_0x262cbe(0x800)][_0x262cbe(0x4eb)]=function(){const _0x52479e=_0x262cbe;VisuMZ['CoreEngine'][_0x52479e(0x3a2)][_0x52479e(0x77c)](this),$event=this;},VisuMZ['CoreEngine']['Scene_Map_update']=Scene_Map['prototype']['update'],Scene_Map['prototype']['update']=function(){const _0x13c3fd=_0x262cbe;VisuMZ[_0x13c3fd(0x244)][_0x13c3fd(0x447)][_0x13c3fd(0x77c)](this),$gameMap[_0x13c3fd(0x3ef)]();},Game_Map[_0x262cbe(0x800)][_0x262cbe(0x3ef)]=function(){const _0x574496=_0x262cbe;!this[_0x574496(0xb1)]()&&$event!==null&&($event=null);},$commonEvent=function(_0x2d7090){const _0x5de913=_0x262cbe;if($gameTemp)$gameTemp[_0x5de913(0x37b)](_0x2d7090);},$onceParallel=function(_0x56fd61,_0xa9116f){const _0x14af35=_0x262cbe;if(SceneManager[_0x14af35(0x62f)]())$scene[_0x14af35(0x589)](_0x56fd61,_0xa9116f);else{if(SceneManager[_0x14af35(0x310)]()){if(Imported[_0x14af35(0x325)])$scene[_0x14af35(0x589)](_0x56fd61);else $gameTemp&&$gameTemp[_0x14af35(0x5ee)]()&&alert('Once\x20Parallel\x20for\x20Battle\x20requires\x20VisuMZ_1_BattleCore!');}else $gameTemp&&$gameTemp[_0x14af35(0x5ee)]()&&alert(_0x14af35(0x5a5));}});;StorageManager[_0x262cbe(0x305)]=function(_0x32a677){return new Promise((_0x3aa51d,_0x4309b7)=>{const _0x196cf3=_0x3598;try{const _0x38b2c0=pako[_0x196cf3(0x3e8)](_0x32a677,{'to':_0x196cf3(0x156),'level':0x1});if(_0x38b2c0[_0x196cf3(0x3c3)]>=0xc350){}_0x3aa51d(_0x38b2c0);}catch(_0x428c57){_0x4309b7(_0x428c57);}});},TextManager[_0x262cbe(0x333)]=['','','',_0x262cbe(0x4ad),'','',_0x262cbe(0x6c4),'',_0x262cbe(0x390),_0x262cbe(0x6fc),'','',_0x262cbe(0x6cf),_0x262cbe(0x7a0),'ENTER_SPECIAL','',_0x262cbe(0x5bc),_0x262cbe(0x1eb),'ALT',_0x262cbe(0x327),_0x262cbe(0x17c),_0x262cbe(0x5ca),'EISU','JUNJA',_0x262cbe(0x68d),'HANJA','','ESC',_0x262cbe(0x457),'NONCONVERT',_0x262cbe(0x493),_0x262cbe(0x6f6),_0x262cbe(0x858),_0x262cbe(0x560),_0x262cbe(0x322),_0x262cbe(0xda),_0x262cbe(0x8e),_0x262cbe(0x7c0),'UP','RIGHT',_0x262cbe(0x2c5),'SELECT','PRINT',_0x262cbe(0x663),_0x262cbe(0x131),_0x262cbe(0x626),_0x262cbe(0x148),'','0','1','2','3','4','5','6','7','8','9',_0x262cbe(0x2cd),_0x262cbe(0x6a4),'LESS_THAN',_0x262cbe(0x24d),_0x262cbe(0x521),_0x262cbe(0xc1),'AT','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','OS_KEY','',_0x262cbe(0x128),'','SLEEP','NUMPAD0',_0x262cbe(0x3df),_0x262cbe(0x4d7),_0x262cbe(0x5f2),_0x262cbe(0x3b0),_0x262cbe(0x7b0),_0x262cbe(0x45b),_0x262cbe(0x467),_0x262cbe(0x50a),_0x262cbe(0x297),'MULTIPLY',_0x262cbe(0x734),_0x262cbe(0x3c4),'SUBTRACT',_0x262cbe(0x53b),'DIVIDE','F1','F2','F3','F4','F5','F6','F7','F8','F9',_0x262cbe(0x5dd),_0x262cbe(0x676),_0x262cbe(0x114),_0x262cbe(0x127),_0x262cbe(0x6c2),_0x262cbe(0x173),_0x262cbe(0x99),_0x262cbe(0x7ae),_0x262cbe(0x35a),_0x262cbe(0x692),_0x262cbe(0x4a6),_0x262cbe(0x598),_0x262cbe(0x2d4),'F23',_0x262cbe(0x712),'','','','','','','','',_0x262cbe(0x2b4),_0x262cbe(0x2b2),_0x262cbe(0x648),_0x262cbe(0x554),_0x262cbe(0x5f6),'WIN_OEM_FJ_LOYA','WIN_OEM_FJ_ROYA','','','','','','','','','','CIRCUMFLEX',_0x262cbe(0x34c),'DOUBLE_QUOTE',_0x262cbe(0x2c8),_0x262cbe(0x81),_0x262cbe(0x35e),_0x262cbe(0x737),_0x262cbe(0x10a),_0x262cbe(0x6c3),_0x262cbe(0x9b),_0x262cbe(0xaa),_0x262cbe(0x4b9),_0x262cbe(0x2bc),'HYPHEN_MINUS',_0x262cbe(0x381),_0x262cbe(0x33f),_0x262cbe(0x368),'','','','',_0x262cbe(0x837),_0x262cbe(0x7fa),_0x262cbe(0x3da),'','',_0x262cbe(0x6a4),_0x262cbe(0x24d),_0x262cbe(0x701),_0x262cbe(0x3a4),_0x262cbe(0x1da),'SLASH',_0x262cbe(0xee),'','','','','','','','','','','','','','','','','','','','','','','','','','',_0x262cbe(0x748),'BACK_SLASH',_0x262cbe(0x87),_0x262cbe(0x2f1),'',_0x262cbe(0x41a),_0x262cbe(0x188),'',_0x262cbe(0x40b),_0x262cbe(0x2db),'','WIN_ICO_CLEAR','','','WIN_OEM_RESET',_0x262cbe(0x46d),'WIN_OEM_PA1','WIN_OEM_PA2','WIN_OEM_PA3','WIN_OEM_WSCTRL',_0x262cbe(0x377),_0x262cbe(0x220),_0x262cbe(0x2df),'WIN_OEM_COPY',_0x262cbe(0x42b),_0x262cbe(0x12d),_0x262cbe(0x187),_0x262cbe(0x274),_0x262cbe(0x704),'EXSEL',_0x262cbe(0x680),_0x262cbe(0x335),'ZOOM','',_0x262cbe(0x6bd),_0x262cbe(0x757),''],TextManager[_0x262cbe(0x394)]=VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x153)][_0x262cbe(0x1a5)],TextManager[_0x262cbe(0x68a)]=VisuMZ['CoreEngine'][_0x262cbe(0x84d)][_0x262cbe(0x153)][_0x262cbe(0x6d9)],TextManager[_0x262cbe(0x52e)]=VisuMZ['CoreEngine'][_0x262cbe(0x84d)][_0x262cbe(0x153)]['SwitchActorText'],VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x1e3)]=TextManager[_0x262cbe(0x1a9)],TextManager[_0x262cbe(0x1a9)]=function(_0x4424b1){const _0x4a5b54=_0x262cbe;return typeof _0x4424b1==='number'?VisuMZ[_0x4a5b54(0x244)]['TextManager_param'][_0x4a5b54(0x77c)](this,_0x4424b1):this[_0x4a5b54(0x7ea)](_0x4424b1);},TextManager[_0x262cbe(0x7ea)]=function(_0x32d22b){const _0x48abeb=_0x262cbe;_0x32d22b=String(_0x32d22b||'')['toUpperCase']();const _0x2f9977=VisuMZ[_0x48abeb(0x244)][_0x48abeb(0x84d)][_0x48abeb(0x778)];if(_0x32d22b==='MAXHP')return $dataSystem[_0x48abeb(0x38f)][_0x48abeb(0x34f)][0x0];if(_0x32d22b===_0x48abeb(0x154))return $dataSystem[_0x48abeb(0x38f)][_0x48abeb(0x34f)][0x1];if(_0x32d22b===_0x48abeb(0x658))return $dataSystem[_0x48abeb(0x38f)][_0x48abeb(0x34f)][0x2];if(_0x32d22b===_0x48abeb(0x353))return $dataSystem[_0x48abeb(0x38f)]['params'][0x3];if(_0x32d22b===_0x48abeb(0xbd))return $dataSystem['terms'][_0x48abeb(0x34f)][0x4];if(_0x32d22b===_0x48abeb(0x1d1))return $dataSystem[_0x48abeb(0x38f)][_0x48abeb(0x34f)][0x5];if(_0x32d22b===_0x48abeb(0x3f1))return $dataSystem[_0x48abeb(0x38f)][_0x48abeb(0x34f)][0x6];if(_0x32d22b===_0x48abeb(0x162))return $dataSystem[_0x48abeb(0x38f)]['params'][0x7];if(_0x32d22b===_0x48abeb(0x7c6))return _0x2f9977[_0x48abeb(0x316)];if(_0x32d22b===_0x48abeb(0xc0))return _0x2f9977[_0x48abeb(0x486)];if(_0x32d22b===_0x48abeb(0x2c3))return _0x2f9977['XParamVocab2'];if(_0x32d22b==='CEV')return _0x2f9977[_0x48abeb(0x41c)];if(_0x32d22b===_0x48abeb(0x30c))return _0x2f9977[_0x48abeb(0xf2)];if(_0x32d22b===_0x48abeb(0x542))return _0x2f9977[_0x48abeb(0x6dc)];if(_0x32d22b==='CNT')return _0x2f9977[_0x48abeb(0x372)];if(_0x32d22b===_0x48abeb(0x657))return _0x2f9977[_0x48abeb(0x102)];if(_0x32d22b===_0x48abeb(0x4b8))return _0x2f9977['XParamVocab8'];if(_0x32d22b==='TRG')return _0x2f9977[_0x48abeb(0x4ae)];if(_0x32d22b===_0x48abeb(0x182))return _0x2f9977[_0x48abeb(0xf9)];if(_0x32d22b===_0x48abeb(0x370))return _0x2f9977[_0x48abeb(0x3dc)];if(_0x32d22b===_0x48abeb(0x424))return _0x2f9977[_0x48abeb(0x4bb)];if(_0x32d22b===_0x48abeb(0x7c))return _0x2f9977[_0x48abeb(0x679)];if(_0x32d22b===_0x48abeb(0x2ef))return _0x2f9977[_0x48abeb(0x190)];if(_0x32d22b==='TCR')return _0x2f9977[_0x48abeb(0x385)];if(_0x32d22b==='PDR')return _0x2f9977[_0x48abeb(0x61a)];if(_0x32d22b===_0x48abeb(0x755))return _0x2f9977[_0x48abeb(0x77d)];if(_0x32d22b===_0x48abeb(0x3c7))return _0x2f9977[_0x48abeb(0x2ae)];if(_0x32d22b==='EXR')return _0x2f9977[_0x48abeb(0x555)];if(VisuMZ[_0x48abeb(0x244)][_0x48abeb(0x7dd)][_0x32d22b])return VisuMZ[_0x48abeb(0x244)][_0x48abeb(0x7dd)][_0x32d22b];return'';},TextManager[_0x262cbe(0x11f)]=function(_0x205139){const _0x49563f=_0x262cbe,_0x16ba44=Input[_0x49563f(0x81c)]();return _0x16ba44===_0x49563f(0x1ce)?this[_0x49563f(0x6f0)](_0x205139):this[_0x49563f(0x2f0)](_0x16ba44,_0x205139);},TextManager['getKeyboardInputButtonString']=function(_0xdef302){const _0x3daec7=_0x262cbe,_0x564cd1=VisuMZ[_0x3daec7(0x244)]['Settings'][_0x3daec7(0x153)][_0x3daec7(0x367)];if(!_0x564cd1){if(_0xdef302===_0x3daec7(0x166))_0xdef302=_0x3daec7(0x7ad);if(_0xdef302===_0x3daec7(0x2e4))_0xdef302=_0x3daec7(0x7ad);}let _0x59f665=[];for(let _0x46aa42 in Input['keyMapper']){_0x46aa42=Number(_0x46aa42);if(_0x46aa42>=0x60&&_0x46aa42<=0x69)continue;if([0x12,0x20][_0x3daec7(0x14c)](_0x46aa42))continue;_0xdef302===Input[_0x3daec7(0x49a)][_0x46aa42]&&_0x59f665[_0x3daec7(0x4ea)](_0x46aa42);}for(let _0x48b040=0x0;_0x48b040<_0x59f665[_0x3daec7(0x3c3)];_0x48b040++){_0x59f665[_0x48b040]=TextManager['stringKeyMap'][_0x59f665[_0x48b040]];}return this[_0x3daec7(0x3a5)](_0x59f665);},TextManager[_0x262cbe(0x3a5)]=function(_0x359fa3){const _0x394f88=_0x262cbe,_0x360022=VisuMZ[_0x394f88(0x244)]['Settings']['ButtonAssist'],_0x36fad2=_0x360022[_0x394f88(0x47c)],_0x2f8422=_0x359fa3[_0x394f88(0x35b)](),_0x225ca4=_0x394f88(0x639)[_0x394f88(0x94)](_0x2f8422);return _0x360022[_0x225ca4]?_0x360022[_0x225ca4]:_0x36fad2[_0x394f88(0x94)](_0x2f8422);},TextManager[_0x262cbe(0x579)]=function(_0x3a85ee,_0x1a23ac){const _0x203183=_0x262cbe,_0x4d7119=VisuMZ[_0x203183(0x244)][_0x203183(0x84d)][_0x203183(0x153)],_0x4fdc13=_0x4d7119[_0x203183(0x4cc)],_0x5870e6=this[_0x203183(0x11f)](_0x3a85ee),_0x15b2a8=this[_0x203183(0x11f)](_0x1a23ac);return _0x4fdc13[_0x203183(0x94)](_0x5870e6,_0x15b2a8);},TextManager[_0x262cbe(0x2f0)]=function(_0x45096d,_0x4ac51a){const _0x503acd=_0x262cbe,_0x1ad943=_0x45096d['toLowerCase']()[_0x503acd(0x4a7)](),_0x495d28=VisuMZ[_0x503acd(0x244)][_0x503acd(0x7d5)][_0x1ad943];if(!_0x495d28)return this[_0x503acd(0x1b9)](_0x45096d,_0x4ac51a);return _0x495d28[_0x4ac51a]||this['getKeyboardInputButtonString'](_0x45096d,_0x4ac51a);},TextManager[_0x262cbe(0x1b9)]=function(_0x4084a2,_0xec7950){const _0x31f789=_0x262cbe,_0x999259=_0x4084a2[_0x31f789(0x218)]()[_0x31f789(0x4a7)]();for(const _0xd92201 in VisuMZ[_0x31f789(0x244)][_0x31f789(0x629)]){if(_0x999259[_0x31f789(0x14c)](_0xd92201)){const _0x1623e5=VisuMZ['CoreEngine']['ControllerMatches'][_0xd92201],_0x41909a=VisuMZ[_0x31f789(0x244)][_0x31f789(0x7d5)][_0x1623e5];return _0x41909a[_0xec7950]||this[_0x31f789(0x6f0)](_0xec7950);}}return this[_0x31f789(0x6f0)](_0xec7950);},VisuMZ['CoreEngine']['ColorManager_loadWindowskin']=ColorManager[_0x262cbe(0x442)],ColorManager[_0x262cbe(0x442)]=function(){const _0x3c9ccc=_0x262cbe;VisuMZ['CoreEngine'][_0x3c9ccc(0x2ec)]['call'](this),this[_0x3c9ccc(0x5b6)]=this[_0x3c9ccc(0x5b6)]||{};},ColorManager[_0x262cbe(0x736)]=function(_0x59d540,_0x355ea6){const _0x5c8b87=_0x262cbe;return _0x355ea6=String(_0x355ea6),this['_colorCache']=this['_colorCache']||{},_0x355ea6[_0x5c8b87(0x13e)](/#(.*)/i)?this[_0x5c8b87(0x5b6)][_0x59d540]=_0x5c8b87(0x731)[_0x5c8b87(0x94)](String(RegExp['$1'])):this[_0x5c8b87(0x5b6)][_0x59d540]=this[_0x5c8b87(0x6fe)](Number(_0x355ea6)),this[_0x5c8b87(0x5b6)][_0x59d540];},ColorManager[_0x262cbe(0x5be)]=function(_0x55fd5d){const _0x1d4b74=_0x262cbe;return _0x55fd5d=String(_0x55fd5d),_0x55fd5d[_0x1d4b74(0x13e)](/#(.*)/i)?_0x1d4b74(0x731)[_0x1d4b74(0x94)](String(RegExp['$1'])):this[_0x1d4b74(0x6fe)](Number(_0x55fd5d));},ColorManager[_0x262cbe(0x34b)]=function(){this['_colorCache']={};},ColorManager[_0x262cbe(0x690)]=function(){const _0x38f721=_0x262cbe,_0x4d9e63='_stored_normalColor';this['_colorCache']=this[_0x38f721(0x5b6)]||{};if(this['_colorCache'][_0x4d9e63])return this[_0x38f721(0x5b6)][_0x4d9e63];const _0x1f63bb=VisuMZ[_0x38f721(0x244)][_0x38f721(0x84d)][_0x38f721(0x37a)]['ColorNormal'];return this[_0x38f721(0x736)](_0x4d9e63,_0x1f63bb);},ColorManager[_0x262cbe(0x1f6)]=function(){const _0x192648=_0x262cbe,_0x204aaa='_stored_systemColor';this[_0x192648(0x5b6)]=this['_colorCache']||{};if(this['_colorCache'][_0x204aaa])return this[_0x192648(0x5b6)][_0x204aaa];const _0x5d2bf0=VisuMZ['CoreEngine'][_0x192648(0x84d)][_0x192648(0x37a)]['ColorSystem'];return this[_0x192648(0x736)](_0x204aaa,_0x5d2bf0);},ColorManager[_0x262cbe(0x818)]=function(){const _0x2098c1=_0x262cbe,_0x3960c9=_0x2098c1(0x653);this[_0x2098c1(0x5b6)]=this[_0x2098c1(0x5b6)]||{};if(this['_colorCache'][_0x3960c9])return this['_colorCache'][_0x3960c9];const _0x440b15=VisuMZ[_0x2098c1(0x244)][_0x2098c1(0x84d)]['Color'][_0x2098c1(0x1a8)];return this[_0x2098c1(0x736)](_0x3960c9,_0x440b15);},ColorManager[_0x262cbe(0x1a6)]=function(){const _0xd107f9=_0x262cbe,_0x445e2f='_stored_deathColor';this['_colorCache']=this['_colorCache']||{};if(this['_colorCache'][_0x445e2f])return this[_0xd107f9(0x5b6)][_0x445e2f];const _0x568f0b=VisuMZ[_0xd107f9(0x244)][_0xd107f9(0x84d)][_0xd107f9(0x37a)][_0xd107f9(0x5dc)];return this[_0xd107f9(0x736)](_0x445e2f,_0x568f0b);},ColorManager[_0x262cbe(0x17e)]=function(){const _0x4521d2=_0x262cbe,_0x3fbf2b=_0x4521d2(0x45f);this['_colorCache']=this[_0x4521d2(0x5b6)]||{};if(this[_0x4521d2(0x5b6)][_0x3fbf2b])return this['_colorCache'][_0x3fbf2b];const _0x5aa1c5=VisuMZ['CoreEngine'][_0x4521d2(0x84d)][_0x4521d2(0x37a)][_0x4521d2(0x6f8)];return this[_0x4521d2(0x736)](_0x3fbf2b,_0x5aa1c5);},ColorManager[_0x262cbe(0x848)]=function(){const _0x16a3a9=_0x262cbe,_0x50f1f3=_0x16a3a9(0x233);this[_0x16a3a9(0x5b6)]=this[_0x16a3a9(0x5b6)]||{};if(this['_colorCache'][_0x50f1f3])return this[_0x16a3a9(0x5b6)][_0x50f1f3];const _0x13aec3=VisuMZ[_0x16a3a9(0x244)][_0x16a3a9(0x84d)][_0x16a3a9(0x37a)][_0x16a3a9(0x3f3)];return this[_0x16a3a9(0x736)](_0x50f1f3,_0x13aec3);},ColorManager[_0x262cbe(0x5bd)]=function(){const _0x4d6b20=_0x262cbe,_0x2eb2b2=_0x4d6b20(0x456);this[_0x4d6b20(0x5b6)]=this[_0x4d6b20(0x5b6)]||{};if(this['_colorCache'][_0x2eb2b2])return this[_0x4d6b20(0x5b6)][_0x2eb2b2];const _0x5ea3ab=VisuMZ['CoreEngine'][_0x4d6b20(0x84d)][_0x4d6b20(0x37a)][_0x4d6b20(0x425)];return this[_0x4d6b20(0x736)](_0x2eb2b2,_0x5ea3ab);},ColorManager[_0x262cbe(0x769)]=function(){const _0x307574=_0x262cbe,_0x46fc63=_0x307574(0x725);this[_0x307574(0x5b6)]=this[_0x307574(0x5b6)]||{};if(this['_colorCache'][_0x46fc63])return this[_0x307574(0x5b6)][_0x46fc63];const _0xdbf5b9=VisuMZ[_0x307574(0x244)][_0x307574(0x84d)][_0x307574(0x37a)][_0x307574(0x14e)];return this['getColorDataFromPluginParameters'](_0x46fc63,_0xdbf5b9);},ColorManager[_0x262cbe(0x821)]=function(){const _0x4d7b6b=_0x262cbe,_0x1b1e87='_stored_mpGaugeColor2';this[_0x4d7b6b(0x5b6)]=this[_0x4d7b6b(0x5b6)]||{};if(this[_0x4d7b6b(0x5b6)][_0x1b1e87])return this[_0x4d7b6b(0x5b6)][_0x1b1e87];const _0x5c2d7a=VisuMZ[_0x4d7b6b(0x244)]['Settings'][_0x4d7b6b(0x37a)][_0x4d7b6b(0x5d5)];return this[_0x4d7b6b(0x736)](_0x1b1e87,_0x5c2d7a);},ColorManager[_0x262cbe(0x1e9)]=function(){const _0x46d901=_0x262cbe,_0x44ad1c=_0x46d901(0x42c);this['_colorCache']=this[_0x46d901(0x5b6)]||{};if(this[_0x46d901(0x5b6)][_0x44ad1c])return this['_colorCache'][_0x44ad1c];const _0x3bbe3f=VisuMZ[_0x46d901(0x244)][_0x46d901(0x84d)][_0x46d901(0x37a)][_0x46d901(0x543)];return this[_0x46d901(0x736)](_0x44ad1c,_0x3bbe3f);},ColorManager[_0x262cbe(0x68b)]=function(){const _0x501acd=_0x262cbe,_0x1b9112=_0x501acd(0x644);this[_0x501acd(0x5b6)]=this[_0x501acd(0x5b6)]||{};if(this['_colorCache'][_0x1b9112])return this['_colorCache'][_0x1b9112];const _0x3c6001=VisuMZ['CoreEngine']['Settings'][_0x501acd(0x37a)][_0x501acd(0x1ca)];return this[_0x501acd(0x736)](_0x1b9112,_0x3c6001);},ColorManager[_0x262cbe(0x739)]=function(){const _0x5b3b74=_0x262cbe,_0x2a3bb9=_0x5b3b74(0x4aa);this['_colorCache']=this['_colorCache']||{};if(this[_0x5b3b74(0x5b6)][_0x2a3bb9])return this[_0x5b3b74(0x5b6)][_0x2a3bb9];const _0x2d917e=VisuMZ[_0x5b3b74(0x244)][_0x5b3b74(0x84d)][_0x5b3b74(0x37a)][_0x5b3b74(0x1a1)];return this['getColorDataFromPluginParameters'](_0x2a3bb9,_0x2d917e);},ColorManager[_0x262cbe(0x221)]=function(){const _0x45edbc=_0x262cbe,_0x1c14bb=_0x45edbc(0x1b0);this[_0x45edbc(0x5b6)]=this[_0x45edbc(0x5b6)]||{};if(this[_0x45edbc(0x5b6)][_0x1c14bb])return this[_0x45edbc(0x5b6)][_0x1c14bb];const _0x539b20=VisuMZ[_0x45edbc(0x244)][_0x45edbc(0x84d)][_0x45edbc(0x37a)]['ColorCTGauge1'];return this[_0x45edbc(0x736)](_0x1c14bb,_0x539b20);},ColorManager[_0x262cbe(0x111)]=function(){const _0x1a1e3c=_0x262cbe,_0x41da87=_0x1a1e3c(0x3e6);this[_0x1a1e3c(0x5b6)]=this[_0x1a1e3c(0x5b6)]||{};if(this[_0x1a1e3c(0x5b6)][_0x41da87])return this[_0x1a1e3c(0x5b6)][_0x41da87];const _0x214d79=VisuMZ['CoreEngine'][_0x1a1e3c(0x84d)][_0x1a1e3c(0x37a)][_0x1a1e3c(0x3f0)];return this['getColorDataFromPluginParameters'](_0x41da87,_0x214d79);},ColorManager[_0x262cbe(0x666)]=function(){const _0x5caa22=_0x262cbe,_0x364138=_0x5caa22(0x23f);this[_0x5caa22(0x5b6)]=this[_0x5caa22(0x5b6)]||{};if(this[_0x5caa22(0x5b6)][_0x364138])return this[_0x5caa22(0x5b6)][_0x364138];const _0x27c149=VisuMZ[_0x5caa22(0x244)]['Settings']['Color'][_0x5caa22(0x216)];return this[_0x5caa22(0x736)](_0x364138,_0x27c149);},ColorManager[_0x262cbe(0x5e8)]=function(){const _0x4f56f4=_0x262cbe,_0x98bba6=_0x4f56f4(0x64b);this[_0x4f56f4(0x5b6)]=this[_0x4f56f4(0x5b6)]||{};if(this[_0x4f56f4(0x5b6)][_0x98bba6])return this[_0x4f56f4(0x5b6)][_0x98bba6];const _0x446a22=VisuMZ[_0x4f56f4(0x244)][_0x4f56f4(0x84d)]['Color']['ColorTPGauge2'];return this[_0x4f56f4(0x736)](_0x98bba6,_0x446a22);},ColorManager[_0x262cbe(0x4fe)]=function(){const _0x36718a=_0x262cbe,_0x531974=_0x36718a(0x819);this[_0x36718a(0x5b6)]=this['_colorCache']||{};if(this[_0x36718a(0x5b6)][_0x531974])return this[_0x36718a(0x5b6)][_0x531974];const _0x528420=VisuMZ[_0x36718a(0x244)]['Settings'][_0x36718a(0x37a)][_0x36718a(0x7d2)];return this[_0x36718a(0x736)](_0x531974,_0x528420);},ColorManager[_0x262cbe(0x16a)]=function(){const _0x422bcf=_0x262cbe,_0x2973c6=_0x422bcf(0x75e);this['_colorCache']=this[_0x422bcf(0x5b6)]||{};if(this[_0x422bcf(0x5b6)][_0x2973c6])return this['_colorCache'][_0x2973c6];const _0x3e1642=VisuMZ[_0x422bcf(0x244)][_0x422bcf(0x84d)]['Color'][_0x422bcf(0x7d2)];return this[_0x422bcf(0x736)](_0x2973c6,_0x3e1642);},ColorManager['expGaugeColor1']=function(){const _0x309218=_0x262cbe,_0x5ad486=_0x309218(0x179);this[_0x309218(0x5b6)]=this[_0x309218(0x5b6)]||{};if(this[_0x309218(0x5b6)][_0x5ad486])return this[_0x309218(0x5b6)][_0x5ad486];const _0x310641=VisuMZ['CoreEngine'][_0x309218(0x84d)][_0x309218(0x37a)][_0x309218(0x7b1)];return this[_0x309218(0x736)](_0x5ad486,_0x310641);},ColorManager[_0x262cbe(0x6f3)]=function(){const _0x5f4af5=_0x262cbe,_0x43bac5='_stored_expGaugeColor2';this[_0x5f4af5(0x5b6)]=this[_0x5f4af5(0x5b6)]||{};if(this['_colorCache'][_0x43bac5])return this[_0x5f4af5(0x5b6)][_0x43bac5];const _0x4a14b8=VisuMZ[_0x5f4af5(0x244)][_0x5f4af5(0x84d)][_0x5f4af5(0x37a)][_0x5f4af5(0x812)];return this[_0x5f4af5(0x736)](_0x43bac5,_0x4a14b8);},ColorManager[_0x262cbe(0x65b)]=function(){const _0x37eb39=_0x262cbe,_0x54f911=_0x37eb39(0x8d);this[_0x37eb39(0x5b6)]=this[_0x37eb39(0x5b6)]||{};if(this['_colorCache'][_0x54f911])return this[_0x37eb39(0x5b6)][_0x54f911];const _0x229759=VisuMZ[_0x37eb39(0x244)][_0x37eb39(0x84d)]['Color']['ColorMaxLvGauge1'];return this[_0x37eb39(0x736)](_0x54f911,_0x229759);},ColorManager['maxLvGaugeColor2']=function(){const _0x30d070=_0x262cbe,_0xb79613=_0x30d070(0x3c9);this[_0x30d070(0x5b6)]=this[_0x30d070(0x5b6)]||{};if(this[_0x30d070(0x5b6)][_0xb79613])return this[_0x30d070(0x5b6)][_0xb79613];const _0xbf29e7=VisuMZ[_0x30d070(0x244)][_0x30d070(0x84d)][_0x30d070(0x37a)]['ColorMaxLvGauge2'];return this[_0x30d070(0x736)](_0xb79613,_0xbf29e7);},ColorManager['hpColor']=function(_0x2683a2){const _0x11c6ac=_0x262cbe;return VisuMZ[_0x11c6ac(0x244)][_0x11c6ac(0x84d)][_0x11c6ac(0x37a)][_0x11c6ac(0x88)][_0x11c6ac(0x77c)](this,_0x2683a2);},ColorManager[_0x262cbe(0x253)]=function(_0x409d91){const _0x59c63a=_0x262cbe;return VisuMZ[_0x59c63a(0x244)][_0x59c63a(0x84d)][_0x59c63a(0x37a)]['ActorMPColor'][_0x59c63a(0x77c)](this,_0x409d91);},ColorManager[_0x262cbe(0x133)]=function(_0x129e74){const _0x3c7742=_0x262cbe;return VisuMZ[_0x3c7742(0x244)][_0x3c7742(0x84d)][_0x3c7742(0x37a)][_0x3c7742(0x6db)]['call'](this,_0x129e74);},ColorManager[_0x262cbe(0x671)]=function(_0x2fce4a){const _0x1d0f5d=_0x262cbe;return VisuMZ[_0x1d0f5d(0x244)]['Settings'][_0x1d0f5d(0x37a)][_0x1d0f5d(0x417)][_0x1d0f5d(0x77c)](this,_0x2fce4a);},ColorManager[_0x262cbe(0x392)]=function(_0x4e2e82){const _0x298c4e=_0x262cbe;return VisuMZ[_0x298c4e(0x244)]['Settings'][_0x298c4e(0x37a)][_0x298c4e(0x480)]['call'](this,_0x4e2e82);},ColorManager[_0x262cbe(0x235)]=function(){const _0x329175=_0x262cbe;return VisuMZ[_0x329175(0x244)][_0x329175(0x84d)][_0x329175(0x37a)][_0x329175(0x7d1)];},ColorManager[_0x262cbe(0x58d)]=function(){const _0x19c832=_0x262cbe;return VisuMZ[_0x19c832(0x244)][_0x19c832(0x84d)][_0x19c832(0x37a)][_0x19c832(0x593)]||_0x19c832(0x48b);},ColorManager[_0x262cbe(0x79e)]=function(){const _0x525751=_0x262cbe;return VisuMZ[_0x525751(0x244)]['Settings'][_0x525751(0x37a)]['OutlineColorGauge']||_0x525751(0x7af);},ColorManager['dimColor1']=function(){const _0x714e03=_0x262cbe;return VisuMZ['CoreEngine'][_0x714e03(0x84d)][_0x714e03(0x37a)][_0x714e03(0x7ca)];},ColorManager['dimColor2']=function(){const _0x37dd4c=_0x262cbe;return VisuMZ[_0x37dd4c(0x244)][_0x37dd4c(0x84d)][_0x37dd4c(0x37a)][_0x37dd4c(0x6fa)];},ColorManager['itemBackColor1']=function(){const _0x569d94=_0x262cbe;return VisuMZ[_0x569d94(0x244)]['Settings']['Color'][_0x569d94(0x730)];},ColorManager['itemBackColor2']=function(){const _0xfc91b3=_0x262cbe;return VisuMZ[_0xfc91b3(0x244)][_0xfc91b3(0x84d)]['Color'][_0xfc91b3(0x391)];},SceneManager[_0x262cbe(0xf0)]=[],SceneManager[_0x262cbe(0x310)]=function(){const _0x3b24c6=_0x262cbe;return this[_0x3b24c6(0x207)]&&this[_0x3b24c6(0x207)][_0x3b24c6(0x1ea)]===Scene_Battle;},SceneManager[_0x262cbe(0x62f)]=function(){const _0x162bd6=_0x262cbe;return this[_0x162bd6(0x207)]&&this[_0x162bd6(0x207)]['constructor']===Scene_Map;},SceneManager['isInstanceOfSceneMap']=function(){const _0x3fc2dd=_0x262cbe;return this[_0x3fc2dd(0x207)]&&this[_0x3fc2dd(0x207)]instanceof Scene_Map;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x1e8)]=SceneManager[_0x262cbe(0x1ad)],SceneManager[_0x262cbe(0x1ad)]=function(){const _0x5f0272=_0x262cbe;VisuMZ['CoreEngine'][_0x5f0272(0x1e8)][_0x5f0272(0x77c)](this),this[_0x5f0272(0x3f5)]();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x4f3)]=SceneManager['onKeyDown'],SceneManager['onKeyDown']=function(_0x52ea2f){const _0x1897d8=_0x262cbe;if($gameTemp)this[_0x1897d8(0x624)](_0x52ea2f);VisuMZ[_0x1897d8(0x244)][_0x1897d8(0x4f3)][_0x1897d8(0x77c)](this,_0x52ea2f);},SceneManager['onKeyDownKeysF6F7']=function(_0x325804){const _0x429c70=_0x262cbe;if(!_0x325804['ctrlKey']&&!_0x325804[_0x429c70(0x7fc)])switch(_0x325804[_0x429c70(0x78f)]){case 0x52:this[_0x429c70(0x789)]();break;case 0x54:this[_0x429c70(0x247)]();break;case 0x75:this[_0x429c70(0x7a)]();break;case 0x76:if(Input[_0x429c70(0xb7)](_0x429c70(0x597))||Input[_0x429c70(0xb7)](_0x429c70(0x82d)))return;this[_0x429c70(0x522)]();break;}else{if(_0x325804[_0x429c70(0x12b)]){let _0x5de20c=_0x325804[_0x429c70(0x78f)];if(_0x5de20c>=0x31&&_0x5de20c<=0x39){const _0x285bb5=_0x5de20c-0x30;return SceneManager[_0x429c70(0x78e)](_0x285bb5);}else{if(_0x5de20c>=0x61&&_0x5de20c<=0x69){const _0x1bfb68=_0x5de20c-0x60;return SceneManager['playtestQuickLoad'](_0x1bfb68);}}}}},SceneManager[_0x262cbe(0x7a)]=function(){const _0x573347=_0x262cbe;if($gameTemp[_0x573347(0x5ee)]()&&VisuMZ[_0x573347(0x244)][_0x573347(0x84d)][_0x573347(0x754)][_0x573347(0x631)]){ConfigManager[_0x573347(0x6fb)]!==0x0?(ConfigManager[_0x573347(0x97)]=0x0,ConfigManager[_0x573347(0x63c)]=0x0,ConfigManager[_0x573347(0x4c5)]=0x0,ConfigManager[_0x573347(0x6fb)]=0x0):(ConfigManager[_0x573347(0x97)]=0x64,ConfigManager[_0x573347(0x63c)]=0x64,ConfigManager[_0x573347(0x4c5)]=0x64,ConfigManager['seVolume']=0x64);ConfigManager[_0x573347(0x637)]();if(this[_0x573347(0x207)][_0x573347(0x1ea)]===Scene_Options){if(this[_0x573347(0x207)][_0x573347(0x7a4)])this[_0x573347(0x207)][_0x573347(0x7a4)]['refresh']();if(this[_0x573347(0x207)][_0x573347(0x50c)])this[_0x573347(0x207)]['_listWindow'][_0x573347(0x14a)]();}}},SceneManager['playTestF7']=function(){const _0x572cf8=_0x262cbe;$gameTemp[_0x572cf8(0x5ee)]()&&VisuMZ[_0x572cf8(0x244)]['Settings']['QoL'][_0x572cf8(0x7e9)]&&($gameTemp[_0x572cf8(0x374)]=!$gameTemp['_playTestFastMode']);},SceneManager['playTestShiftR']=function(){const _0x489a0d=_0x262cbe;if(!VisuMZ[_0x489a0d(0x244)][_0x489a0d(0x84d)][_0x489a0d(0x754)]['ShiftR_Toggle'])return;if(!$gameTemp[_0x489a0d(0x5ee)]())return;if(!SceneManager[_0x489a0d(0x310)]())return;if(!Input['isPressed'](_0x489a0d(0x597)))return;for(const _0x3c5710 of $gameParty[_0x489a0d(0x23e)]()){if(!_0x3c5710)continue;_0x3c5710[_0x489a0d(0x258)]();}},SceneManager[_0x262cbe(0x247)]=function(){const _0x580e9=_0x262cbe;if(!VisuMZ[_0x580e9(0x244)][_0x580e9(0x84d)][_0x580e9(0x754)]['ShiftT_Toggle'])return;if(!$gameTemp[_0x580e9(0x5ee)]())return;if(!SceneManager[_0x580e9(0x310)]())return;if(!Input[_0x580e9(0xb7)]('shift'))return;for(const _0xad3116 of $gameParty[_0x580e9(0x23e)]()){if(!_0xad3116)continue;_0xad3116['gainSilentTp'](_0xad3116[_0x580e9(0x3ca)]());}},SceneManager[_0x262cbe(0x78e)]=function(_0x30ddaa){const _0x240a0d=_0x262cbe;if(!$gameTemp[_0x240a0d(0x5ee)]())return;if(!DataManager['savefileInfo'](_0x30ddaa))return;if(!(VisuMZ[_0x240a0d(0x244)][_0x240a0d(0x84d)][_0x240a0d(0x754)][_0x240a0d(0x443)]??!![]))return;this[_0x240a0d(0x4ea)](Scene_QuickLoad),this[_0x240a0d(0x1b1)](_0x30ddaa);},SceneManager[_0x262cbe(0x3f5)]=function(){const _0x5512d5=_0x262cbe;this[_0x5512d5(0x745)]=![],this[_0x5512d5(0x473)]=!VisuMZ['CoreEngine'][_0x5512d5(0x84d)]['UI']['ShowButtons'];},SceneManager[_0x262cbe(0x26c)]=function(_0x29ade2){const _0x554b3f=_0x262cbe;VisuMZ[_0x554b3f(0x244)]['Settings']['UI'][_0x554b3f(0x301)]&&(this[_0x554b3f(0x745)]=_0x29ade2);},SceneManager['isSideButtonLayout']=function(){const _0x45a5d8=_0x262cbe;return this[_0x45a5d8(0x745)];},SceneManager[_0x262cbe(0x3d3)]=function(){return this['_hideButtons'];},SceneManager[_0x262cbe(0x2a7)]=function(){const _0x16d3da=_0x262cbe;return this[_0x16d3da(0x3d3)]()||this[_0x16d3da(0x7be)]();},VisuMZ['CoreEngine'][_0x262cbe(0x6b7)]=SceneManager[_0x262cbe(0x239)],SceneManager[_0x262cbe(0x239)]=function(){const _0x9fdd1b=_0x262cbe;return VisuMZ['CoreEngine']['Settings']['QoL'][_0x9fdd1b(0x150)]?VisuMZ['CoreEngine'][_0x9fdd1b(0x6b7)]['call'](this):!![];},SceneManager[_0x262cbe(0x84c)]=function(_0x352ea3){const _0x36703e=_0x262cbe;if(_0x352ea3 instanceof Error)this[_0x36703e(0x15c)](_0x352ea3);else _0x352ea3 instanceof Array&&_0x352ea3[0x0]==='LoadError'?this[_0x36703e(0x513)](_0x352ea3):this['catchUnknownError'](_0x352ea3);this[_0x36703e(0x62c)]();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x505)]=BattleManager[_0x262cbe(0x857)],BattleManager[_0x262cbe(0x857)]=function(){const _0x1101ba=_0x262cbe;return VisuMZ[_0x1101ba(0x244)]['Settings']['QoL']['EscapeAlways']?this['processAlwaysEscape']():VisuMZ[_0x1101ba(0x244)][_0x1101ba(0x505)][_0x1101ba(0x77c)](this);},BattleManager[_0x262cbe(0x7bb)]=function(){const _0x3d1364=_0x262cbe;return $gameParty[_0x3d1364(0x854)](),SoundManager['playEscape'](),this[_0x3d1364(0x192)](),!![];},BattleManager[_0x262cbe(0x567)]=function(){const _0x538010=_0x262cbe;return $gameSystem[_0x538010(0x35f)]()>=0x1;},BattleManager[_0x262cbe(0x5cc)]=function(){return $gameSystem['getBattleSystem']()===0x1;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x12c)]=Game_Temp[_0x262cbe(0x800)]['initialize'],Game_Temp[_0x262cbe(0x800)][_0x262cbe(0x1ad)]=function(){const _0x9554c5=_0x262cbe;VisuMZ[_0x9554c5(0x244)]['Game_Temp_initialize']['call'](this),this[_0x9554c5(0x337)](),this[_0x9554c5(0x373)](),this[_0x9554c5(0x44b)]();},Game_Temp[_0x262cbe(0x800)][_0x262cbe(0x337)]=function(){const _0x4df741=_0x262cbe;VisuMZ[_0x4df741(0x244)][_0x4df741(0x84d)][_0x4df741(0x754)][_0x4df741(0x578)]&&(this[_0x4df741(0x7e6)]=![]);},Game_Temp['prototype'][_0x262cbe(0xd6)]=function(_0x116c63){const _0x290e56=_0x262cbe;this[_0x290e56(0xed)]=_0x116c63;},Game_Temp[_0x262cbe(0x800)][_0x262cbe(0x482)]=function(){const _0x4ae599=_0x262cbe;return this[_0x4ae599(0xed)];},Game_Temp[_0x262cbe(0x800)][_0x262cbe(0x814)]=function(){const _0xf0654e=_0x262cbe;this['_forcedTroopView']=undefined,this[_0xf0654e(0x4c0)]=undefined,this['_forcedBattleGridSystem']=undefined;},Game_Temp[_0x262cbe(0x800)][_0x262cbe(0x208)]=function(_0x58f26){const _0x13f932=_0x262cbe;$gameMap&&$dataMap&&$dataMap[_0x13f932(0x215)]&&this['parseForcedGameTroopSettingsCoreEngine']($dataMap[_0x13f932(0x215)]);const _0x2cc851=$dataTroops[_0x58f26];if(_0x2cc851){let _0x186a05=DataManager['createTroopNote'](_0x2cc851['id']);this[_0x13f932(0x1e2)](_0x186a05);}},Game_Temp['prototype'][_0x262cbe(0x1e2)]=function(_0x311178){const _0x114194=_0x262cbe;if(!_0x311178)return;if(_0x311178[_0x114194(0x13e)](/<(?:FRONTVIEW|FRONT VIEW|FV)>/i))this[_0x114194(0x56a)]='FV';else{if(_0x311178[_0x114194(0x13e)](/<(?:SIDEVIEW|SIDE VIEW|SV)>/i))this['_forcedTroopView']='SV';else{if(_0x311178[_0x114194(0x13e)](/<(?:BATTLEVIEW|BATTLE VIEW):[ ](.*)>/i)){const _0x1c8bd1=String(RegExp['$1']);if(_0x1c8bd1[_0x114194(0x13e)](/(?:FRONTVIEW|FRONT VIEW|FV)/i))this[_0x114194(0x56a)]='FV';else _0x1c8bd1['match'](/(?:SIDEVIEW|SIDE VIEW|SV)/i)&&(this['_forcedTroopView']='SV');}}}if(_0x311178[_0x114194(0x13e)](/<(?:DTB)>/i))this[_0x114194(0x4c0)]=0x0;else{if(_0x311178['match'](/<(?:TPB|ATB)[ ]ACTIVE>/i))this[_0x114194(0x4c0)]=0x1;else{if(_0x311178[_0x114194(0x13e)](/<(?:TPB|ATB)[ ]WAIT>/i))this[_0x114194(0x4c0)]=0x2;else{if(_0x311178[_0x114194(0x13e)](/<(?:TPB|ATB)>/i))this[_0x114194(0x4c0)]=0x2;else{if(_0x311178[_0x114194(0x13e)](/<(?:CTB)>/i))Imported[_0x114194(0x2de)]&&(this['_forcedBattleSys']=_0x114194(0x283));else{if(_0x311178['match'](/<(?:STB)>/i))Imported['VisuMZ_2_BattleSystemSTB']&&(this['_forcedBattleSys']='STB');else{if(_0x311178['match'](/<(?:BTB)>/i))Imported[_0x114194(0x383)]&&(this['_forcedBattleSys']=_0x114194(0x723));else{if(_0x311178[_0x114194(0x13e)](/<(?:FTB)>/i))Imported['VisuMZ_2_BattleSystemFTB']&&(this[_0x114194(0x4c0)]=_0x114194(0x56f));else{if(_0x311178[_0x114194(0x13e)](/<(?:OTB)>/i))Imported[_0x114194(0x4e1)]&&(this[_0x114194(0x4c0)]=_0x114194(0x31e));else{if(_0x311178['match'](/<(?:ETB)>/i))Imported[_0x114194(0x72f)]&&(this[_0x114194(0x4c0)]=_0x114194(0x22f));else{if(_0x311178[_0x114194(0x13e)](/<(?:PTB)>/i))Imported[_0x114194(0x70b)]&&(this['_forcedBattleSys']=_0x114194(0x7f3));else{if(_0x311178[_0x114194(0x13e)](/<(?:BATTLEVIEW|BATTLE VIEW):[ ](.*)>/i)){const _0x2ea2d6=String(RegExp['$1']);if(_0x2ea2d6[_0x114194(0x13e)](/DTB/i))this[_0x114194(0x4c0)]=0x0;else{if(_0x2ea2d6[_0x114194(0x13e)](/(?:TPB|ATB)[ ]ACTIVE/i))this['_forcedBattleSys']=0x1;else{if(_0x2ea2d6[_0x114194(0x13e)](/(?:TPB|ATB)[ ]WAIT/i))this[_0x114194(0x4c0)]=0x2;else{if(_0x2ea2d6[_0x114194(0x13e)](/CTB/i))Imported[_0x114194(0x2de)]&&(this[_0x114194(0x4c0)]=_0x114194(0x283));else{if(_0x2ea2d6['match'](/STB/i))Imported[_0x114194(0x718)]&&(this[_0x114194(0x4c0)]='STB');else{if(_0x2ea2d6[_0x114194(0x13e)](/BTB/i))Imported[_0x114194(0x383)]&&(this['_forcedBattleSys']=_0x114194(0x723));else{if(_0x2ea2d6[_0x114194(0x13e)](/FTB/i))Imported[_0x114194(0xc2)]&&(this['_forcedBattleSys']=_0x114194(0x56f));else{if(_0x2ea2d6['match'](/OTB/i))Imported[_0x114194(0x4e1)]&&(this[_0x114194(0x4c0)]='OTB');else{if(_0x2ea2d6['match'](/ETB/i))Imported[_0x114194(0x72f)]&&(this[_0x114194(0x4c0)]=_0x114194(0x22f));else _0x2ea2d6[_0x114194(0x13e)](/PTB/i)&&(Imported[_0x114194(0x70b)]&&(this[_0x114194(0x4c0)]='PTB'));}}}}}}}}}}}}}}}}}}}}if(_0x311178[_0x114194(0x13e)](/<(?:|BATTLE )GRID>/i))this['_forcedBattleGridSystem']=!![];else _0x311178[_0x114194(0x13e)](/<NO (?:|BATTLE )GRID>/i)&&(this[_0x114194(0x81f)]=![]);},Game_Temp[_0x262cbe(0x800)][_0x262cbe(0x373)]=function(){const _0xd5d766=_0x262cbe;this[_0xd5d766(0x791)]=[];},Game_Temp[_0x262cbe(0x800)]['requestFauxAnimation']=function(_0x55402f,_0x1e3833,_0x4d496d,_0x1b8e8e){const _0x30e435=_0x262cbe;if(!this['showFauxAnimations']())return;_0x4d496d=_0x4d496d||![],_0x1b8e8e=_0x1b8e8e||![];if($dataAnimations[_0x1e3833]){const _0x416d41={'targets':_0x55402f,'animationId':_0x1e3833,'mirror':_0x4d496d,'mute':_0x1b8e8e};this[_0x30e435(0x791)][_0x30e435(0x4ea)](_0x416d41);for(const _0x2f956a of _0x55402f){_0x2f956a[_0x30e435(0x53d)]&&_0x2f956a[_0x30e435(0x53d)]();}}},Game_Temp[_0x262cbe(0x800)][_0x262cbe(0x4b7)]=function(){return!![];},Game_Temp[_0x262cbe(0x800)][_0x262cbe(0x802)]=function(){const _0x3bdf64=_0x262cbe;return this['_fauxAnimationQueue'][_0x3bdf64(0x597)]();},Game_Temp[_0x262cbe(0x800)][_0x262cbe(0x44b)]=function(){const _0x1d65b0=_0x262cbe;this[_0x1d65b0(0x2a2)]=[];},Game_Temp['prototype']['requestPointAnimation']=function(_0x5d408b,_0x3cc282,_0x311ddf,_0x2599b3,_0x231e8f){const _0x284b54=_0x262cbe;if(!this[_0x284b54(0x6b9)]())return;_0x2599b3=_0x2599b3||![],_0x231e8f=_0x231e8f||![];if($dataAnimations[_0x311ddf]){const _0xd43f51={'x':_0x5d408b,'y':_0x3cc282,'animationId':_0x311ddf,'mirror':_0x2599b3,'mute':_0x231e8f};this[_0x284b54(0x2a2)][_0x284b54(0x4ea)](_0xd43f51);}},Game_Temp[_0x262cbe(0x800)]['showPointAnimations']=function(){return!![];},Game_Temp[_0x262cbe(0x800)][_0x262cbe(0xd7)]=function(){return this['_pointAnimationQueue']['shift']();},VisuMZ['CoreEngine'][_0x262cbe(0x640)]=Game_System['prototype'][_0x262cbe(0x1ad)],Game_System[_0x262cbe(0x800)][_0x262cbe(0x1ad)]=function(){const _0x489da0=_0x262cbe;VisuMZ['CoreEngine'][_0x489da0(0x640)][_0x489da0(0x77c)](this),this[_0x489da0(0x7cc)]();},Game_System['prototype'][_0x262cbe(0x7cc)]=function(){const _0x8f0e82=_0x262cbe;this[_0x8f0e82(0x22c)]={'SideView':$dataSystem['optSideView'],'BattleSystem':this[_0x8f0e82(0x25f)](),'FontSize':$dataSystem[_0x8f0e82(0x171)][_0x8f0e82(0x5ad)],'Padding':0xc};},Game_System[_0x262cbe(0x800)]['isSideView']=function(){const _0x5bf094=_0x262cbe;if($gameTemp[_0x5bf094(0x56a)]==='SV')return!![];else{if($gameTemp[_0x5bf094(0x56a)]==='FV')return![];}if(this[_0x5bf094(0x22c)]===undefined)this['initCoreEngine']();if(this[_0x5bf094(0x22c)][_0x5bf094(0x2a4)]===undefined)this[_0x5bf094(0x7cc)]();return this['_CoreEngineSettings'][_0x5bf094(0x2a4)];},Game_System[_0x262cbe(0x800)]['setSideView']=function(_0x50997b){const _0x549816=_0x262cbe;if(this['_CoreEngineSettings']===undefined)this[_0x549816(0x7cc)]();if(this['_CoreEngineSettings'][_0x549816(0x2a4)]===undefined)this[_0x549816(0x7cc)]();this[_0x549816(0x22c)][_0x549816(0x2a4)]=_0x50997b;},Game_System[_0x262cbe(0x800)][_0x262cbe(0x817)]=function(){const _0x2b87c4=_0x262cbe;if(this[_0x2b87c4(0x22c)]===undefined)this['initCoreEngine']();this['_CoreEngineSettings'][_0x2b87c4(0x196)]=this['initialBattleSystem']();},Game_System['prototype'][_0x262cbe(0x25f)]=function(){const _0x18a190=_0x262cbe,_0x2f53d0=(VisuMZ[_0x18a190(0x244)][_0x18a190(0x84d)][_0x18a190(0x196)]||_0x18a190(0x62a))[_0x18a190(0x551)]()[_0x18a190(0x4a7)]();return VisuMZ[_0x18a190(0x244)]['CreateBattleSystemID'](_0x2f53d0);},Game_System[_0x262cbe(0x800)]['getBattleSystem']=function(){const _0x413131=_0x262cbe;if($gameTemp[_0x413131(0x4c0)]!==undefined)return $gameTemp[_0x413131(0x4c0)];if(this[_0x413131(0x22c)]===undefined)this[_0x413131(0x7cc)]();if(this[_0x413131(0x22c)][_0x413131(0x196)]===undefined)this[_0x413131(0x817)]();return this[_0x413131(0x22c)]['BattleSystem'];},Game_System[_0x262cbe(0x800)][_0x262cbe(0xef)]=function(_0x2944c5){const _0x12012a=_0x262cbe;if(this[_0x12012a(0x22c)]===undefined)this['initCoreEngine']();if(this[_0x12012a(0x22c)]['BattleSystem']===undefined)this[_0x12012a(0x817)]();this['_CoreEngineSettings']['BattleSystem']=_0x2944c5;},Game_System[_0x262cbe(0x800)][_0x262cbe(0xc5)]=function(){const _0x2ac4b0=_0x262cbe;if(this[_0x2ac4b0(0x22c)]===undefined)this[_0x2ac4b0(0x7cc)]();if(this[_0x2ac4b0(0x22c)]['FontSize']===undefined)this[_0x2ac4b0(0x7cc)]();return this[_0x2ac4b0(0x22c)][_0x2ac4b0(0x29e)];},Game_System[_0x262cbe(0x800)]['setMainFontSize']=function(_0x4007ea){const _0x3a9c20=_0x262cbe;if(this[_0x3a9c20(0x22c)]===undefined)this['initCoreEngine']();if(this[_0x3a9c20(0x22c)]['TimeProgress']===undefined)this[_0x3a9c20(0x7cc)]();this[_0x3a9c20(0x22c)][_0x3a9c20(0x29e)]=_0x4007ea;},Game_System['prototype']['windowPadding']=function(){const _0x1343ce=_0x262cbe;if(this['_CoreEngineSettings']===undefined)this[_0x1343ce(0x7cc)]();if(this[_0x1343ce(0x22c)][_0x1343ce(0x708)]===undefined)this['initCoreEngine']();return this[_0x1343ce(0x22c)][_0x1343ce(0x708)];},Game_System[_0x262cbe(0x800)][_0x262cbe(0x262)]=function(_0x3042bd){const _0x41fa39=_0x262cbe;if(this['_CoreEngineSettings']===undefined)this[_0x41fa39(0x7cc)]();if(this[_0x41fa39(0x22c)][_0x41fa39(0x64f)]===undefined)this['initCoreEngine']();this['_CoreEngineSettings'][_0x41fa39(0x708)]=_0x3042bd;},VisuMZ['CoreEngine'][_0x262cbe(0x799)]=Game_Screen[_0x262cbe(0x800)][_0x262cbe(0x1ad)],Game_Screen[_0x262cbe(0x800)]['initialize']=function(){const _0x32f3ca=_0x262cbe;VisuMZ[_0x32f3ca(0x244)][_0x32f3ca(0x799)][_0x32f3ca(0x77c)](this),this[_0x32f3ca(0x47b)]();},Game_Screen[_0x262cbe(0x800)][_0x262cbe(0x47b)]=function(){const _0x16dd3d=_0x262cbe,_0x2ec5e3=VisuMZ[_0x16dd3d(0x244)][_0x16dd3d(0x84d)]['ScreenShake'];this[_0x16dd3d(0x499)]=_0x2ec5e3?.[_0x16dd3d(0x541)]||_0x16dd3d(0x571);},Game_Screen[_0x262cbe(0x800)][_0x262cbe(0x4e3)]=function(){const _0x300c5=_0x262cbe;if(this[_0x300c5(0x499)]===undefined)this['initCoreEngineScreenShake']();return this[_0x300c5(0x499)];},Game_Screen[_0x262cbe(0x800)][_0x262cbe(0x347)]=function(_0x11f2ba){const _0x38f051=_0x262cbe;if(this[_0x38f051(0x499)]===undefined)this[_0x38f051(0x47b)]();this[_0x38f051(0x499)]=_0x11f2ba[_0x38f051(0x218)]()[_0x38f051(0x4a7)]();},Game_Picture[_0x262cbe(0x800)]['isMapScrollLinked']=function(){const _0x429a86=_0x262cbe;if($gameParty['inBattle']())return![];return this['onlyfilename']()&&this[_0x429a86(0x61f)]()['charAt'](0x0)==='!';},Game_Picture['prototype']['onlyfilename']=function(){const _0x5c2f3c=_0x262cbe;return this[_0x5c2f3c(0x4b1)]['split']('/')[_0x5c2f3c(0x35b)]();},VisuMZ[_0x262cbe(0x244)]['Game_Picture_x']=Game_Picture[_0x262cbe(0x800)]['x'],Game_Picture[_0x262cbe(0x800)]['x']=function(){const _0x3df422=_0x262cbe;return this[_0x3df422(0x105)]()?this[_0x3df422(0x6f9)]():VisuMZ[_0x3df422(0x244)][_0x3df422(0xcf)]['call'](this);},Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x6f9)]=function(){const _0x433650=_0x262cbe,_0xed91e7=$gameMap['displayX']()*$gameMap[_0x433650(0x11e)]();return(this['_x']-_0xed91e7)*$gameScreen[_0x433650(0x611)]();},VisuMZ[_0x262cbe(0x244)]['Game_Picture_y']=Game_Picture[_0x262cbe(0x800)]['y'],Game_Picture[_0x262cbe(0x800)]['y']=function(){const _0x171378=_0x262cbe;return this[_0x171378(0x105)]()?this[_0x171378(0x523)]():VisuMZ['CoreEngine'][_0x171378(0x4dc)][_0x171378(0x77c)](this);},Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x523)]=function(){const _0x45026b=_0x262cbe,_0xb5706b=$gameMap['displayY']()*$gameMap[_0x45026b(0x5a2)]();return(this['_y']-_0xb5706b)*$gameScreen[_0x45026b(0x611)]();},VisuMZ['CoreEngine']['Game_Picture_scaleX']=Game_Picture['prototype'][_0x262cbe(0x58e)],Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x58e)]=function(){const _0x404ac9=_0x262cbe;let _0xb0a0c0=VisuMZ[_0x404ac9(0x244)][_0x404ac9(0x859)]['call'](this);return this['isMapScrollLinked']()&&(_0xb0a0c0*=$gameScreen[_0x404ac9(0x611)]()),_0xb0a0c0;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x412)]=Game_Picture[_0x262cbe(0x800)][_0x262cbe(0xd1)],Game_Picture[_0x262cbe(0x800)][_0x262cbe(0xd1)]=function(){const _0xe147b1=_0x262cbe;let _0x544312=VisuMZ['CoreEngine'][_0xe147b1(0x412)][_0xe147b1(0x77c)](this);return this[_0xe147b1(0x105)]()&&(_0x544312*=$gameScreen[_0xe147b1(0x611)]()),_0x544312;},Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x2dc)]=function(_0x331f5e){const _0x502dc8=_0x262cbe;this[_0x502dc8(0x78d)]=_0x331f5e;},VisuMZ['CoreEngine'][_0x262cbe(0x650)]=Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x29c)],Game_Picture['prototype'][_0x262cbe(0x29c)]=function(_0x32146a){const _0x1a85fa=_0x262cbe;return this[_0x1a85fa(0x78d)]=this[_0x1a85fa(0x78d)]||0x0,[0x0,0x1,0x2,0x3][_0x1a85fa(0x14c)](this[_0x1a85fa(0x78d)])?VisuMZ['CoreEngine'][_0x1a85fa(0x650)][_0x1a85fa(0x77c)](this,_0x32146a):VisuMZ[_0x1a85fa(0x152)](_0x32146a,this[_0x1a85fa(0x78d)]);},VisuMZ[_0x262cbe(0x244)]['Game_Picture_initRotation']=Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x139)],Game_Picture[_0x262cbe(0x800)]['initRotation']=function(){const _0x70f322=_0x262cbe;VisuMZ[_0x70f322(0x244)][_0x70f322(0x613)][_0x70f322(0x77c)](this),this[_0x70f322(0x400)]();},Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x400)]=function(){const _0x3df4d4=_0x262cbe;this[_0x3df4d4(0x1bb)]={'current':0x0,'target':0x0,'duration':0x0,'wholeDuration':0x0,'easingType':'Linear'};},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x411)]=Game_Picture[_0x262cbe(0x800)]['angle'],Game_Picture['prototype'][_0x262cbe(0xe6)]=function(){const _0xd7ff45=_0x262cbe;let _0x1da1ac=VisuMZ[_0xd7ff45(0x244)][_0xd7ff45(0x411)][_0xd7ff45(0x77c)](this);return _0x1da1ac+=this[_0xd7ff45(0x6b2)](),_0x1da1ac;},Game_Picture[_0x262cbe(0x800)]['anglePlus']=function(){const _0x12e2eb=_0x262cbe;if(this[_0x12e2eb(0x1bb)]===undefined)this['initRotationCoreEngine']();return this['_anglePlus'][_0x12e2eb(0x810)]||0x0;},Game_Picture['prototype'][_0x262cbe(0x470)]=function(_0x67594c,_0x372eef,_0x355d63){const _0x3c5045=_0x262cbe;if(this['_anglePlus']===undefined)this['initRotationCoreEngine']();this[_0x3c5045(0x1bb)][_0x3c5045(0x38a)]=_0x67594c||0x0,this[_0x3c5045(0x1bb)][_0x3c5045(0x700)]=_0x372eef||0x0,this['_anglePlus']['wholeDuration']=_0x372eef||0x0,this[_0x3c5045(0x1bb)][_0x3c5045(0x74f)]=_0x355d63||_0x3c5045(0x7c1),_0x372eef<=0x0&&(this[_0x3c5045(0x1bb)]['current']=this[_0x3c5045(0x1bb)]['target']);},Game_Picture[_0x262cbe(0x800)]['changeAnglePlusData']=function(_0x14014e,_0x3ed076,_0x1ef30b){const _0x56f824=_0x262cbe;if(this[_0x56f824(0x1bb)]===undefined)this['initRotationCoreEngine']();this['_anglePlus']['target']+=_0x14014e||0x0,this[_0x56f824(0x1bb)][_0x56f824(0x700)]=_0x3ed076||0x0,this['_anglePlus'][_0x56f824(0x194)]=_0x3ed076||0x0,this[_0x56f824(0x1bb)]['easingType']=_0x1ef30b||_0x56f824(0x7c1),_0x3ed076<=0x0&&(this['_anglePlus'][_0x56f824(0x810)]=this[_0x56f824(0x1bb)]['target']);},VisuMZ['CoreEngine'][_0x262cbe(0x4b4)]=Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x1ef)],Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x1ef)]=function(){const _0x5c62ff=_0x262cbe;VisuMZ[_0x5c62ff(0x244)]['Game_Picture_updateRotation'][_0x5c62ff(0x77c)](this),this[_0x5c62ff(0x1e7)]();},Game_Picture['prototype'][_0x262cbe(0x1e7)]=function(){const _0x34525a=_0x262cbe;if(this[_0x34525a(0x1bb)]===undefined)this['initRotationCoreEngine']();const _0x4f835c=this[_0x34525a(0x1bb)];if(_0x4f835c['duration']<=0x0)return;_0x4f835c[_0x34525a(0x810)]=this[_0x34525a(0x23c)](_0x4f835c['current'],_0x4f835c['target']),_0x4f835c[_0x34525a(0x700)]--,_0x4f835c[_0x34525a(0x700)]<=0x0&&(_0x4f835c[_0x34525a(0x810)]=_0x4f835c['target']);},Game_Picture['prototype']['applyEasingAnglePlus']=function(_0x1c2cc8,_0x5c2e3d){const _0x185b47=_0x262cbe,_0x347a36=this[_0x185b47(0x1bb)],_0x1d1ad6=_0x347a36[_0x185b47(0x74f)],_0x3520af=_0x347a36[_0x185b47(0x700)],_0x208d9d=_0x347a36[_0x185b47(0x194)],_0x4e7697=VisuMZ[_0x185b47(0x152)]((_0x208d9d-_0x3520af)/_0x208d9d,_0x1d1ad6),_0x3b7de1=VisuMZ[_0x185b47(0x152)]((_0x208d9d-_0x3520af+0x1)/_0x208d9d,_0x1d1ad6),_0x2fc96d=(_0x1c2cc8-_0x5c2e3d*_0x4e7697)/(0x1-_0x4e7697);return _0x2fc96d+(_0x5c2e3d-_0x2fc96d)*_0x3b7de1;},VisuMZ['CoreEngine'][_0x262cbe(0x5b2)]=Game_Action[_0x262cbe(0x800)][_0x262cbe(0x3c2)],Game_Action[_0x262cbe(0x800)][_0x262cbe(0x3c2)]=function(_0x438ad9){const _0x492780=_0x262cbe;return VisuMZ[_0x492780(0x244)][_0x492780(0x84d)][_0x492780(0x754)][_0x492780(0x134)]?this[_0x492780(0x175)](_0x438ad9):VisuMZ[_0x492780(0x244)]['Game_Action_itemHit'][_0x492780(0x77c)](this,_0x438ad9);},Game_Action[_0x262cbe(0x800)][_0x262cbe(0x175)]=function(_0x5d3c37){const _0x1ed3a5=_0x262cbe,_0x4cc35f=this['itemSuccessRate'](_0x5d3c37),_0x15a066=this[_0x1ed3a5(0x34e)](_0x5d3c37),_0x50b852=this[_0x1ed3a5(0x43f)](_0x5d3c37);return _0x4cc35f*(_0x15a066-_0x50b852);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x180)]=Game_Action[_0x262cbe(0x800)][_0x262cbe(0x752)],Game_Action[_0x262cbe(0x800)]['itemEva']=function(_0x728473){const _0x327d93=_0x262cbe;return VisuMZ[_0x327d93(0x244)][_0x327d93(0x84d)][_0x327d93(0x754)][_0x327d93(0x134)]?0x0:VisuMZ[_0x327d93(0x244)][_0x327d93(0x180)][_0x327d93(0x77c)](this,_0x728473);},Game_Action[_0x262cbe(0x800)][_0x262cbe(0x23b)]=function(_0xcfa749){const _0x309844=_0x262cbe;return this[_0x309844(0x798)]()['successRate']*0.01;},Game_Action[_0x262cbe(0x800)]['subjectHitRate']=function(_0x370105){const _0x4de28e=_0x262cbe;if(VisuMZ[_0x4de28e(0x244)][_0x4de28e(0x84d)][_0x4de28e(0x754)][_0x4de28e(0x5cd)]&&this[_0x4de28e(0x380)]())return 0x1;return this['isPhysical']()?VisuMZ[_0x4de28e(0x244)][_0x4de28e(0x84d)][_0x4de28e(0x754)]['AccuracyBoost']&&this[_0x4de28e(0x7f7)]()[_0x4de28e(0x6e7)]()?this[_0x4de28e(0x7f7)]()[_0x4de28e(0x4bc)]+0.05:this[_0x4de28e(0x7f7)]()[_0x4de28e(0x4bc)]:0x1;},Game_Action['prototype'][_0x262cbe(0x43f)]=function(_0x119aba){const _0x462efd=_0x262cbe;if(this[_0x462efd(0x7f7)]()[_0x462efd(0x6e7)]()===_0x119aba[_0x462efd(0x6e7)]())return 0x0;if(this[_0x462efd(0x691)]())return VisuMZ[_0x462efd(0x244)]['Settings'][_0x462efd(0x754)][_0x462efd(0x5cd)]&&_0x119aba[_0x462efd(0x816)]()?_0x119aba['eva']-0.05:_0x119aba['eva'];else return this[_0x462efd(0x1e6)]()?_0x119aba[_0x462efd(0x7f6)]:0x0;},VisuMZ[_0x262cbe(0x244)]['Game_Action_updateLastTarget']=Game_Action[_0x262cbe(0x800)]['updateLastTarget'],Game_Action[_0x262cbe(0x800)][_0x262cbe(0x2d3)]=function(_0x137aea){const _0x13f7a4=_0x262cbe;VisuMZ[_0x13f7a4(0x244)][_0x13f7a4(0x4a9)]['call'](this,_0x137aea);if(VisuMZ[_0x13f7a4(0x244)]['Settings'][_0x13f7a4(0x754)][_0x13f7a4(0x134)])return;const _0x5593cc=_0x137aea[_0x13f7a4(0x5e3)]();_0x5593cc[_0x13f7a4(0x7ed)]&&(0x1-this[_0x13f7a4(0x752)](_0x137aea)>this[_0x13f7a4(0x3c2)](_0x137aea)&&(_0x5593cc[_0x13f7a4(0x7ed)]=![],_0x5593cc[_0x13f7a4(0x1fe)]=!![]));},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x4a3)]=Game_BattlerBase['prototype']['initMembers'],Game_BattlerBase[_0x262cbe(0x800)][_0x262cbe(0x697)]=function(){const _0x3cf203=_0x262cbe;this[_0x3cf203(0x72b)]={},VisuMZ[_0x3cf203(0x244)]['Game_BattlerBase_initMembers'][_0x3cf203(0x77c)](this);},VisuMZ[_0x262cbe(0x244)]['Game_BattlerBase_refresh']=Game_BattlerBase[_0x262cbe(0x800)]['refresh'],Game_BattlerBase['prototype'][_0x262cbe(0x14a)]=function(){const _0xa27509=_0x262cbe;this[_0xa27509(0x72b)]={},VisuMZ['CoreEngine'][_0xa27509(0x801)][_0xa27509(0x77c)](this);},Game_BattlerBase[_0x262cbe(0x800)][_0x262cbe(0x312)]=function(_0x1f26b7){const _0x2da7bf=_0x262cbe;return this['_cache']=this[_0x2da7bf(0x72b)]||{},this['_cache'][_0x1f26b7]!==undefined;},Game_BattlerBase['prototype'][_0x262cbe(0x776)]=function(_0x4c4f5e){const _0x453193=_0x262cbe,_0x598f8d=(_0xe44c09,_0x25b99d)=>{const _0x462f7a=_0x3598;if(!_0x25b99d)return _0xe44c09;if(_0x25b99d[_0x462f7a(0x215)][_0x462f7a(0x13e)](VisuMZ[_0x462f7a(0x244)][_0x462f7a(0x168)]['paramPlus'][_0x4c4f5e])){var _0x583780=Number(RegExp['$1']);_0xe44c09+=_0x583780;}if(_0x25b99d['note'][_0x462f7a(0x13e)](VisuMZ[_0x462f7a(0x244)][_0x462f7a(0x168)][_0x462f7a(0x760)][_0x4c4f5e])){var _0x58805f=String(RegExp['$1']);try{_0xe44c09+=eval(_0x58805f);}catch(_0x3b9289){if($gameTemp[_0x462f7a(0x5ee)]())console[_0x462f7a(0x254)](_0x3b9289);}}return _0xe44c09;};return this['traitObjects']()[_0x453193(0x5a6)](_0x598f8d,this[_0x453193(0x70d)][_0x4c4f5e]);},Game_BattlerBase['prototype']['paramMax']=function(_0x4108dd){const _0x4cb8a0=_0x262cbe;var _0x18615c=_0x4cb8a0(0x59d)+(this[_0x4cb8a0(0x6e7)]()?_0x4cb8a0(0x840):_0x4cb8a0(0x46c))+'ParamMax'+_0x4108dd;if(this[_0x4cb8a0(0x312)](_0x18615c))return this[_0x4cb8a0(0x72b)][_0x18615c];this[_0x4cb8a0(0x72b)][_0x18615c]=eval(VisuMZ['CoreEngine'][_0x4cb8a0(0x84d)]['Param'][_0x18615c]);const _0x19050f=(_0x18b3d1,_0x19d4bb)=>{const _0x569347=_0x4cb8a0;if(!_0x19d4bb)return _0x18b3d1;if(_0x19d4bb[_0x569347(0x215)]['match'](VisuMZ[_0x569347(0x244)][_0x569347(0x168)][_0x569347(0x59f)][_0x4108dd])){var _0x59469b=Number(RegExp['$1']);if(_0x59469b===0x0)_0x59469b=Number[_0x569347(0x379)];_0x18b3d1=Math['max'](_0x18b3d1,_0x59469b);}if(_0x19d4bb[_0x569347(0x215)][_0x569347(0x13e)](VisuMZ[_0x569347(0x244)][_0x569347(0x168)][_0x569347(0x1b2)][_0x4108dd])){var _0x3252f1=String(RegExp['$1']);try{_0x18b3d1=Math['max'](_0x18b3d1,Number(eval(_0x3252f1)));}catch(_0x1d548e){if($gameTemp[_0x569347(0x5ee)]())console['log'](_0x1d548e);}}return _0x18b3d1;};if(this[_0x4cb8a0(0x72b)][_0x18615c]===0x0)this[_0x4cb8a0(0x72b)][_0x18615c]=Number[_0x4cb8a0(0x379)];return this['_cache'][_0x18615c]=this['traitObjects']()[_0x4cb8a0(0x5a6)](_0x19050f,this[_0x4cb8a0(0x72b)][_0x18615c]),this['_cache'][_0x18615c];},Game_BattlerBase['prototype'][_0x262cbe(0x5d8)]=function(_0x41a2c7){const _0x9bafec=_0x262cbe,_0x3484c9=this[_0x9bafec(0x822)](Game_BattlerBase[_0x9bafec(0x74e)],_0x41a2c7),_0x715671=(_0x38d810,_0x1ba7b3)=>{const _0x1c8f00=_0x9bafec;if(!_0x1ba7b3)return _0x38d810;if(_0x1ba7b3[_0x1c8f00(0x215)][_0x1c8f00(0x13e)](VisuMZ[_0x1c8f00(0x244)]['RegExp']['paramRate1'][_0x41a2c7])){var _0x760fb4=Number(RegExp['$1'])/0x64;_0x38d810*=_0x760fb4;}if(_0x1ba7b3[_0x1c8f00(0x215)][_0x1c8f00(0x13e)](VisuMZ[_0x1c8f00(0x244)][_0x1c8f00(0x168)]['paramRate2'][_0x41a2c7])){var _0x760fb4=Number(RegExp['$1']);_0x38d810*=_0x760fb4;}if(_0x1ba7b3[_0x1c8f00(0x215)][_0x1c8f00(0x13e)](VisuMZ[_0x1c8f00(0x244)]['RegExp'][_0x1c8f00(0x726)][_0x41a2c7])){var _0x3ba4a0=String(RegExp['$1']);try{_0x38d810*=eval(_0x3ba4a0);}catch(_0x22d661){if($gameTemp[_0x1c8f00(0x5ee)]())console[_0x1c8f00(0x254)](_0x22d661);}}return _0x38d810;};return this[_0x9bafec(0x329)]()['reduce'](_0x715671,_0x3484c9);},Game_BattlerBase['prototype'][_0x262cbe(0x2c4)]=function(_0x40c3dc){const _0x15bc9b=_0x262cbe,_0x403a4a=(_0x162299,_0x43f13c)=>{const _0x5602ab=_0x3598;if(!_0x43f13c)return _0x162299;if(_0x43f13c[_0x5602ab(0x215)]['match'](VisuMZ['CoreEngine'][_0x5602ab(0x168)][_0x5602ab(0x340)][_0x40c3dc])){var _0x22c473=Number(RegExp['$1']);_0x162299+=_0x22c473;}if(_0x43f13c[_0x5602ab(0x215)][_0x5602ab(0x13e)](VisuMZ[_0x5602ab(0x244)][_0x5602ab(0x168)]['paramFlatJS'][_0x40c3dc])){var _0x1d4ffc=String(RegExp['$1']);try{_0x162299+=eval(_0x1d4ffc);}catch(_0x46233b){if($gameTemp['isPlaytest']())console[_0x5602ab(0x254)](_0x46233b);}}return _0x162299;};return this[_0x15bc9b(0x329)]()['reduce'](_0x403a4a,0x0);},Game_BattlerBase['prototype'][_0x262cbe(0x1a9)]=function(_0x3563e5){const _0x47906b=_0x262cbe;let _0x35f533='param'+_0x3563e5+_0x47906b(0x509);if(this[_0x47906b(0x312)](_0x35f533))return this[_0x47906b(0x72b)][_0x35f533];return this[_0x47906b(0x72b)][_0x35f533]=Math[_0x47906b(0x38d)](VisuMZ[_0x47906b(0x244)][_0x47906b(0x84d)]['Param']['BasicParameterFormula'][_0x47906b(0x77c)](this,_0x3563e5)),this[_0x47906b(0x72b)][_0x35f533];},Game_BattlerBase[_0x262cbe(0x800)][_0x262cbe(0x4e9)]=function(_0x24f1a0){const _0x50e46e=_0x262cbe,_0x76e820=(_0x2d545b,_0x10caff)=>{const _0x591e83=_0x3598;if(!_0x10caff)return _0x2d545b;if(_0x10caff[_0x591e83(0x215)][_0x591e83(0x13e)](VisuMZ[_0x591e83(0x244)][_0x591e83(0x168)][_0x591e83(0x222)][_0x24f1a0])){var _0x523126=Number(RegExp['$1'])/0x64;_0x2d545b+=_0x523126;}if(_0x10caff[_0x591e83(0x215)][_0x591e83(0x13e)](VisuMZ['CoreEngine']['RegExp'][_0x591e83(0xdb)][_0x24f1a0])){var _0x523126=Number(RegExp['$1']);_0x2d545b+=_0x523126;}if(_0x10caff['note']['match'](VisuMZ[_0x591e83(0x244)][_0x591e83(0x168)]['xparamPlusJS'][_0x24f1a0])){var _0xfe827b=String(RegExp['$1']);try{_0x2d545b+=eval(_0xfe827b);}catch(_0x923d20){if($gameTemp[_0x591e83(0x5ee)]())console[_0x591e83(0x254)](_0x923d20);}}return _0x2d545b;};return this[_0x50e46e(0x329)]()[_0x50e46e(0x5a6)](_0x76e820,0x0);},Game_BattlerBase['prototype'][_0x262cbe(0x4c1)]=function(_0x2e61c4){const _0x1686ba=_0x262cbe,_0x41ba97=(_0x351c4c,_0x2b34b0)=>{const _0x50e4a7=_0x3598;if(!_0x2b34b0)return _0x351c4c;if(_0x2b34b0['note'][_0x50e4a7(0x13e)](VisuMZ[_0x50e4a7(0x244)][_0x50e4a7(0x168)][_0x50e4a7(0x3b4)][_0x2e61c4])){var _0x4dc321=Number(RegExp['$1'])/0x64;_0x351c4c*=_0x4dc321;}if(_0x2b34b0['note'][_0x50e4a7(0x13e)](VisuMZ[_0x50e4a7(0x244)][_0x50e4a7(0x168)][_0x50e4a7(0x117)][_0x2e61c4])){var _0x4dc321=Number(RegExp['$1']);_0x351c4c*=_0x4dc321;}if(_0x2b34b0['note']['match'](VisuMZ[_0x50e4a7(0x244)][_0x50e4a7(0x168)]['xparamRateJS'][_0x2e61c4])){var _0x472115=String(RegExp['$1']);try{_0x351c4c*=eval(_0x472115);}catch(_0x43a586){if($gameTemp[_0x50e4a7(0x5ee)]())console[_0x50e4a7(0x254)](_0x43a586);}}return _0x351c4c;};return this['traitObjects']()[_0x1686ba(0x5a6)](_0x41ba97,0x1);},Game_BattlerBase[_0x262cbe(0x800)][_0x262cbe(0x68e)]=function(_0x47e81c){const _0x122aa1=_0x262cbe,_0x4f33b2=(_0x450665,_0x3c10c2)=>{const _0x46f9ae=_0x3598;if(!_0x3c10c2)return _0x450665;if(_0x3c10c2[_0x46f9ae(0x215)]['match'](VisuMZ[_0x46f9ae(0x244)][_0x46f9ae(0x168)][_0x46f9ae(0x418)][_0x47e81c])){var _0x4afd3b=Number(RegExp['$1'])/0x64;_0x450665+=_0x4afd3b;}if(_0x3c10c2['note'][_0x46f9ae(0x13e)](VisuMZ[_0x46f9ae(0x244)][_0x46f9ae(0x168)][_0x46f9ae(0x787)][_0x47e81c])){var _0x4afd3b=Number(RegExp['$1']);_0x450665+=_0x4afd3b;}if(_0x3c10c2['note'][_0x46f9ae(0x13e)](VisuMZ[_0x46f9ae(0x244)]['RegExp'][_0x46f9ae(0x2d6)][_0x47e81c])){var _0x3f64d7=String(RegExp['$1']);try{_0x450665+=eval(_0x3f64d7);}catch(_0x1f93fc){if($gameTemp[_0x46f9ae(0x5ee)]())console[_0x46f9ae(0x254)](_0x1f93fc);}}return _0x450665;};return this[_0x122aa1(0x329)]()[_0x122aa1(0x5a6)](_0x4f33b2,0x0);},Game_BattlerBase[_0x262cbe(0x800)][_0x262cbe(0x844)]=function(_0x5048c6){const _0x455317=_0x262cbe;let _0x1e5fb3=_0x455317(0x844)+_0x5048c6+'Total';if(this[_0x455317(0x312)](_0x1e5fb3))return this['_cache'][_0x1e5fb3];return this[_0x455317(0x72b)][_0x1e5fb3]=VisuMZ[_0x455317(0x244)][_0x455317(0x84d)]['Param']['XParameterFormula'][_0x455317(0x77c)](this,_0x5048c6),this['_cache'][_0x1e5fb3];},Game_BattlerBase[_0x262cbe(0x800)][_0x262cbe(0x535)]=function(_0x115d9a){const _0x2ca1b9=_0x262cbe,_0x1cf823=(_0x5ddacf,_0x3186e2)=>{const _0x471685=_0x3598;if(!_0x3186e2)return _0x5ddacf;if(_0x3186e2[_0x471685(0x215)][_0x471685(0x13e)](VisuMZ[_0x471685(0x244)]['RegExp'][_0x471685(0x4fc)][_0x115d9a])){var _0x524e2a=Number(RegExp['$1'])/0x64;_0x5ddacf+=_0x524e2a;}if(_0x3186e2[_0x471685(0x215)][_0x471685(0x13e)](VisuMZ[_0x471685(0x244)][_0x471685(0x168)][_0x471685(0x7f4)][_0x115d9a])){var _0x524e2a=Number(RegExp['$1']);_0x5ddacf+=_0x524e2a;}if(_0x3186e2[_0x471685(0x215)][_0x471685(0x13e)](VisuMZ['CoreEngine'][_0x471685(0x168)][_0x471685(0x1fa)][_0x115d9a])){var _0x553e4a=String(RegExp['$1']);try{_0x5ddacf+=eval(_0x553e4a);}catch(_0x5b7460){if($gameTemp[_0x471685(0x5ee)]())console[_0x471685(0x254)](_0x5b7460);}}return _0x5ddacf;};return this[_0x2ca1b9(0x329)]()['reduce'](_0x1cf823,0x0);},Game_BattlerBase[_0x262cbe(0x800)][_0x262cbe(0x436)]=function(_0x119377){const _0x2ed364=_0x262cbe,_0x3d31cd=(_0x1fee07,_0x386235)=>{const _0x939fee=_0x3598;if(!_0x386235)return _0x1fee07;if(_0x386235['note'][_0x939fee(0x13e)](VisuMZ['CoreEngine'][_0x939fee(0x168)][_0x939fee(0x378)][_0x119377])){var _0x54fa40=Number(RegExp['$1'])/0x64;_0x1fee07*=_0x54fa40;}if(_0x386235['note'][_0x939fee(0x13e)](VisuMZ[_0x939fee(0x244)][_0x939fee(0x168)][_0x939fee(0x290)][_0x119377])){var _0x54fa40=Number(RegExp['$1']);_0x1fee07*=_0x54fa40;}if(_0x386235[_0x939fee(0x215)][_0x939fee(0x13e)](VisuMZ[_0x939fee(0x244)][_0x939fee(0x168)][_0x939fee(0x5a1)][_0x119377])){var _0xc48bcd=String(RegExp['$1']);try{_0x1fee07*=eval(_0xc48bcd);}catch(_0x25e43a){if($gameTemp[_0x939fee(0x5ee)]())console[_0x939fee(0x254)](_0x25e43a);}}return _0x1fee07;};return this[_0x2ed364(0x329)]()[_0x2ed364(0x5a6)](_0x3d31cd,0x1);},Game_BattlerBase[_0x262cbe(0x800)][_0x262cbe(0x7d6)]=function(_0x1ed518){const _0x5b16ca=_0x262cbe,_0x15eb67=(_0x222108,_0x4ba2ea)=>{const _0x59554e=_0x3598;if(!_0x4ba2ea)return _0x222108;if(_0x4ba2ea[_0x59554e(0x215)][_0x59554e(0x13e)](VisuMZ[_0x59554e(0x244)]['RegExp'][_0x59554e(0x852)][_0x1ed518])){var _0x3d7e81=Number(RegExp['$1'])/0x64;_0x222108+=_0x3d7e81;}if(_0x4ba2ea[_0x59554e(0x215)][_0x59554e(0x13e)](VisuMZ['CoreEngine']['RegExp'][_0x59554e(0x52c)][_0x1ed518])){var _0x3d7e81=Number(RegExp['$1']);_0x222108+=_0x3d7e81;}if(_0x4ba2ea[_0x59554e(0x215)][_0x59554e(0x13e)](VisuMZ[_0x59554e(0x244)][_0x59554e(0x168)][_0x59554e(0x1b8)][_0x1ed518])){var _0x390936=String(RegExp['$1']);try{_0x222108+=eval(_0x390936);}catch(_0x431d02){if($gameTemp[_0x59554e(0x5ee)]())console[_0x59554e(0x254)](_0x431d02);}}return _0x222108;};return this[_0x5b16ca(0x329)]()[_0x5b16ca(0x5a6)](_0x15eb67,0x0);},Game_BattlerBase[_0x262cbe(0x800)][_0x262cbe(0xe2)]=function(_0x40393e){const _0x3b71fd=_0x262cbe;let _0x584ce7=_0x3b71fd(0xe2)+_0x40393e+'Total';if(this['checkCacheKey'](_0x584ce7))return this[_0x3b71fd(0x72b)][_0x584ce7];return this[_0x3b71fd(0x72b)][_0x584ce7]=VisuMZ[_0x3b71fd(0x244)][_0x3b71fd(0x84d)][_0x3b71fd(0x778)][_0x3b71fd(0x65c)][_0x3b71fd(0x77c)](this,_0x40393e),this['_cache'][_0x584ce7];},Game_BattlerBase[_0x262cbe(0x800)][_0x262cbe(0x7a8)]=function(_0x14e556,_0x12be7f){const _0x2096a7=_0x262cbe;if(typeof paramId===_0x2096a7(0x76f))return this[_0x2096a7(0x1a9)](_0x14e556);_0x14e556=String(_0x14e556||'')[_0x2096a7(0x551)]();if(_0x14e556===_0x2096a7(0x92))return this[_0x2096a7(0x1a9)](0x0);if(_0x14e556===_0x2096a7(0x154))return this[_0x2096a7(0x1a9)](0x1);if(_0x14e556==='ATK')return this[_0x2096a7(0x1a9)](0x2);if(_0x14e556==='DEF')return this[_0x2096a7(0x1a9)](0x3);if(_0x14e556===_0x2096a7(0xbd))return this[_0x2096a7(0x1a9)](0x4);if(_0x14e556==='MDF')return this[_0x2096a7(0x1a9)](0x5);if(_0x14e556===_0x2096a7(0x3f1))return this[_0x2096a7(0x1a9)](0x6);if(_0x14e556===_0x2096a7(0x162))return this[_0x2096a7(0x1a9)](0x7);if(_0x14e556===_0x2096a7(0x7c6))return _0x12be7f?String(Math['round'](this['xparam'](0x0)*0x64))+'%':this[_0x2096a7(0x844)](0x0);if(_0x14e556===_0x2096a7(0xc0))return _0x12be7f?String(Math[_0x2096a7(0x38d)](this['xparam'](0x1)*0x64))+'%':this['xparam'](0x1);if(_0x14e556==='CRI')return _0x12be7f?String(Math[_0x2096a7(0x38d)](this[_0x2096a7(0x844)](0x2)*0x64))+'%':this[_0x2096a7(0x844)](0x2);if(_0x14e556===_0x2096a7(0x483))return _0x12be7f?String(Math[_0x2096a7(0x38d)](this['xparam'](0x3)*0x64))+'%':this[_0x2096a7(0x844)](0x3);if(_0x14e556===_0x2096a7(0x30c))return _0x12be7f?String(Math[_0x2096a7(0x38d)](this[_0x2096a7(0x844)](0x4)*0x64))+'%':this[_0x2096a7(0x844)](0x4);if(_0x14e556===_0x2096a7(0x542))return _0x12be7f?String(Math['round'](this['xparam'](0x5)*0x64))+'%':this[_0x2096a7(0x844)](0x5);if(_0x14e556===_0x2096a7(0xe8))return _0x12be7f?String(Math[_0x2096a7(0x38d)](this[_0x2096a7(0x844)](0x6)*0x64))+'%':this[_0x2096a7(0x844)](0x6);if(_0x14e556===_0x2096a7(0x657))return _0x12be7f?String(Math['round'](this[_0x2096a7(0x844)](0x7)*0x64))+'%':this['xparam'](0x7);if(_0x14e556===_0x2096a7(0x4b8))return _0x12be7f?String(Math['round'](this[_0x2096a7(0x844)](0x8)*0x64))+'%':this['xparam'](0x8);if(_0x14e556===_0x2096a7(0x4f5))return _0x12be7f?String(Math[_0x2096a7(0x38d)](this[_0x2096a7(0x844)](0x9)*0x64))+'%':this[_0x2096a7(0x844)](0x9);if(_0x14e556===_0x2096a7(0x182))return _0x12be7f?String(Math[_0x2096a7(0x38d)](this[_0x2096a7(0xe2)](0x0)*0x64))+'%':this[_0x2096a7(0xe2)](0x0);if(_0x14e556===_0x2096a7(0x370))return _0x12be7f?String(Math[_0x2096a7(0x38d)](this[_0x2096a7(0xe2)](0x1)*0x64))+'%':this[_0x2096a7(0xe2)](0x1);if(_0x14e556==='REC')return _0x12be7f?String(Math['round'](this[_0x2096a7(0xe2)](0x2)*0x64))+'%':this[_0x2096a7(0xe2)](0x2);if(_0x14e556==='PHA')return _0x12be7f?String(Math['round'](this[_0x2096a7(0xe2)](0x3)*0x64))+'%':this[_0x2096a7(0xe2)](0x3);if(_0x14e556===_0x2096a7(0x2ef))return _0x12be7f?String(Math['round'](this['sparam'](0x4)*0x64))+'%':this[_0x2096a7(0xe2)](0x4);if(_0x14e556===_0x2096a7(0x7c3))return _0x12be7f?String(Math[_0x2096a7(0x38d)](this[_0x2096a7(0xe2)](0x5)*0x64))+'%':this[_0x2096a7(0xe2)](0x5);if(_0x14e556==='PDR')return _0x12be7f?String(Math[_0x2096a7(0x38d)](this[_0x2096a7(0xe2)](0x6)*0x64))+'%':this['sparam'](0x6);if(_0x14e556==='MDR')return _0x12be7f?String(Math['round'](this[_0x2096a7(0xe2)](0x7)*0x64))+'%':this['sparam'](0x7);if(_0x14e556===_0x2096a7(0x3c7))return _0x12be7f?String(Math[_0x2096a7(0x38d)](this[_0x2096a7(0xe2)](0x8)*0x64))+'%':this[_0x2096a7(0xe2)](0x8);if(_0x14e556===_0x2096a7(0x659))return _0x12be7f?String(Math[_0x2096a7(0x38d)](this[_0x2096a7(0xe2)](0x9)*0x64))+'%':this[_0x2096a7(0xe2)](0x9);if(VisuMZ[_0x2096a7(0x244)]['CustomParamAbb'][_0x14e556]){const _0x3f470d=VisuMZ[_0x2096a7(0x244)][_0x2096a7(0x3dd)][_0x14e556],_0x7713a0=this[_0x3f470d];return VisuMZ[_0x2096a7(0x244)][_0x2096a7(0x36a)][_0x14e556]===_0x2096a7(0x25d)?_0x7713a0:_0x12be7f?String(Math[_0x2096a7(0x38d)](_0x7713a0*0x64))+'%':_0x7713a0;}return'';},Game_BattlerBase['prototype'][_0x262cbe(0x1d7)]=function(){const _0x5cdd1b=_0x262cbe;return this['isAlive']()&&this['_hp']<this[_0x5cdd1b(0x84b)]*VisuMZ['CoreEngine'][_0x5cdd1b(0x84d)]['Param']['CrisisRate'];},Game_Battler[_0x262cbe(0x800)][_0x262cbe(0x13c)]=function(){SoundManager['playMiss'](),this['requestMotion']('evade');},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x27b)]=Game_Actor[_0x262cbe(0x800)]['paramBase'],Game_Actor[_0x262cbe(0x800)]['paramBase']=function(_0x4c546b){const _0x14a8bf=_0x262cbe;if(this[_0x14a8bf(0xb5)]>0x63)return this[_0x14a8bf(0x803)](_0x4c546b);return VisuMZ[_0x14a8bf(0x244)][_0x14a8bf(0x27b)][_0x14a8bf(0x77c)](this,_0x4c546b);},Game_Actor['prototype'][_0x262cbe(0x803)]=function(_0x5435bb){const _0x3481d7=_0x262cbe,_0x2b4185=this[_0x3481d7(0x18f)]()[_0x3481d7(0x34f)][_0x5435bb][0x63],_0x6a0d08=this[_0x3481d7(0x18f)]()[_0x3481d7(0x34f)][_0x5435bb][0x62];return _0x2b4185+(_0x2b4185-_0x6a0d08)*(this['level']-0x63);},VisuMZ[_0x262cbe(0x244)]['Game_Actor_changeClass']=Game_Actor[_0x262cbe(0x800)][_0x262cbe(0x600)],Game_Actor[_0x262cbe(0x800)]['changeClass']=function(_0x4f9fda,_0x232e89){const _0x17effc=_0x262cbe;$gameTemp[_0x17effc(0x19a)]=!![],VisuMZ[_0x17effc(0x244)][_0x17effc(0x317)][_0x17effc(0x77c)](this,_0x4f9fda,_0x232e89),$gameTemp[_0x17effc(0x19a)]=undefined;},VisuMZ[_0x262cbe(0x244)]['Game_Actor_levelUp']=Game_Actor[_0x262cbe(0x800)][_0x262cbe(0x7bc)],Game_Actor[_0x262cbe(0x800)]['levelUp']=function(){const _0x211d63=_0x262cbe;VisuMZ[_0x211d63(0x244)][_0x211d63(0x1a7)][_0x211d63(0x77c)](this);if(!$gameTemp['_changingClass'])this[_0x211d63(0x3f4)]();},Game_Actor['prototype'][_0x262cbe(0x3f4)]=function(){const _0xb19d9a=_0x262cbe;this['_cache']={};if(VisuMZ[_0xb19d9a(0x244)][_0xb19d9a(0x84d)][_0xb19d9a(0x754)][_0xb19d9a(0x5f5)])this['_hp']=this[_0xb19d9a(0x84b)];if(VisuMZ[_0xb19d9a(0x244)][_0xb19d9a(0x84d)][_0xb19d9a(0x754)][_0xb19d9a(0x51a)])this[_0xb19d9a(0x1e5)]=this[_0xb19d9a(0x4b3)];},Game_Actor[_0x262cbe(0x800)][_0x262cbe(0x12a)]=function(){const _0x3346ff=_0x262cbe;if(this[_0x3346ff(0xa7)]())return 0x1;const _0x4fcb0e=this[_0x3346ff(0x43c)]()-this[_0x3346ff(0x3bd)](),_0x4e006e=this['currentExp']()-this[_0x3346ff(0x3bd)]();return(_0x4e006e/_0x4fcb0e)[_0x3346ff(0x565)](0x0,0x1);},Game_Actor[_0x262cbe(0x800)][_0x262cbe(0x329)]=function(){const _0x174ed4=_0x262cbe,_0xe7aea2=Game_Battler[_0x174ed4(0x800)][_0x174ed4(0x329)][_0x174ed4(0x77c)](this);for(const _0x2f2df6 of this['equips']()){_0x2f2df6&&_0xe7aea2[_0x174ed4(0x4ea)](_0x2f2df6);}return _0xe7aea2[_0x174ed4(0x4ea)](this[_0x174ed4(0x18f)](),this['actor']()),_0xe7aea2;},Object[_0x262cbe(0x1b7)](Game_Enemy[_0x262cbe(0x800)],'level',{'get':function(){const _0x279ca4=_0x262cbe;return this[_0x279ca4(0x583)]();},'configurable':!![]}),Game_Enemy[_0x262cbe(0x800)][_0x262cbe(0x583)]=function(){const _0x331178=_0x262cbe;return this[_0x331178(0x1d4)]()[_0x331178(0xb5)];},Game_Enemy[_0x262cbe(0x800)]['moveRelativeToResolutionChange']=function(){const _0x414074=_0x262cbe;!this[_0x414074(0xe7)]&&(this['_screenY']+=Math[_0x414074(0x38d)]((Graphics['height']-0x270)/0x2),this[_0x414074(0x278)]-=Math['floor']((Graphics[_0x414074(0x100)]-Graphics[_0x414074(0x9f)])/0x2),$gameSystem['isSideView']()?this[_0x414074(0x15a)]-=Math[_0x414074(0x431)]((Graphics[_0x414074(0x80a)]-Graphics['boxWidth'])/0x2):this['_screenX']+=Math[_0x414074(0x38d)]((Graphics[_0x414074(0x61b)]-0x330)/0x2)),this[_0x414074(0xe7)]=!![];},Game_Party[_0x262cbe(0x800)][_0x262cbe(0x3ec)]=function(){const _0x1aabf6=_0x262cbe;return VisuMZ[_0x1aabf6(0x244)][_0x1aabf6(0x84d)][_0x1aabf6(0x682)][_0x1aabf6(0x5d6)];},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x313)]=Game_Party[_0x262cbe(0x800)][_0x262cbe(0x54a)],Game_Party['prototype'][_0x262cbe(0x54a)]=function(_0x2fc988){const _0xb1e752=_0x262cbe;if(VisuMZ[_0xb1e752(0x244)][_0xb1e752(0x84d)][_0xb1e752(0x754)]['KeyItemProtect']&&DataManager[_0xb1e752(0x30d)](_0x2fc988))return;VisuMZ[_0xb1e752(0x244)][_0xb1e752(0x313)]['call'](this,_0x2fc988);},Game_Party[_0x262cbe(0x800)][_0x262cbe(0x13b)]=function(){const _0x54e0fa=_0x262cbe,_0x1a724b=VisuMZ['CoreEngine'][_0x54e0fa(0x84d)][_0x54e0fa(0x754)],_0x48734c=_0x1a724b['BTestAddedQuantity']??0x63;let _0x2c8211=[];(_0x1a724b[_0x54e0fa(0x118)]??!![])&&(_0x2c8211=_0x2c8211[_0x54e0fa(0x669)]($dataItems));(_0x1a724b[_0x54e0fa(0x160)]??!![])&&(_0x2c8211=_0x2c8211[_0x54e0fa(0x669)]($dataWeapons));(_0x1a724b[_0x54e0fa(0x475)]??!![])&&(_0x2c8211=_0x2c8211[_0x54e0fa(0x669)]($dataArmors));for(const _0xf1f02c of _0x2c8211){if(!_0xf1f02c)continue;if(_0xf1f02c[_0x54e0fa(0x84e)]['trim']()<=0x0)continue;if(_0xf1f02c[_0x54e0fa(0x84e)][_0x54e0fa(0x13e)](/-----/i))continue;this['gainItem'](_0xf1f02c,_0x48734c);}},VisuMZ[_0x262cbe(0x244)]['Game_Troop_setup']=Game_Troop['prototype']['setup'],Game_Troop[_0x262cbe(0x800)][_0x262cbe(0x4a5)]=function(_0x108e62){const _0x4db993=_0x262cbe;$gameTemp['clearForcedGameTroopSettingsCoreEngine'](),$gameTemp[_0x4db993(0x208)](_0x108e62),VisuMZ[_0x4db993(0x244)][_0x4db993(0x6a7)][_0x4db993(0x77c)](this,_0x108e62);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x2c7)]=Game_Map[_0x262cbe(0x800)][_0x262cbe(0x4a5)],Game_Map['prototype'][_0x262cbe(0x4a5)]=function(_0xbcd945){const _0x376336=_0x262cbe;VisuMZ[_0x376336(0x244)][_0x376336(0x2c7)][_0x376336(0x77c)](this,_0xbcd945),this[_0x376336(0x3fa)](),this[_0x376336(0x460)](_0xbcd945),this['setupTileExtendTerrainTags']();},Game_Map[_0x262cbe(0x800)][_0x262cbe(0x460)]=function(){const _0x3b8f34=_0x262cbe;this['_hideTileShadows']=VisuMZ[_0x3b8f34(0x244)]['Settings'][_0x3b8f34(0x754)][_0x3b8f34(0x345)]||![];const _0x4beda9=VisuMZ[_0x3b8f34(0x244)]['Settings'][_0x3b8f34(0x5b8)],_0x199fdd=$dataMap?$dataMap[_0x3b8f34(0x215)]||'':'';if(_0x199fdd[_0x3b8f34(0x13e)](/<SHOW TILE SHADOWS>/i))this[_0x3b8f34(0x30f)]=![];else _0x199fdd[_0x3b8f34(0x13e)](/<HIDE TILE SHADOWS>/i)&&(this[_0x3b8f34(0x30f)]=!![]);if(_0x199fdd[_0x3b8f34(0x13e)](/<SCROLL LOCK X>/i))this[_0x3b8f34(0x6cb)]()['centerX']=!![],this[_0x3b8f34(0x6cb)]()[_0x3b8f34(0x707)]=_0x4beda9[_0x3b8f34(0x7fd)];else _0x199fdd[_0x3b8f34(0x13e)](/<SCROLL LOCK X: (.*?)>/i)&&(this[_0x3b8f34(0x6cb)]()['centerX']=!![],this[_0x3b8f34(0x6cb)]()[_0x3b8f34(0x707)]=Number(RegExp['$1']));if(_0x199fdd['match'](/<SCROLL LOCK Y>/i))this['centerCameraCheckData']()[_0x3b8f34(0x828)]=!![],this[_0x3b8f34(0x6cb)]()[_0x3b8f34(0x43e)]=_0x4beda9[_0x3b8f34(0x76c)];else _0x199fdd[_0x3b8f34(0x13e)](/<SCROLL LOCK Y: (.*?)>/i)&&(this[_0x3b8f34(0x6cb)]()[_0x3b8f34(0x828)]=!![],this[_0x3b8f34(0x6cb)]()[_0x3b8f34(0x43e)]=Number(RegExp['$1']));},Game_Map[_0x262cbe(0x800)][_0x262cbe(0x614)]=function(){const _0x22fbcd=_0x262cbe;if(this[_0x22fbcd(0x30f)]===undefined)this[_0x22fbcd(0x460)]();return this['_hideTileShadows'];},Game_Map[_0x262cbe(0x800)][_0x262cbe(0x3fa)]=function(){const _0x3b996d=_0x262cbe,_0x20ee49=VisuMZ[_0x3b996d(0x244)]['Settings'][_0x3b996d(0x5b8)];this[_0x3b996d(0x101)]={'centerX':![],'centerY':![],'displayX':0x0,'displayY':0x0};if(_0x20ee49[_0x3b996d(0x268)]){const _0x455d53=Graphics[_0x3b996d(0x80a)]/this[_0x3b996d(0x11e)]();_0x455d53%0x1!==0x0&&Math[_0x3b996d(0x4c7)](_0x455d53)===this[_0x3b996d(0x80a)]()&&!this[_0x3b996d(0x69e)]()&&(this[_0x3b996d(0x101)][_0x3b996d(0x6f2)]=!![],this[_0x3b996d(0x101)][_0x3b996d(0x707)]=_0x20ee49[_0x3b996d(0x7fd)]||0x0);}if(_0x20ee49[_0x3b996d(0x71d)]){const _0x223ea2=Graphics[_0x3b996d(0x100)]/this[_0x3b996d(0x5a2)]();_0x223ea2%0x1!==0x0&&Math['ceil'](_0x223ea2)===this[_0x3b996d(0x100)]()&&!this[_0x3b996d(0x427)]()&&(this[_0x3b996d(0x101)][_0x3b996d(0x828)]=!![],this[_0x3b996d(0x101)][_0x3b996d(0x43e)]=_0x20ee49['DisplayLockY']||0x0);}$gameScreen['zoomScale']()===0x1&&(this[_0x3b996d(0x6cb)]()[_0x3b996d(0x6f2)]&&(this['_displayX']=this[_0x3b996d(0x6cb)]()[_0x3b996d(0x707)]),this[_0x3b996d(0x6cb)]()[_0x3b996d(0x828)]&&(this['_displayY']=this[_0x3b996d(0x6cb)]()[_0x3b996d(0x43e)]));},VisuMZ['CoreEngine'][_0x262cbe(0x343)]=Game_Map['prototype'][_0x262cbe(0x71c)],Game_Map[_0x262cbe(0x800)][_0x262cbe(0x71c)]=function(_0x1e7b1b,_0x1dbbfb){const _0x5683d7=_0x262cbe;VisuMZ[_0x5683d7(0x244)]['Game_Map_setDisplayPos']['call'](this,_0x1e7b1b,_0x1dbbfb),$gameScreen['zoomScale']()===0x1&&(!this[_0x5683d7(0x69e)]()&&this[_0x5683d7(0x6cb)]()[_0x5683d7(0x6f2)]&&(this[_0x5683d7(0x615)]=this['centerCameraCheckData']()['displayX']),!this[_0x5683d7(0x427)]()&&this[_0x5683d7(0x6cb)]()[_0x5683d7(0x828)]&&(this[_0x5683d7(0x63d)]=this['centerCameraCheckData']()['displayY']));},Game_Map[_0x262cbe(0x800)][_0x262cbe(0x6cb)]=function(){const _0x42ff61=_0x262cbe;if(this[_0x42ff61(0x101)]===undefined)this[_0x42ff61(0x3fa)]();return this[_0x42ff61(0x101)];},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x471)]=Game_Map[_0x262cbe(0x800)]['scrollDown'],Game_Map[_0x262cbe(0x800)][_0x262cbe(0x7a5)]=function(_0x20a1e1){const _0x38878c=_0x262cbe;if(this[_0x38878c(0x6cb)]()[_0x38878c(0x828)]&&$gameScreen[_0x38878c(0x611)]()===0x1){this[_0x38878c(0x63d)]=this[_0x38878c(0x6cb)]()[_0x38878c(0x43e)];return;}VisuMZ[_0x38878c(0x244)][_0x38878c(0x471)][_0x38878c(0x77c)](this,_0x20a1e1);},VisuMZ[_0x262cbe(0x244)]['Game_Map_scrollLeft']=Game_Map[_0x262cbe(0x800)][_0x262cbe(0x124)],Game_Map[_0x262cbe(0x800)]['scrollLeft']=function(_0x5cd665){const _0x76d521=_0x262cbe;if(this[_0x76d521(0x6cb)]()[_0x76d521(0x6f2)]&&$gameScreen['zoomScale']()===0x1){this[_0x76d521(0x615)]=this[_0x76d521(0x6cb)]()[_0x76d521(0x707)];return;}VisuMZ['CoreEngine']['Game_Map_scrollLeft'][_0x76d521(0x77c)](this,_0x5cd665);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x376)]=Game_Map[_0x262cbe(0x800)][_0x262cbe(0x2f3)],Game_Map[_0x262cbe(0x800)][_0x262cbe(0x2f3)]=function(_0x533c07){const _0x228081=_0x262cbe;if(this[_0x228081(0x6cb)]()[_0x228081(0x6f2)]&&$gameScreen[_0x228081(0x611)]()===0x1){this['_displayX']=this[_0x228081(0x6cb)]()[_0x228081(0x707)];return;}VisuMZ[_0x228081(0x244)][_0x228081(0x376)][_0x228081(0x77c)](this,_0x533c07);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x7d)]=Game_Map['prototype']['scrollUp'],Game_Map[_0x262cbe(0x800)]['scrollUp']=function(_0x165eb6){const _0x107c44=_0x262cbe;if(this[_0x107c44(0x6cb)]()['centerY']&&$gameScreen[_0x107c44(0x611)]()===0x1){this[_0x107c44(0x63d)]=this['centerCameraCheckData']()[_0x107c44(0x43e)];return;}VisuMZ[_0x107c44(0x244)][_0x107c44(0x7d)]['call'](this,_0x165eb6);},Game_Map['prototype'][_0x262cbe(0x780)]=function(){const _0x2ad9e6=_0x262cbe;this[_0x2ad9e6(0x500)]={};const _0x1138c6=this[_0x2ad9e6(0x22a)]();if(!_0x1138c6)return{};const _0x5bf79b=_0x1138c6[_0x2ad9e6(0x215)]||'',_0xe3e80b=/<(?:TALLER|EXT|EXTEND|RAISE)[ ]BY[ ](\d+):[ ](.*)>/gi;let _0xebddf={};const _0x282b7d=_0x5bf79b[_0x2ad9e6(0x13e)](_0xe3e80b);if(_0x282b7d)for(const _0x3bf01d of _0x282b7d){_0x3bf01d['match'](_0xe3e80b);const _0x475a68=Number(RegExp['$1'])[_0x2ad9e6(0x565)](0x1,0x10),_0xeb29a5=String(RegExp['$2'])[_0x2ad9e6(0x7e)](',')['map'](_0x4beb53=>Number(_0x4beb53)[_0x2ad9e6(0x565)](0x1,0x7));for(const _0x214347 of _0xeb29a5){_0xebddf[_0x214347]=_0x475a68;}}this[_0x2ad9e6(0x500)]=_0xebddf;},Game_Map[_0x262cbe(0x800)][_0x262cbe(0x13a)]=function(){const _0x22f3b=_0x262cbe;if(this[_0x22f3b(0x500)]===undefined)this[_0x22f3b(0x780)]();return this[_0x22f3b(0x500)];},Game_Map[_0x262cbe(0x800)]['isTileExtended']=function(_0x194d0e){const _0x16fcb7=_0x262cbe;if(_0x194d0e>=0x400)return![];const _0x542a47=$gameMap['getTileExtendTerrainTags']();if(Object[_0x16fcb7(0xae)](_0x542a47)['length']<=0x0)return![];const _0x45c444=this[_0x16fcb7(0x552)](),_0x44368c=_0x45c444[_0x194d0e]>>0xc,_0x4b9743=_0x542a47[_0x44368c]||0x0;return _0x4b9743>0x0;},Game_Map[_0x262cbe(0x800)]['refreshSpritesetForExtendedTiles']=function(){const _0x73d748=_0x262cbe,_0xf22b57=this['getTileExtendTerrainTags']();if(Object['keys'](_0xf22b57)[_0x73d748(0x3c3)]<=0x0)return;$spriteset&&($spriteset['removeTileExtendSprites']&&$spriteset[_0x73d748(0x5cf)](),$spriteset[_0x73d748(0x488)]&&$spriteset[_0x73d748(0x488)]());},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x673)]=Game_Character[_0x262cbe(0x800)][_0x262cbe(0x689)],Game_Character[_0x262cbe(0x800)][_0x262cbe(0x689)]=function(_0x4ca572){const _0x12566e=_0x262cbe;try{VisuMZ[_0x12566e(0x244)][_0x12566e(0x673)]['call'](this,_0x4ca572);}catch(_0x4e7c0d){if($gameTemp['isPlaytest']())console[_0x12566e(0x254)](_0x4e7c0d);}},Game_Player['prototype']['makeEncounterCount']=function(){const _0x4ee59b=_0x262cbe,_0x48796f=$gameMap['encounterStep']();this[_0x4ee59b(0x28f)]=Math[_0x4ee59b(0x508)](_0x48796f)+Math[_0x4ee59b(0x508)](_0x48796f)+this[_0x4ee59b(0x526)]();},Game_Player['prototype'][_0x262cbe(0x526)]=function(){const _0x306a78=_0x262cbe;return $dataMap&&$dataMap[_0x306a78(0x215)]&&$dataMap[_0x306a78(0x215)][_0x306a78(0x13e)](/<MINIMUM ENCOUNTER STEPS:[ ](\d+)>/i)?Number(RegExp['$1']):VisuMZ['CoreEngine'][_0x306a78(0x84d)][_0x306a78(0x754)]['EncounterRateMinimum'];},VisuMZ['CoreEngine'][_0x262cbe(0x435)]=Game_Event[_0x262cbe(0x800)][_0x262cbe(0xbe)],Game_Event[_0x262cbe(0x800)][_0x262cbe(0xbe)]=function(_0x37d854,_0x19b0a4){const _0xccc64a=_0x262cbe;return this['isSmartEventCollisionOn']()?this['checkSmartEventCollision'](_0x37d854,_0x19b0a4):VisuMZ[_0xccc64a(0x244)]['Game_Event_isCollidedWithEvents'][_0xccc64a(0x77c)](this,_0x37d854,_0x19b0a4);},Game_Event[_0x262cbe(0x800)][_0x262cbe(0xcc)]=function(){const _0x5aa7cb=_0x262cbe;return VisuMZ[_0x5aa7cb(0x244)][_0x5aa7cb(0x84d)][_0x5aa7cb(0x754)][_0x5aa7cb(0x90)];},Game_Event[_0x262cbe(0x800)][_0x262cbe(0x314)]=function(_0x1cb068,_0x1661a4){const _0x40db6f=_0x262cbe;if(!this['isNormalPriority']())return![];else{const _0x2a2985=$gameMap[_0x40db6f(0x781)](_0x1cb068,_0x1661a4)['filter'](_0x10211b=>_0x10211b[_0x40db6f(0x620)]());return _0x2a2985[_0x40db6f(0x3c3)]>0x0;}},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x36b)]=Game_Interpreter[_0x262cbe(0x800)][_0x262cbe(0x20d)],Game_Interpreter['prototype']['command105']=function(_0xffb62){const _0x2f203a=_0x262cbe,_0x558c7a=this['getCombinedScrollingText']();return _0x558c7a[_0x2f203a(0x13e)](/\/\/[ ]SCRIPT[ ]CALL/i)?this[_0x2f203a(0x6b0)](_0x558c7a):VisuMZ[_0x2f203a(0x244)][_0x2f203a(0x36b)][_0x2f203a(0x77c)](this,_0xffb62);},Game_Interpreter[_0x262cbe(0x800)][_0x262cbe(0x6bc)]=function(){const _0x59a399=_0x262cbe;let _0x25978b='',_0x5bc2e3=this[_0x59a399(0x634)]+0x1;while(this[_0x59a399(0x4c3)][_0x5bc2e3]&&this[_0x59a399(0x4c3)][_0x5bc2e3][_0x59a399(0xd8)]===0x195){_0x25978b+=this[_0x59a399(0x4c3)][_0x5bc2e3][_0x59a399(0x5d7)][0x0]+'\x0a',_0x5bc2e3++;}return _0x25978b;},Game_Interpreter['prototype'][_0x262cbe(0x6b0)]=function(_0x39185a){const _0x6cbdb6=_0x262cbe;try{eval(_0x39185a);}catch(_0x254d16){$gameTemp['isPlaytest']()&&(console['log']('Show\x20Scrolling\x20Text\x20Script\x20Error'),console[_0x6cbdb6(0x254)](_0x254d16));}return!![];},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x206)]=Game_Interpreter['prototype'][_0x262cbe(0x699)],Game_Interpreter[_0x262cbe(0x800)]['command111']=function(_0x345ad6){const _0x2bc015=_0x262cbe;try{VisuMZ[_0x2bc015(0x244)][_0x2bc015(0x206)]['call'](this,_0x345ad6);}catch(_0x257ded){$gameTemp['isPlaytest']()&&(console[_0x2bc015(0x254)](_0x2bc015(0x43d)),console[_0x2bc015(0x254)](_0x257ded)),this[_0x2bc015(0x6d7)]();}return!![];},VisuMZ['CoreEngine'][_0x262cbe(0x474)]=Game_Interpreter[_0x262cbe(0x800)][_0x262cbe(0x496)],Game_Interpreter[_0x262cbe(0x800)]['command122']=function(_0x3a180c){const _0xd4c0cb=_0x262cbe;try{VisuMZ[_0xd4c0cb(0x244)]['Game_Interpreter_command122'][_0xd4c0cb(0x77c)](this,_0x3a180c);}catch(_0x33cb4c){$gameTemp[_0xd4c0cb(0x5ee)]()&&(console[_0xd4c0cb(0x254)]('Control\x20Variables\x20Script\x20Error'),console[_0xd4c0cb(0x254)](_0x33cb4c));}return!![];},VisuMZ[_0x262cbe(0x244)]['Game_Interpreter_command355']=Game_Interpreter[_0x262cbe(0x800)]['command355'],Game_Interpreter[_0x262cbe(0x800)][_0x262cbe(0x537)]=function(){const _0x2a8a0f=_0x262cbe;try{VisuMZ[_0x2a8a0f(0x244)][_0x2a8a0f(0x831)][_0x2a8a0f(0x77c)](this);}catch(_0x209480){$gameTemp[_0x2a8a0f(0x5ee)]()&&(console['log'](_0x2a8a0f(0x492)),console[_0x2a8a0f(0x254)](_0x209480));}return!![];},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x197)]=Game_Interpreter[_0x262cbe(0x800)][_0x262cbe(0x654)],Game_Interpreter[_0x262cbe(0x800)][_0x262cbe(0x654)]=function(_0x24babb){const _0x3e6fb6=_0x262cbe;return $gameTemp['setLastPluginCommandInterpreter'](this),VisuMZ[_0x3e6fb6(0x244)][_0x3e6fb6(0x197)][_0x3e6fb6(0x77c)](this,_0x24babb);},Scene_Base[_0x262cbe(0x800)]['fadeSpeed']=function(){const _0x332b71=_0x262cbe;return VisuMZ[_0x332b71(0x244)][_0x332b71(0x84d)]['UI'][_0x332b71(0x577)];},Scene_Base['prototype']['isBottomHelpMode']=function(){const _0xc8c427=_0x262cbe;return VisuMZ['CoreEngine'][_0xc8c427(0x84d)]['UI'][_0xc8c427(0x5c5)];},Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x11a)]=function(){const _0x322f1f=_0x262cbe;return VisuMZ['CoreEngine'][_0x322f1f(0x84d)]['UI'][_0x322f1f(0x5d2)];},Scene_Base[_0x262cbe(0x800)][_0x262cbe(0xbb)]=function(){const _0x26d94f=_0x262cbe;return VisuMZ[_0x26d94f(0x244)][_0x26d94f(0x84d)]['UI'][_0x26d94f(0x7de)];},Scene_Base['prototype'][_0x262cbe(0x342)]=function(){const _0x8226a3=_0x262cbe;return VisuMZ['CoreEngine'][_0x8226a3(0x84d)]['UI'][_0x8226a3(0x61d)];},Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x4a2)]=function(){const _0x36daef=_0x262cbe;return VisuMZ[_0x36daef(0x244)][_0x36daef(0x84d)]['UI'][_0x36daef(0xa3)];},Scene_Base['prototype'][_0x262cbe(0x546)]=function(){const _0x44e1d6=_0x262cbe;return VisuMZ['CoreEngine'][_0x44e1d6(0x84d)]['Window'][_0x44e1d6(0x20a)];},VisuMZ['CoreEngine'][_0x262cbe(0x3bc)]=Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x6d8)],Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x6d8)]=function(){const _0x11561b=_0x262cbe;VisuMZ[_0x11561b(0x244)][_0x11561b(0x3bc)][_0x11561b(0x77c)](this),this[_0x11561b(0x67b)](),this[_0x11561b(0xe4)](),this[_0x11561b(0x489)]['x']=Math[_0x11561b(0x38d)](this[_0x11561b(0x489)]['x']),this[_0x11561b(0x489)]['y']=Math['round'](this[_0x11561b(0x489)]['y']);},Scene_Base[_0x262cbe(0x800)]['createButtonAssistWindow']=function(){},Scene_Base[_0x262cbe(0x800)][_0x262cbe(0xe4)]=function(){const _0x3e7854=_0x262cbe;this[_0x3e7854(0x255)]=new Window_TextPopup(),this[_0x3e7854(0x286)](this[_0x3e7854(0x255)]);},$textPopup=function(_0x212810){const _0xb6ceea=_0x262cbe,_0x4297de=SceneManager['_scene'][_0xb6ceea(0x255)];_0x4297de&&_0x4297de[_0xb6ceea(0x5af)](_0x212810);},Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x3d5)]=function(){const _0x244d29=_0x262cbe;return TextManager['getInputMultiButtonStrings'](_0x244d29(0x797),'pagedown');},Scene_Base['prototype'][_0x262cbe(0x119)]=function(){const _0x516100=_0x262cbe;return TextManager[_0x516100(0x11f)]('tab');},Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x147)]=function(){const _0x9da5ae=_0x262cbe;return TextManager['getInputButtonString'](_0x9da5ae(0x597));},Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x389)]=function(){const _0x4e82f1=_0x262cbe;return TextManager[_0x4e82f1(0x11f)]('ok');},Scene_Base[_0x262cbe(0x800)]['buttonAssistKey5']=function(){const _0x12b92f=_0x262cbe;return TextManager[_0x12b92f(0x11f)](_0x12b92f(0x166));},Scene_Base[_0x262cbe(0x800)]['buttonAssistText1']=function(){const _0x310f59=_0x262cbe;return this['_pageupButton']&&this['_pageupButton'][_0x310f59(0x209)]?TextManager[_0x310f59(0x52e)]:'';},Scene_Base['prototype'][_0x262cbe(0x3c1)]=function(){return'';},Scene_Base[_0x262cbe(0x800)]['buttonAssistText3']=function(){return'';},Scene_Base[_0x262cbe(0x800)]['buttonAssistText4']=function(){const _0x3afe41=_0x262cbe;return TextManager[_0x3afe41(0x394)];},Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x773)]=function(){const _0x4b7256=_0x262cbe;return TextManager[_0x4b7256(0x68a)];},Scene_Base['prototype'][_0x262cbe(0x632)]=function(){return 0x0;},Scene_Base[_0x262cbe(0x800)][_0x262cbe(0xff)]=function(){return 0x0;},Scene_Base[_0x262cbe(0x800)][_0x262cbe(0xf4)]=function(){return 0x0;},Scene_Base[_0x262cbe(0x800)]['buttonAssistOffset4']=function(){return 0x0;},Scene_Base['prototype'][_0x262cbe(0x17d)]=function(){return 0x0;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x303)]=Scene_Boot[_0x262cbe(0x800)]['loadSystemImages'],Scene_Boot['prototype'][_0x262cbe(0xbf)]=function(){const _0xa49a34=_0x262cbe;VisuMZ[_0xa49a34(0x244)][_0xa49a34(0x303)]['call'](this),this['loadGameImagesCoreEngine']();},Scene_Boot['prototype'][_0x262cbe(0x28c)]=function(){const _0x5b6c94=_0x262cbe,_0x39c8b9=['animations',_0x5b6c94(0x74b),_0x5b6c94(0x2fc),_0x5b6c94(0x2da),_0x5b6c94(0x5f3),'faces',_0x5b6c94(0x74d),'pictures',_0x5b6c94(0x231),'sv_enemies','system',_0x5b6c94(0x7c4),_0x5b6c94(0x75f),_0x5b6c94(0x77e)];for(const _0x1c6801 of _0x39c8b9){const _0x4428fb=VisuMZ[_0x5b6c94(0x244)]['Settings'][_0x5b6c94(0x7da)][_0x1c6801],_0x41266a=_0x5b6c94(0x6eb)['format'](_0x1c6801);for(const _0x3d419a of _0x4428fb){ImageManager['loadBitmap'](_0x41266a,_0x3d419a);}}},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x3ea)]=Scene_Boot[_0x262cbe(0x800)][_0x262cbe(0x40c)],Scene_Boot[_0x262cbe(0x800)]['startNormalGame']=function(){const _0x4c81f5=_0x262cbe;Utils[_0x4c81f5(0x6a3)]('test')&&VisuMZ[_0x4c81f5(0x244)]['Settings'][_0x4c81f5(0x754)]['NewGameBoot']?this['startAutoNewGame']():VisuMZ['CoreEngine'][_0x4c81f5(0x3ea)][_0x4c81f5(0x77c)](this);},Scene_Boot[_0x262cbe(0x800)]['startAutoNewGame']=function(){const _0x5dcf5b=_0x262cbe;this[_0x5dcf5b(0x17b)](),DataManager[_0x5dcf5b(0x811)](),SceneManager[_0x5dcf5b(0x5f4)](Scene_Map);},Scene_Boot[_0x262cbe(0x800)]['adjustBoxSize']=function(){const _0x1d09d0=_0x262cbe,_0x1c6698=$dataSystem[_0x1d09d0(0x171)][_0x1d09d0(0x413)],_0x108c5c=$dataSystem['advanced']['uiAreaHeight'],_0x275421=VisuMZ[_0x1d09d0(0x244)]['Settings']['UI'][_0x1d09d0(0x647)];Graphics[_0x1d09d0(0x61b)]=_0x1c6698-_0x275421*0x2,Graphics[_0x1d09d0(0x9f)]=_0x108c5c-_0x275421*0x2,this['determineSideButtonLayoutValid']();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x573)]=Scene_Boot['prototype'][_0x262cbe(0x504)],Scene_Boot[_0x262cbe(0x800)][_0x262cbe(0x504)]=function(){const _0xfd05e6=_0x262cbe;this['isFullDocumentTitle']()?this[_0xfd05e6(0x4b2)]():VisuMZ[_0xfd05e6(0x244)]['Scene_Boot_updateDocumentTitle'][_0xfd05e6(0x77c)](this);},Scene_Boot[_0x262cbe(0x800)][_0x262cbe(0x203)]=function(){const _0x3517c9=_0x262cbe;if(Scene_Title[_0x3517c9(0x771)]==='')return![];if(Scene_Title['subtitle']===_0x3517c9(0x61e))return![];if(Scene_Title[_0x3517c9(0x4f7)]==='')return![];if(Scene_Title[_0x3517c9(0x4f7)]===_0x3517c9(0x83d))return![];return!![];},Scene_Boot[_0x262cbe(0x800)][_0x262cbe(0x4b2)]=function(){const _0x34101d=_0x262cbe,_0x3d80f8=$dataSystem[_0x34101d(0x72d)],_0x437eb5=Scene_Title[_0x34101d(0x771)]||'',_0x2bfcee=Scene_Title[_0x34101d(0x4f7)]||'',_0x6884f8=VisuMZ['CoreEngine'][_0x34101d(0x84d)][_0x34101d(0x62e)]['Title'][_0x34101d(0x6d2)],_0x139f47=_0x6884f8[_0x34101d(0x94)](_0x3d80f8,_0x437eb5,_0x2bfcee);document[_0x34101d(0x50e)]=_0x139f47;},Scene_Boot[_0x262cbe(0x800)][_0x262cbe(0x1d6)]=function(){const _0x4f890=_0x262cbe;if(VisuMZ['CoreEngine'][_0x4f890(0x84d)]['UI']['SideButtons']){const _0x176678=Graphics[_0x4f890(0x80a)]-Graphics['boxWidth']-VisuMZ[_0x4f890(0x244)][_0x4f890(0x84d)]['UI'][_0x4f890(0x647)]*0x2,_0x2e0d3a=Sprite_Button[_0x4f890(0x800)][_0x4f890(0x27d)]['call'](this)*0x4;if(_0x176678>=_0x2e0d3a)SceneManager[_0x4f890(0x26c)](!![]);}},Scene_Title['subtitle']=VisuMZ['CoreEngine'][_0x262cbe(0x84d)][_0x262cbe(0x62e)][_0x262cbe(0x7c8)]['Subtitle'],Scene_Title['version']=VisuMZ[_0x262cbe(0x244)]['Settings'][_0x262cbe(0x62e)]['Title'][_0x262cbe(0x143)],Scene_Title['pictureButtons']=VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x83)],VisuMZ[_0x262cbe(0x244)]['Scene_Title_drawGameTitle']=Scene_Title['prototype'][_0x262cbe(0x4d4)],Scene_Title[_0x262cbe(0x800)]['drawGameTitle']=function(){const _0x481da4=_0x262cbe;VisuMZ['CoreEngine'][_0x481da4(0x84d)][_0x481da4(0x62e)][_0x481da4(0x7c8)]['drawGameTitle'][_0x481da4(0x77c)](this);if(Scene_Title['subtitle']!==''&&Scene_Title['subtitle']!=='Subtitle')this[_0x481da4(0x60d)]();if(Scene_Title[_0x481da4(0x4f7)]!==''&&Scene_Title['version']!==_0x481da4(0x83d))this[_0x481da4(0x7ac)]();},Scene_Title[_0x262cbe(0x800)]['drawGameSubtitle']=function(){const _0x27efa6=_0x262cbe;VisuMZ['CoreEngine'][_0x27efa6(0x84d)][_0x27efa6(0x62e)][_0x27efa6(0x7c8)][_0x27efa6(0x60d)][_0x27efa6(0x77c)](this);},Scene_Title[_0x262cbe(0x800)][_0x262cbe(0x7ac)]=function(){const _0x1f3c8b=_0x262cbe;VisuMZ['CoreEngine'][_0x1f3c8b(0x84d)][_0x1f3c8b(0x62e)][_0x1f3c8b(0x7c8)][_0x1f3c8b(0x7ac)]['call'](this);},Scene_Title[_0x262cbe(0x800)][_0x262cbe(0x53f)]=function(){const _0x39031f=_0x262cbe;this[_0x39031f(0x782)]();const _0xd3c878=$dataSystem[_0x39031f(0x446)][_0x39031f(0x429)],_0x3632b8=this[_0x39031f(0x5c8)]();this[_0x39031f(0x686)]=new Window_TitleCommand(_0x3632b8),this[_0x39031f(0x686)][_0x39031f(0xa6)](_0xd3c878);const _0x4479a1=this['commandWindowRect']();this[_0x39031f(0x686)][_0x39031f(0x5ea)](_0x4479a1['x'],_0x4479a1['y'],_0x4479a1['width'],_0x4479a1[_0x39031f(0x100)]),this[_0x39031f(0x686)][_0x39031f(0x518)](),this[_0x39031f(0x686)][_0x39031f(0x14a)](),this[_0x39031f(0x686)][_0x39031f(0x83e)](),this['addWindow'](this['_commandWindow']);},Scene_Title[_0x262cbe(0x800)][_0x262cbe(0x1d3)]=function(){const _0x2ff9df=_0x262cbe;return this[_0x2ff9df(0x686)]?this[_0x2ff9df(0x686)][_0x2ff9df(0x1aa)]():VisuMZ[_0x2ff9df(0x244)][_0x2ff9df(0x84d)][_0x2ff9df(0x69f)]['length'];},Scene_Title[_0x262cbe(0x800)][_0x262cbe(0x5c8)]=function(){const _0x453877=_0x262cbe;return VisuMZ['CoreEngine'][_0x453877(0x84d)][_0x453877(0x62e)][_0x453877(0x7c8)][_0x453877(0x746)][_0x453877(0x77c)](this);},Scene_Title[_0x262cbe(0x800)][_0x262cbe(0x782)]=function(){const _0x3e20df=_0x262cbe;for(const _0x143e80 of Scene_Title[_0x3e20df(0x575)]){const _0x13d57e=new Sprite_TitlePictureButton(_0x143e80);this[_0x3e20df(0x286)](_0x13d57e);}},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x33d)]=Scene_Map['prototype'][_0x262cbe(0x1ad)],Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x1ad)]=function(){const _0x5731b8=_0x262cbe;VisuMZ['CoreEngine'][_0x5731b8(0x33d)][_0x5731b8(0x77c)](this),$gameTemp[_0x5731b8(0x814)](),this['clearOnceParallelInterpreters']();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x236)]=Scene_Map[_0x262cbe(0x800)]['updateMainMultiply'],Scene_Map['prototype'][_0x262cbe(0x223)]=function(){const _0x341d27=_0x262cbe;VisuMZ[_0x341d27(0x244)][_0x341d27(0x236)][_0x341d27(0x77c)](this),$gameTemp[_0x341d27(0x374)]&&!$gameMessage[_0x341d27(0x212)]()&&(this['updateMain'](),SceneManager['updateEffekseer']());},Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x1f1)]=function(){const _0x242517=_0x262cbe;Scene_Message[_0x242517(0x800)][_0x242517(0x1f1)][_0x242517(0x77c)](this),!SceneManager[_0x242517(0x23d)](Scene_Battle)&&(this[_0x242517(0x2aa)][_0x242517(0x64e)](),this[_0x242517(0x7a1)][_0x242517(0x826)](),this['_windowLayer'][_0x242517(0x209)]=![],SceneManager[_0x242517(0x503)]()),$gameScreen[_0x242517(0x6e4)](),this[_0x242517(0xe3)]();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x711)]=Scene_Map[_0x262cbe(0x800)]['createMenuButton'],Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x609)]=function(){const _0x33f8dc=_0x262cbe;VisuMZ[_0x33f8dc(0x244)][_0x33f8dc(0x711)]['call'](this),SceneManager['isSideButtonLayout']()&&this[_0x33f8dc(0x621)]();},Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x621)]=function(){const _0x1058ec=_0x262cbe;this[_0x1058ec(0xce)]['x']=Graphics[_0x1058ec(0x61b)]+0x4;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x408)]=Scene_Map[_0x262cbe(0x800)]['updateScene'],Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x651)]=function(){const _0x2788c7=_0x262cbe;VisuMZ[_0x2788c7(0x244)][_0x2788c7(0x408)][_0x2788c7(0x77c)](this),this[_0x2788c7(0x581)]();},Scene_Map['prototype']['updateDashToggle']=function(){const _0x4322a5=_0x262cbe;Input[_0x4322a5(0x41b)](_0x4322a5(0x56c))&&(ConfigManager[_0x4322a5(0x44f)]=!ConfigManager['alwaysDash'],ConfigManager[_0x4322a5(0x637)]());},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x2bb)]=Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x116)],Scene_Map['prototype'][_0x262cbe(0x116)]=function(){const _0x264d32=_0x262cbe;VisuMZ[_0x264d32(0x244)][_0x264d32(0x2bb)][_0x264d32(0x77c)](this),this['updateOnceParallelInterpreters']();},Scene_Map['prototype'][_0x262cbe(0xe3)]=function(){const _0x1b5d96=_0x262cbe;this[_0x1b5d96(0x636)]=[];},Scene_Map['prototype'][_0x262cbe(0x454)]=function(){const _0x561c9b=_0x262cbe;if(!this[_0x561c9b(0x636)])return;for(const _0x3e4ba3 of this[_0x561c9b(0x636)]){_0x3e4ba3&&_0x3e4ba3['update']();}},Scene_Map['prototype']['playOnceParallelInterpreter']=function(_0x4ac4dd,_0x475a6d){const _0x32a97f=_0x262cbe,_0x1a7dfd=$dataCommonEvents[_0x4ac4dd];if(!_0x1a7dfd)return;const _0x3ae8c7=new Game_OnceParallelInterpreter();this['addOnceParallelInterpreter'](_0x3ae8c7),_0x3ae8c7[_0x32a97f(0x1cc)](_0x4ac4dd),_0x3ae8c7[_0x32a97f(0x1af)](_0x475a6d);},Scene_Map['prototype']['addOnceParallelInterpreter']=function(_0x520e0f){const _0x1d1986=_0x262cbe;this['_onceParallelInterpreters']=this[_0x1d1986(0x636)]||[],this[_0x1d1986(0x636)]['push'](_0x520e0f);},Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x1a4)]=function(_0x200b6a){const _0x7de27d=_0x262cbe;this[_0x7de27d(0x636)]=this['_onceParallelInterpreters']||[],this[_0x7de27d(0x636)]['remove'](_0x200b6a);};function Game_OnceParallelInterpreter(){const _0x578573=_0x262cbe;this[_0x578573(0x1ad)](...arguments);}Game_OnceParallelInterpreter[_0x262cbe(0x800)]=Object[_0x262cbe(0x3de)](Game_Interpreter[_0x262cbe(0x800)]),Game_OnceParallelInterpreter['prototype'][_0x262cbe(0x1ea)]=Game_OnceParallelInterpreter,Game_OnceParallelInterpreter[_0x262cbe(0x800)][_0x262cbe(0x1cc)]=function(_0xb82678){const _0x5c7ded=_0x262cbe,_0x2c2f1f=$dataCommonEvents[_0xb82678];_0x2c2f1f?this[_0x5c7ded(0x4a5)](_0x2c2f1f[_0x5c7ded(0x145)],0x0):this[_0x5c7ded(0x1f1)]();},Game_OnceParallelInterpreter['prototype']['setEvent']=function(_0x49bf64){const _0x1045c9=_0x262cbe;this[_0x1045c9(0x462)]=_0x49bf64||0x0;},Game_OnceParallelInterpreter[_0x262cbe(0x800)][_0x262cbe(0x1f1)]=function(){const _0x51d4e2=_0x262cbe;if(!SceneManager['isSceneMap']())return;SceneManager[_0x51d4e2(0x207)][_0x51d4e2(0x1a4)](this),Game_Interpreter[_0x51d4e2(0x800)][_0x51d4e2(0x1f1)][_0x51d4e2(0x77c)](this);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x786)]=Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x3a7)],Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x3a7)]=function(){const _0x4bdaed=_0x262cbe;let _0x55c79c=0x0;return SceneManager['areButtonsOutsideMainUI']()?_0x55c79c=this[_0x4bdaed(0x5e5)]():_0x55c79c=VisuMZ[_0x4bdaed(0x244)][_0x4bdaed(0x786)][_0x4bdaed(0x77c)](this),_0x55c79c;},Scene_MenuBase[_0x262cbe(0x800)]['helpAreaTopSideButtonLayout']=function(){return this['isBottomHelpMode']()?this['mainAreaBottom']():0x0;},VisuMZ['CoreEngine']['Scene_MenuBase_mainAreaTop']=Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x668)],Scene_MenuBase[_0x262cbe(0x800)]['mainAreaTop']=function(){const _0x13f3dd=_0x262cbe;return SceneManager['areButtonsOutsideMainUI']()?this['mainAreaTopSideButtonLayout']():VisuMZ[_0x13f3dd(0x244)]['Scene_MenuBase_mainAreaTop'][_0x13f3dd(0x77c)](this);},Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x1bf)]=function(){const _0x46ef38=_0x262cbe;if(!this['isBottomHelpMode']())return this[_0x46ef38(0x459)]();else return this[_0x46ef38(0x122)]()&&this[_0x46ef38(0x662)]()===_0x46ef38(0xa0)?Window_ButtonAssist[_0x46ef38(0x800)][_0x46ef38(0x66d)]():0x0;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x224)]=Scene_MenuBase[_0x262cbe(0x800)]['mainAreaHeight'],Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x1d2)]=function(){const _0xeeb07=_0x262cbe;let _0x5e705c=0x0;return SceneManager[_0xeeb07(0x2a7)]()?_0x5e705c=this['mainAreaHeightSideButtonLayout']():_0x5e705c=VisuMZ[_0xeeb07(0x244)][_0xeeb07(0x224)][_0xeeb07(0x77c)](this),this[_0xeeb07(0x122)]()&&this[_0xeeb07(0x662)]()!==_0xeeb07(0x3aa)&&(_0x5e705c-=Window_ButtonAssist[_0xeeb07(0x800)][_0xeeb07(0x66d)]()),_0x5e705c;},Scene_MenuBase['prototype'][_0x262cbe(0x3d8)]=function(){const _0x3445f1=_0x262cbe;return Graphics[_0x3445f1(0x9f)]-this['helpAreaHeight']();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x1c8)]=Scene_MenuBase['prototype'][_0x262cbe(0xc7)],Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0xc7)]=function(){const _0xe235ad=_0x262cbe,_0x2abda7=VisuMZ[_0xe235ad(0x244)][_0xe235ad(0x84d)]['MenuBg'][_0xe235ad(0x386)]??0x8;this[_0xe235ad(0x2ff)]=new PIXI[(_0xe235ad(0x177))]['BlurFilter'](_0x2abda7),this[_0xe235ad(0x6ea)]=new Sprite(),this[_0xe235ad(0x6ea)][_0xe235ad(0x2a9)]=SceneManager[_0xe235ad(0x2e7)](),this[_0xe235ad(0x6ea)][_0xe235ad(0x177)]=[this['_backgroundFilter']],this[_0xe235ad(0x286)](this[_0xe235ad(0x6ea)]),this[_0xe235ad(0x490)](0xc0),this['setBackgroundOpacity'](this[_0xe235ad(0x52f)]()),this['createCustomBackgroundImages']();},Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x52f)]=function(){const _0x27f18d=_0x262cbe,_0x508c5e=String(this['constructor'][_0x27f18d(0x84e)]),_0x136a5d=this[_0x27f18d(0x309)](_0x508c5e);return _0x136a5d?_0x136a5d[_0x27f18d(0x230)]:0xc0;},Scene_MenuBase['prototype'][_0x262cbe(0x1ae)]=function(){const _0x19b57b=_0x262cbe,_0x18d7e6=String(this[_0x19b57b(0x1ea)]['name']),_0x46f029=this['getCustomBackgroundSettings'](_0x18d7e6);_0x46f029&&(_0x46f029[_0x19b57b(0x758)]!==''||_0x46f029[_0x19b57b(0x318)]!=='')&&(this[_0x19b57b(0x69a)]=new Sprite(ImageManager[_0x19b57b(0x72c)](_0x46f029[_0x19b57b(0x758)])),this[_0x19b57b(0x20e)]=new Sprite(ImageManager[_0x19b57b(0x774)](_0x46f029[_0x19b57b(0x318)])),this[_0x19b57b(0x286)](this['_backSprite1']),this[_0x19b57b(0x286)](this[_0x19b57b(0x20e)]),this['_backSprite1'][_0x19b57b(0x2a9)][_0x19b57b(0x7f0)](this[_0x19b57b(0x89)]['bind'](this,this[_0x19b57b(0x69a)])),this[_0x19b57b(0x20e)][_0x19b57b(0x2a9)][_0x19b57b(0x7f0)](this[_0x19b57b(0x89)][_0x19b57b(0x75d)](this,this['_backSprite2'])));},Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x309)]=function(_0x40ee66){const _0x21ee33=_0x262cbe;return VisuMZ[_0x21ee33(0x244)][_0x21ee33(0x84d)][_0x21ee33(0x4ee)][_0x40ee66]||VisuMZ['CoreEngine'][_0x21ee33(0x84d)]['MenuBg'][_0x21ee33(0xac)];},Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x89)]=function(_0x2c7ae7){const _0x2ec196=_0x262cbe;this[_0x2ec196(0x623)](_0x2c7ae7),this[_0x2ec196(0x2ce)](_0x2c7ae7);},VisuMZ[_0x262cbe(0x244)]['Scene_MenuBase_createCancelButton']=Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x354)],Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x354)]=function(){const _0x303f4e=_0x262cbe;VisuMZ['CoreEngine'][_0x303f4e(0x3ed)]['call'](this),SceneManager[_0x303f4e(0x7be)]()&&this[_0x303f4e(0x7d4)]();},Scene_MenuBase['prototype'][_0x262cbe(0x7d4)]=function(){const _0xad30fc=_0x262cbe;this[_0xad30fc(0x3ad)]['x']=Graphics[_0xad30fc(0x61b)]+0x4;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x57a)]=Scene_MenuBase[_0x262cbe(0x800)]['createPageButtons'],Scene_MenuBase['prototype'][_0x262cbe(0x24e)]=function(){const _0x551bab=_0x262cbe;VisuMZ[_0x551bab(0x244)][_0x551bab(0x57a)][_0x551bab(0x77c)](this),SceneManager[_0x551bab(0x7be)]()&&this[_0x551bab(0x73c)]();},Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x73c)]=function(){const _0x2d5a1e=_0x262cbe;this['_pageupButton']['x']=-0x1*(this[_0x2d5a1e(0x170)]['width']+this[_0x2d5a1e(0x585)][_0x2d5a1e(0x80a)]+0x8),this[_0x2d5a1e(0x585)]['x']=-0x1*(this[_0x2d5a1e(0x585)]['width']+0x4);},Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x122)]=function(){const _0x815e41=_0x262cbe;return VisuMZ[_0x815e41(0x244)]['Settings']['ButtonAssist'][_0x815e41(0x6ec)];},Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x662)]=function(){const _0x4c51a0=_0x262cbe;return SceneManager['isSideButtonLayout']()||SceneManager[_0x4c51a0(0x3d3)]()?VisuMZ['CoreEngine'][_0x4c51a0(0x84d)]['ButtonAssist'][_0x4c51a0(0x41f)]:_0x4c51a0(0x3aa);},Scene_MenuBase[_0x262cbe(0x800)]['createButtonAssistWindow']=function(){const _0x4dde09=_0x262cbe;if(!this[_0x4dde09(0x122)]())return;const _0x487a62=this['buttonAssistWindowRect']();this['_buttonAssistWindow']=new Window_ButtonAssist(_0x487a62),this[_0x4dde09(0x3b7)](this[_0x4dde09(0x7cf)]);},Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x39d)]=function(){const _0x37f031=_0x262cbe;return this['getButtonAssistLocation']()==='button'?this['buttonAssistWindowButtonRect']():this[_0x37f031(0x5e7)]();},Scene_MenuBase[_0x262cbe(0x800)][_0x262cbe(0x806)]=function(){const _0x4e2152=_0x262cbe,_0x948c8e=ConfigManager['touchUI']?(Sprite_Button['prototype'][_0x4e2152(0x27d)]()+0x6)*0x2:0x0,_0x966c28=this[_0x4e2152(0x204)](),_0x3a0234=Graphics['boxWidth']-_0x948c8e*0x2,_0xc97345=this[_0x4e2152(0x4a2)]();return new Rectangle(_0x948c8e,_0x966c28,_0x3a0234,_0xc97345);},Scene_MenuBase['prototype'][_0x262cbe(0x5e7)]=function(){const _0x582e82=_0x262cbe,_0x8154af=Graphics['boxWidth'],_0x4d2b0b=Window_ButtonAssist[_0x582e82(0x800)]['lineHeight'](),_0x3dadeb=0x0;let _0x59aaa7=0x0;return this[_0x582e82(0x662)]()===_0x582e82(0xa0)?_0x59aaa7=0x0:_0x59aaa7=Graphics[_0x582e82(0x9f)]-_0x4d2b0b,new Rectangle(_0x3dadeb,_0x59aaa7,_0x8154af,_0x4d2b0b);},Scene_Menu[_0x262cbe(0x7e0)]=VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x62e)][_0x262cbe(0x2b0)],VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x733)]=Scene_Menu[_0x262cbe(0x800)][_0x262cbe(0x3de)],Scene_Menu[_0x262cbe(0x800)]['create']=function(){const _0x54d8a9=_0x262cbe;VisuMZ[_0x54d8a9(0x244)][_0x54d8a9(0x733)][_0x54d8a9(0x77c)](this),this[_0x54d8a9(0x31d)]();},Scene_Menu[_0x262cbe(0x800)]['setCoreEngineUpdateWindowBg']=function(){const _0x3719b4=_0x262cbe;this[_0x3719b4(0x686)]&&this[_0x3719b4(0x686)][_0x3719b4(0xa6)](Scene_Menu[_0x3719b4(0x7e0)]['CommandBgType']),this[_0x3719b4(0xc3)]&&this[_0x3719b4(0xc3)][_0x3719b4(0xa6)](Scene_Menu[_0x3719b4(0x7e0)][_0x3719b4(0x172)]),this[_0x3719b4(0x330)]&&this[_0x3719b4(0x330)][_0x3719b4(0xa6)](Scene_Menu[_0x3719b4(0x7e0)][_0x3719b4(0x10f)]);},Scene_Menu['prototype']['commandWindowRect']=function(){const _0xb84199=_0x262cbe;return Scene_Menu[_0xb84199(0x7e0)][_0xb84199(0x746)][_0xb84199(0x77c)](this);},Scene_Menu[_0x262cbe(0x800)][_0x262cbe(0x24c)]=function(){const _0x18e3ee=_0x262cbe;return Scene_Menu[_0x18e3ee(0x7e0)][_0x18e3ee(0x530)][_0x18e3ee(0x77c)](this);},Scene_Menu[_0x262cbe(0x800)][_0x262cbe(0x403)]=function(){const _0x45c489=_0x262cbe;return Scene_Menu[_0x45c489(0x7e0)]['StatusRect'][_0x45c489(0x77c)](this);},Scene_Item[_0x262cbe(0x7e0)]=VisuMZ[_0x262cbe(0x244)]['Settings'][_0x262cbe(0x62e)][_0x262cbe(0x533)],VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x633)]=Scene_Item[_0x262cbe(0x800)][_0x262cbe(0x3de)],Scene_Item['prototype'][_0x262cbe(0x3de)]=function(){const _0x5b0c6e=_0x262cbe;VisuMZ[_0x5b0c6e(0x244)][_0x5b0c6e(0x633)][_0x5b0c6e(0x77c)](this),this[_0x5b0c6e(0x31d)]();},Scene_Item[_0x262cbe(0x800)][_0x262cbe(0x31d)]=function(){const _0x4fec47=_0x262cbe;this[_0x4fec47(0x48f)]&&this[_0x4fec47(0x48f)][_0x4fec47(0xa6)](Scene_Item[_0x4fec47(0x7e0)]['HelpBgType']),this['_categoryWindow']&&this[_0x4fec47(0x5fa)][_0x4fec47(0xa6)](Scene_Item[_0x4fec47(0x7e0)][_0x4fec47(0x281)]),this[_0x4fec47(0x15e)]&&this['_itemWindow'][_0x4fec47(0xa6)](Scene_Item[_0x4fec47(0x7e0)][_0x4fec47(0x361)]),this[_0x4fec47(0x272)]&&this[_0x4fec47(0x272)]['setBackgroundType'](Scene_Item[_0x4fec47(0x7e0)][_0x4fec47(0x5fc)]);},Scene_Item[_0x262cbe(0x800)]['helpWindowRect']=function(){const _0x414c65=_0x262cbe;return Scene_Item[_0x414c65(0x7e0)][_0x414c65(0x2f9)][_0x414c65(0x77c)](this);},Scene_Item[_0x262cbe(0x800)][_0x262cbe(0x744)]=function(){const _0x5a267d=_0x262cbe;return Scene_Item[_0x5a267d(0x7e0)]['CategoryRect']['call'](this);},Scene_Item['prototype'][_0x262cbe(0x622)]=function(){const _0x3bd22a=_0x262cbe;return Scene_Item[_0x3bd22a(0x7e0)][_0x3bd22a(0x5df)][_0x3bd22a(0x77c)](this);},Scene_Item['prototype'][_0x262cbe(0x6b5)]=function(){const _0x4d68d5=_0x262cbe;return Scene_Item[_0x4d68d5(0x7e0)][_0x4d68d5(0x6a9)][_0x4d68d5(0x77c)](this);},Scene_Skill[_0x262cbe(0x7e0)]=VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x62e)][_0x262cbe(0x73e)],VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x4fd)]=Scene_Skill[_0x262cbe(0x800)][_0x262cbe(0x3de)],Scene_Skill['prototype'][_0x262cbe(0x3de)]=function(){const _0x1777a7=_0x262cbe;VisuMZ[_0x1777a7(0x244)][_0x1777a7(0x4fd)]['call'](this),this[_0x1777a7(0x31d)]();},Scene_Skill[_0x262cbe(0x800)][_0x262cbe(0x31d)]=function(){const _0x407b9b=_0x262cbe;this[_0x407b9b(0x48f)]&&this[_0x407b9b(0x48f)]['setBackgroundType'](Scene_Skill[_0x407b9b(0x7e0)][_0x407b9b(0x4ba)]),this[_0x407b9b(0x3b6)]&&this[_0x407b9b(0x3b6)]['setBackgroundType'](Scene_Skill[_0x407b9b(0x7e0)][_0x407b9b(0x5fb)]),this[_0x407b9b(0x330)]&&this[_0x407b9b(0x330)][_0x407b9b(0xa6)](Scene_Skill[_0x407b9b(0x7e0)][_0x407b9b(0x10f)]),this[_0x407b9b(0x15e)]&&this[_0x407b9b(0x15e)]['setBackgroundType'](Scene_Skill[_0x407b9b(0x7e0)][_0x407b9b(0x361)]),this[_0x407b9b(0x272)]&&this[_0x407b9b(0x272)][_0x407b9b(0xa6)](Scene_Skill['layoutSettings'][_0x407b9b(0x5fc)]);},Scene_Skill[_0x262cbe(0x800)]['helpWindowRect']=function(){const _0x27c010=_0x262cbe;return Scene_Skill[_0x27c010(0x7e0)][_0x27c010(0x2f9)]['call'](this);},Scene_Skill[_0x262cbe(0x800)]['skillTypeWindowRect']=function(){const _0x13ca6d=_0x262cbe;return Scene_Skill['layoutSettings'][_0x13ca6d(0x3a0)][_0x13ca6d(0x77c)](this);},Scene_Skill[_0x262cbe(0x800)][_0x262cbe(0x403)]=function(){const _0x166471=_0x262cbe;return Scene_Skill['layoutSettings']['StatusRect'][_0x166471(0x77c)](this);},Scene_Skill[_0x262cbe(0x800)][_0x262cbe(0x622)]=function(){const _0x338b35=_0x262cbe;return Scene_Skill[_0x338b35(0x7e0)]['ItemRect']['call'](this);},Scene_Skill[_0x262cbe(0x800)]['actorWindowRect']=function(){const _0x31e06f=_0x262cbe;return Scene_Skill[_0x31e06f(0x7e0)]['ActorRect'][_0x31e06f(0x77c)](this);},Scene_Equip[_0x262cbe(0x7e0)]=VisuMZ[_0x262cbe(0x244)]['Settings'][_0x262cbe(0x62e)][_0x262cbe(0x23a)],VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x853)]=Scene_Equip[_0x262cbe(0x800)][_0x262cbe(0x3de)],Scene_Equip['prototype']['create']=function(){const _0x12ab5b=_0x262cbe;VisuMZ['CoreEngine']['Scene_Equip_create'][_0x12ab5b(0x77c)](this),this['setCoreEngineUpdateWindowBg']();},Scene_Equip[_0x262cbe(0x800)][_0x262cbe(0x31d)]=function(){const _0x2b0582=_0x262cbe;this[_0x2b0582(0x48f)]&&this[_0x2b0582(0x48f)]['setBackgroundType'](Scene_Equip[_0x2b0582(0x7e0)][_0x2b0582(0x4ba)]),this[_0x2b0582(0x330)]&&this['_statusWindow'][_0x2b0582(0xa6)](Scene_Equip[_0x2b0582(0x7e0)][_0x2b0582(0x10f)]),this['_commandWindow']&&this[_0x2b0582(0x686)][_0x2b0582(0xa6)](Scene_Equip[_0x2b0582(0x7e0)][_0x2b0582(0x2d5)]),this[_0x2b0582(0x1ba)]&&this['_slotWindow'][_0x2b0582(0xa6)](Scene_Equip[_0x2b0582(0x7e0)][_0x2b0582(0x7a9)]),this[_0x2b0582(0x15e)]&&this[_0x2b0582(0x15e)][_0x2b0582(0xa6)](Scene_Equip[_0x2b0582(0x7e0)]['ItemBgType']);},Scene_Equip[_0x262cbe(0x800)]['helpWindowRect']=function(){const _0x4f568c=_0x262cbe;return Scene_Equip[_0x4f568c(0x7e0)][_0x4f568c(0x2f9)][_0x4f568c(0x77c)](this);},Scene_Equip[_0x262cbe(0x800)][_0x262cbe(0x403)]=function(){const _0x3c3121=_0x262cbe;return Scene_Equip['layoutSettings'][_0x3c3121(0x6d6)]['call'](this);},Scene_Equip[_0x262cbe(0x800)][_0x262cbe(0x5c8)]=function(){const _0xbf8346=_0x262cbe;return Scene_Equip[_0xbf8346(0x7e0)][_0xbf8346(0x746)]['call'](this);},Scene_Equip[_0x262cbe(0x800)][_0x262cbe(0x20c)]=function(){const _0x56fab0=_0x262cbe;return Scene_Equip[_0x56fab0(0x7e0)][_0x56fab0(0x6b1)][_0x56fab0(0x77c)](this);},Scene_Equip[_0x262cbe(0x800)][_0x262cbe(0x622)]=function(){const _0x64f16=_0x262cbe;return Scene_Equip['layoutSettings']['ItemRect'][_0x64f16(0x77c)](this);},Scene_Status['layoutSettings']=VisuMZ[_0x262cbe(0x244)]['Settings'][_0x262cbe(0x62e)][_0x262cbe(0x284)],VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x37f)]=Scene_Status['prototype'][_0x262cbe(0x3de)],Scene_Status[_0x262cbe(0x800)][_0x262cbe(0x3de)]=function(){const _0xa39274=_0x262cbe;VisuMZ['CoreEngine'][_0xa39274(0x37f)][_0xa39274(0x77c)](this),this['setCoreEngineUpdateWindowBg']();},Scene_Status[_0x262cbe(0x800)][_0x262cbe(0x31d)]=function(){const _0x4af00c=_0x262cbe;this['_profileWindow']&&this[_0x4af00c(0x52d)][_0x4af00c(0xa6)](Scene_Status['layoutSettings']['ProfileBgType']),this['_statusWindow']&&this['_statusWindow'][_0x4af00c(0xa6)](Scene_Status[_0x4af00c(0x7e0)][_0x4af00c(0x10f)]),this[_0x4af00c(0x3fb)]&&this[_0x4af00c(0x3fb)]['setBackgroundType'](Scene_Status[_0x4af00c(0x7e0)][_0x4af00c(0x211)]),this[_0x4af00c(0x55d)]&&this[_0x4af00c(0x55d)]['setBackgroundType'](Scene_Status[_0x4af00c(0x7e0)][_0x4af00c(0x762)]);},Scene_Status['prototype'][_0x262cbe(0x246)]=function(){const _0x558af7=_0x262cbe;return Scene_Status[_0x558af7(0x7e0)]['ProfileRect'][_0x558af7(0x77c)](this);},Scene_Status[_0x262cbe(0x800)][_0x262cbe(0x403)]=function(){const _0x1b2531=_0x262cbe;return Scene_Status['layoutSettings'][_0x1b2531(0x6d6)]['call'](this);},Scene_Status[_0x262cbe(0x800)][_0x262cbe(0x458)]=function(){const _0x80569b=_0x262cbe;return Scene_Status[_0x80569b(0x7e0)][_0x80569b(0x586)][_0x80569b(0x77c)](this);},Scene_Status[_0x262cbe(0x800)][_0x262cbe(0x38e)]=function(){const _0x265ede=_0x262cbe;return Scene_Status[_0x265ede(0x7e0)][_0x265ede(0x608)][_0x265ede(0x77c)](this);},Scene_Options[_0x262cbe(0x7e0)]=VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x62e)]['OptionsMenu'],VisuMZ[_0x262cbe(0x244)]['Scene_Options_create']=Scene_Options[_0x262cbe(0x800)][_0x262cbe(0x3de)],Scene_Options[_0x262cbe(0x800)][_0x262cbe(0x3de)]=function(){const _0x421abf=_0x262cbe;VisuMZ[_0x421abf(0x244)][_0x421abf(0x4db)]['call'](this),this['setCoreEngineUpdateWindowBg']();},Scene_Options[_0x262cbe(0x800)][_0x262cbe(0x31d)]=function(){const _0x2e6b3c=_0x262cbe;this[_0x2e6b3c(0x7a4)]&&this[_0x2e6b3c(0x7a4)][_0x2e6b3c(0xa6)](Scene_Options[_0x2e6b3c(0x7e0)][_0x2e6b3c(0x3e0)]);},Scene_Options[_0x262cbe(0x800)][_0x262cbe(0x4de)]=function(){const _0x380af8=_0x262cbe;return Scene_Options[_0x380af8(0x7e0)][_0x380af8(0x349)][_0x380af8(0x77c)](this);},Scene_Save['layoutSettings']=VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x62e)][_0x262cbe(0x75b)],Scene_Save['prototype'][_0x262cbe(0x3de)]=function(){const _0x205afe=_0x262cbe;Scene_File[_0x205afe(0x800)][_0x205afe(0x3de)][_0x205afe(0x77c)](this),this['setCoreEngineUpdateWindowBg']();},Scene_Save[_0x262cbe(0x800)][_0x262cbe(0x31d)]=function(){const _0x566ef3=_0x262cbe;this[_0x566ef3(0x48f)]&&this[_0x566ef3(0x48f)][_0x566ef3(0xa6)](Scene_Save['layoutSettings'][_0x566ef3(0x4ba)]),this[_0x566ef3(0x50c)]&&this[_0x566ef3(0x50c)][_0x566ef3(0xa6)](Scene_Save['layoutSettings'][_0x566ef3(0x4c9)]);},Scene_Save['prototype'][_0x262cbe(0x461)]=function(){const _0x2a0517=_0x262cbe;return Scene_Save['layoutSettings']['HelpRect'][_0x2a0517(0x77c)](this);},Scene_Save[_0x262cbe(0x800)][_0x262cbe(0x77a)]=function(){const _0x4068be=_0x262cbe;return Scene_Save[_0x4068be(0x7e0)]['ListRect'][_0x4068be(0x77c)](this);},Scene_Load[_0x262cbe(0x7e0)]=VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x62e)][_0x262cbe(0x1fc)],Scene_Load[_0x262cbe(0x800)][_0x262cbe(0x3de)]=function(){const _0x1ec516=_0x262cbe;Scene_File[_0x1ec516(0x800)][_0x1ec516(0x3de)][_0x1ec516(0x77c)](this),this[_0x1ec516(0x31d)]();},Scene_Load[_0x262cbe(0x800)][_0x262cbe(0x31d)]=function(){const _0x4a00c2=_0x262cbe;this[_0x4a00c2(0x48f)]&&this['_helpWindow']['setBackgroundType'](Scene_Load['layoutSettings'][_0x4a00c2(0x4ba)]),this[_0x4a00c2(0x50c)]&&this['_listWindow'][_0x4a00c2(0xa6)](Scene_Load['layoutSettings'][_0x4a00c2(0x4c9)]);},Scene_Load[_0x262cbe(0x800)]['helpWindowRect']=function(){const _0x21084d=_0x262cbe;return Scene_Load[_0x21084d(0x7e0)]['HelpRect']['call'](this);},Scene_Load['prototype'][_0x262cbe(0x77a)]=function(){const _0x5847cc=_0x262cbe;return Scene_Load[_0x5847cc(0x7e0)]['ListRect']['call'](this);};function _0x3598(_0x73c0c9,_0x4519c7){const _0x448665=_0x4486();return _0x3598=function(_0x3598e0,_0x4d88ee){_0x3598e0=_0x3598e0-0x78;let _0x55a8d2=_0x448665[_0x3598e0];return _0x55a8d2;},_0x3598(_0x73c0c9,_0x4519c7);}function Scene_QuickLoad(){const _0x32f6e6=_0x262cbe;this[_0x32f6e6(0x1ad)](...arguments);}Scene_QuickLoad[_0x262cbe(0x800)]=Object[_0x262cbe(0x3de)](Scene_Load[_0x262cbe(0x800)]),Scene_QuickLoad[_0x262cbe(0x800)][_0x262cbe(0x1ea)]=Scene_QuickLoad,Scene_QuickLoad['prototype']['initialize']=function(){const _0x4aaaa5=_0x262cbe;Scene_Load['prototype']['initialize'][_0x4aaaa5(0x77c)](this);},Scene_QuickLoad[_0x262cbe(0x800)][_0x262cbe(0x3de)]=function(){const _0x2507ce=_0x262cbe;this[_0x2507ce(0x24a)](this[_0x2507ce(0x590)]);},Scene_QuickLoad[_0x262cbe(0x800)]['prepare']=function(_0x3d2598){this['_saveFileID']=_0x3d2598;},Scene_QuickLoad[_0x262cbe(0x800)][_0x262cbe(0x4eb)]=function(){const _0x156c10=_0x262cbe;Scene_MenuBase[_0x156c10(0x800)][_0x156c10(0x4eb)]['call'](this);},Scene_GameEnd[_0x262cbe(0x7e0)]=VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)]['MenuLayout'][_0x262cbe(0x4e6)],VisuMZ[_0x262cbe(0x244)]['Scene_GameEnd_createBackground']=Scene_GameEnd[_0x262cbe(0x800)][_0x262cbe(0xc7)],Scene_GameEnd[_0x262cbe(0x800)]['createBackground']=function(){const _0x3ce176=_0x262cbe;Scene_MenuBase[_0x3ce176(0x800)]['createBackground'][_0x3ce176(0x77c)](this);},Scene_GameEnd[_0x262cbe(0x800)][_0x262cbe(0x53f)]=function(){const _0x5d8a09=_0x262cbe,_0x54efd3=this[_0x5d8a09(0x5c8)]();this[_0x5d8a09(0x686)]=new Window_GameEnd(_0x54efd3),this[_0x5d8a09(0x686)][_0x5d8a09(0x5b1)]('cancel',this[_0x5d8a09(0x5ae)][_0x5d8a09(0x75d)](this)),this[_0x5d8a09(0x3b7)](this['_commandWindow']),this[_0x5d8a09(0x686)][_0x5d8a09(0xa6)](Scene_GameEnd[_0x5d8a09(0x7e0)][_0x5d8a09(0x2d5)]);},Scene_GameEnd['prototype']['commandWindowRect']=function(){const _0x486c85=_0x262cbe;return Scene_GameEnd[_0x486c85(0x7e0)][_0x486c85(0x746)]['call'](this);},Scene_Shop[_0x262cbe(0x7e0)]=VisuMZ['CoreEngine'][_0x262cbe(0x84d)][_0x262cbe(0x62e)][_0x262cbe(0x112)],VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x741)]=Scene_Shop['prototype'][_0x262cbe(0x3de)],Scene_Shop[_0x262cbe(0x800)][_0x262cbe(0x3de)]=function(){const _0x6c5615=_0x262cbe;VisuMZ[_0x6c5615(0x244)][_0x6c5615(0x741)][_0x6c5615(0x77c)](this),this[_0x6c5615(0x31d)]();},Scene_Shop[_0x262cbe(0x800)][_0x262cbe(0x31d)]=function(){const _0x276e1a=_0x262cbe;this[_0x276e1a(0x48f)]&&this[_0x276e1a(0x48f)][_0x276e1a(0xa6)](Scene_Shop[_0x276e1a(0x7e0)][_0x276e1a(0x4ba)]),this['_goldWindow']&&this[_0x276e1a(0xc3)]['setBackgroundType'](Scene_Shop[_0x276e1a(0x7e0)][_0x276e1a(0x172)]),this['_commandWindow']&&this['_commandWindow'][_0x276e1a(0xa6)](Scene_Shop['layoutSettings']['CommandBgType']),this['_dummyWindow']&&this[_0x276e1a(0x45e)][_0x276e1a(0xa6)](Scene_Shop[_0x276e1a(0x7e0)][_0x276e1a(0x42e)]),this[_0x276e1a(0x18e)]&&this[_0x276e1a(0x18e)][_0x276e1a(0xa6)](Scene_Shop[_0x276e1a(0x7e0)]['NumberBgType']),this[_0x276e1a(0x330)]&&this[_0x276e1a(0x330)][_0x276e1a(0xa6)](Scene_Shop['layoutSettings']['StatusBgType']),this['_buyWindow']&&this[_0x276e1a(0x827)][_0x276e1a(0xa6)](Scene_Shop[_0x276e1a(0x7e0)][_0x276e1a(0x77f)]),this[_0x276e1a(0x5fa)]&&this[_0x276e1a(0x5fa)][_0x276e1a(0xa6)](Scene_Shop[_0x276e1a(0x7e0)][_0x276e1a(0x281)]),this['_sellWindow']&&this['_sellWindow'][_0x276e1a(0xa6)](Scene_Shop[_0x276e1a(0x7e0)][_0x276e1a(0x291)]);},Scene_Shop['prototype'][_0x262cbe(0x461)]=function(){const _0x4b1293=_0x262cbe;return Scene_Shop[_0x4b1293(0x7e0)][_0x4b1293(0x2f9)][_0x4b1293(0x77c)](this);},Scene_Shop['prototype'][_0x262cbe(0x24c)]=function(){const _0x32d0fd=_0x262cbe;return Scene_Shop[_0x32d0fd(0x7e0)][_0x32d0fd(0x530)][_0x32d0fd(0x77c)](this);},Scene_Shop[_0x262cbe(0x800)]['commandWindowRect']=function(){const _0x1fe960=_0x262cbe;return Scene_Shop['layoutSettings']['CommandRect'][_0x1fe960(0x77c)](this);},Scene_Shop['prototype'][_0x262cbe(0x332)]=function(){const _0x546041=_0x262cbe;return Scene_Shop['layoutSettings']['DummyRect'][_0x546041(0x77c)](this);},Scene_Shop['prototype']['numberWindowRect']=function(){const _0x1d268b=_0x262cbe;return Scene_Shop[_0x1d268b(0x7e0)][_0x1d268b(0x243)][_0x1d268b(0x77c)](this);},Scene_Shop['prototype'][_0x262cbe(0x403)]=function(){const _0xd8eb72=_0x262cbe;return Scene_Shop[_0xd8eb72(0x7e0)][_0xd8eb72(0x6d6)][_0xd8eb72(0x77c)](this);},Scene_Shop['prototype']['buyWindowRect']=function(){const _0x262515=_0x262cbe;return Scene_Shop[_0x262515(0x7e0)][_0x262515(0x7ce)][_0x262515(0x77c)](this);},Scene_Shop[_0x262cbe(0x800)][_0x262cbe(0x744)]=function(){const _0x3714a6=_0x262cbe;return Scene_Shop[_0x3714a6(0x7e0)][_0x3714a6(0x8b)][_0x3714a6(0x77c)](this);},Scene_Shop[_0x262cbe(0x800)][_0x262cbe(0x55b)]=function(){const _0x492d1c=_0x262cbe;return Scene_Shop['layoutSettings']['SellRect'][_0x492d1c(0x77c)](this);},Scene_Name[_0x262cbe(0x7e0)]=VisuMZ[_0x262cbe(0x244)]['Settings']['MenuLayout'][_0x262cbe(0x4c6)],VisuMZ[_0x262cbe(0x244)]['Scene_Name_create']=Scene_Name['prototype'][_0x262cbe(0x3de)],Scene_Name['prototype'][_0x262cbe(0x3de)]=function(){const _0x3bdeef=_0x262cbe;VisuMZ[_0x3bdeef(0x244)][_0x3bdeef(0x1cf)][_0x3bdeef(0x77c)](this),this[_0x3bdeef(0x31d)]();},Scene_Name[_0x262cbe(0x800)][_0x262cbe(0x31d)]=function(){const _0x4d904d=_0x262cbe;this['_editWindow']&&this[_0x4d904d(0xf3)]['setBackgroundType'](Scene_Name[_0x4d904d(0x7e0)]['EditBgType']),this[_0x4d904d(0xb2)]&&this[_0x4d904d(0xb2)][_0x4d904d(0xa6)](Scene_Name[_0x4d904d(0x7e0)][_0x4d904d(0x271)]);},Scene_Name[_0x262cbe(0x800)]['helpAreaHeight']=function(){return 0x0;},Scene_Name['prototype'][_0x262cbe(0x714)]=function(){const _0x97f635=_0x262cbe;return Scene_Name[_0x97f635(0x7e0)]['EditRect'][_0x97f635(0x77c)](this);},Scene_Name[_0x262cbe(0x800)][_0x262cbe(0x86)]=function(){const _0x3c4fa5=_0x262cbe;return Scene_Name[_0x3c4fa5(0x7e0)][_0x3c4fa5(0x167)][_0x3c4fa5(0x77c)](this);},Scene_Name['prototype']['EnableNameInput']=function(){const _0x1d6b98=_0x262cbe;if(!this[_0x1d6b98(0xb2)])return![];return VisuMZ[_0x1d6b98(0x244)][_0x1d6b98(0x84d)][_0x1d6b98(0x67f)][_0x1d6b98(0x1de)];},Scene_Name[_0x262cbe(0x800)][_0x262cbe(0x3d5)]=function(){const _0x4b9e1e=_0x262cbe;if(this['EnableNameInput']()&&this['_inputWindow']['_mode']!=='keyboard')return TextManager[_0x4b9e1e(0x579)]('pageup',_0x4b9e1e(0x9e));return Scene_MenuBase[_0x4b9e1e(0x800)][_0x4b9e1e(0x3d5)][_0x4b9e1e(0x77c)](this);},Scene_Name[_0x262cbe(0x800)][_0x262cbe(0x147)]=function(){const _0x52ebdb=_0x262cbe;return this['EnableNameInput']()?TextManager['getInputButtonString']('tab'):Scene_MenuBase[_0x52ebdb(0x800)][_0x52ebdb(0x147)]['call'](this);},Scene_Name[_0x262cbe(0x800)][_0x262cbe(0x389)]=function(){const _0x242d68=_0x262cbe;if(this['EnableNameInput']()&&this[_0x242d68(0xb2)]['_mode']==='keyboard')return TextManager[_0x242d68(0x3a5)]([_0x242d68(0x7a0)]);return Scene_MenuBase[_0x242d68(0x800)][_0x242d68(0x389)]['call'](this);},Scene_Name[_0x262cbe(0x800)][_0x262cbe(0x6c8)]=function(){const _0x2157e3=_0x262cbe;if(this[_0x2157e3(0x1de)]()&&this['_inputWindow'][_0x2157e3(0x7c7)]===_0x2157e3(0x570))return TextManager[_0x2157e3(0x3a5)]([_0x2157e3(0x26a)]);return Scene_MenuBase[_0x2157e3(0x800)][_0x2157e3(0x6c8)]['call'](this);},Scene_Name[_0x262cbe(0x800)][_0x262cbe(0xc9)]=function(){const _0x4ebd77=_0x262cbe;if(this[_0x4ebd77(0x1de)]()&&this[_0x4ebd77(0xb2)][_0x4ebd77(0x7c7)]!==_0x4ebd77(0x570)){const _0x4c4e7a=VisuMZ[_0x4ebd77(0x244)][_0x4ebd77(0x84d)][_0x4ebd77(0x67f)];return _0x4c4e7a[_0x4ebd77(0x655)]||_0x4ebd77(0x2a5);}return Scene_MenuBase[_0x4ebd77(0x800)][_0x4ebd77(0xc9)][_0x4ebd77(0x77c)](this);},Scene_Name[_0x262cbe(0x800)]['buttonAssistText3']=function(){const _0x5d1cc5=_0x262cbe;if(this[_0x5d1cc5(0x1de)]()){const _0x79b855=VisuMZ[_0x5d1cc5(0x244)]['Settings'][_0x5d1cc5(0x67f)];return this[_0x5d1cc5(0xb2)][_0x5d1cc5(0x7c7)]===_0x5d1cc5(0x570)?_0x79b855['Keyboard']||_0x5d1cc5(0x1ce):_0x79b855[_0x5d1cc5(0x705)]||_0x5d1cc5(0x705);}else return Scene_MenuBase[_0x5d1cc5(0x800)][_0x5d1cc5(0x2cb)][_0x5d1cc5(0x77c)](this);},Scene_Name[_0x262cbe(0x800)][_0x262cbe(0x556)]=function(){const _0x13e36b=_0x262cbe;if(this[_0x13e36b(0x1de)]()){const _0xd4da29=VisuMZ['CoreEngine'][_0x13e36b(0x84d)]['KeyboardInput'];if(this[_0x13e36b(0xb2)][_0x13e36b(0x7c7)]==='keyboard')return _0xd4da29[_0x13e36b(0x65d)]||_0x13e36b(0x65d);}return Scene_MenuBase[_0x13e36b(0x800)][_0x13e36b(0x556)][_0x13e36b(0x77c)](this);},VisuMZ[_0x262cbe(0x244)]['Scene_Name_onInputOk']=Scene_Name[_0x262cbe(0x800)][_0x262cbe(0x27f)],Scene_Name[_0x262cbe(0x800)][_0x262cbe(0x27f)]=function(){const _0x2ecd2f=_0x262cbe;this[_0x2ecd2f(0x25b)]()?this[_0x2ecd2f(0x140)]():VisuMZ[_0x2ecd2f(0x244)][_0x2ecd2f(0x29b)][_0x2ecd2f(0x77c)](this);},Scene_Name[_0x262cbe(0x800)]['doesNameContainBannedWords']=function(){const _0xf0690=_0x262cbe,_0x87299b=VisuMZ[_0xf0690(0x244)][_0xf0690(0x84d)]['KeyboardInput'];if(!_0x87299b)return![];const _0x2593eb=_0x87299b[_0xf0690(0x1df)];if(!_0x2593eb)return![];const _0x152554=this[_0xf0690(0xf3)][_0xf0690(0x84e)]()[_0xf0690(0x218)]();for(const _0x3f09e8 of _0x2593eb){if(_0x152554[_0xf0690(0x14c)](_0x3f09e8[_0xf0690(0x218)]()))return!![];}return![];},Scene_Name[_0x262cbe(0x800)][_0x262cbe(0x140)]=function(){SoundManager['playBuzzer']();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x4e2)]=Scene_Battle[_0x262cbe(0x800)][_0x262cbe(0x64e)],Scene_Battle[_0x262cbe(0x800)][_0x262cbe(0x64e)]=function(){const _0x28c410=_0x262cbe;VisuMZ[_0x28c410(0x244)][_0x28c410(0x4e2)][_0x28c410(0x77c)](this);if($gameTemp[_0x28c410(0x374)])this[_0x28c410(0x296)]();},Scene_Battle[_0x262cbe(0x800)][_0x262cbe(0x296)]=function(){const _0x40568e=_0x262cbe;!BattleManager[_0x40568e(0x4a0)]()&&!this[_0x40568e(0x5ac)]&&!$gameMessage[_0x40568e(0x212)]()&&(this[_0x40568e(0x5ac)]=!![],this[_0x40568e(0x64e)](),SceneManager[_0x40568e(0x5e1)](),this['_playtestF7Looping']=![]);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x3cb)]=Scene_Battle['prototype']['createCancelButton'],Scene_Battle['prototype']['createCancelButton']=function(){const _0x3fcc6c=_0x262cbe;VisuMZ[_0x3fcc6c(0x244)][_0x3fcc6c(0x3cb)][_0x3fcc6c(0x77c)](this),SceneManager[_0x3fcc6c(0x7be)]()&&this[_0x3fcc6c(0x308)]();},Scene_Battle[_0x262cbe(0x800)][_0x262cbe(0x308)]=function(){const _0xec560b=_0x262cbe;this[_0xec560b(0x3ad)]['x']=Graphics['boxWidth']+0x4,this[_0xec560b(0x11a)]()?this[_0xec560b(0x3ad)]['y']=Graphics[_0xec560b(0x9f)]-this[_0xec560b(0x4a2)]():this['_cancelButton']['y']=0x0;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x241)]=Sprite_Button[_0x262cbe(0x800)][_0x262cbe(0x1ad)],Sprite_Button[_0x262cbe(0x800)][_0x262cbe(0x1ad)]=function(_0x3fe694){const _0x5f49ef=_0x262cbe;VisuMZ['CoreEngine'][_0x5f49ef(0x241)][_0x5f49ef(0x77c)](this,_0x3fe694),this['initButtonHidden']();},Sprite_Button['prototype'][_0x262cbe(0x78a)]=function(){const _0x33a6c2=_0x262cbe,_0x4fafaa=VisuMZ['CoreEngine'][_0x33a6c2(0x84d)]['UI'];this['_isButtonHidden']=![];switch(this['_buttonType']){case _0x33a6c2(0x166):this[_0x33a6c2(0x44a)]=!_0x4fafaa[_0x33a6c2(0x630)];break;case _0x33a6c2(0x797):case'pagedown':this['_isButtonHidden']=!_0x4fafaa[_0x33a6c2(0x399)];break;case _0x33a6c2(0x557):case'up':case _0x33a6c2(0xb9):case'up2':case'ok':this[_0x33a6c2(0x44a)]=!_0x4fafaa[_0x33a6c2(0x38c)];break;case _0x33a6c2(0x2e4):this[_0x33a6c2(0x44a)]=!_0x4fafaa['menuShowButton'];break;}},VisuMZ[_0x262cbe(0x244)]['Sprite_Button_updateOpacity']=Sprite_Button[_0x262cbe(0x800)]['updateOpacity'],Sprite_Button[_0x262cbe(0x800)][_0x262cbe(0x45d)]=function(){const _0xfbe813=_0x262cbe;SceneManager[_0xfbe813(0x3d3)]()||this['_isButtonHidden']?this[_0xfbe813(0x80b)]():VisuMZ[_0xfbe813(0x244)]['Sprite_Button_updateOpacity'][_0xfbe813(0x77c)](this);},Sprite_Button[_0x262cbe(0x800)]['hideButtonFromView']=function(){const _0x390e2d=_0x262cbe;this['visible']=![],this[_0x390e2d(0x2b3)]=0x0,this['x']=Graphics['width']*0xa,this['y']=Graphics[_0x390e2d(0x100)]*0xa;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x761)]=Sprite_Battler[_0x262cbe(0x800)]['startMove'],Sprite_Battler[_0x262cbe(0x800)][_0x262cbe(0x62d)]=function(_0xba84af,_0x446224,_0x2a4b35){const _0x376fe7=_0x262cbe;(this[_0x376fe7(0x20b)]!==_0xba84af||this[_0x376fe7(0x136)]!==_0x446224)&&(this[_0x376fe7(0x6d0)](_0x376fe7(0x7c1)),this[_0x376fe7(0x60a)]=_0x2a4b35),VisuMZ[_0x376fe7(0x244)][_0x376fe7(0x761)]['call'](this,_0xba84af,_0x446224,_0x2a4b35);},Sprite_Battler[_0x262cbe(0x800)][_0x262cbe(0x6d0)]=function(_0x1484b3){const _0x11fe14=_0x262cbe;this[_0x11fe14(0x2ed)]=_0x1484b3;},Sprite_Battler[_0x262cbe(0x800)][_0x262cbe(0x688)]=function(){const _0x4b3131=_0x262cbe;if(this[_0x4b3131(0x7ec)]<=0x0)return;const _0x29b1e3=this['_movementDuration'],_0xbbebac=this[_0x4b3131(0x60a)],_0x4e424d=this[_0x4b3131(0x2ed)];this[_0x4b3131(0x2d0)]=this[_0x4b3131(0xad)](this[_0x4b3131(0x2d0)],this['_targetOffsetX'],_0x29b1e3,_0xbbebac,_0x4e424d),this[_0x4b3131(0x7d7)]=this['applyEasing'](this['_offsetY'],this[_0x4b3131(0x136)],_0x29b1e3,_0xbbebac,_0x4e424d),this['_movementDuration']--;if(this[_0x4b3131(0x7ec)]<=0x0)this[_0x4b3131(0x619)]();},Sprite_Battler[_0x262cbe(0x800)]['applyEasing']=function(_0x2b76a4,_0x25809f,_0x3f82b5,_0x4688d0,_0x127bf0){const _0x59c51d=_0x262cbe,_0x54328c=VisuMZ[_0x59c51d(0x152)]((_0x4688d0-_0x3f82b5)/_0x4688d0,_0x127bf0||'Linear'),_0xe17109=VisuMZ[_0x59c51d(0x152)]((_0x4688d0-_0x3f82b5+0x1)/_0x4688d0,_0x127bf0||_0x59c51d(0x7c1)),_0x25dc82=(_0x2b76a4-_0x25809f*_0x54328c)/(0x1-_0x54328c);return _0x25dc82+(_0x25809f-_0x25dc82)*_0xe17109;},VisuMZ['CoreEngine']['Sprite_Actor_setActorHome']=Sprite_Actor['prototype']['setActorHome'],Sprite_Actor[_0x262cbe(0x800)][_0x262cbe(0x635)]=function(_0x478544){const _0x1ecdeb=_0x262cbe;VisuMZ[_0x1ecdeb(0x244)][_0x1ecdeb(0x84d)]['UI'][_0x1ecdeb(0x587)]?this[_0x1ecdeb(0x51e)](_0x478544):VisuMZ[_0x1ecdeb(0x244)][_0x1ecdeb(0x48a)][_0x1ecdeb(0x77c)](this,_0x478544);},Sprite_Actor[_0x262cbe(0x800)][_0x262cbe(0x51e)]=function(_0x2f859a){const _0x1bf86e=_0x262cbe;let _0x4e644a=Math[_0x1bf86e(0x38d)](Graphics[_0x1bf86e(0x80a)]/0x2+0xc0);_0x4e644a-=Math['floor']((Graphics[_0x1bf86e(0x80a)]-Graphics[_0x1bf86e(0x61b)])/0x2),_0x4e644a+=_0x2f859a*0x20;let _0x3ded64=Graphics[_0x1bf86e(0x100)]-0xc8-$gameParty[_0x1bf86e(0x276)]()*0x30;_0x3ded64-=Math[_0x1bf86e(0x431)]((Graphics[_0x1bf86e(0x100)]-Graphics[_0x1bf86e(0x9f)])/0x2),_0x3ded64+=_0x2f859a*0x30,this[_0x1bf86e(0x238)](_0x4e644a,_0x3ded64);},Sprite_Actor[_0x262cbe(0x800)]['retreat']=function(){const _0x3f4f9c=_0x262cbe;this[_0x3f4f9c(0x62d)](0x4b0,0x0,0x78);},Sprite_Animation[_0x262cbe(0x800)][_0x262cbe(0x44e)]=function(_0x533328){this['_muteSound']=_0x533328;},VisuMZ['CoreEngine'][_0x262cbe(0x24f)]=Sprite_Animation[_0x262cbe(0x800)][_0x262cbe(0x44c)],Sprite_Animation[_0x262cbe(0x800)][_0x262cbe(0x44c)]=function(){const _0x4199aa=_0x262cbe;if(this[_0x4199aa(0x226)])return;VisuMZ[_0x4199aa(0x244)]['Sprite_Animation_processSoundTimings'][_0x4199aa(0x77c)](this);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x4e8)]=Sprite_Animation['prototype']['setViewport'],Sprite_Animation['prototype'][_0x262cbe(0x81d)]=function(_0x2af163){const _0x15f8c4=_0x262cbe;this[_0x15f8c4(0x594)]()?this[_0x15f8c4(0x287)](_0x2af163):VisuMZ[_0x15f8c4(0x244)][_0x15f8c4(0x4e8)]['call'](this,_0x2af163);},Sprite_Animation[_0x262cbe(0x800)][_0x262cbe(0x594)]=function(){const _0x5e07cc=_0x262cbe;if(!this[_0x5e07cc(0x81e)])return![];const _0x455d2f=this[_0x5e07cc(0x81e)]['name']||'';if(_0x455d2f[_0x5e07cc(0x13e)](/<MIRROR OFFSET X>/i))return!![];if(_0x455d2f['match'](/<NO MIRROR OFFSET X>/i))return![];return VisuMZ['CoreEngine']['Settings'][_0x5e07cc(0x754)][_0x5e07cc(0x7a3)];},Sprite_Animation['prototype'][_0x262cbe(0x287)]=function(_0x366ba1){const _0x2a8efb=_0x262cbe,_0x905a2d=this[_0x2a8efb(0xfe)],_0x136a52=this['_viewportSize'],_0x4408d8=this[_0x2a8efb(0x81e)]['offsetX']*(this[_0x2a8efb(0xdc)]?-0x1:0x1)-_0x905a2d/0x2,_0x3596ae=this[_0x2a8efb(0x81e)][_0x2a8efb(0x847)]-_0x136a52/0x2,_0x266565=this['targetPosition'](_0x366ba1);_0x366ba1['gl']['viewport'](_0x4408d8+_0x266565['x'],_0x3596ae+_0x266565['y'],_0x905a2d,_0x136a52);},Sprite_Animation['prototype'][_0x262cbe(0x57b)]=function(_0x36c7a8){const _0x11d036=_0x262cbe;if(_0x36c7a8[_0x11d036(0x356)]){}const _0x587a50=this['_animation'][_0x11d036(0x84e)];let _0x518ae4=_0x36c7a8[_0x11d036(0x100)]*_0x36c7a8[_0x11d036(0xc6)]['y'],_0x26ebb5=0x0,_0x314c04=-_0x518ae4/0x2;if(_0x587a50[_0x11d036(0x13e)](/<(?:HEAD|HEADER|TOP)>/i))_0x314c04=-_0x518ae4;if(_0x587a50[_0x11d036(0x13e)](/<(?:FOOT|FOOTER|BOTTOM)>/i))_0x314c04=0x0;if(this[_0x11d036(0x81e)][_0x11d036(0x507)])_0x314c04=0x0;if(_0x587a50[_0x11d036(0x13e)](/<(?:LEFT)>/i))_0x26ebb5=-_0x36c7a8['width']/0x2;if(_0x587a50[_0x11d036(0x13e)](/<(?:RIGHT)>/i))_0x26ebb5=_0x36c7a8[_0x11d036(0x80a)]/0x2;_0x587a50[_0x11d036(0x13e)](/<ANCHOR X:[ ](\d+\.?\d*)>/i)&&(_0x26ebb5=Number(RegExp['$1'])*_0x36c7a8[_0x11d036(0x80a)]);_0x587a50['match'](/<ANCHOR Y:[ ](\d+\.?\d*)>/i)&&(_0x314c04=(0x1-Number(RegExp['$1']))*-_0x518ae4);_0x587a50[_0x11d036(0x13e)](/<ANCHOR:[ ](\d+\.?\d*),[ ](\d+\.?\d*)>/i)&&(_0x26ebb5=Number(RegExp['$1'])*_0x36c7a8[_0x11d036(0x80a)],_0x314c04=(0x1-Number(RegExp['$2']))*-_0x518ae4);if(_0x587a50[_0x11d036(0x13e)](/<OFFSET X:[ ]([\+\-]\d+)>/i))_0x26ebb5+=Number(RegExp['$1']);if(_0x587a50[_0x11d036(0x13e)](/<OFFSET Y:[ ]([\+\-]\d+)>/i))_0x314c04+=Number(RegExp['$1']);_0x587a50[_0x11d036(0x13e)](/<OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i)&&(_0x26ebb5+=Number(RegExp['$1']),_0x314c04+=Number(RegExp['$2']));const _0x427bab=new Point(_0x26ebb5,_0x314c04);return _0x36c7a8['updateTransform'](),_0x36c7a8[_0x11d036(0xd2)][_0x11d036(0x1c4)](_0x427bab);},Sprite_AnimationMV[_0x262cbe(0x800)][_0x262cbe(0x36d)]=function(){const _0x5e1fc9=_0x262cbe;this[_0x5e1fc9(0x1bc)]=VisuMZ[_0x5e1fc9(0x244)]['Settings'][_0x5e1fc9(0x754)][_0x5e1fc9(0x19d)]??0x4,this['setupCustomRateCoreEngine'](),this[_0x5e1fc9(0x1bc)]=this[_0x5e1fc9(0x1bc)][_0x5e1fc9(0x565)](0x1,0xa);},Sprite_AnimationMV[_0x262cbe(0x800)][_0x262cbe(0x678)]=function(){const _0x3cee7a=_0x262cbe;if(!this[_0x3cee7a(0x81e)]);const _0x5a7152=this[_0x3cee7a(0x81e)][_0x3cee7a(0x84e)]||'';_0x5a7152[_0x3cee7a(0x13e)](/<RATE:[ ](\d+)>/i)&&(this[_0x3cee7a(0x1bc)]=(Number(RegExp['$1'])||0x1)[_0x3cee7a(0x565)](0x1,0xa));},Sprite_AnimationMV[_0x262cbe(0x800)]['setMute']=function(_0x238efc){this['_muteSound']=_0x238efc;},VisuMZ['CoreEngine'][_0x262cbe(0x58b)]=Sprite_AnimationMV[_0x262cbe(0x800)][_0x262cbe(0xcd)],Sprite_AnimationMV['prototype']['processTimingData']=function(_0x1ff930){const _0x4fcaed=_0x262cbe;this['_muteSound']&&(_0x1ff930=JsonEx[_0x4fcaed(0x54b)](_0x1ff930),_0x1ff930['se']&&(_0x1ff930['se'][_0x4fcaed(0x665)]=0x0)),VisuMZ[_0x4fcaed(0x244)]['Sprite_AnimationMV_processTimingData']['call'](this,_0x1ff930);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x245)]=Sprite_AnimationMV[_0x262cbe(0x800)][_0x262cbe(0x2bd)],Sprite_AnimationMV[_0x262cbe(0x800)][_0x262cbe(0x2bd)]=function(){const _0x5d8cac=_0x262cbe;VisuMZ[_0x5d8cac(0x244)][_0x5d8cac(0x245)][_0x5d8cac(0x77c)](this);if(this['_animation']['position']===0x3){if(this['x']===0x0)this['x']=Math['round'](Graphics[_0x5d8cac(0x80a)]/0x2);if(this['y']===0x0)this['y']=Math[_0x5d8cac(0x38d)](Graphics[_0x5d8cac(0x100)]/0x2);}},Sprite_Damage[_0x262cbe(0x800)][_0x262cbe(0x783)]=function(_0x1929ad){const _0x277524=_0x262cbe;let _0x3177a5=Math[_0x277524(0x4f1)](_0x1929ad)[_0x277524(0x420)]();this['useDigitGrouping']()&&(_0x3177a5=VisuMZ[_0x277524(0x270)](_0x3177a5));const _0x4ae882=this[_0x277524(0x5ad)](),_0x59fc68=Math[_0x277524(0x431)](_0x4ae882*0.75);for(let _0x534408=0x0;_0x534408<_0x3177a5['length'];_0x534408++){const _0x11520e=this[_0x277524(0x81a)](_0x59fc68,_0x4ae882);_0x11520e[_0x277524(0x2a9)][_0x277524(0x549)](_0x3177a5[_0x534408],0x0,0x0,_0x59fc68,_0x4ae882,'center'),_0x11520e['x']=(_0x534408-(_0x3177a5[_0x277524(0x3c3)]-0x1)/0x2)*_0x59fc68,_0x11520e['dy']=-_0x534408;}},Sprite_Damage['prototype'][_0x262cbe(0x765)]=function(){const _0x3e1aa8=_0x262cbe;return VisuMZ[_0x3e1aa8(0x244)][_0x3e1aa8(0x84d)][_0x3e1aa8(0x754)]['DigitGroupingDamageSprites'];},Sprite_Damage[_0x262cbe(0x800)]['valueOutlineColor']=function(){const _0x1a5149=_0x262cbe;return ColorManager[_0x1a5149(0x58d)]();},VisuMZ['CoreEngine'][_0x262cbe(0x855)]=Sprite_Gauge[_0x262cbe(0x800)][_0x262cbe(0x307)],Sprite_Gauge[_0x262cbe(0x800)][_0x262cbe(0x307)]=function(){return VisuMZ['CoreEngine']['Sprite_Gauge_gaugeRate']['call'](this)['clamp'](0x0,0x1);},VisuMZ['CoreEngine']['Sprite_Gauge_currentValue']=Sprite_Gauge['prototype'][_0x262cbe(0x300)],Sprite_Gauge['prototype']['currentValue']=function(){const _0x2e8caa=_0x262cbe;let _0x8cedfc=VisuMZ[_0x2e8caa(0x244)][_0x2e8caa(0x438)][_0x2e8caa(0x77c)](this);return _0x8cedfc;},Sprite_Gauge[_0x262cbe(0x800)][_0x262cbe(0x7ef)]=function(){const _0x3edada=_0x262cbe;let _0x4d99e5=this[_0x3edada(0x300)]();this[_0x3edada(0x765)]()&&(_0x4d99e5=VisuMZ[_0x3edada(0x270)](_0x4d99e5));const _0x20c9f1=this[_0x3edada(0x73b)]()-0x1,_0x9dc941=this[_0x3edada(0x5b5)]?this[_0x3edada(0x5b5)]():this['bitmapHeight']();this[_0x3edada(0x6bb)](),this['bitmap'][_0x3edada(0x549)](_0x4d99e5,0x0,0x0,_0x20c9f1,_0x9dc941,'right');},Sprite_Gauge[_0x262cbe(0x800)][_0x262cbe(0x2ca)]=function(){return 0x3;},Sprite_Gauge['prototype'][_0x262cbe(0x765)]=function(){const _0x36a710=_0x262cbe;return VisuMZ['CoreEngine'][_0x36a710(0x84d)]['QoL'][_0x36a710(0x3b2)];},Sprite_Gauge[_0x262cbe(0x800)][_0x262cbe(0x15d)]=function(){return ColorManager['outlineColorGauge']();},Sprite_StateIcon[_0x262cbe(0x479)]=VisuMZ['CoreEngine']['Settings']['UI']['StateIconsNonFrame']??!![],VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x3b3)]=Sprite_StateIcon[_0x262cbe(0x800)][_0x262cbe(0x19b)],Sprite_StateIcon[_0x262cbe(0x800)][_0x262cbe(0x19b)]=function(){const _0xb7932=_0x262cbe;Sprite_StateIcon[_0xb7932(0x479)]?this[_0xb7932(0x2be)]():VisuMZ[_0xb7932(0x244)]['Sprite_StateIcon_loadBitmap'][_0xb7932(0x77c)](this);},Sprite_StateIcon[_0x262cbe(0x800)]['loadBitmapCoreEngine']=function(){const _0x4562d2=_0x262cbe;this[_0x4562d2(0x2a9)]=new Bitmap(ImageManager[_0x4562d2(0x5eb)],ImageManager['iconHeight']),this[_0x4562d2(0x21f)]=ImageManager['loadSystem'](_0x4562d2(0x108));},VisuMZ[_0x262cbe(0x244)]['Sprite_StateIcon_updateFrame']=Sprite_StateIcon[_0x262cbe(0x800)][_0x262cbe(0x5d4)],Sprite_StateIcon[_0x262cbe(0x800)]['updateFrame']=function(){const _0x1adc58=_0x262cbe;Sprite_StateIcon['NON_FRAME']?this[_0x1adc58(0x260)]():VisuMZ[_0x1adc58(0x244)][_0x1adc58(0x3ab)][_0x1adc58(0x77c)](this);},Sprite_StateIcon['prototype'][_0x262cbe(0x260)]=function(){const _0x1d257f=_0x262cbe;if(this[_0x1d257f(0x1e1)]===this['_iconIndex'])return;this['_lastIconIndex']=this['_iconIndex'];const _0x166ed7=ImageManager['iconWidth'],_0x4d03ef=ImageManager[_0x1d257f(0x362)],_0x47abdf=this[_0x1d257f(0x4f9)]%0x10*_0x166ed7,_0xf71f79=Math[_0x1d257f(0x431)](this[_0x1d257f(0x4f9)]/0x10)*_0x4d03ef,_0x197adc=this['_srcBitmap'],_0x1c64bb=this['bitmap'];_0x1c64bb['clear'](),_0x1c64bb[_0x1d257f(0x649)](_0x197adc,_0x47abdf,_0xf71f79,_0x166ed7,_0x4d03ef,0x0,0x0,_0x1c64bb[_0x1d257f(0x80a)],_0x1c64bb[_0x1d257f(0x100)]);},VisuMZ['CoreEngine'][_0x262cbe(0x21a)]=Sprite_Picture[_0x262cbe(0x800)][_0x262cbe(0x19b)],Sprite_Picture['prototype'][_0x262cbe(0x19b)]=function(){const _0x47aee6=_0x262cbe;this[_0x47aee6(0x41e)]&&this[_0x47aee6(0x41e)][_0x47aee6(0x13e)](/VisuMZ CoreEngine PictureIcon (\d+)/i)?this[_0x47aee6(0x2f8)](Number(RegExp['$1'])):VisuMZ['CoreEngine'][_0x47aee6(0x21a)][_0x47aee6(0x77c)](this);},Sprite_Picture[_0x262cbe(0x800)][_0x262cbe(0x2f8)]=function(_0x2ab3a2){const _0xd6a42c=_0x262cbe,_0x1f8478=ImageManager[_0xd6a42c(0x5eb)],_0x3b46df=ImageManager[_0xd6a42c(0x362)],_0x55a209=this[_0xd6a42c(0x41e)][_0xd6a42c(0x13e)](/SMOOTH/i);this['bitmap']=new Bitmap(_0x1f8478,_0x3b46df);const _0x41f9e8=ImageManager['loadSystem'](_0xd6a42c(0x108)),_0x1f9c46=_0x2ab3a2%0x10*_0x1f8478,_0x504431=Math['floor'](_0x2ab3a2/0x10)*_0x3b46df;this[_0xd6a42c(0x2a9)][_0xd6a42c(0x428)]=_0x55a209,this['bitmap']['blt'](_0x41f9e8,_0x1f9c46,_0x504431,_0x1f8478,_0x3b46df,0x0,0x0,_0x1f8478,_0x3b46df);};function Sprite_TitlePictureButton(){this['initialize'](...arguments);}Sprite_TitlePictureButton['prototype']=Object[_0x262cbe(0x3de)](Sprite_Clickable['prototype']),Sprite_TitlePictureButton[_0x262cbe(0x800)][_0x262cbe(0x1ea)]=Sprite_TitlePictureButton,Sprite_TitlePictureButton[_0x262cbe(0x800)][_0x262cbe(0x1ad)]=function(_0x2c6587){const _0x3b6697=_0x262cbe;Sprite_Clickable['prototype']['initialize'][_0x3b6697(0x77c)](this),this[_0x3b6697(0x3a3)]=_0x2c6587,this[_0x3b6697(0x32d)]=null,this['setup']();},Sprite_TitlePictureButton[_0x262cbe(0x800)][_0x262cbe(0x4a5)]=function(){const _0x85b8b3=_0x262cbe;this['x']=Graphics['width'],this['y']=Graphics[_0x85b8b3(0x100)],this[_0x85b8b3(0x209)]=![],this['setupButtonImage']();},Sprite_TitlePictureButton[_0x262cbe(0x800)][_0x262cbe(0x120)]=function(){const _0x9f0c48=_0x262cbe;this['bitmap']=ImageManager[_0x9f0c48(0x6ad)](this[_0x9f0c48(0x3a3)]['PictureFilename']),this[_0x9f0c48(0x2a9)][_0x9f0c48(0x7f0)](this[_0x9f0c48(0x809)][_0x9f0c48(0x75d)](this));},Sprite_TitlePictureButton[_0x262cbe(0x800)][_0x262cbe(0x809)]=function(){const _0x54689c=_0x262cbe;this[_0x54689c(0x3a3)][_0x54689c(0x2fa)]['call'](this),this['_data'][_0x54689c(0x350)][_0x54689c(0x77c)](this),this[_0x54689c(0x409)](this['_data']['CallHandlerJS'][_0x54689c(0x75d)](this));},Sprite_TitlePictureButton[_0x262cbe(0x800)][_0x262cbe(0x64e)]=function(){const _0x50247b=_0x262cbe;Sprite_Clickable['prototype'][_0x50247b(0x64e)][_0x50247b(0x77c)](this),this[_0x50247b(0x45d)](),this[_0x50247b(0x7dc)]();},Sprite_TitlePictureButton['prototype']['fadeSpeed']=function(){const _0x466c77=_0x262cbe;return VisuMZ['CoreEngine']['Settings'][_0x466c77(0x62e)][_0x466c77(0x7c8)][_0x466c77(0x6df)];},Sprite_TitlePictureButton[_0x262cbe(0x800)]['updateOpacity']=function(){const _0x5f3bfc=_0x262cbe;this[_0x5f3bfc(0x6a0)]||this[_0x5f3bfc(0x49c)]?this[_0x5f3bfc(0x2b3)]=0xff:(this[_0x5f3bfc(0x2b3)]+=this[_0x5f3bfc(0x209)]?this[_0x5f3bfc(0x6d1)]():-0x1*this[_0x5f3bfc(0x6d1)](),this[_0x5f3bfc(0x2b3)]=Math['min'](0xc0,this[_0x5f3bfc(0x2b3)]));},Sprite_TitlePictureButton[_0x262cbe(0x800)]['setClickHandler']=function(_0x5cf89c){const _0x24c638=_0x262cbe;this[_0x24c638(0x32d)]=_0x5cf89c;},Sprite_TitlePictureButton[_0x262cbe(0x800)][_0x262cbe(0x5a3)]=function(){const _0x5696f4=_0x262cbe;this[_0x5696f4(0x32d)]&&this[_0x5696f4(0x32d)]();};function Sprite_ExtendedTile(){const _0x2101cf=_0x262cbe;this[_0x2101cf(0x1ad)](...arguments);}Sprite_ExtendedTile[_0x262cbe(0x800)]=Object[_0x262cbe(0x3de)](Sprite[_0x262cbe(0x800)]),Sprite_ExtendedTile[_0x262cbe(0x800)][_0x262cbe(0x1ea)]=Sprite_ExtendedTile,Sprite_ExtendedTile[_0x262cbe(0x800)][_0x262cbe(0x1ad)]=function(_0x4f0f0b,_0x443750,_0x56656b,_0x31a2b2){const _0x253b5e=_0x262cbe;this[_0x253b5e(0x4f6)]=Game_CharacterBase['DEFAULT_SHIFT_Y']||-0x6,this[_0x253b5e(0x384)]=_0x4f0f0b,this[_0x253b5e(0xfd)]=_0x443750,this[_0x253b5e(0x5b3)]=_0x56656b,this['_patternHeight']=_0x31a2b2,Sprite[_0x253b5e(0x800)][_0x253b5e(0x1ad)][_0x253b5e(0x77c)](this),this['createSubSprite'](),this['loadTileBitmap'](),this[_0x253b5e(0x341)](),this[_0x253b5e(0x64e)]();},Sprite_ExtendedTile[_0x262cbe(0x800)][_0x262cbe(0x625)]=function(){const _0x233a9f=_0x262cbe;this['_tileSprite']=new Sprite(),this['_tileSprite'][_0x233a9f(0xc4)]['x']=0.5,this['_tileSprite'][_0x233a9f(0xc4)]['y']=0x1,this[_0x233a9f(0x78b)]['y']=-this[_0x233a9f(0x4f6)]+0x1,this[_0x233a9f(0x286)](this['_tileSprite']);},Sprite_ExtendedTile[_0x262cbe(0x800)][_0x262cbe(0x360)]=function(){const _0xedd4bb=_0x262cbe,_0x4ba07f=$gameMap[_0xedd4bb(0x22a)](),_0x4c82b7=0x5+Math['floor'](this['_tile']/0x100);this[_0xedd4bb(0x78b)]['bitmap']=ImageManager[_0xedd4bb(0x3d7)](_0x4ba07f[_0xedd4bb(0x743)][_0x4c82b7]);},Sprite_ExtendedTile['prototype'][_0x262cbe(0x341)]=function(){const _0x49c7f5=_0x262cbe,_0x2c5d37=this[_0x49c7f5(0x5b3)],_0x2a5869=$gameMap[_0x49c7f5(0x11e)](),_0x10d7cc=$gameMap['tileHeight'](),_0x1c904e=(Math[_0x49c7f5(0x431)](_0x2c5d37/0x80)%0x2*0x8+_0x2c5d37%0x8)*_0x2a5869,_0x27d7b0=Math[_0x49c7f5(0x431)](_0x2c5d37%0x100/0x8)%0x10*_0x10d7cc,_0x5274ba=this['_patternHeight']*_0x10d7cc;this[_0x49c7f5(0x78b)]['setFrame'](_0x1c904e,_0x27d7b0-_0x5274ba,_0x2a5869,_0x10d7cc+_0x5274ba);},Sprite_ExtendedTile['prototype']['update']=function(){const _0x2a803c=_0x262cbe;Sprite[_0x2a803c(0x800)]['update'][_0x2a803c(0x77c)](this),this[_0x2a803c(0x2bd)]();},Sprite_ExtendedTile[_0x262cbe(0x800)][_0x262cbe(0x2bd)]=function(){const _0x87dec6=_0x262cbe,_0x4937c3=$gameMap['tileWidth'](),_0x2bbcb7=$gameMap[_0x87dec6(0x5a2)](),_0x226ef3=this['_mapX'],_0x2fd1df=this[_0x87dec6(0xfd)];this['x']=Math[_0x87dec6(0x431)](($gameMap[_0x87dec6(0x6aa)](_0x226ef3)+0.5)*_0x4937c3),this['y']=Math[_0x87dec6(0x431)](($gameMap[_0x87dec6(0x40d)](_0x2fd1df)+0x1)*_0x2bbcb7)+this[_0x87dec6(0x4f6)]-0x1;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x71b)]=Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x1ad)],Spriteset_Base['prototype'][_0x262cbe(0x1ad)]=function(){const _0x26f342=_0x262cbe;VisuMZ[_0x26f342(0x244)]['Spriteset_Base_initialize'][_0x26f342(0x77c)](this),this[_0x26f342(0x13f)]();},Spriteset_Base[_0x262cbe(0x800)]['initMembersCoreEngine']=function(){const _0x21793=_0x262cbe;this[_0x21793(0x2a1)]=[],this[_0x21793(0x515)]=[],this[_0x21793(0x121)]=this[_0x21793(0xc6)]['x'],this[_0x21793(0x157)]=this['scale']['y'];},VisuMZ['CoreEngine']['Spriteset_Base_destroy']=Spriteset_Base[_0x262cbe(0x800)]['destroy'],Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x80c)]=function(_0x259c93){const _0x543777=_0x262cbe;this['removeAllFauxAnimations'](),this['removeAllPointAnimations'](),VisuMZ[_0x543777(0x244)]['Spriteset_Base_destroy'][_0x543777(0x77c)](this,_0x259c93);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0xa9)]=Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x64e)],Spriteset_Base['prototype']['update']=function(){const _0x169067=_0x262cbe;VisuMZ[_0x169067(0x244)][_0x169067(0xa9)][_0x169067(0x77c)](this),this[_0x169067(0x43b)](),this[_0x169067(0x2b8)](),this[_0x169067(0x6ab)](),this['updatePointAnimations']();},Spriteset_Base[_0x262cbe(0x800)]['updatePictureSettings']=function(){},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x2b8)]=function(){const _0x5d423e=_0x262cbe;if(!VisuMZ[_0x5d423e(0x244)]['Settings'][_0x5d423e(0x754)]['AntiZoomPictures'])return;if(this[_0x5d423e(0x121)]===this['scale']['x']&&this[_0x5d423e(0x157)]===this[_0x5d423e(0xc6)]['y'])return;this['adjustPictureAntiZoom'](),this['_cacheScaleX']=this['scale']['x'],this[_0x5d423e(0x157)]=this[_0x5d423e(0xc6)]['y'];},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x76d)]=function(){const _0x31824a=_0x262cbe;if(SceneManager[_0x31824a(0x62f)]()&&Spriteset_Map[_0x31824a(0x387)])return;else{if(SceneManager[_0x31824a(0x310)]()&&Spriteset_Battle[_0x31824a(0x387)])return;}this[_0x31824a(0xc6)]['x']!==0x0&&(this[_0x31824a(0x155)]['scale']['x']=0x1/this[_0x31824a(0xc6)]['x'],this[_0x31824a(0x155)]['x']=-(this['x']/this[_0x31824a(0xc6)]['x'])),this[_0x31824a(0xc6)]['y']!==0x0&&(this[_0x31824a(0x155)][_0x31824a(0xc6)]['y']=0x1/this[_0x31824a(0xc6)]['y'],this[_0x31824a(0x155)]['y']=-(this['y']/this[_0x31824a(0xc6)]['y']));},VisuMZ['CoreEngine']['Spriteset_Base_updatePosition']=Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x2bd)],Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x2bd)]=function(){const _0x3e24ae=_0x262cbe;VisuMZ[_0x3e24ae(0x244)][_0x3e24ae(0x7fe)][_0x3e24ae(0x77c)](this),this[_0x3e24ae(0x19c)]();},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x19c)]=function(){const _0x15ca36=_0x262cbe;if(!$gameScreen)return;if($gameScreen['_shakeDuration']<=0x0)return;this['x']-=Math[_0x15ca36(0x38d)]($gameScreen['shake']());const _0x3e78a5=$gameScreen[_0x15ca36(0x4e3)]();switch($gameScreen[_0x15ca36(0x4e3)]()){case _0x15ca36(0x7b2):this[_0x15ca36(0x395)]();break;case _0x15ca36(0x229):this[_0x15ca36(0x257)]();break;case _0x15ca36(0x501):this[_0x15ca36(0x54f)]();break;default:this[_0x15ca36(0x716)]();break;}},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x395)]=function(){const _0x15646f=_0x262cbe,_0x1ba796=VisuMZ[_0x15646f(0x244)][_0x15646f(0x84d)][_0x15646f(0x67e)];if(_0x1ba796&&_0x1ba796[_0x15646f(0x450)])return _0x1ba796[_0x15646f(0x450)][_0x15646f(0x77c)](this);this['x']+=Math[_0x15646f(0x38d)]($gameScreen[_0x15646f(0x580)]());},Spriteset_Base[_0x262cbe(0x800)]['updatePositionCoreEngineShakeRand']=function(){const _0x1f3e79=_0x262cbe,_0x3f0c40=VisuMZ['CoreEngine'][_0x1f3e79(0x84d)]['ScreenShake'];if(_0x3f0c40&&_0x3f0c40['randomJS'])return _0x3f0c40[_0x1f3e79(0x32a)][_0x1f3e79(0x77c)](this);const _0x3a97a4=$gameScreen[_0x1f3e79(0x724)]*0.75,_0x780eb2=$gameScreen[_0x1f3e79(0x24b)]*0.6,_0x53b9e4=$gameScreen[_0x1f3e79(0x834)];this['x']+=Math[_0x1f3e79(0x38d)](Math['randomInt'](_0x3a97a4)-Math[_0x1f3e79(0x508)](_0x780eb2))*(Math[_0x1f3e79(0x5d0)](_0x53b9e4,0x1e)*0.5),this['y']+=Math[_0x1f3e79(0x38d)](Math['randomInt'](_0x3a97a4)-Math[_0x1f3e79(0x508)](_0x780eb2))*(Math[_0x1f3e79(0x5d0)](_0x53b9e4,0x1e)*0.5);},Spriteset_Base[_0x262cbe(0x800)]['updatePositionCoreEngineShakeHorz']=function(){const _0x4171d3=_0x262cbe,_0xeb172c=VisuMZ[_0x4171d3(0x244)]['Settings'][_0x4171d3(0x67e)];if(_0xeb172c&&_0xeb172c[_0x4171d3(0x439)])return _0xeb172c[_0x4171d3(0x439)][_0x4171d3(0x77c)](this);const _0x5b0250=$gameScreen[_0x4171d3(0x724)]*0.75,_0x5f0e9a=$gameScreen[_0x4171d3(0x24b)]*0.6,_0x3d2681=$gameScreen['_shakeDuration'];this['x']+=Math[_0x4171d3(0x38d)](Math[_0x4171d3(0x508)](_0x5b0250)-Math['randomInt'](_0x5f0e9a))*(Math['min'](_0x3d2681,0x1e)*0.5);},Spriteset_Base['prototype']['updatePositionCoreEngineShakeVert']=function(){const _0x1075a4=_0x262cbe,_0x55414a=VisuMZ[_0x1075a4(0x244)][_0x1075a4(0x84d)][_0x1075a4(0x67e)];if(_0x55414a&&_0x55414a[_0x1075a4(0x5c7)])return _0x55414a[_0x1075a4(0x5c7)][_0x1075a4(0x77c)](this);const _0xd0aa0f=$gameScreen[_0x1075a4(0x724)]*0.75,_0x4b8398=$gameScreen[_0x1075a4(0x24b)]*0.6,_0x371a8e=$gameScreen['_shakeDuration'];this['y']+=Math['round'](Math[_0x1075a4(0x508)](_0xd0aa0f)-Math[_0x1075a4(0x508)](_0x4b8398))*(Math[_0x1075a4(0x5d0)](_0x371a8e,0x1e)*0.5);},Spriteset_Base[_0x262cbe(0x800)]['updateFauxAnimations']=function(){const _0x2d951c=_0x262cbe;for(const _0x2984b6 of this[_0x2d951c(0x2a1)]){!_0x2984b6[_0x2d951c(0x3fc)]()&&this[_0x2d951c(0x843)](_0x2984b6);}this[_0x2d951c(0x4e5)]();},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x4e5)]=function(){const _0x217c9c=_0x262cbe;for(;;){const _0x28bee4=$gameTemp[_0x217c9c(0x802)]();if(_0x28bee4)this[_0x217c9c(0x4d1)](_0x28bee4);else break;}},Spriteset_Base[_0x262cbe(0x800)]['createFauxAnimation']=function(_0x482ea8){const _0x294f6b=_0x262cbe,_0x5a5c10=$dataAnimations[_0x482ea8[_0x294f6b(0x95)]],_0x28c81b=_0x482ea8[_0x294f6b(0x40f)],_0x214f8f=_0x482ea8[_0x294f6b(0x406)],_0x5d4a03=_0x482ea8[_0x294f6b(0x19f)];let _0x106595=this[_0x294f6b(0x1c0)]();const _0x3fe2ea=this['animationNextDelay']();if(this[_0x294f6b(0x5d1)](_0x5a5c10))for(const _0x15e6f7 of _0x28c81b){this['createFauxAnimationSprite']([_0x15e6f7],_0x5a5c10,_0x214f8f,_0x106595,_0x5d4a03),_0x106595+=_0x3fe2ea;}else this[_0x294f6b(0x423)](_0x28c81b,_0x5a5c10,_0x214f8f,_0x106595,_0x5d4a03);},Spriteset_Base[_0x262cbe(0x800)]['createAnimationSprite']=function(_0x16aadb,_0x4474ef,_0x1991b8,_0x2d7246){const _0x6ff8ae=_0x262cbe,_0x22e94c=this[_0x6ff8ae(0x576)](_0x4474ef),_0x184f97=new(_0x22e94c?Sprite_AnimationMV:Sprite_Animation)(),_0x568ad1=this[_0x6ff8ae(0x3a1)](_0x16aadb),_0xd31ada=this[_0x6ff8ae(0x1c0)](),_0x5e2de4=_0x2d7246>_0xd31ada?this[_0x6ff8ae(0x77b)]():null;this[_0x6ff8ae(0x371)](_0x16aadb[0x0])&&(_0x1991b8=!_0x1991b8),_0x184f97['targetObjects']=_0x16aadb,_0x184f97[_0x6ff8ae(0x4a5)](_0x568ad1,_0x4474ef,_0x1991b8,_0x2d7246,_0x5e2de4),this[_0x6ff8ae(0x5c2)](_0x184f97),this[_0x6ff8ae(0x759)][_0x6ff8ae(0x4ea)](_0x184f97);},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x423)]=function(_0x3d7448,_0x2e4137,_0x47c0ab,_0x15c36d,_0x12b879){const _0xdee676=_0x262cbe,_0x1baea3=this[_0xdee676(0x576)](_0x2e4137),_0x45f915=new(_0x1baea3?Sprite_AnimationMV:Sprite_Animation)(),_0xf1b226=this[_0xdee676(0x3a1)](_0x3d7448);this[_0xdee676(0x371)](_0x3d7448[0x0])&&(_0x47c0ab=!_0x47c0ab);_0x45f915[_0xdee676(0x693)]=_0x3d7448,_0x45f915['setup'](_0xf1b226,_0x2e4137,_0x47c0ab,_0x15c36d),_0x45f915['setMute'](_0x12b879),this[_0xdee676(0x5c2)](_0x45f915);if(this[_0xdee676(0x759)])this[_0xdee676(0x759)][_0xdee676(0x261)](_0x45f915);this[_0xdee676(0x2a1)][_0xdee676(0x4ea)](_0x45f915);},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x5c2)]=function(_0x35a95a){const _0x6af292=_0x262cbe;this[_0x6af292(0x524)][_0x6af292(0x286)](_0x35a95a);},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x323)]=function(_0x5f47bd){const _0x1701ba=_0x262cbe;this[_0x1701ba(0x759)]['remove'](_0x5f47bd),this['removeAnimationFromContainer'](_0x5f47bd);for(const _0x4875c9 of _0x5f47bd[_0x1701ba(0x693)]){_0x4875c9[_0x1701ba(0x7f)]&&_0x4875c9['endAnimation']();}_0x5f47bd[_0x1701ba(0x80c)]();},Spriteset_Base['prototype'][_0x262cbe(0x843)]=function(_0x56f75a){const _0x181a22=_0x262cbe;this[_0x181a22(0x2a1)][_0x181a22(0x261)](_0x56f75a),this[_0x181a22(0x191)](_0x56f75a);for(const _0x4cedd4 of _0x56f75a[_0x181a22(0x693)]){_0x4cedd4[_0x181a22(0x7f)]&&_0x4cedd4['endAnimation']();}_0x56f75a[_0x181a22(0x80c)]();},Spriteset_Base[_0x262cbe(0x800)]['removeAnimationFromContainer']=function(_0x54eae0){const _0x2bb21c=_0x262cbe;this[_0x2bb21c(0x524)][_0x2bb21c(0x2e8)](_0x54eae0);},Spriteset_Base['prototype'][_0x262cbe(0x7f5)]=function(){const _0x35ab98=_0x262cbe;for(const _0x268ed1 of this[_0x35ab98(0x2a1)]){this[_0x35ab98(0x843)](_0x268ed1);}},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x17f)]=function(){const _0x31cd12=_0x262cbe;return this[_0x31cd12(0x2a1)][_0x31cd12(0x3c3)]>0x0;},Spriteset_Base[_0x262cbe(0x800)]['updatePointAnimations']=function(){const _0x46e400=_0x262cbe;for(const _0x2d101a of this[_0x46e400(0x515)]){!_0x2d101a[_0x46e400(0x3fc)]()&&this['removePointAnimation'](_0x2d101a);}this[_0x46e400(0x60c)]();},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x60c)]=function(){const _0x3aa94e=_0x262cbe;for(;;){const _0x32e0f5=$gameTemp[_0x3aa94e(0xd7)]();if(_0x32e0f5)this[_0x3aa94e(0xe1)](_0x32e0f5);else break;}},Spriteset_Base[_0x262cbe(0x800)]['createPointAnimation']=function(_0x208299){const _0x1d6490=_0x262cbe,_0x2aae76=$dataAnimations[_0x208299[_0x1d6490(0x95)]],_0x246eda=this['createPointAnimationTargets'](_0x208299),_0x485112=_0x208299[_0x1d6490(0x406)],_0x3d5e58=_0x208299[_0x1d6490(0x19f)];let _0x149dee=this['animationBaseDelay']();const _0x519e5c=this[_0x1d6490(0x159)]();if(this['isAnimationForEach'](_0x2aae76))for(const _0x1ca4d1 of _0x246eda){this[_0x1d6490(0x71f)]([_0x1ca4d1],_0x2aae76,_0x485112,_0x149dee,_0x3d5e58),_0x149dee+=_0x519e5c;}else this[_0x1d6490(0x71f)](_0x246eda,_0x2aae76,_0x485112,_0x149dee,_0x3d5e58);},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x606)]=function(_0x212a06){const _0x5043f7=_0x262cbe,_0x279283=new Sprite_Clickable(),_0x3db91a=this[_0x5043f7(0x3a9)]();_0x279283['x']=_0x212a06['x']-_0x3db91a['x'],_0x279283['y']=_0x212a06['y']-_0x3db91a['y'],_0x279283['z']=0x64;const _0x36cd87=this[_0x5043f7(0x3a9)]();return _0x36cd87[_0x5043f7(0x286)](_0x279283),[_0x279283];},Spriteset_Base[_0x262cbe(0x800)]['getPointAnimationLayer']=function(){return this;},Spriteset_Map[_0x262cbe(0x800)]['getPointAnimationLayer']=function(){const _0x38b4fc=_0x262cbe;return this[_0x38b4fc(0x1f7)]||this;},Spriteset_Battle[_0x262cbe(0x800)][_0x262cbe(0x3a9)]=function(){const _0x353a4b=_0x262cbe;return this[_0x353a4b(0x5c3)]||this;},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x71f)]=function(_0x463090,_0x41fc8f,_0x4cc262,_0xf2af26,_0x4856f2){const _0x140500=_0x262cbe,_0x2e718e=this[_0x140500(0x576)](_0x41fc8f),_0x4fe48e=new(_0x2e718e?Sprite_AnimationMV:Sprite_Animation)();_0x4fe48e['targetObjects']=_0x463090,_0x4fe48e[_0x140500(0x4a5)](_0x463090,_0x41fc8f,_0x4cc262,_0xf2af26),_0x4fe48e['setMute'](_0x4856f2),this[_0x140500(0x5c2)](_0x4fe48e),this[_0x140500(0x515)]['push'](_0x4fe48e);},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x3ce)]=function(_0x1416f2){const _0x3ee0aa=_0x262cbe;this[_0x3ee0aa(0x515)][_0x3ee0aa(0x261)](_0x1416f2),this[_0x3ee0aa(0x524)][_0x3ee0aa(0x2e8)](_0x1416f2);for(const _0x455ee3 of _0x1416f2[_0x3ee0aa(0x693)]){_0x455ee3['endAnimation']&&_0x455ee3[_0x3ee0aa(0x7f)]();const _0x2fb008=this[_0x3ee0aa(0x3a9)]();if(_0x2fb008)_0x2fb008['removeChild'](_0x455ee3);}_0x1416f2[_0x3ee0aa(0x80c)]();},Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x38b)]=function(){const _0x22c236=_0x262cbe;for(const _0x2002e9 of this['_pointAnimationSprites']){this[_0x22c236(0x3ce)](_0x2002e9);}},Spriteset_Base['prototype'][_0x262cbe(0x1b6)]=function(){return this['_pointAnimationSprites']['length']>0x0;},VisuMZ[_0x262cbe(0x244)]['Spriteset_Base_isAnimationPlaying']=Spriteset_Base[_0x262cbe(0x800)]['isAnimationPlaying'],Spriteset_Base[_0x262cbe(0x800)][_0x262cbe(0x84)]=function(){const _0x1c2e1e=_0x262cbe;return VisuMZ['CoreEngine'][_0x1c2e1e(0x78)]['call'](this)||this[_0x1c2e1e(0x1b6)]();},Spriteset_Map[_0x262cbe(0x387)]=VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x754)][_0x262cbe(0x538)]||![],VisuMZ[_0x262cbe(0x244)]['Scene_Map_createSpriteset_detach']=Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x568)],Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x568)]=function(){const _0x3a7647=_0x262cbe;VisuMZ[_0x3a7647(0x244)][_0x3a7647(0x62b)][_0x3a7647(0x77c)](this);if(!Spriteset_Map[_0x3a7647(0x387)])return;const _0x9d9c8d=this['_spriteset'];if(!_0x9d9c8d)return;this[_0x3a7647(0x155)]=_0x9d9c8d[_0x3a7647(0x155)];if(!this[_0x3a7647(0x155)])return;this['addChild'](this[_0x3a7647(0x155)]);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x263)]=Spriteset_Map['prototype'][_0x262cbe(0x1be)],Spriteset_Map[_0x262cbe(0x800)][_0x262cbe(0x1be)]=function(){const _0x3ea6cc=_0x262cbe;VisuMZ[_0x3ea6cc(0x244)]['Spriteset_Map_createTilemap'][_0x3ea6cc(0x77c)](this),this['createTileExtendSprites']();},Spriteset_Map['prototype'][_0x262cbe(0x488)]=function(){const _0x9bbce=_0x262cbe,_0x53489c=$gameMap[_0x9bbce(0x22a)]();if(!_0x53489c)return;const _0x207bd9=$gameMap[_0x9bbce(0x13a)]();if(Object[_0x9bbce(0xae)](_0x207bd9)['length']<=0x0)return;const _0x132dcf=$gameMap[_0x9bbce(0x552)]();this[_0x9bbce(0x6ac)]=this[_0x9bbce(0x6ac)]||[];for(let _0x38d75a=0x0;_0x38d75a<$gameMap[_0x9bbce(0x100)]();_0x38d75a++){for(let _0x42be14=0x0;_0x42be14<$gameMap[_0x9bbce(0x80a)]();_0x42be14++){for(const _0x2d3da1 of $gameMap[_0x9bbce(0x210)](_0x42be14,_0x38d75a)){const _0x3f1e6b=_0x132dcf[_0x2d3da1]>>0xc,_0x31e12f=_0x207bd9[_0x3f1e6b]||0x0;if(_0x31e12f<=0x0)continue;this[_0x9bbce(0x199)](_0x42be14,_0x38d75a,_0x2d3da1,_0x31e12f);}}}},Spriteset_Map[_0x262cbe(0x800)]['removeTileExtendSprites']=function(){const _0x478384=_0x262cbe;this['_tileExtendSprites']=this[_0x478384(0x6ac)]||[];for(const _0x5d39c2 of this[_0x478384(0x6ac)]){this[_0x478384(0x1f7)]['removeChild'](_0x5d39c2);}this['_tileExtendSprites']=[];},Spriteset_Map[_0x262cbe(0x800)]['createExtendedTileSprite']=function(_0x449652,_0xfe6fb7,_0x51ddca,_0x2f07f7){const _0x2beef1=_0x262cbe,_0x47abc4=new Sprite_ExtendedTile(_0x449652,_0xfe6fb7,_0x51ddca,_0x2f07f7),_0x3659cd=$gameMap[_0x2beef1(0x552)]();_0x3659cd[_0x51ddca]&0x10?_0x47abc4['z']=0x4:_0x47abc4['z']=0x3,this[_0x2beef1(0x1f7)]['addChild'](_0x47abc4),this['_tileExtendSprites'][_0x2beef1(0x4ea)](_0x47abc4);},VisuMZ[_0x262cbe(0x244)]['Tilemap_addSpotTile']=Tilemap['prototype']['_addSpotTile'],Tilemap[_0x262cbe(0x800)]['_addSpotTile']=function(_0x36b80b,_0x6d4f28,_0x59bc85){const _0x53bf1c=_0x262cbe;if($gameMap[_0x53bf1c(0x68f)](_0x36b80b))return;VisuMZ[_0x53bf1c(0x244)][_0x53bf1c(0x55e)]['call'](this,_0x36b80b,_0x6d4f28,_0x59bc85);},Spriteset_Battle['DETACH_PICTURE_CONTAINER']=VisuMZ['CoreEngine'][_0x262cbe(0x84d)][_0x262cbe(0x754)][_0x262cbe(0x3eb)]||![],VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x4f2)]=Scene_Battle[_0x262cbe(0x800)][_0x262cbe(0x568)],Scene_Battle[_0x262cbe(0x800)]['createSpriteset']=function(){const _0x318556=_0x262cbe;VisuMZ[_0x318556(0x244)][_0x318556(0x4f2)][_0x318556(0x77c)](this);if(!Spriteset_Battle['DETACH_PICTURE_CONTAINER'])return;const _0x474302=this[_0x318556(0x2aa)];if(!_0x474302)return;this['_pictureContainer']=_0x474302[_0x318556(0x155)];if(!this[_0x318556(0x155)])return;this[_0x318556(0x286)](this[_0x318556(0x155)]);},Spriteset_Battle[_0x262cbe(0x800)]['createBackground']=function(){const _0x1748ff=_0x262cbe;this[_0x1748ff(0x2ff)]=new PIXI[(_0x1748ff(0x177))][(_0x1748ff(0x2e3))](clamp=!![]),this[_0x1748ff(0x6ea)]=new Sprite(),this[_0x1748ff(0x6ea)]['bitmap']=SceneManager[_0x1748ff(0x2e7)](),this[_0x1748ff(0x6ea)][_0x1748ff(0x177)]=[this[_0x1748ff(0x2ff)]],this[_0x1748ff(0x34a)][_0x1748ff(0x286)](this[_0x1748ff(0x6ea)]);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x344)]=Spriteset_Battle['prototype']['createEnemies'],Spriteset_Battle[_0x262cbe(0x800)][_0x262cbe(0x59e)]=function(){const _0x21b783=_0x262cbe;this[_0x21b783(0x56e)]()&&this[_0x21b783(0x4b0)](),VisuMZ[_0x21b783(0x244)][_0x21b783(0x344)][_0x21b783(0x77c)](this);},Spriteset_Battle['prototype'][_0x262cbe(0x56e)]=function(){const _0x5ae956=_0x262cbe,_0x33d596=VisuMZ['CoreEngine'][_0x5ae956(0x84d)][_0x5ae956(0x5b8)];if(!_0x33d596)return![];if(Utils[_0x5ae956(0xea)]>=_0x5ae956(0xb6)&&!_0x33d596[_0x5ae956(0x7e2)])return![];return _0x33d596['RepositionEnemies'];},Spriteset_Battle[_0x262cbe(0x800)][_0x262cbe(0x4b0)]=function(){const _0x312052=_0x262cbe;for(member of $gameTroop[_0x312052(0x23e)]()){member['moveRelativeToResolutionChange']();}},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x3e1)]=Window_Base[_0x262cbe(0x800)]['initialize'],Window_Base['prototype'][_0x262cbe(0x1ad)]=function(_0x5e39c2){const _0x1612a6=_0x262cbe;_0x5e39c2['x']=Math['round'](_0x5e39c2['x']),_0x5e39c2['y']=Math[_0x1612a6(0x38d)](_0x5e39c2['y']),_0x5e39c2[_0x1612a6(0x80a)]=Math['round'](_0x5e39c2[_0x1612a6(0x80a)]),_0x5e39c2['height']=Math[_0x1612a6(0x38d)](_0x5e39c2[_0x1612a6(0x100)]),this[_0x1612a6(0x7d0)](),VisuMZ[_0x1612a6(0x244)][_0x1612a6(0x3e1)]['call'](this,_0x5e39c2),this['initCoreEasing']();},Window_Base['prototype'][_0x262cbe(0x7d0)]=function(){const _0x53f80f=_0x262cbe;this['_digitGrouping']=VisuMZ[_0x53f80f(0x244)][_0x53f80f(0x84d)][_0x53f80f(0x754)][_0x53f80f(0xb8)],this[_0x53f80f(0x529)]=VisuMZ[_0x53f80f(0x244)]['Settings'][_0x53f80f(0x754)][_0x53f80f(0x5aa)];},Window_Base[_0x262cbe(0x800)]['lineHeight']=function(){const _0x51c297=_0x262cbe;return VisuMZ[_0x51c297(0x244)][_0x51c297(0x84d)][_0x51c297(0x10e)]['LineHeight'];},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x835)]=function(){const _0x3603a6=_0x262cbe;return VisuMZ[_0x3603a6(0x244)]['Settings'][_0x3603a6(0x10e)]['ItemPadding'];},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x186)]=function(){const _0x424034=_0x262cbe;$gameSystem['windowOpacity']?this[_0x424034(0x6ce)]=$gameSystem[_0x424034(0x183)]():this[_0x424034(0x6ce)]=VisuMZ[_0x424034(0x244)][_0x424034(0x84d)][_0x424034(0x10e)]['BackOpacity'];},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x1a3)]=function(){const _0x1dcd1f=_0x262cbe;return VisuMZ[_0x1dcd1f(0x244)][_0x1dcd1f(0x84d)][_0x1dcd1f(0x10e)]['TranslucentOpacity'];},Window_Base[_0x262cbe(0x800)]['openingSpeed']=function(){const _0x139113=_0x262cbe;return VisuMZ[_0x139113(0x244)]['Settings'][_0x139113(0x10e)][_0x139113(0x1b3)];},VisuMZ[_0x262cbe(0x244)]['Window_Base_update']=Window_Base['prototype']['update'],Window_Base[_0x262cbe(0x800)][_0x262cbe(0x64e)]=function(){const _0x4870b9=_0x262cbe;VisuMZ['CoreEngine'][_0x4870b9(0x126)][_0x4870b9(0x77c)](this),this[_0x4870b9(0x2e6)]();},Window_Base['prototype'][_0x262cbe(0x248)]=function(){const _0x1d96e6=_0x262cbe;this[_0x1d96e6(0x32f)]&&(this['openness']+=this[_0x1d96e6(0xf8)](),this['isOpen']()&&(this[_0x1d96e6(0x32f)]=![]));},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x484)]=function(){const _0x2c040b=_0x262cbe;this[_0x2c040b(0x472)]&&(this[_0x2c040b(0x48d)]-=this[_0x2c040b(0xf8)](),this[_0x2c040b(0x20f)]()&&(this[_0x2c040b(0x472)]=![]));},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x331)]=Window_Base['prototype'][_0x262cbe(0x549)],Window_Base[_0x262cbe(0x800)][_0x262cbe(0x549)]=function(_0x392496,_0x3ea231,_0x1a0054,_0x9c3b2,_0x40a0d6){const _0x44e171=_0x262cbe;if(this['useDigitGrouping']())_0x392496=VisuMZ[_0x44e171(0x270)](_0x392496);VisuMZ[_0x44e171(0x244)][_0x44e171(0x331)][_0x44e171(0x77c)](this,_0x392496,_0x3ea231,_0x1a0054,_0x9c3b2,_0x40a0d6);},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x765)]=function(){const _0x285b2d=_0x262cbe;return this[_0x285b2d(0x740)];},VisuMZ['CoreEngine'][_0x262cbe(0x30e)]=Window_Base[_0x262cbe(0x800)][_0x262cbe(0x7e5)],Window_Base['prototype'][_0x262cbe(0x7e5)]=function(_0x4fbc41,_0x6a51b0,_0x212f27,_0xb89d81){const _0x48dff4=_0x262cbe;var _0x5708f7=VisuMZ[_0x48dff4(0x244)][_0x48dff4(0x30e)][_0x48dff4(0x77c)](this,_0x4fbc41,_0x6a51b0,_0x212f27,_0xb89d81);if(this['useDigitGroupingEx']())_0x5708f7[_0x48dff4(0x616)]=String(VisuMZ[_0x48dff4(0x270)](_0x5708f7['text']))||'';return _0x5708f7;},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x2b5)]=function(){const _0x625a45=_0x262cbe;return this[_0x625a45(0x529)];},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x3b9)]=function(_0x5c8c1b){const _0x1ecbac=_0x262cbe;this[_0x1ecbac(0x740)]=_0x5c8c1b;},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x805)]=function(_0x3b1c95){this['_digitGroupingEx']=_0x3b1c95;},VisuMZ['CoreEngine'][_0x262cbe(0x16e)]=Window_Base[_0x262cbe(0x800)][_0x262cbe(0x279)],Window_Base[_0x262cbe(0x800)][_0x262cbe(0x279)]=function(_0xf1da60,_0xe4e06e,_0x11e67c){const _0x375b1b=_0x262cbe;_0xe4e06e=Math['round'](_0xe4e06e),_0x11e67c=Math[_0x375b1b(0x38d)](_0x11e67c),VisuMZ[_0x375b1b(0x244)][_0x375b1b(0x16e)]['call'](this,_0xf1da60,_0xe4e06e,_0x11e67c);},VisuMZ[_0x262cbe(0x244)]['Window_Base_drawFace']=Window_Base[_0x262cbe(0x800)][_0x262cbe(0x792)],Window_Base[_0x262cbe(0x800)][_0x262cbe(0x792)]=function(_0x4a9a37,_0x2d380a,_0x40d35d,_0x464cdf,_0x3bc579,_0x2e76a7){const _0xc8b62f=_0x262cbe;_0x3bc579=_0x3bc579||ImageManager[_0xc8b62f(0x832)],_0x2e76a7=_0x2e76a7||ImageManager[_0xc8b62f(0x273)],_0x40d35d=Math[_0xc8b62f(0x38d)](_0x40d35d),_0x464cdf=Math['round'](_0x464cdf),_0x3bc579=Math[_0xc8b62f(0x38d)](_0x3bc579),_0x2e76a7=Math['round'](_0x2e76a7),VisuMZ[_0xc8b62f(0x244)][_0xc8b62f(0x26f)][_0xc8b62f(0x77c)](this,_0x4a9a37,_0x2d380a,_0x40d35d,_0x464cdf,_0x3bc579,_0x2e76a7);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x3e7)]=Window_Base[_0x262cbe(0x800)][_0x262cbe(0x2ee)],Window_Base[_0x262cbe(0x800)][_0x262cbe(0x2ee)]=function(_0x42879a,_0xd8bfde,_0x1ceed9,_0x3fcde7){const _0x500e08=_0x262cbe;_0x1ceed9=Math['round'](_0x1ceed9),_0x3fcde7=Math[_0x500e08(0x38d)](_0x3fcde7),VisuMZ[_0x500e08(0x244)][_0x500e08(0x3e7)][_0x500e08(0x77c)](this,_0x42879a,_0xd8bfde,_0x1ceed9,_0x3fcde7);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x285)]=Window_Selectable[_0x262cbe(0x800)]['itemRect'],Window_Selectable['prototype'][_0x262cbe(0x695)]=function(_0x1d8f0c){const _0x3056f6=_0x262cbe;let _0x501e58=VisuMZ[_0x3056f6(0x244)]['Window_Selectable_itemRect'][_0x3056f6(0x77c)](this,_0x1d8f0c);return _0x501e58['x']=Math[_0x3056f6(0x38d)](_0x501e58['x']),_0x501e58['y']=Math[_0x3056f6(0x38d)](_0x501e58['y']),_0x501e58['width']=Math['round'](_0x501e58[_0x3056f6(0x80a)]),_0x501e58[_0x3056f6(0x100)]=Math[_0x3056f6(0x38d)](_0x501e58[_0x3056f6(0x100)]),_0x501e58;},VisuMZ[_0x262cbe(0x244)]['Window_StatusBase_drawActorSimpleStatus']=Window_StatusBase[_0x262cbe(0x800)][_0x262cbe(0x444)],Window_StatusBase['prototype'][_0x262cbe(0x444)]=function(_0x52de3f,_0x4aea8d,_0x5ed901){const _0x12ee7e=_0x262cbe;_0x4aea8d=Math[_0x12ee7e(0x38d)](_0x4aea8d),_0x5ed901=Math['round'](_0x5ed901),VisuMZ[_0x12ee7e(0x244)]['Window_StatusBase_drawActorSimpleStatus'][_0x12ee7e(0x77c)](this,_0x52de3f,_0x4aea8d,_0x5ed901);},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x4ab)]=function(){const _0x138dc8=_0x262cbe;this[_0x138dc8(0x6b3)]={'duration':0x0,'wholeDuration':0x0,'type':_0x138dc8(0x564),'targetX':this['x'],'targetY':this['y'],'targetScaleX':this[_0x138dc8(0xc6)]['x'],'targetScaleY':this[_0x138dc8(0xc6)]['y'],'targetOpacity':this[_0x138dc8(0x2b3)],'targetBackOpacity':this[_0x138dc8(0x6ce)],'targetContentsOpacity':this['contentsOpacity']};},Window_Base[_0x262cbe(0x800)]['updateCoreEasing']=function(){const _0x2d32df=_0x262cbe;if(!this[_0x2d32df(0x6b3)])return;if(this['_coreEasing'][_0x2d32df(0x700)]<=0x0)return;this['x']=this[_0x2d32df(0x453)](this['x'],this['_coreEasing']['targetX']),this['y']=this['applyCoreEasing'](this['y'],this[_0x2d32df(0x6b3)]['targetY']),this[_0x2d32df(0xc6)]['x']=this[_0x2d32df(0x453)](this[_0x2d32df(0xc6)]['x'],this['_coreEasing'][_0x2d32df(0x1b5)]),this[_0x2d32df(0xc6)]['y']=this[_0x2d32df(0x453)](this['scale']['y'],this[_0x2d32df(0x6b3)][_0x2d32df(0x72e)]),this[_0x2d32df(0x2b3)]=this[_0x2d32df(0x453)](this[_0x2d32df(0x2b3)],this['_coreEasing'][_0x2d32df(0x464)]),this[_0x2d32df(0x6ce)]=this['applyCoreEasing'](this[_0x2d32df(0x6ce)],this[_0x2d32df(0x6b3)][_0x2d32df(0x3d1)]),this[_0x2d32df(0x70c)]=this['applyCoreEasing'](this['contentsOpacity'],this['_coreEasing']['targetContentsOpacity']),this['_coreEasing'][_0x2d32df(0x700)]--;},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x453)]=function(_0x3716ce,_0xb3088a){const _0x469c7f=_0x262cbe;if(!this[_0x469c7f(0x6b3)])return _0xb3088a;const _0x4363d3=this['_coreEasing'][_0x469c7f(0x700)],_0x2edd26=this[_0x469c7f(0x6b3)][_0x469c7f(0x194)],_0x51b6f8=this[_0x469c7f(0x539)]((_0x2edd26-_0x4363d3)/_0x2edd26),_0x67c09e=this[_0x469c7f(0x539)]((_0x2edd26-_0x4363d3+0x1)/_0x2edd26),_0x30bfd0=(_0x3716ce-_0xb3088a*_0x51b6f8)/(0x1-_0x51b6f8);return _0x30bfd0+(_0xb3088a-_0x30bfd0)*_0x67c09e;},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x539)]=function(_0x5ee13c){const _0xa78ca1=_0x262cbe;if(!this[_0xa78ca1(0x6b3)])return _0x5ee13c;return VisuMZ['ApplyEasing'](_0x5ee13c,this[_0xa78ca1(0x6b3)]['type']||_0xa78ca1(0x564));},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x7d3)]=function(_0x368e0c,_0x2d456c){const _0x319a15=_0x262cbe;if(!this[_0x319a15(0x6b3)])return;this['x']=this['_coreEasing'][_0x319a15(0x64a)],this['y']=this[_0x319a15(0x6b3)][_0x319a15(0x706)],this['scale']['x']=this['_coreEasing']['targetScaleX'],this['scale']['y']=this[_0x319a15(0x6b3)][_0x319a15(0x72e)],this[_0x319a15(0x2b3)]=this['_coreEasing'][_0x319a15(0x464)],this[_0x319a15(0x6ce)]=this[_0x319a15(0x6b3)][_0x319a15(0x3d1)],this['contentsOpacity']=this[_0x319a15(0x6b3)][_0x319a15(0x4f4)],this['setupCoreEasing'](_0x368e0c,_0x2d456c,this['x'],this['y'],this[_0x319a15(0xc6)]['x'],this['scale']['y'],this[_0x319a15(0x2b3)],this[_0x319a15(0x6ce)],this[_0x319a15(0x70c)]);},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x6e9)]=function(_0x198391,_0x58e67f,_0x369ad0,_0x17600d,_0x33d9bf,_0x11e622,_0x529933,_0x5da5c7,_0x492449){const _0x44eb4=_0x262cbe;this[_0x44eb4(0x6b3)]={'duration':_0x198391,'wholeDuration':_0x198391,'type':_0x58e67f,'targetX':_0x369ad0,'targetY':_0x17600d,'targetScaleX':_0x33d9bf,'targetScaleY':_0x11e622,'targetOpacity':_0x529933,'targetBackOpacity':_0x5da5c7,'targetContentsOpacity':_0x492449};},Window_Base['prototype'][_0x262cbe(0x205)]=function(_0x37190a,_0x40aa57,_0x8b6931,_0x135b2f,_0x5bce28){const _0x19a28b=_0x262cbe;this[_0x19a28b(0x7db)](),this['contents'][_0x19a28b(0x5ad)]=VisuMZ['CoreEngine'][_0x19a28b(0x84d)][_0x19a28b(0x682)][_0x19a28b(0x31a)];const _0x294de2=VisuMZ[_0x19a28b(0x244)][_0x19a28b(0x84d)][_0x19a28b(0x682)][_0x19a28b(0x1f0)];if(_0x294de2>0x0&&_0x40aa57===TextManager[_0x19a28b(0x3d6)]){const _0x18ee80=_0x135b2f+(this['lineHeight']()-ImageManager[_0x19a28b(0x362)])/0x2;this['drawIcon'](_0x294de2,_0x8b6931+(_0x5bce28-ImageManager[_0x19a28b(0x5eb)]),_0x18ee80),_0x5bce28-=ImageManager[_0x19a28b(0x5eb)]+0x4;}else this['changeTextColor'](ColorManager['systemColor']()),this[_0x19a28b(0x549)](_0x40aa57,_0x8b6931,_0x135b2f,_0x5bce28,_0x19a28b(0x7d9)),_0x5bce28-=this[_0x19a28b(0x5f0)](_0x40aa57)+0x6;this['resetTextColor']();const _0x1c043a=this[_0x19a28b(0x5f0)](this[_0x19a28b(0x740)]?VisuMZ['GroupDigits'](_0x37190a):_0x37190a);_0x1c043a>_0x5bce28?this[_0x19a28b(0x549)](VisuMZ[_0x19a28b(0x244)][_0x19a28b(0x84d)][_0x19a28b(0x682)][_0x19a28b(0x71e)],_0x8b6931,_0x135b2f,_0x5bce28,_0x19a28b(0x7d9)):this[_0x19a28b(0x549)](_0x37190a,_0x8b6931,_0x135b2f,_0x5bce28,_0x19a28b(0x7d9)),this[_0x19a28b(0x7db)]();},Window_Base['prototype']['drawIconBySize']=function(_0x828dfd,_0x5adca9,_0x347923,_0x40ef70,_0x385e42){const _0x5629ec=_0x262cbe,_0x2b5d48=ImageManager[_0x5629ec(0x7c2)](_0x5629ec(0x108)),_0x24a89f=ImageManager[_0x5629ec(0x5eb)],_0x3d5f53=ImageManager[_0x5629ec(0x362)],_0xea137f=_0x828dfd%0x10*_0x24a89f,_0x2281a3=Math['floor'](_0x828dfd/0x10)*_0x3d5f53,_0x5d1fc7=_0x40ef70,_0x573ea7=_0x40ef70;this['contents'][_0x5629ec(0x83c)][_0x5629ec(0x7e1)]=_0x385e42,this[_0x5629ec(0xaf)][_0x5629ec(0x649)](_0x2b5d48,_0xea137f,_0x2281a3,_0x24a89f,_0x3d5f53,_0x5adca9,_0x347923,_0x5d1fc7,_0x573ea7),this[_0x5629ec(0xaf)][_0x5629ec(0x83c)][_0x5629ec(0x7e1)]=!![];},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x595)]=function(_0x22ef3d,_0x149cde,_0x1f1bd3,_0x1d82c9,_0x1f301d,_0x36c985){const _0x4f606e=_0x262cbe,_0x42dcfd=Math[_0x4f606e(0x431)]((_0x1f1bd3-0x2)*_0x1d82c9),_0x4e6723=Sprite_Gauge['prototype'][_0x4f606e(0x4da)][_0x4f606e(0x77c)](this),_0x173dc7=_0x149cde+this[_0x4f606e(0x66d)]()-_0x4e6723-0x2;this[_0x4f606e(0xaf)][_0x4f606e(0x46a)](_0x22ef3d,_0x173dc7,_0x1f1bd3,_0x4e6723,ColorManager[_0x4f606e(0x17e)]()),this[_0x4f606e(0xaf)][_0x4f606e(0x6ee)](_0x22ef3d+0x1,_0x173dc7+0x1,_0x42dcfd,_0x4e6723-0x2,_0x1f301d,_0x36c985);},Window_Scrollable[_0x262cbe(0x6a8)]={'enabled':VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)]['Window'][_0x262cbe(0x3d2)]??!![],'thickness':VisuMZ[_0x262cbe(0x244)]['Settings'][_0x262cbe(0x10e)][_0x262cbe(0xec)]??0x2,'offset':VisuMZ['CoreEngine'][_0x262cbe(0x84d)][_0x262cbe(0x10e)][_0x262cbe(0x729)]??0x2,'bodyColor':VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x10e)][_0x262cbe(0x11c)]??0x0,'offColor':VisuMZ[_0x262cbe(0x244)]['Settings'][_0x262cbe(0x10e)][_0x262cbe(0x85)]??0x7,'offOpacity':VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x10e)][_0x262cbe(0x375)]??0x80},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x12f)]=function(){const _0x526194=_0x262cbe;return Window_Scrollable[_0x526194(0x6a8)][_0x526194(0x299)]&&Window_Scrollable[_0x526194(0x6a8)][_0x526194(0x22b)]>0x0;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x21b)]=Window_Base[_0x262cbe(0x800)][_0x262cbe(0x518)],Window_Base['prototype'][_0x262cbe(0x518)]=function(){const _0x150fca=_0x262cbe;VisuMZ[_0x150fca(0x244)][_0x150fca(0x21b)][_0x150fca(0x77c)](this),this[_0x150fca(0x50b)](),this[_0x150fca(0x1a0)](!![]),this[_0x150fca(0x1a0)](![]);},Window_Base[_0x262cbe(0x800)]['createScrollBarSprites']=function(){const _0x420f93=_0x262cbe;if(!this['isScrollBarVisible']())return;if(this[_0x420f93(0x5fe)]||this[_0x420f93(0x267)])return;this[_0x420f93(0xe0)]={'horz':null,'vert':null,'maxHorz':null,'maxVert':null},this[_0x420f93(0x5fe)]=new Sprite(),this[_0x420f93(0x267)]=new Sprite(),this[_0x420f93(0x286)](this[_0x420f93(0x5fe)]),this[_0x420f93(0x286)](this['_scrollBarVert']);},Window_Base['prototype'][_0x262cbe(0x1a0)]=function(_0x2287c1){const _0x17a6e9=_0x262cbe,_0x4aa806=_0x2287c1?this[_0x17a6e9(0x5fe)]:this[_0x17a6e9(0x267)];if(!_0x4aa806)return;const _0x4ba2e9=Window_Scrollable[_0x17a6e9(0x6a8)],_0x18ea36=_0x4ba2e9[_0x17a6e9(0x22b)],_0x534803=_0x2287c1?this[_0x17a6e9(0x466)]-_0x18ea36*0x2:_0x18ea36,_0x112bf5=_0x2287c1?_0x18ea36:this['innerHeight']-_0x18ea36*0x2;_0x4aa806[_0x17a6e9(0x2a9)]=new Bitmap(_0x534803,_0x112bf5),_0x4aa806[_0x17a6e9(0x6f4)](0x0,0x0,_0x534803,_0x112bf5),this[_0x17a6e9(0x498)](_0x2287c1);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x5e9)]=Window_Base[_0x262cbe(0x800)]['destroyContents'],Window_Base[_0x262cbe(0x800)]['destroyContents']=function(){const _0x3c8297=_0x262cbe;VisuMZ['CoreEngine'][_0x3c8297(0x5e9)][_0x3c8297(0x77c)](this),this[_0x3c8297(0x422)]();},Window_Base['prototype']['destroyScrollBarBitmaps']=function(){const _0x414549=_0x262cbe,_0x43f4b4=[this[_0x414549(0x5fe)],this[_0x414549(0x267)]];for(const _0x46778b of _0x43f4b4){if(_0x46778b&&_0x46778b[_0x414549(0x2a9)])_0x46778b[_0x414549(0x2a9)]['destroy']();}},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x339)]=Window_Scrollable[_0x262cbe(0x800)][_0x262cbe(0x64e)],Window_Scrollable[_0x262cbe(0x800)][_0x262cbe(0x64e)]=function(){const _0x56edf9=_0x262cbe;VisuMZ[_0x56edf9(0x244)]['Window_Scrollable_update'][_0x56edf9(0x77c)](this),this[_0x56edf9(0x213)]();},Window_Scrollable[_0x262cbe(0x800)][_0x262cbe(0x213)]=function(){const _0x44e295=_0x262cbe;this[_0x44e295(0x69d)](),this[_0x44e295(0x37e)](!![]),this[_0x44e295(0x37e)](![]),this[_0x44e295(0x498)](!![]),this['updateScrollBarPosition'](![]);},Window_Scrollable[_0x262cbe(0x800)][_0x262cbe(0x69d)]=function(){const _0x39d1fc=_0x262cbe,_0x57243c=[this[_0x39d1fc(0x5fe)],this[_0x39d1fc(0x267)]];for(const _0x343d87 of _0x57243c){_0x343d87&&(_0x343d87['visible']=this['isScrollBarVisible']()&&this[_0x39d1fc(0xf6)]());}},Window_Scrollable[_0x262cbe(0x800)][_0x262cbe(0x37e)]=function(_0x4d7652){const _0x4c9f6f=_0x262cbe;if(!this['_lastScrollBarValues'])return;const _0x472f08=this['scrollbar'](_0x4d7652),_0x4d3fe3=this[_0x4c9f6f(0x184)](_0x4d7652),_0x5b43c0=_0x4d7652?_0x4c9f6f(0x57e):_0x4c9f6f(0x311),_0x254e45=_0x4d7652?_0x4c9f6f(0x3f6):_0x4c9f6f(0x433);(this[_0x4c9f6f(0xe0)][_0x5b43c0]!==_0x472f08||this['_lastScrollBarValues'][_0x254e45]!==_0x4d3fe3)&&(this[_0x4c9f6f(0xe0)][_0x5b43c0]=_0x472f08,this[_0x4c9f6f(0xe0)][_0x254e45]=_0x4d3fe3,this['refreshScrollBarBitmap'](_0x4d7652,_0x472f08,_0x4d3fe3));},Window_Scrollable['prototype'][_0x262cbe(0x4ed)]=function(_0x24f751){const _0x50a481=_0x262cbe;if(this[_0x50a481(0x293)]!==undefined)return _0x24f751?this[_0x50a481(0x295)]():this[_0x50a481(0x6ca)]['y'];return _0x24f751?this[_0x50a481(0x295)]():this[_0x50a481(0x627)]();},Window_Scrollable['prototype'][_0x262cbe(0x184)]=function(_0x5e7c4b){const _0x5b373f=_0x262cbe;if(this[_0x5b373f(0x293)]!==undefined)return _0x5e7c4b?this[_0x5b373f(0x3fe)]():Math[_0x5b373f(0x256)](0x0,this[_0x5b373f(0x293)]-this['innerHeight']);return _0x5e7c4b?this[_0x5b373f(0x3fe)]():this[_0x5b373f(0x26d)]();},Window_Scrollable['prototype'][_0x262cbe(0x5f8)]=function(){const _0x513fa2=_0x262cbe;if(this[_0x513fa2(0x293)]!==undefined)return Math['max'](0x0,this['_allTextHeight']);return this[_0x513fa2(0x33a)]();},Window_Scrollable[_0x262cbe(0x800)][_0x262cbe(0x4d3)]=function(_0x316fd7,_0x2c24ee,_0x5f1859){const _0x53a48a=_0x262cbe,_0x4cc756=_0x316fd7?this[_0x53a48a(0x5fe)]:this[_0x53a48a(0x267)];if(!_0x4cc756)return;if(!_0x4cc756[_0x53a48a(0x2a9)])return;const _0xe221f5=_0x4cc756['bitmap'];_0xe221f5[_0x53a48a(0x294)]();if(_0x5f1859<=0x0)return;const _0x212eb2=_0x316fd7?this[_0x53a48a(0x466)]/this['overallWidth']():this['innerHeight']/this[_0x53a48a(0x5f8)](),_0x2c0c6e=_0x316fd7?Math['round'](_0x2c24ee*_0x212eb2):0x0,_0x18af3e=_0x316fd7?0x0:Math[_0x53a48a(0x38d)](_0x2c24ee*_0x212eb2),_0x1912f6=_0x316fd7?Math[_0x53a48a(0x38d)](_0xe221f5[_0x53a48a(0x80a)]*_0x212eb2):_0xe221f5['width'],_0x5455a0=_0x316fd7?_0xe221f5[_0x53a48a(0x100)]:Math[_0x53a48a(0x38d)](_0xe221f5['height']*_0x212eb2),_0x13e9b5=Window_Scrollable[_0x53a48a(0x6a8)],_0x56b1c2=ColorManager[_0x53a48a(0x5be)](_0x13e9b5[_0x53a48a(0x4af)]),_0x30c83d=ColorManager[_0x53a48a(0x5be)](_0x13e9b5[_0x53a48a(0x548)]),_0x3a56f6=_0x13e9b5[_0x53a48a(0x7e7)];_0xe221f5[_0x53a48a(0x404)]=_0x3a56f6,_0xe221f5[_0x53a48a(0x69b)](_0x56b1c2),_0xe221f5['paintOpacity']=0xff,_0xe221f5[_0x53a48a(0x46a)](_0x2c0c6e,_0x18af3e,_0x1912f6,_0x5455a0,_0x30c83d);},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x498)]=function(_0xde1d85){const _0x4b628a=_0x262cbe,_0x48c700=_0xde1d85?this[_0x4b628a(0x5fe)]:this[_0x4b628a(0x267)];if(!_0x48c700)return;const _0xd649d8=Window_Scrollable[_0x4b628a(0x6a8)],_0x133533=_0xd649d8[_0x4b628a(0x22b)],_0x194ec8=_0xd649d8[_0x4b628a(0x227)];if(!_0x48c700[_0x4b628a(0x4c8)])return;_0x48c700['x']=this[_0x4b628a(0x3e2)]+(_0xde1d85?_0x133533:this[_0x4b628a(0x466)]+_0x194ec8),_0x48c700['y']=this[_0x4b628a(0x3e2)]+(_0xde1d85?this[_0x4b628a(0x9d)]+_0x194ec8:_0x133533);},Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x5fd)]=function(_0x506456){const _0x2b704a=_0x262cbe;let _0x295afe=this[_0x2b704a(0x326)]();const _0x358a97=this['maxItems'](),_0x546ff7=this[_0x2b704a(0x398)]();if(this[_0x2b704a(0x747)]()&&(_0x295afe<_0x358a97||_0x506456&&_0x546ff7===0x1)){_0x295afe+=_0x546ff7;if(_0x295afe>=_0x358a97)_0x295afe=_0x358a97-0x1;this[_0x2b704a(0x51b)](_0x295afe);}else!this[_0x2b704a(0x747)]()&&((_0x295afe<_0x358a97-_0x546ff7||_0x506456&&_0x546ff7===0x1)&&this[_0x2b704a(0x51b)]((_0x295afe+_0x546ff7)%_0x358a97));},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x4a4)]=Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x5fd)],Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x5fd)]=function(_0x2ba6d6){const _0x1aed67=_0x262cbe;this[_0x1aed67(0x747)]()&&_0x2ba6d6&&this[_0x1aed67(0x398)]()===0x1&&this[_0x1aed67(0x326)]()===this['maxItems']()-0x1?this[_0x1aed67(0x51b)](0x0):VisuMZ[_0x1aed67(0x244)][_0x1aed67(0x4a4)]['call'](this,_0x2ba6d6);},Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x176)]=function(_0x6abb5){const _0x3cb215=_0x262cbe;let _0x1249c7=Math['max'](0x0,this[_0x3cb215(0x326)]());const _0x243898=this[_0x3cb215(0x1aa)](),_0x50e00a=this['maxCols']();if(this[_0x3cb215(0x747)]()&&_0x1249c7>0x0||_0x6abb5&&_0x50e00a===0x1){_0x1249c7-=_0x50e00a;if(_0x1249c7<=0x0)_0x1249c7=0x0;this[_0x3cb215(0x51b)](_0x1249c7);}else!this[_0x3cb215(0x747)]()&&((_0x1249c7>=_0x50e00a||_0x6abb5&&_0x50e00a===0x1)&&this['smoothSelect']((_0x1249c7-_0x50e00a+_0x243898)%_0x243898));},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x544)]=Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x176)],Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x176)]=function(_0x15000f){const _0x54b09c=_0x262cbe;this['isUseModernControls']()&&_0x15000f&&this['maxCols']()===0x1&&this[_0x54b09c(0x326)]()===0x0?this['smoothSelect'](this[_0x54b09c(0x1aa)]()-0x1):VisuMZ['CoreEngine']['Window_Selectable_cursorUp']['call'](this,_0x15000f);},Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x747)]=function(){const _0x13ca68=_0x262cbe;return VisuMZ['CoreEngine'][_0x13ca68(0x84d)]['QoL'][_0x13ca68(0x22e)];},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x3ee)]=Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x7f9)],Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x7f9)]=function(){const _0x21bf91=_0x262cbe;this[_0x21bf91(0x747)]()?(this[_0x21bf91(0x2c0)](),this[_0x21bf91(0x1cb)]()):VisuMZ[_0x21bf91(0x244)][_0x21bf91(0x3ee)][_0x21bf91(0x77c)](this);},Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x604)]=function(){return!![];},Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x2c0)]=function(){const _0x17ba34=_0x262cbe;if(this['isCursorMovable']()){const _0xbc329=this[_0x17ba34(0x326)]();Input[_0x17ba34(0x437)](_0x17ba34(0x557))&&(Input[_0x17ba34(0xb7)]('shift')&&this[_0x17ba34(0x604)]()?this[_0x17ba34(0x251)]():this[_0x17ba34(0x5fd)](Input[_0x17ba34(0x41b)](_0x17ba34(0x557)))),Input['isRepeated']('up')&&(Input[_0x17ba34(0xb7)](_0x17ba34(0x597))&&this[_0x17ba34(0x604)]()?this[_0x17ba34(0x138)]():this['cursorUp'](Input['isTriggered']('up'))),Input[_0x17ba34(0x437)]('right')&&this[_0x17ba34(0x605)](Input[_0x17ba34(0x41b)](_0x17ba34(0x7d9))),Input[_0x17ba34(0x437)](_0x17ba34(0x5ec))&&this[_0x17ba34(0x5b9)](Input[_0x17ba34(0x41b)](_0x17ba34(0x5ec))),!this[_0x17ba34(0x7b)]('pagedown')&&Input[_0x17ba34(0x437)](_0x17ba34(0x9e))&&this['cursorPagedown'](),!this['isHandled']('pageup')&&Input[_0x17ba34(0x437)](_0x17ba34(0x797))&&this[_0x17ba34(0x138)](),this[_0x17ba34(0x326)]()!==_0xbc329&&this[_0x17ba34(0x512)]();}},Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x1cb)]=function(){const _0x20b4f7=_0x262cbe;if(this[_0x20b4f7(0x364)]()){const _0x3d35ff=this[_0x20b4f7(0x326)]();Input[_0x20b4f7(0x41b)](_0x20b4f7(0x6b6))&&this[_0x20b4f7(0x51b)](Math[_0x20b4f7(0x5d0)](this[_0x20b4f7(0x326)](),0x0)),Input[_0x20b4f7(0x41b)]('end')&&this['smoothSelect'](Math[_0x20b4f7(0x256)](this[_0x20b4f7(0x326)](),this[_0x20b4f7(0x1aa)]()-0x1)),this[_0x20b4f7(0x326)]()!==_0x3d35ff&&this[_0x20b4f7(0x512)]();}},VisuMZ['CoreEngine'][_0x262cbe(0x5ce)]=Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x7dc)],Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x7dc)]=function(){const _0x3207fb=_0x262cbe;this['isUseModernControls']()?this[_0x3207fb(0x2bf)]():VisuMZ[_0x3207fb(0x244)][_0x3207fb(0x5ce)][_0x3207fb(0x77c)](this);},Window_Selectable[_0x262cbe(0x800)]['processTouchModernControls']=function(){const _0x100c06=_0x262cbe;VisuMZ['CoreEngine'][_0x100c06(0x5ce)][_0x100c06(0x77c)](this);},Window_Selectable['prototype'][_0x262cbe(0x388)]=function(){const _0x283e10=_0x262cbe;return VisuMZ[_0x283e10(0x244)][_0x283e10(0x84d)][_0x283e10(0x10e)][_0x283e10(0x415)];},Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0xbc)]=function(){const _0x50e1e6=_0x262cbe;return VisuMZ[_0x50e1e6(0x244)][_0x50e1e6(0x84d)][_0x50e1e6(0x10e)][_0x50e1e6(0x6b8)];},Window_Selectable['prototype']['itemHeight']=function(){const _0x5d2829=_0x262cbe;return Window_Scrollable[_0x5d2829(0x800)][_0x5d2829(0x21c)][_0x5d2829(0x77c)](this)+VisuMZ[_0x5d2829(0x244)]['Settings']['Window'][_0x5d2829(0x710)];;},VisuMZ['CoreEngine'][_0x262cbe(0x82c)]=Window_Selectable[_0x262cbe(0x800)][_0x262cbe(0x282)],Window_Selectable['prototype'][_0x262cbe(0x282)]=function(_0x46b339){const _0x7f9f1=_0x262cbe,_0x3375ca=VisuMZ[_0x7f9f1(0x244)][_0x7f9f1(0x84d)][_0x7f9f1(0x10e)];if(_0x3375ca[_0x7f9f1(0x14f)]===![])return;_0x3375ca[_0x7f9f1(0x511)]?_0x3375ca[_0x7f9f1(0x511)][_0x7f9f1(0x77c)](this,_0x46b339):VisuMZ[_0x7f9f1(0x244)][_0x7f9f1(0x82c)][_0x7f9f1(0x77c)](this,_0x46b339);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x3f9)]=Window_Gold['prototype']['refresh'],Window_Gold['prototype'][_0x262cbe(0x14a)]=function(){const _0x46e786=_0x262cbe;this[_0x46e786(0x7a2)]()?this[_0x46e786(0x163)]():VisuMZ[_0x46e786(0x244)]['Window_Gold_refresh']['call'](this);},Window_Gold[_0x262cbe(0x800)][_0x262cbe(0x7a2)]=function(){const _0x472314=_0x262cbe;if(TextManager[_0x472314(0x3d6)]!==this['currencyUnit']())return![];return VisuMZ[_0x472314(0x244)][_0x472314(0x84d)][_0x472314(0x682)][_0x472314(0x645)];},Window_Gold[_0x262cbe(0x800)][_0x262cbe(0x163)]=function(){const _0x3139cb=_0x262cbe;this[_0x3139cb(0x7db)](),this[_0x3139cb(0xaf)][_0x3139cb(0x294)](),this[_0x3139cb(0xaf)][_0x3139cb(0x5ad)]=VisuMZ[_0x3139cb(0x244)][_0x3139cb(0x84d)][_0x3139cb(0x682)][_0x3139cb(0x31a)];const _0x58905f=VisuMZ[_0x3139cb(0x244)][_0x3139cb(0x84d)]['Gold']['GoldIcon'],_0x1fae17=this[_0x3139cb(0x15f)](0x0);if(_0x58905f>0x0){const _0x3a9ea4=_0x1fae17['y']+(this['lineHeight']()-ImageManager['iconHeight'])/0x2;this['drawIcon'](_0x58905f,_0x1fae17['x'],_0x3a9ea4);const _0x3b693e=ImageManager['iconWidth']+0x4;_0x1fae17['x']+=_0x3b693e,_0x1fae17[_0x3139cb(0x80a)]-=_0x3b693e;}this[_0x3139cb(0x3c5)](ColorManager['systemColor']()),this[_0x3139cb(0x549)](this['currencyUnit'](),_0x1fae17['x'],_0x1fae17['y'],_0x1fae17[_0x3139cb(0x80a)],'left');const _0x3f1a8a=this['textWidth'](this[_0x3139cb(0x3d6)]())+0x6;;_0x1fae17['x']+=_0x3f1a8a,_0x1fae17[_0x3139cb(0x80a)]-=_0x3f1a8a,this[_0x3139cb(0x28d)]();const _0xcbe745=this[_0x3139cb(0x531)](),_0x2277a4=this['textWidth'](this[_0x3139cb(0x740)]?VisuMZ[_0x3139cb(0x270)](this[_0x3139cb(0x531)]()):this[_0x3139cb(0x531)]());_0x2277a4>_0x1fae17[_0x3139cb(0x80a)]?this[_0x3139cb(0x549)](VisuMZ[_0x3139cb(0x244)][_0x3139cb(0x84d)][_0x3139cb(0x682)][_0x3139cb(0x71e)],_0x1fae17['x'],_0x1fae17['y'],_0x1fae17[_0x3139cb(0x80a)],_0x3139cb(0x7d9)):this[_0x3139cb(0x549)](this[_0x3139cb(0x531)](),_0x1fae17['x'],_0x1fae17['y'],_0x1fae17['width'],_0x3139cb(0x7d9)),this[_0x3139cb(0x7db)]();},Window_StatusBase[_0x262cbe(0x800)][_0x262cbe(0x694)]=function(_0x58c1b9,_0x49b4ce,_0x568a21,_0x1c32ab,_0x10aa02){const _0x396996=_0x262cbe;_0x1c32ab=String(_0x1c32ab||'')['toUpperCase']();if(VisuMZ['CoreEngine'][_0x396996(0x84d)][_0x396996(0x778)][_0x396996(0x7b5)]){const _0x49c7b9=VisuMZ[_0x396996(0x2e9)](_0x1c32ab);_0x10aa02?(this['drawIconBySize'](_0x49c7b9,_0x58c1b9,_0x49b4ce,this[_0x396996(0x793)]()),_0x568a21-=this[_0x396996(0x793)]()+0x2,_0x58c1b9+=this[_0x396996(0x793)]()+0x2):(this[_0x396996(0x279)](_0x49c7b9,_0x58c1b9+0x2,_0x49b4ce+0x2),_0x568a21-=ImageManager['iconWidth']+0x4,_0x58c1b9+=ImageManager[_0x396996(0x5eb)]+0x4);}const _0x43faf1=TextManager['param'](_0x1c32ab);this[_0x396996(0x7db)](),this['changeTextColor'](ColorManager['systemColor']()),_0x10aa02?(this[_0x396996(0xaf)][_0x396996(0x5ad)]=this['smallParamFontSize'](),this[_0x396996(0xaf)]['drawText'](_0x43faf1,_0x58c1b9,_0x49b4ce,_0x568a21,this[_0x396996(0x793)](),_0x396996(0x5ec))):this[_0x396996(0x549)](_0x43faf1,_0x58c1b9,_0x49b4ce,_0x568a21),this[_0x396996(0x7db)]();},Window_StatusBase[_0x262cbe(0x800)][_0x262cbe(0x4ac)]=function(){const _0x4d115b=_0x262cbe;return $gameSystem[_0x4d115b(0xc5)]()-0x8;},Window_StatusBase[_0x262cbe(0x800)][_0x262cbe(0x421)]=function(_0x4c4af8,_0x52f57a,_0x5555d5,_0x1ed35e){const _0x4cfbaa=_0x262cbe;_0x1ed35e=_0x1ed35e||0xa8,this[_0x4cfbaa(0x28d)]();if(VisuMZ[_0x4cfbaa(0x244)][_0x4cfbaa(0x84d)]['UI'][_0x4cfbaa(0x553)])this[_0x4cfbaa(0x5db)](_0x4c4af8['currentClass']()['name'],_0x52f57a,_0x5555d5,_0x1ed35e);else{const _0xffaf21=_0x4c4af8[_0x4cfbaa(0x18f)]()['name'][_0x4cfbaa(0x641)](/\\I\[(\d+)\]/gi,'');this[_0x4cfbaa(0x549)](_0xffaf21,_0x52f57a,_0x5555d5,_0x1ed35e);}},Window_StatusBase[_0x262cbe(0x800)][_0x262cbe(0x601)]=function(_0x1594a1,_0x1fdff4,_0x17702b,_0x4907c8){const _0x353e13=_0x262cbe;_0x4907c8=_0x4907c8||0x10e,this[_0x353e13(0x28d)]();if(VisuMZ['CoreEngine'][_0x353e13(0x84d)]['UI'][_0x353e13(0x22d)])this['drawTextEx'](_0x1594a1[_0x353e13(0x7bd)](),_0x1fdff4,_0x17702b,_0x4907c8);else{const _0x4f139f=_0x1594a1[_0x353e13(0x7bd)]()[_0x353e13(0x641)](/\\I\[(\d+)\]/gi,'');this[_0x353e13(0x549)](_0x1594a1[_0x353e13(0x7bd)](),_0x1fdff4,_0x17702b,_0x4907c8);}},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x7eb)]=Window_StatusBase['prototype']['drawActorLevel'],Window_StatusBase[_0x262cbe(0x800)][_0x262cbe(0x16d)]=function(_0x4cf2a3,_0x1cb821,_0x2c33d0){const _0x35fda=_0x262cbe;if(VisuMZ[_0x35fda(0x244)][_0x35fda(0x84d)]['Param'][_0x35fda(0x3a6)]===![])return;if(this['isExpGaugeDrawn']())this[_0x35fda(0x3f8)](_0x4cf2a3,_0x1cb821,_0x2c33d0);VisuMZ['CoreEngine'][_0x35fda(0x7eb)][_0x35fda(0x77c)](this,_0x4cf2a3,_0x1cb821,_0x2c33d0);},Window_StatusBase[_0x262cbe(0x800)]['isExpGaugeDrawn']=function(){const _0x5cf5b8=_0x262cbe;return VisuMZ['CoreEngine'][_0x5cf5b8(0x84d)]['UI']['LvExpGauge'];},Window_StatusBase['prototype'][_0x262cbe(0x3f8)]=function(_0x5d2770,_0x460a1b,_0x1eab76){const _0x5460c0=_0x262cbe;if(!_0x5d2770)return;if(!_0x5d2770[_0x5460c0(0x6e7)]())return;const _0x38c184=0x80,_0x4c4462=_0x5d2770['expRate']();let _0x494c1c=ColorManager['expGaugeColor1'](),_0x3aa940=ColorManager['expGaugeColor2']();_0x4c4462>=0x1&&(_0x494c1c=ColorManager[_0x5460c0(0x65b)](),_0x3aa940=ColorManager['maxLvGaugeColor2']()),this[_0x5460c0(0x595)](_0x460a1b,_0x1eab76,_0x38c184,_0x4c4462,_0x494c1c,_0x3aa940);},Window_EquipStatus['prototype']['drawAllParams']=function(){const _0x2199cb=_0x262cbe;let _0x5d9ddc=0x0;for(const _0x486848 of VisuMZ[_0x2199cb(0x244)][_0x2199cb(0x84d)][_0x2199cb(0x778)]['DisplayedParams']){const _0x5a33f0=this[_0x2199cb(0x835)](),_0x5b4205=this[_0x2199cb(0x784)](_0x5d9ddc);this['drawItem'](_0x5a33f0,_0x5b4205,_0x486848),_0x5d9ddc++;}},Window_EquipStatus['prototype'][_0x262cbe(0x4ef)]=function(_0xb7a159,_0x579994,_0x536665){const _0x54cfb7=_0x262cbe,_0x1c9b6d=this['paramX']()-this[_0x54cfb7(0x835)]()*0x2;this['drawParamText'](_0xb7a159,_0x579994,_0x1c9b6d,_0x536665,![]);},Window_EquipStatus[_0x262cbe(0x800)][_0x262cbe(0x497)]=function(_0x43a398,_0x1d1cca,_0x247688){const _0xd7fe57=_0x262cbe,_0x2cf34e=this['paramWidth']();this[_0xd7fe57(0x28d)](),this[_0xd7fe57(0x549)](this['_actor']['paramValueByName'](_0x247688,!![]),_0x43a398,_0x1d1cca,_0x2cf34e,_0xd7fe57(0x7d9));},Window_EquipStatus['prototype'][_0x262cbe(0x588)]=function(_0x532920,_0x5cf128){const _0x5b0533=_0x262cbe,_0x479ab7=this[_0x5b0533(0x767)]();this['changeTextColor'](ColorManager['systemColor']());const _0x209851=VisuMZ[_0x5b0533(0x244)]['Settings']['UI'][_0x5b0533(0x4cd)];this[_0x5b0533(0x549)](_0x209851,_0x532920,_0x5cf128,_0x479ab7,_0x5b0533(0x3b5));},Window_EquipStatus[_0x262cbe(0x800)]['drawNewParam']=function(_0x677131,_0x5cbe79,_0x79672c){const _0x3a6fe6=_0x262cbe,_0x50719d=this[_0x3a6fe6(0x304)](),_0xe60e02=this[_0x3a6fe6(0x494)]['paramValueByName'](_0x79672c),_0x33c593=_0xe60e02-this['_actor']['paramValueByName'](_0x79672c);this[_0x3a6fe6(0x3c5)](ColorManager[_0x3a6fe6(0x671)](_0x33c593)),this['drawText'](this[_0x3a6fe6(0x494)]['paramValueByName'](_0x79672c,!![]),_0x677131,_0x5cbe79,_0x50719d,_0x3a6fe6(0x7d9));},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x677)]=Window_EquipItem[_0x262cbe(0x800)]['isEnabled'],Window_EquipItem[_0x262cbe(0x800)][_0x262cbe(0x1c1)]=function(_0x135707){const _0x2ffca3=_0x262cbe;return _0x135707&&this[_0x2ffca3(0x65e)]?this[_0x2ffca3(0x65e)][_0x2ffca3(0x3b8)](_0x135707):VisuMZ[_0x2ffca3(0x244)][_0x2ffca3(0x677)]['call'](this,_0x135707);},Window_StatusParams[_0x262cbe(0x800)][_0x262cbe(0x1aa)]=function(){const _0x5dcb53=_0x262cbe;return VisuMZ[_0x5dcb53(0x244)][_0x5dcb53(0x84d)]['Param'][_0x5dcb53(0x3e9)][_0x5dcb53(0x3c3)];},Window_StatusParams[_0x262cbe(0x800)][_0x262cbe(0x7f2)]=function(_0x4b20a3){const _0xef74cd=_0x262cbe,_0x50d234=this[_0xef74cd(0x15f)](_0x4b20a3),_0x269311=VisuMZ[_0xef74cd(0x244)][_0xef74cd(0x84d)][_0xef74cd(0x778)]['DisplayedParams'][_0x4b20a3],_0x1745e1=TextManager['param'](_0x269311),_0x4498fc=this[_0xef74cd(0x65e)]['paramValueByName'](_0x269311,!![]);this['drawParamText'](_0x50d234['x'],_0x50d234['y'],0xa0,_0x269311,![]),this[_0xef74cd(0x28d)](),this[_0xef74cd(0x549)](_0x4498fc,_0x50d234['x']+0xa0,_0x50d234['y'],0x3c,_0xef74cd(0x7d9));};if(VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)]['KeyboardInput']['EnableNameInput']){VisuMZ[_0x262cbe(0x244)]['Settings'][_0x262cbe(0x67f)][_0x262cbe(0x516)]&&(Window_NameInput[_0x262cbe(0x178)]=['Q','W','E','R','T','Y','U','I','O','P','A','S','D','F','G','H','J','K','L','\x27','`','Z','X','C','V','B','N','M',',','.','q','w','e','r','t','y','u','i','o','p','a','s','d','f','g','h','j','k','l',':','~','z','x','c','v','b','n','m','\x22',';','1','2','3','4','5','6','7','8','9','0','!','@','#','$','%','^','&','*','(',')','<','>','[',']','-','_','/','\x20',_0x262cbe(0x2a5),'OK']);;VisuMZ['CoreEngine'][_0x262cbe(0x6e0)]=Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x1ad)],Window_NameInput['prototype'][_0x262cbe(0x1ad)]=function(_0x2a37cc){const _0x10ea7d=_0x262cbe;this[_0x10ea7d(0x7c7)]=this[_0x10ea7d(0x289)](),VisuMZ['CoreEngine'][_0x10ea7d(0x6e0)][_0x10ea7d(0x77c)](this,_0x2a37cc),this[_0x10ea7d(0x7c7)]==='default'?this[_0x10ea7d(0x772)](0x0):(Input[_0x10ea7d(0x294)](),this[_0x10ea7d(0x98)]());},Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x289)]=function(){const _0x1d6cca=_0x262cbe;if(Input[_0x1d6cca(0x55a)]())return _0x1d6cca(0x78c);return VisuMZ[_0x1d6cca(0x244)][_0x1d6cca(0x84d)][_0x1d6cca(0x67f)][_0x1d6cca(0x2f5)]||_0x1d6cca(0x570);},VisuMZ[_0x262cbe(0x244)]['Window_NameInput_processHandling']=Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0xa2)],Window_NameInput[_0x262cbe(0x800)]['processHandling']=function(){const _0x185b74=_0x262cbe;if(!this['isOpen']())return;if(!this[_0x185b74(0x477)])return;if(this[_0x185b74(0x7c7)]===_0x185b74(0x570)&&Input['isGamepadTriggered']())this['switchModes'](_0x185b74(0x78c));else{if(Input[_0x185b74(0x40e)]('backspace'))Input[_0x185b74(0x294)](),this[_0x185b74(0x3be)]();else{if(Input[_0x185b74(0x41b)](_0x185b74(0x30a)))Input['clear'](),this[_0x185b74(0x7c7)]===_0x185b74(0x570)?this['switchModes']('default'):this[_0x185b74(0x75a)](_0x185b74(0x570));else{if(this[_0x185b74(0x7c7)]===_0x185b74(0x570))this[_0x185b74(0x2d2)]();else Input['isSpecialCode'](_0x185b74(0x7ad))?(Input[_0x185b74(0x294)](),this['switchModes'](_0x185b74(0x570))):VisuMZ['CoreEngine']['Window_NameInput_processHandling'][_0x185b74(0x77c)](this);}}}},VisuMZ['CoreEngine']['Window_NameInput_processTouch']=Window_NameInput[_0x262cbe(0x800)]['processTouch'],Window_NameInput['prototype'][_0x262cbe(0x7dc)]=function(){const _0x2f3b2b=_0x262cbe;if(!this['isOpenAndActive']())return;if(this[_0x2f3b2b(0x7c7)]==='keyboard'){if(TouchInput[_0x2f3b2b(0x41b)]()&&this[_0x2f3b2b(0x35d)]())this[_0x2f3b2b(0x75a)](_0x2f3b2b(0x78c));else TouchInput[_0x2f3b2b(0x1f9)]()&&this[_0x2f3b2b(0x75a)](_0x2f3b2b(0x78c));}else VisuMZ[_0x2f3b2b(0x244)][_0x2f3b2b(0x1dd)]['call'](this);},Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x2d2)]=function(){const _0x3d37e8=_0x262cbe;if(Input['isSpecialCode']('enter'))Input[_0x3d37e8(0x294)](),this[_0x3d37e8(0x842)]();else{if(Input['_inputString']!==undefined){let _0x5bd099=Input[_0x3d37e8(0x4e0)],_0x271753=_0x5bd099[_0x3d37e8(0x3c3)];for(let _0x11cbf6=0x0;_0x11cbf6<_0x271753;++_0x11cbf6){this[_0x3d37e8(0xf3)][_0x3d37e8(0x225)](_0x5bd099[_0x11cbf6])?SoundManager[_0x3d37e8(0x2af)]():SoundManager['playBuzzer']();}Input[_0x3d37e8(0x294)]();}}},Window_NameInput[_0x262cbe(0x800)]['switchModes']=function(_0x30673a){const _0x22cf75=_0x262cbe;let _0x529dbb=this[_0x22cf75(0x7c7)];this[_0x22cf75(0x7c7)]=_0x30673a,_0x529dbb!==this[_0x22cf75(0x7c7)]&&(this[_0x22cf75(0x14a)](),SoundManager[_0x22cf75(0x2af)](),this[_0x22cf75(0x7c7)]==='default'?this[_0x22cf75(0x772)](0x0):this[_0x22cf75(0x772)](-0x1));},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x702)]=Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x5fd)],Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x5fd)]=function(_0x3b4b27){const _0x26a98c=_0x262cbe;if(this['_mode']==='keyboard'&&!Input[_0x26a98c(0x51c)]())return;if(Input['isNumpadPressed']())return;VisuMZ['CoreEngine'][_0x26a98c(0x702)]['call'](this,_0x3b4b27),this[_0x26a98c(0x75a)](_0x26a98c(0x78c));},VisuMZ['CoreEngine'][_0x262cbe(0x449)]=Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x176)],Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x176)]=function(_0x43c693){const _0x1bcf58=_0x262cbe;if(this[_0x1bcf58(0x7c7)]===_0x1bcf58(0x570)&&!Input[_0x1bcf58(0x51c)]())return;if(Input['isNumpadPressed']())return;VisuMZ['CoreEngine']['Window_NameInput_cursorUp'][_0x1bcf58(0x77c)](this,_0x43c693),this[_0x1bcf58(0x75a)](_0x1bcf58(0x78c));},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x7ee)]=Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x605)],Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x605)]=function(_0x1ff212){const _0x4bc072=_0x262cbe;if(this['_mode']==='keyboard'&&!Input[_0x4bc072(0x51c)]())return;if(Input[_0x4bc072(0x785)]())return;VisuMZ['CoreEngine']['Window_NameInput_cursorRight'][_0x4bc072(0x77c)](this,_0x1ff212),this['switchModes'](_0x4bc072(0x78c));},VisuMZ[_0x262cbe(0x244)]['Window_NameInput_cursorLeft']=Window_NameInput[_0x262cbe(0x800)]['cursorLeft'],Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x5b9)]=function(_0x3ad978){const _0xf4e0cb=_0x262cbe;if(this[_0xf4e0cb(0x7c7)]===_0xf4e0cb(0x570)&&!Input['isArrowPressed']())return;if(Input['isNumpadPressed']())return;VisuMZ['CoreEngine'][_0xf4e0cb(0x6dd)]['call'](this,_0x3ad978),this['switchModes']('default');},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x33b)]=Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x251)],Window_NameInput['prototype'][_0x262cbe(0x251)]=function(){const _0xba9db2=_0x262cbe;if(this[_0xba9db2(0x7c7)]===_0xba9db2(0x570))return;if(Input[_0xba9db2(0x785)]())return;VisuMZ[_0xba9db2(0x244)][_0xba9db2(0x33b)][_0xba9db2(0x77c)](this),this[_0xba9db2(0x75a)]('default');},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x189)]=Window_NameInput['prototype'][_0x262cbe(0x138)],Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x138)]=function(){const _0x5908d4=_0x262cbe;if(this[_0x5908d4(0x7c7)]===_0x5908d4(0x570))return;if(Input[_0x5908d4(0x785)]())return;VisuMZ[_0x5908d4(0x244)][_0x5908d4(0x189)][_0x5908d4(0x77c)](this),this['switchModes'](_0x5908d4(0x78c));},VisuMZ['CoreEngine'][_0x262cbe(0x3e5)]=Window_NameInput['prototype'][_0x262cbe(0x14a)],Window_NameInput[_0x262cbe(0x800)][_0x262cbe(0x14a)]=function(){const _0x378347=_0x262cbe;if(this[_0x378347(0x7c7)]==='keyboard'){this[_0x378347(0xaf)][_0x378347(0x294)](),this[_0x378347(0x72a)]['clear'](),this[_0x378347(0x28d)]();let _0x3adb75=VisuMZ['CoreEngine'][_0x378347(0x84d)][_0x378347(0x67f)][_0x378347(0x2b6)][_0x378347(0x7e)]('\x0a'),_0x539d5e=_0x3adb75[_0x378347(0x3c3)],_0x4d1524=(this[_0x378347(0x9d)]-_0x539d5e*this['lineHeight']())/0x2;for(let _0xc954e3=0x0;_0xc954e3<_0x539d5e;++_0xc954e3){let _0x3ff4a3=_0x3adb75[_0xc954e3],_0xaa6a90=this[_0x378347(0x382)](_0x3ff4a3)[_0x378347(0x80a)],_0x5b3d77=Math['floor']((this[_0x378347(0xaf)][_0x378347(0x80a)]-_0xaa6a90)/0x2);this[_0x378347(0x5db)](_0x3ff4a3,_0x5b3d77,_0x4d1524),_0x4d1524+=this[_0x378347(0x66d)]();}}else VisuMZ[_0x378347(0x244)]['Window_NameInput_refresh'][_0x378347(0x77c)](this);};};VisuMZ['CoreEngine'][_0x262cbe(0x37d)]=Window_ShopSell[_0x262cbe(0x800)][_0x262cbe(0x1c1)],Window_ShopSell[_0x262cbe(0x800)][_0x262cbe(0x1c1)]=function(_0x3c4317){const _0x563adc=_0x262cbe;return VisuMZ[_0x563adc(0x244)][_0x563adc(0x84d)][_0x563adc(0x754)]['KeyItemProtect']&&DataManager[_0x563adc(0x30d)](_0x3c4317)?![]:VisuMZ['CoreEngine']['Window_ShopSell_isEnabled'][_0x563adc(0x77c)](this,_0x3c4317);},Window_NumberInput[_0x262cbe(0x800)][_0x262cbe(0x747)]=function(){return![];};VisuMZ['CoreEngine']['Settings'][_0x262cbe(0x67f)]['EnableNumberInput']&&(VisuMZ['CoreEngine']['Window_NumberInput_start']=Window_NumberInput['prototype']['start'],Window_NumberInput[_0x262cbe(0x800)][_0x262cbe(0x4eb)]=function(){const _0x2c9c4e=_0x262cbe;VisuMZ['CoreEngine'][_0x2c9c4e(0x64d)]['call'](this),this[_0x2c9c4e(0x772)](this[_0x2c9c4e(0x320)]-0x1),Input[_0x2c9c4e(0x294)]();},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x181)]=Window_NumberInput[_0x262cbe(0x800)][_0x262cbe(0x31f)],Window_NumberInput['prototype'][_0x262cbe(0x31f)]=function(){const _0x35b6e5=_0x262cbe;if(!this[_0x35b6e5(0x6fd)]())return;if(Input[_0x35b6e5(0x785)]())this['processKeyboardDigitChange']();else{if(Input[_0x35b6e5(0x40e)](_0x35b6e5(0x596)))this[_0x35b6e5(0x84f)]();else{if(Input['_inputSpecialKeyCode']===0x2e)this[_0x35b6e5(0x2ea)]();else{if(Input[_0x35b6e5(0xa5)]===0x24)this['processKeyboardHome']();else Input[_0x35b6e5(0xa5)]===0x23?this[_0x35b6e5(0x6e8)]():VisuMZ[_0x35b6e5(0x244)][_0x35b6e5(0x181)][_0x35b6e5(0x77c)](this);}}}},Window_NumberInput[_0x262cbe(0x800)][_0x262cbe(0x7f9)]=function(){const _0x1b857a=_0x262cbe;if(!this[_0x1b857a(0x364)]())return;Input[_0x1b857a(0x785)]()?this[_0x1b857a(0x82b)]():Window_Selectable[_0x1b857a(0x800)][_0x1b857a(0x7f9)][_0x1b857a(0x77c)](this);},Window_NumberInput[_0x262cbe(0x800)][_0x262cbe(0x1cb)]=function(){},Window_NumberInput['prototype'][_0x262cbe(0x82b)]=function(){const _0x1605fb=_0x262cbe;if(String(this[_0x1605fb(0x28e)])['length']>=this[_0x1605fb(0x320)])return;const _0x919a2b=Number(String(this['_number'])+Input[_0x1605fb(0x4e0)]);if(isNaN(_0x919a2b))return;this[_0x1605fb(0x28e)]=_0x919a2b;const _0x7d101d='9'[_0x1605fb(0x1c5)](this[_0x1605fb(0x320)]);this[_0x1605fb(0x28e)]=this[_0x1605fb(0x28e)][_0x1605fb(0x565)](0x0,_0x7d101d),Input[_0x1605fb(0x294)](),this[_0x1605fb(0x14a)](),SoundManager[_0x1605fb(0x7fb)](),this['select'](this[_0x1605fb(0x320)]-0x1);},Window_NumberInput[_0x262cbe(0x800)][_0x262cbe(0x84f)]=function(){const _0x331d5f=_0x262cbe;this[_0x331d5f(0x28e)]=Number(String(this[_0x331d5f(0x28e)])[_0x331d5f(0x53a)](0x0,-0x1)),this[_0x331d5f(0x28e)]=Math['max'](0x0,this[_0x331d5f(0x28e)]),Input[_0x331d5f(0x294)](),this['refresh'](),SoundManager['playCursor'](),this[_0x331d5f(0x772)](this[_0x331d5f(0x320)]-0x1);},Window_NumberInput[_0x262cbe(0x800)][_0x262cbe(0x2ea)]=function(){const _0x2b10c0=_0x262cbe;this[_0x2b10c0(0x28e)]=Number(String(this['_number'])[_0x2b10c0(0x5d3)](0x1)),this[_0x2b10c0(0x28e)]=Math[_0x2b10c0(0x256)](0x0,this[_0x2b10c0(0x28e)]),Input[_0x2b10c0(0x294)](),this[_0x2b10c0(0x14a)](),SoundManager[_0x2b10c0(0x7fb)](),this[_0x2b10c0(0x772)](this[_0x2b10c0(0x320)]-0x1);},Window_NumberInput['prototype'][_0x262cbe(0x3cf)]=function(){const _0x544299=_0x262cbe;if(this['index']()===0x0)return;Input['clear'](),this[_0x544299(0x14a)](),SoundManager[_0x544299(0x7fb)](),this[_0x544299(0x772)](0x0);},Window_NumberInput[_0x262cbe(0x800)][_0x262cbe(0x6e8)]=function(){const _0x38eabf=_0x262cbe;if(this[_0x38eabf(0x326)]()===this[_0x38eabf(0x320)]-0x1)return;Input[_0x38eabf(0x294)](),this['refresh'](),SoundManager[_0x38eabf(0x7fb)](),this['select'](this['_maxDigits']-0x1);});;VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x79a)]=Window_MapName[_0x262cbe(0x800)]['refresh'],Window_MapName[_0x262cbe(0x800)][_0x262cbe(0x14a)]=function(){const _0x17be82=_0x262cbe;VisuMZ[_0x17be82(0x244)][_0x17be82(0x84d)][_0x17be82(0x754)][_0x17be82(0x510)]?this[_0x17be82(0x804)]():VisuMZ['CoreEngine'][_0x17be82(0x79a)]['call'](this);},Window_MapName[_0x262cbe(0x800)][_0x262cbe(0x804)]=function(){const _0x55f725=_0x262cbe;this['contents'][_0x55f725(0x294)]();if($gameMap[_0x55f725(0x1ab)]()){const _0x141566=this[_0x55f725(0x466)];this[_0x55f725(0x4e7)](0x0,0x0,_0x141566,this[_0x55f725(0x66d)]());const _0xc8d17d=this[_0x55f725(0x382)]($gameMap[_0x55f725(0x1ab)]())[_0x55f725(0x80a)];this[_0x55f725(0x5db)]($gameMap['displayName'](),Math[_0x55f725(0x431)]((_0x141566-_0xc8d17d)/0x2),0x0);}},Window_TitleCommand['_commandList']=VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x69f)],Window_TitleCommand[_0x262cbe(0x800)][_0x262cbe(0x574)]=function(){this['makeCoreEngineCommandList']();},Window_TitleCommand[_0x262cbe(0x800)]['makeCoreEngineCommandList']=function(){const _0x1915c6=_0x262cbe;for(const _0x276f36 of Window_TitleCommand[_0x1915c6(0x158)]){if(_0x276f36[_0x1915c6(0x722)]['call'](this)){const _0x50a62a=_0x276f36[_0x1915c6(0xa4)];let _0x4a0608=_0x276f36[_0x1915c6(0x851)];if(['',_0x1915c6(0x109)][_0x1915c6(0x14c)](_0x4a0608))_0x4a0608=_0x276f36[_0x1915c6(0x2e2)][_0x1915c6(0x77c)](this);const _0x237ae2=_0x276f36[_0x1915c6(0x563)][_0x1915c6(0x77c)](this),_0x3610c8=_0x276f36[_0x1915c6(0x237)][_0x1915c6(0x77c)](this);this['addCommand'](_0x4a0608,_0x50a62a,_0x237ae2,_0x3610c8),this['setHandler'](_0x50a62a,_0x276f36[_0x1915c6(0x51d)][_0x1915c6(0x75d)](this,_0x3610c8));}}},VisuMZ['CoreEngine']['Window_TitleCommand_selectLast']=Window_TitleCommand['prototype'][_0x262cbe(0x83e)],Window_TitleCommand[_0x262cbe(0x800)]['selectLast']=function(){const _0x39c2fe=_0x262cbe;VisuMZ[_0x39c2fe(0x244)]['Window_TitleCommand_selectLast'][_0x39c2fe(0x77c)](this);if(!Window_TitleCommand[_0x39c2fe(0x6d4)])return;const _0x10196d=this[_0x39c2fe(0x6be)](Window_TitleCommand[_0x39c2fe(0x6d4)]),_0x4ce585=Math[_0x39c2fe(0x431)](this['maxVisibleItems']()/0x2)-0x1;this[_0x39c2fe(0x51b)](_0x10196d),this[_0x39c2fe(0x4fa)]>0x1&&(this['_scrollDuration']=0x1,this[_0x39c2fe(0x36c)]()),this[_0x39c2fe(0xa1)](_0x10196d-_0x4ce585);},Window_GameEnd[_0x262cbe(0x158)]=VisuMZ['CoreEngine'][_0x262cbe(0x84d)][_0x262cbe(0x62e)][_0x262cbe(0x4e6)][_0x262cbe(0x824)],Window_GameEnd[_0x262cbe(0x800)][_0x262cbe(0x574)]=function(){this['makeCoreEngineCommandList']();},Window_GameEnd[_0x262cbe(0x800)][_0x262cbe(0x7ab)]=function(){const _0x492f3c=_0x262cbe;for(const _0xc96516 of Window_GameEnd[_0x492f3c(0x158)]){if(_0xc96516[_0x492f3c(0x722)][_0x492f3c(0x77c)](this)){const _0x16ce66=_0xc96516[_0x492f3c(0xa4)];let _0x17df6b=_0xc96516[_0x492f3c(0x851)];if(['','Untitled'][_0x492f3c(0x14c)](_0x17df6b))_0x17df6b=_0xc96516[_0x492f3c(0x2e2)][_0x492f3c(0x77c)](this);const _0x2f2069=_0xc96516['EnableJS'][_0x492f3c(0x77c)](this),_0x430370=_0xc96516[_0x492f3c(0x237)][_0x492f3c(0x77c)](this);this['addCommand'](_0x17df6b,_0x16ce66,_0x2f2069,_0x430370),this[_0x492f3c(0x5b1)](_0x16ce66,_0xc96516[_0x492f3c(0x51d)][_0x492f3c(0x75d)](this,_0x430370));}}};function Window_ButtonAssist(){const _0xd38ee8=_0x262cbe;this[_0xd38ee8(0x1ad)](...arguments);}Window_ButtonAssist[_0x262cbe(0x800)]=Object[_0x262cbe(0x3de)](Window_Base[_0x262cbe(0x800)]),Window_ButtonAssist[_0x262cbe(0x800)][_0x262cbe(0x1ea)]=Window_ButtonAssist,Window_ButtonAssist[_0x262cbe(0x800)]['initialize']=function(_0x683788){const _0x147409=_0x262cbe;this['_data']={},Window_Base[_0x147409(0x800)][_0x147409(0x1ad)]['call'](this,_0x683788),this[_0x147409(0xa6)](VisuMZ[_0x147409(0x244)][_0x147409(0x84d)][_0x147409(0x153)][_0x147409(0x7c9)]||0x0),this[_0x147409(0x14a)]();},Window_ButtonAssist[_0x262cbe(0x800)][_0x262cbe(0x16b)]=function(){const _0x333c05=_0x262cbe;this[_0x333c05(0xaf)][_0x333c05(0x5ad)]<=0x60&&(this['contents'][_0x333c05(0x5ad)]+=0x6);},Window_ButtonAssist[_0x262cbe(0x800)][_0x262cbe(0x455)]=function(){const _0x9ce571=_0x262cbe;this['contents'][_0x9ce571(0x5ad)]>=0x18&&(this[_0x9ce571(0xaf)][_0x9ce571(0x5ad)]-=0x6);},Window_ButtonAssist['prototype'][_0x262cbe(0x64e)]=function(){const _0x4d0e45=_0x262cbe;Window_Base[_0x4d0e45(0x800)]['update']['call'](this),this[_0x4d0e45(0x63b)]();},Window_ButtonAssist[_0x262cbe(0x800)][_0x262cbe(0x48c)]=function(){const _0x1ac526=_0x262cbe;this['padding']=SceneManager['_scene'][_0x1ac526(0x662)]()!=='button'?0x0:0x8;},Window_ButtonAssist[_0x262cbe(0x800)][_0x262cbe(0x63b)]=function(){const _0x1e0ff9=_0x262cbe,_0x18a5f0=SceneManager[_0x1e0ff9(0x207)];for(let _0x92299=0x1;_0x92299<=0x5;_0x92299++){if(this[_0x1e0ff9(0x3a3)][_0x1e0ff9(0x6d5)[_0x1e0ff9(0x94)](_0x92299)]!==_0x18a5f0[_0x1e0ff9(0x2c9)['format'](_0x92299)]())return this[_0x1e0ff9(0x14a)]();if(this[_0x1e0ff9(0x3a3)][_0x1e0ff9(0x14b)['format'](_0x92299)]!==_0x18a5f0[_0x1e0ff9(0x76e)['format'](_0x92299)]())return this[_0x1e0ff9(0x14a)]();}},Window_ButtonAssist[_0x262cbe(0x800)][_0x262cbe(0x14a)]=function(){const _0x2eeb4c=_0x262cbe;this[_0x2eeb4c(0xaf)][_0x2eeb4c(0x294)]();for(let _0x39d3f5=0x1;_0x39d3f5<=0x5;_0x39d3f5++){this[_0x2eeb4c(0x82a)](_0x39d3f5);}},Window_ButtonAssist[_0x262cbe(0x800)][_0x262cbe(0x82a)]=function(_0x50acd7){const _0x389a15=_0x262cbe,_0x54709f=this[_0x389a15(0x466)]/0x5,_0x26fd21=SceneManager['_scene'],_0x46c2ee=_0x26fd21[_0x389a15(0x2c9)['format'](_0x50acd7)](),_0x8adac9=_0x26fd21[_0x389a15(0x76e)[_0x389a15(0x94)](_0x50acd7)]();this['_data']['key%1'['format'](_0x50acd7)]=_0x46c2ee,this[_0x389a15(0x3a3)][_0x389a15(0x14b)[_0x389a15(0x94)](_0x50acd7)]=_0x8adac9;if(_0x46c2ee==='')return;if(_0x8adac9==='')return;const _0x15a2f0=_0x26fd21['buttonAssistOffset%1'['format'](_0x50acd7)](),_0x571a9b=this[_0x389a15(0x835)](),_0x536300=_0x54709f*(_0x50acd7-0x1)+_0x571a9b+_0x15a2f0,_0xa88cd7=VisuMZ[_0x389a15(0x244)][_0x389a15(0x84d)][_0x389a15(0x153)][_0x389a15(0xfc)];this['drawTextEx'](_0xa88cd7['format'](_0x46c2ee,_0x8adac9),_0x536300,0x0,_0x54709f-_0x571a9b*0x2);},VisuMZ['CoreEngine']['Game_Interpreter_updateWaitMode']=Game_Interpreter['prototype']['updateWaitMode'],Game_Interpreter[_0x262cbe(0x800)][_0x262cbe(0xc8)]=function(){const _0x555c0c=_0x262cbe;if($gameTemp[_0x555c0c(0xe9)]!==undefined)return VisuMZ[_0x555c0c(0x244)][_0x555c0c(0x5ba)]();return VisuMZ['CoreEngine'][_0x555c0c(0x234)][_0x555c0c(0x77c)](this);},VisuMZ['CoreEngine'][_0x262cbe(0x5ba)]=function(){const _0x2aa7e9=_0x262cbe,_0x317cde=$gameTemp[_0x2aa7e9(0xe9)]||0x0;(_0x317cde<0x0||_0x317cde>0x64||TouchInput[_0x2aa7e9(0x1f9)]()||Input[_0x2aa7e9(0x41b)](_0x2aa7e9(0x166)))&&($gameTemp[_0x2aa7e9(0xe9)]=undefined,Input[_0x2aa7e9(0x294)](),TouchInput[_0x2aa7e9(0x294)]());const _0x1264a9=$gameScreen[_0x2aa7e9(0x766)](_0x317cde);return _0x1264a9&&(_0x1264a9['_x']=TouchInput['_x'],_0x1264a9['_y']=TouchInput['_y']),VisuMZ['CoreEngine']['updatePictureCoordinates'](),$gameTemp[_0x2aa7e9(0xe9)]!==undefined;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x3ae)]=function(){const _0x205511=_0x262cbe,_0x3d05eb=SceneManager[_0x205511(0x207)];if(!_0x3d05eb)return;!_0x3d05eb[_0x205511(0x18a)]&&(SoundManager[_0x205511(0x79d)](),_0x3d05eb[_0x205511(0x18a)]=new Window_PictureCoordinates(),_0x3d05eb[_0x205511(0x286)](_0x3d05eb[_0x205511(0x18a)])),$gameTemp[_0x205511(0xe9)]===undefined&&(SoundManager['playCancel'](),_0x3d05eb[_0x205511(0x2e8)](_0x3d05eb[_0x205511(0x18a)]),_0x3d05eb['_pictureCoordinatesWindow']=undefined);};function Window_PictureCoordinates(){const _0x59ff10=_0x262cbe;this[_0x59ff10(0x1ad)](...arguments);}function _0x4486(){const _0x4edfab=['resetFontSettings','processTouch','CustomParamNames','RightMenus','BattleManager_invokeCounterAttack','layoutSettings','imageSmoothingEnabled','RepositionEnemies130','Weapon-%1-%2','AudioChangeBgmPan','createTextState','_isPlaytest','offOpacity','Scene_Map_createSpritesetFix','F7key','paramName','Window_StatusBase_drawActorLevel','_movementDuration','missed','Window_NameInput_cursorRight','drawValue','addLoadListener','_targetScaleY','drawItem','PTB','sparamPlus2','removeAllFauxAnimations','mev','subject','getParameter','processCursorMove','VOLUME_DOWN','playCursor','altKey','DisplayLockX','Spriteset_Base_updatePosition','pressed','prototype','Game_BattlerBase_refresh','retrieveFauxAnimation','paramBaseAboveLevel99','refreshWithTextCodeSupport','enableDigitGroupingEx','buttonAssistWindowButtonRect','_width','Game_Picture_show','onButtonImageLoad','width','hideButtonFromView','destroy','WindowLayer_render','dimColor1','_registerKeyInput','current','setupNewGame','ColorExpGauge2','skills','clearForcedGameTroopSettingsCoreEngine','getLastGamepadUsed','isEnemy','resetBattleSystem','crisisColor','_stored_tpCostColor','createChildSprite','addChildToBack','getLastUsedGamepadType','setViewport','_animation','_forcedBattleGridSystem','getGamepads','mpGaugeColor2','traitsPi','isGamepadAxisMoved','CommandList','PictureRotate','hide','_buyWindow','centerY','setSkill','drawSegment','processKeyboardDigitChange','Window_Selectable_drawBackgroundRect','ctrl','PictureCoordinatesMode','alphabetic','OUTCUBIC','Game_Interpreter_command355','faceWidth','setSideView','_shakeDuration','itemPadding','IconParam6','VOLUME_MUTE','win32','Upper\x20Left','IconParam5','340fvjqDB','_context','0.00','selectLast','Scene_Battle_createSpriteset','Actor','dimColor2','onNameOk','removeFauxAnimation','xparam','refreshActor','_refreshPauseSign','offsetY','hpGaugeColor1','addEventListener','CorrectSkinBleeding','mhp','catchException','Settings','name','processKeyboardBackspace','AudioChangeBgmVolume','TextStr','sparamFlat1','Scene_Equip_create','performEscape','Sprite_Gauge_gaugeRate','_isWindow','processEscape','SPACE','Game_Picture_scaleX','Plus2','invokeCounterAttack','KEEP','Spriteset_Base_isAnimationPlaying','〘Common\x20Event\x20%1:\x20%2〙\x20End','playTestF6','isHandled','PHA','Game_Map_scrollUp','split','endAnimation','ConvertParams','DOLLAR','sin','TitlePicButtons','isAnimationPlaying','OffBarColor','inputWindowRect','CLOSE_BRACKET','ActorHPColor','adjustSprite','ShowDevTools','CategoryRect','SETTINGS','_stored_maxLvGaugeColor1','HOME','Scene_Base_terminate','SmartEventCollisionPriority','normal','MAXHP','sqrt','format','animationId','IconSParam5','bgmVolume','deselect','F16','get','CLOSE_PAREN','IconSParam9','innerHeight','pagedown','boxHeight','top','setTopRow','processHandling','ButtonHeight','Symbol','_inputSpecialKeyCode','setBackgroundType','isMaxLevel','Input_shouldPreventDefault','Spriteset_Base_update','ASTERISK','process_VisuMZ_CoreEngine_ControllerButtons','Scene_Unlisted','applyEasing','keys','contents','OUTBACK','isEventRunning','_inputWindow','$dataMap','_currentBgs','level','1.3.0','isPressed','DigitGroupingStandardText','down2','_windowskin','isRightInputMode','rowSpacing','MAT','isCollidedWithEvents','loadSystemImages','EVA','QUESTION_MARK','VisuMZ_2_BattleSystemFTB','_goldWindow','anchor','mainFontSize','scale','createBackground','updateWaitMode','buttonAssistText1','Bitmap_initialize','DigitGroupingLocale','isSmartEventCollisionOn','processTimingData','_menuButton','Game_Picture_x','inBattle','scaleY','worldTransform','PRESERVCONVERSION(%1)','FunctionName','framesPerChar','setLastPluginCommandInterpreter','retrievePointAnimation','code','makeAutoBattleActions','END','xparamPlus2','_mirror','setLastGamepadUsed','OUTBOUNCE','activate','_lastScrollBarValues','createPointAnimation','sparam','clearOnceParallelInterpreters','createTextPopupWindow','framesMin','angle','_repositioned','CNT','_pictureCoordinatesMode','RPGMAKER_VERSION','IconXParam1','BarThickness','_lastPluginCommandInterpreter','BACK_QUOTE','setBattleSystem','_storedStack','WASD','XParamVocab4','_editWindow','buttonAssistOffset3','STENCIL_BUFFER_BIT','isOpen','endAction','openingSpeed','SParamVocab0','_makeFontNameText','%1〘Choice\x20Cancel〙%1','TextFmt','_mapY','_viewportSize','buttonAssistOffset2','height','_centerCameraCheck','XParamVocab7','_clientArea','MinDuration','isMapScrollLinked','setColorTone','Class-%1-%2','IconSet','Untitled','UNDERSCORE','6441669PjsDFQ','%1\x0a','playBgs','Window','StatusBgType','_image','ctGaugeColor2','ShopMenu','INOUTCUBIC','F12','Sprite_Picture_updateOrigin','updateMain','xparamRate2','BTestItems','buttonAssistKey2','isBottomButtonMode','219197QPKVHD','BarBodyColor','responseText','tileWidth','getInputButtonString','setupButtonImage','_cacheScaleX','isMenuButtonAssistEnabled','Scene_Battle_createSpritesetFix','scrollLeft','wait','Window_Base_update','F13','CONTEXT_MENU','xdg-open','expRate','ctrlKey','Game_Temp_initialize','WIN_OEM_ENLW','hasEncryptedImages','isScrollBarVisible','ALWAYS','PRINTSCREEN','Bitmap_clearRect','tpColor','ImprovedAccuracySystem','exec','_targetOffsetY','Game_Action_numRepeats','cursorPageup','initRotation','getTileExtendTerrainTags','setupBattleTestItems','performMiss','indexOf','match','initMembersCoreEngine','onInputBannedWords','ZERO','%1:\x20Exit\x20','Version','font','list','fillStyle','buttonAssistKey3','DELETE','WARNING:\x20%1\x20has\x20already\x20been\x20declared\x0aand\x20cannot\x20be\x20used\x20as\x20a\x20Quick\x20JS\x20Function','refresh','text%1','includes','platform','ColorMPGauge1','ShowItemBackground','RequireFocus','SCALE_MODES','ApplyEasing','ButtonAssist','MAXMP','_pictureContainer','string','_cacheScaleY','_commandList','animationNextDelay','_screenX','ParseSkillNotetags','catchNormalError','valueOutlineColor','_itemWindow','itemLineRect','BTestWeapons','BattleManager_checkSubstitute','LUK','drawGoldItemStyle','pointY','Input_updateGamepadState','cancel','InputRect','RegExp','ParseTilesetNotetags','pendingColor','makeFontBigger','PictureID','drawActorLevel','Window_Base_drawIcon','exportAllMapStrings','_pageupButton','advanced','GoldBgType','F15','_bgmBuffer','itemHitImprovedAccuracy','cursorUp','filters','LATIN1','_stored_expGaugeColor1','%1〘Choice\x20%2〙\x20%3%1','checkPlayerLocation','CAPSLOCK','buttonAssistOffset5','gaugeBackColor','isFauxAnimationPlaying','Game_Action_itemEva','Window_NumberInput_processDigitChange','TGR','windowOpacity','maxScrollbar','(\x5cd+)>','updateBackOpacity','WIN_OEM_BACKTAB','ALTGR','Window_NameInput_cursorPageup','_pictureCoordinatesWindow','_duration','overrideMimeType','DebugConsoleLastControllerID','_numberWindow','currentClass','SParamVocab4','removeAnimationFromContainer','onEscapeSuccess','IconXParam7','wholeDuration','measureTextWidthNoRounding','BattleSystem','Game_Interpreter_PluginCommand','Game_Action_setAttack','createExtendedTileSprite','_changingClass','loadBitmap','updatePositionCoreEngine','MvAnimationRate','isAutoColorAffected','mute','setupScrollBarBitmap','ColorPowerDown','_pauseSignSprite','translucentOpacity','removeOnceParallelInterpreter','OkText','deathColor','Game_Actor_levelUp','ColorCrisis','param','maxItems','displayName','IconParam1','initialize','createCustomBackgroundImages','setEvent','_stored_ctGaugeColor1','prepareNextScene','paramMaxJS','OpenSpeed','Scene_Title','targetScaleX','isPointAnimationPlaying','defineProperty','sparamFlatJS','getControllerInputButtonMatch','_slotWindow','_anglePlus','_rate','isGamepadTriggered','createTilemap','mainAreaTopSideButtonLayout','animationBaseDelay','isEnabled','IconXParam8','operation','apply','repeat','Actor-%1-%2','filter','Scene_MenuBase_createBackground','_onKeyPress','ColorPowerUp','processCursorHomeEndTrigger','setCommonEvent','_url','Keyboard','Scene_Name_create','pixelated','MDF','mainAreaHeight','commandWindowRows','enemy','Bitmap_gradientFillRect','determineSideButtonLayoutValid','isDying','IconSParam6','BattleManager_update','PERIOD','ParseArmorNotetags','INELASTIC','Window_NameInput_processTouch','EnableNameInput','BannedWords','_startDecrypting','_lastIconIndex','parseForcedGameTroopSettingsCoreEngine','TextManager_param','Scene_Map_createSpriteset','_mp','isMagical','updateAnglePlus','SceneManager_initialize','mpCostColor','constructor','CTRL','printError','pictures','_lastGamepad','updateRotation','GoldIcon','terminate','ParamName','INEXPO','measureTextWidth','pointX','systemColor','_tilemap','《《《\x20Page\x20%1\x20》》》\x0a%2\x0a','isCancelled','sparamPlusJS','KeySHIFT','LoadMenu','Duration','evaded','pictureId','Sprite_destroy','_currentBgm','VisuMZ_3_EventChainReact','isFullDocumentTitle','buttonY','drawCurrencyValue','Game_Interpreter_command111','_scene','applyForcedGameTroopSettingsCoreEngine','visible','EnableMasking','_targetOffsetX','slotWindowRect','command105','_backSprite2','isClosed','layeredTiles','StatusParamsBgType','isBusy','updateScrollBars','Bitmap_fillRect','note','ColorTPGauge1','Current\x20tileset\x20has\x20incomplete\x20flag\x20data.','toLowerCase','_timerSprite','Sprite_Picture_loadBitmap','Window_Base_createContents','itemHeight','DTB','Input_update','_srcBitmap','WIN_OEM_ATTN','ctGaugeColor1','xparamPlus1','updateMainMultiply','Scene_MenuBase_mainAreaHeight','add','_muteSound','offset','Scene_Base_create','horizontal','tileset','thickness','_CoreEngineSettings','TextCodeNicknames','ModernControls','ETB','SnapshotOpacity','sv_actors','INCIRC','_stored_hpGaugeColor1','Game_Interpreter_updateWaitMode','outlineColor','Scene_Map_updateMainMultiply','ExtJS','setHome','isGameActive','EquipMenu','itemSuccessRate','applyEasingAnglePlus','isNextScene','members','_stored_tpGaugeColor1','ExtractStrFromMap','Sprite_Button_initialize','INQUINT','NumberRect','CoreEngine','Sprite_AnimationMV_updatePosition','profileWindowRect','playTestShiftT','updateOpen','OpenURL','executeLoad','_shakeSpeed','goldWindowRect','EQUALS','createPageButtons','Sprite_Animation_processSoundTimings','mapId','cursorPagedown','gainGold','mpColor','log','_textPopupWindow','max','updatePositionCoreEngineShakeHorz','recoverAll','buttons','_storedMapText','doesNameContainBannedWords','Graphics_defaultStretchMode','integer','INBACK','initialBattleSystem','updateFrameCoreEngine','remove','setWindowPadding','Spriteset_Map_createTilemap','SceneManager_exit','ExtractStrFromTroop','ARRAYJSON','_scrollBarVert','AutoScrollLockX','system','BKSP','close','setSideButtonLayout','maxScrollY','Export\x20Map\x20Text\x20operation\x20will\x20finish\x20in\x20%1\x20ms(s)','Window_Base_drawFace','GroupDigits','InputBgType','_actorWindow','faceHeight','ATTN','sceneTerminationClearEffects','maxBattleMembers','setActionState','_screenY','drawIcon','shouldAutosave','Game_Actor_paramBase','AdjustAngle','blockWidth','_smooth','onInputOk','%1〘End\x20Choice\x20Selection〙%1','CategoryBgType','drawBackgroundRect','CTB','StatusMenu','Window_Selectable_itemRect','addChild','setViewportCoreEngineFix','Map%1.json','defaultInputMode','maxTurns','Bitmap_drawCircle','loadGameImagesCoreEngine','resetTextColor','_number','_encounterCount','sparamRate2','SellBgType','Tilemap_addShadow','_allTextHeight','clear','scrollX','updatePlayTestF7','NUMPAD9','stretch','enabled','CodeJS','Scene_Name_onInputOk','calcEasing','exit','FontSize','Bitmap_drawTextOutline','onerror','_fauxAnimationSprites','_pointAnimationQueue','operand','SideView','Page','Bitmap_resize','areButtonsOutsideMainUI','_active','bitmap','_spriteset','Item-%1-%2','skillTypes','exportAllTroopStrings','SParamVocab8','playOk','MainMenu','%1/','SCROLL_LOCK','opacity','NUM_LOCK','useDigitGroupingEx','NameInputMessage','createDimmerSprite','updatePictureAntiZoom','canAttack','INOUTELASTIC','Scene_Map_updateMain','PIPE','updatePosition','loadBitmapCoreEngine','processTouchModernControls','processCursorMoveModernControls','Type','framebuffer','CRI','paramFlatBonus','DOWN','ExtractStrFromList','Game_Map_setup','HASH','buttonAssistKey%1','valueOutlineWidth','buttonAssistText3','_lastOrigin','COLON','centerSprite','Origin','_offsetX','PreserveNumbers','processKeyboardHandling','updateLastTarget','F22','CommandBgType','xparamFlatJS','NewGameCommonEventAll','SwitchRandomizeRange','_animationQueue','characters','WIN_ICO_00','setEasingType','_destroyCanvas','VisuMZ_2_BattleSystemCTB','WIN_OEM_FINISH','openURL','PixelateImageRendering','TextJS','BlurFilter','menu','NUM','updateCoreEasing','backgroundBitmap','removeChild','GetParamIcon','processKeyboardDelete','axes','ColorManager_loadWindowskin','_moveEasingType','drawCharacter','MCR','getControllerInputButtonString','QUOTE','Input_pollGamepads','scrollRight','blendFunc','DefaultMode','PictureEasingType','contains','loadIconBitmap','HelpRect','OnLoadJS','itypeId','battlebacks2','updateBgmParameters','map','_backgroundFilter','currentValue','SideButtons','IDs','Scene_Boot_loadSystemImages','paramWidth','jsonToZip','updateText','gaugeRate','repositionCancelButtonSideButtonLayout','getCustomBackgroundSettings','tab','clone','MEV','isKeyItem','Window_Base_createTextState','_hideTileShadows','isSceneBattle','vert','checkCacheKey','Game_Party_consumeItem','checkSmartEventCollision','storeMapData','XParamVocab0','Game_Actor_changeClass','BgFilename2','_refreshBack','GoldFontSize','PDR','process_VisuMZ_CoreEngine_Settings','setCoreEngineUpdateWindowBg','OTB','processDigitChange','_maxDigits','saveViewport','PGDN','removeAnimation','AudioChangeBgsPitch','VisuMZ_1_BattleCore','index','PAUSE','Wait','traitObjects','randomJS','style','FUNC','_clickHandler','maxLevel','_opening','_statusWindow','Window_Base_drawText','dummyWindowRect','stringKeyMap','ExportString','PLAY','pan','forceOutOfPlaytest','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','Window_Scrollable_update','overallHeight','Window_NameInput_cursorPagedown','toLocaleString','Scene_Map_initialize','focus','CLOSE_CURLY_BRACKET','paramFlat','setTileFrame','mainCommandWidth','Game_Map_setDisplayPos','Spriteset_Battle_createEnemies','NoTileShadows','Plus','setCoreEngineScreenShakeStyle','showDevTools','OptionsRect','_baseSprite','clearCachedKeys','EXCLAMATION','bgs','subjectHitRate','params','PositionJS','Scene_Boot_onDatabaseLoaded','numRepeats','DEF','createCancelButton','onDatabaseLoaded','_mainSprite','EndingID','charCode','Scene_TitleTransition','F18','pop','_scaleX','isTouchedInsideFrame','PERCENT','getBattleSystem','loadTileBitmap','ItemBgType','iconHeight','1887054WWHpsu','isCursorMovable','861162JeNxGf','_drawTextShadow','SplitEscape','TILDE','IconXParam0','CustomParamType','Game_Interpreter_command105','updateSmoothScroll','setupRate','createKeyJS','TPB\x20ACTIVE','GRD','animationShouldMirror','XParamVocab6','createFauxAnimationQueue','_playTestFastMode','OffBarOpacity','Game_Map_scrollRight','WIN_OEM_CUSEL','sparamRate1','MAX_SAFE_INTEGER','Color','reserveCommonEvent','setTargetAnchor','Window_ShopSell_isEnabled','checkScrollBarBitmap','Scene_Status_create','isItem','OPEN_CURLY_BRACKET','textSizeEx','VisuMZ_2_BattleSystemBTB','_mapX','SParamVocab5','BlurStrength','DETACH_PICTURE_CONTAINER','colSpacing','buttonAssistKey4','target','removeAllPointAnimations','numberShowButton','round','statusEquipWindowRect','terms','BACKSPACE','ItemBackColor2','damageColor','CustomParamIcons','buttonAssistOk','updatePositionCoreEngineShakeOriginal','Y:\x20%1','resize','maxCols','pagedownShowButton','onActorChange','stencilFunc','_originalViewport','buttonAssistWindowRect','\x5c}❪SHIFT❫\x5c{','ShiftT_Toggle','SkillTypeRect','makeTargetSprites','Game_Event_start','_data','MINUS','makeInputButtonString','ShowActorLevel','helpAreaTop','forceStencil','getPointAnimationLayer','button','Sprite_StateIcon_updateFrame','image-rendering','_cancelButton','updatePictureCoordinates','_anchor','NUMPAD4','OUTEXPO','DigitGroupingGaugeSprites','Sprite_StateIcon_loadBitmap','xparamRate1','center','_skillTypeWindow','addWindow','canEquip','enableDigitGrouping','updateMotion','_texture','Scene_Base_createWindowLayer','currentLevelExp','processBack','_backSprite','Window_refreshBack','buttonAssistText2','itemHit','length','SEPARATOR','changeTextColor','bgm','FDR','IconXParam5','_stored_maxLvGaugeColor2','maxTp','Scene_Battle_createCancelButton','ExportStrFromAllTroops','VisuMZ\x20CoreEngine\x20PictureIcon\x20%1\x20%2','removePointAnimation','processKeyboardHome','IconSParam3','targetBackOpacity','ShowScrollBar','areButtonsHidden','skillId','buttonAssistKey1','currencyUnit','loadTileset','mainAreaHeightSideButtonLayout','Scene_Load','VOLUME_UP','IconParam0','SParamVocab1','CustomParamAbb','create','NUMPAD1','OptionsBgType','Window_Base_initialize','padding','keypress','render','Window_NameInput_refresh','_stored_ctGaugeColor2','Window_Base_drawCharacter','deflate','DisplayedParams','Scene_Boot_startNormalGame','DetachBattlePictureContainer','maxGold','Scene_MenuBase_createCancelButton','Window_Selectable_processCursorMove','updateCurrentEvent','ColorCTGauge2','AGI','status','ColorHPGauge1','levelUpRecovery','initVisuMZCoreEngine','maxHorz','_baseTexture','drawActorExpGauge','Window_Gold_refresh','checkCoreEngineDisplayCenter','_statusParamsWindow','isPlaying','REPLACE','maxScrollX','INCUBIC','initRotationCoreEngine','_colorTone','MapOnceParallel','statusWindowRect','paintOpacity','gold','mirror','Click\x20\x22Copy\x20Page\x22\x20from\x20another\x20tileset\x27s\x20pages','Scene_Map_updateScene','setClickHandler','numActions','WIN_ICO_HELP','startNormalGame','adjustY','isSpecialCode','targets','Center','Game_Picture_angle','Game_Picture_scaleY','uiAreaWidth','flush','ColSpacing','_upArrowSprite','ParamChange','xparamFlat1','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','META','isTriggered','XParamVocab3','STB','_pictureName','Location','toString','drawActorClass','destroyScrollBarBitmaps','createFauxAnimationSprite','REC','ColorHPGauge2','DurationPerChat','isLoopVertical','smooth','background','toFixed','WIN_OEM_AUTO','_stored_mpCostColor','loading','DummyBgType','parse','FontShadows','floor','_downArrowSprite','maxVert','VariableJsBlock','Game_Event_isCollidedWithEvents','sparamRate','isRepeated','Sprite_Gauge_currentValue','horzJS','Flat1','updatePictureSettings','nextLevelExp','Conditional\x20Branch\x20Script\x20Error','displayY','targetEvaRate','Saved\x20file\x20as\x20%1\x20in\x20project\x20folder.','consumable','loadWindowskin','CtrlQuickLoad','drawActorSimpleStatus','URL','titleCommandWindow','Scene_Map_update','ParseEnemyNotetags','Window_NameInput_cursorUp','_isButtonHidden','createPointAnimationQueue','processSoundTimings','_updateFilterArea','setMute','alwaysDash','originalJS','_timeDuration','INOUTCIRC','applyCoreEasing','updateOnceParallelInterpreters','makeFontSmaller','_stored_hpGaugeColor2','CONVERT','statusParamsWindowRect','helpAreaBottom','playBgm','NUMPAD6','_centerElement','updateOpacity','_dummyWindow','_stored_gaugeBackColor','setupCoreEngine','helpWindowRect','_eventId','([\x5c+\x5c-]\x5cd+\x5c.?\x5cd+)>','targetOpacity','INOUTEXPO','innerWidth','NUMPAD7','bitmapHeight','needsUpdate','fillRect','reserveNewGameCommonEvent','Enemy','WIN_OEM_JUMP','App','INBOUNCE','setAnglePlusData','Game_Map_scrollDown','_closing','_hideButtons','Game_Interpreter_command122','BTestArmors','asin','active','deactivate','NON_FRAME','pitch','initCoreEngineScreenShake','KeyUnlisted','keyRepeatWait','_internalTextures','_balloonQueue','DamageColor','initialLevel','getLastPluginCommandInterpreter','CEV','updateClose','_refreshArrows','XParamVocab1','_drawTextOutline','createTileExtendSprites','_windowLayer','Sprite_Actor_setActorHome','rgba(0,\x200,\x200,\x200.7)','updatePadding','openness','connected','_helpWindow','setBackgroundOpacity','1.4.4','Script\x20Call\x20Error','ACCEPT','_tempActor','sv_enemies','command122','drawCurrentParam','updateScrollBarPosition','_coreEngineShakeStyle','keyMapper','_text','_hovered','end','IconSParam1','IconParam4','isInputting','writeFile','buttonAreaHeight','Game_BattlerBase_initMembers','Window_Selectable_cursorDown','setup','F20','trim','ExtDisplayedParams','Game_Action_updateLastTarget','_stored_powerDownColor','initCoreEasing','smallParamFontSize','CANCEL','XParamVocab9','offColor','repositionEnemiesByResolution','_name','makeDocumentTitle','mmp','Game_Picture_updateRotation','_defaultStretchMode','([\x5c+\x5c-]\x5cd+)([%％])>','showFauxAnimations','MRG','PLUS','HelpBgType','SParamVocab2','hit','_dimmerSprite','\x0a\x0a\x0a\x0a\x0a','canUse','_forcedBattleSys','xparamRate','erasePicture','_list','ExportAllTroopText','meVolume','NameMenu','ceil','transform','ListBgType','(\x5cd+\x5c.?\x5cd+)>','windowRect','MultiKeyFmt','ParamArrow','MIN_SAFE_INTEGER','renderNoMask','StartID','createFauxAnimation','textAlign','refreshScrollBarBitmap','drawGameTitle','enable','ExportStrFromAllMaps','NUMPAD2','drawCircle','Unnamed','gaugeHeight','Scene_Options_create','Game_Picture_y','isEventTest','optionsWindowRect','updateData','_inputString','VisuMZ_2_BattleSystemOTB','Scene_Battle_update','getCoreEngineScreenShakeStyle','batch','processFauxAnimationRequests','GameEnd','drawBackground','Sprite_Animation_setViewport','xparamPlus','push','start','destroyCoreEngineMarkedBitmaps','scrollbar','MenuBg','drawParamName','setAttack','abs','Scene_Battle_createSpriteset_detach','SceneManager_onKeyDown','targetContentsOpacity','TRG','_shiftY','version','Bitmap_drawText','_iconIndex','_scrollDuration','ConvertNumberToString','sparamPlus1','Scene_Skill_create','tpCostColor','_startLoading','_tileExtendTerrainTags','vertical','ParseClassNotetags','snapForBackground','updateDocumentTitle','BattleManager_processEscape','PositionX','alignBottom','randomInt','Total','NUMPAD8','createScrollBarSprites','_listWindow','updateAnchor','title','<JS\x20%1\x20%2:[\x20](.*)>','MapNameTextCode','DrawItemBackgroundJS','playCursorSound','catchLoadError','createBuffer','_pointAnimationSprites','QwertyLayout','_createInternalTextures','createContents','learnings','LevelUpFullMp','smoothSelect','isArrowPressed','CallHandlerJS','setActorHomeRepositioned','createCustomParameter','pos','GREATER_THAN','playTestF7','yScrollLinkedOffset','_effectsContainer','isSideView','encounterStepsMinimum','_bitmap','PictureEraseRange','_digitGroupingEx','IconSParam4','〘Scrolling\x20Text〙\x0a','sparamFlat2','_profileWindow','buttonAssistSwitch','getBackgroundOpacity','GoldRect','value','_onLoad','ItemMenu','1limYav','sparamPlus','onload','command355','DetachMapPictureContainer','calcCoreEasing','slice','DECIMAL','Renderer','startAnimation','Troop%1','createCommandWindow','AudioChangeBgsPan','DefaultStyle','MRF','ColorMPCost','Window_Selectable_cursorUp','context','isWindowMaskingEnabled','Scene_SingleLoadTransition','bodyColor','drawText','consumeItem','makeDeepCopy','framesMax','_gamepadWait','textBaseline','updatePositionCoreEngineShakeVert','isClosing','toUpperCase','tilesetFlags','TextCodeClassNames','WIN_OEM_FJ_MASSHOU','SParamVocab9','buttonAssistText4','down','SystemSetFontSize','MaxDuration','isGamepadConnected','sellWindowRect','setValue','_statusEquipWindow','Tilemap_addSpotTile','ARRAYSTR','PGUP','EVAL','faces','EnableJS','LINEAR','clamp','updateDuration','isTpb','createSpriteset','atbActive','_forcedTroopView','show','dashToggle','Rate2','coreEngineRepositionEnemies','FTB','keyboard','random','Bitmap_blt','Scene_Boot_updateDocumentTitle','makeCommandList','pictureButtons','isMVAnimation','FadeSpeed','ForceNoPlayTest','getInputMultiButtonStrings','Scene_MenuBase_createPageButtons','targetSpritePosition','destroyed','actor','horz','fillText','shake','updateDashToggle','Plus1','getLevel','SystemSetWindowPadding','_pagedownButton','StatusParamsRect','RepositionActors','drawRightArrow','playOnceParallelInterpreter','Input_onKeyDown','Sprite_AnimationMV_processTimingData','Graphics_centerElement','outlineColorDmg','scaleX','_pollGamepads','_saveFileID','_targets','font-smooth','OutlineColorDmg','isAnimationOffsetXMirrored','drawGauge','backspace','shift','F21','initBasic','DataManager_setupNewGame','showPicture','arePageButtonsEnabled','Basic','createEnemies','paramMax','_opacity','sparamRateJS','tileHeight','onClick','13360DeRojs','This\x20scene\x20cannot\x20utilize\x20a\x20Once\x20Parallel!','reduce','Rate','etypeId','INOUTSINE','DigitGroupingExText','《《《\x20Event\x20%1:\x20%2,\x20Page\x20%3\x20》》》\x0a%4\x0a','_playtestF7Looping','fontSize','popScene','addQueue','INOUTBOUNCE','setHandler','Game_Action_itemHit','_tile','markCoreEngineModified','textHeight','_colorCache','data/','ScreenResolution','cursorLeft','UpdatePictureCoordinates','〘Show\x20Text〙\x0a','SHIFT','hpGaugeColor2','getColor','ScaleX','〘Common\x20Event\x20%1:\x20%2〙\x20Start','ValueJS','addAnimationSpriteToContainer','_battleField','CreateBattleSystemID','BottomHelp','PositionY','vertJS','commandWindowRect','refreshDimmerBitmap','KANA','checkSubstitute','isActiveTpb','AccuracyBoost','Window_Selectable_processTouch','removeTileExtendSprites','min','isAnimationForEach','BottomButtons','substring','updateFrame','ColorMPGauge2','GoldMax','parameters','paramRate','startShake','ParseAllNotetags','drawTextEx','ColorDeath','F10','SwitchToggleOne','ItemRect','loadMapData','updateEffekseer','option','result','Opacity','helpAreaTopSideButtonLayout','INOUTQUAD','buttonAssistWindowSideRect','tpGaugeColor2','Window_Base_destroyContents','move','iconWidth','left','process_VisuMZ_CoreEngine_Functions','isPlaytest','restore','textWidth','IconParam7','NUMPAD3','enemies','goto','LevelUpFullHp','WIN_OEM_FJ_TOUROKU','nah','scrollbarHeight','_height','_categoryWindow','SkillTypeBgType','ActorBgType','cursorDown','_scrollBarHorz','FontSmoothing','changeClass','drawActorNickname','expParams','ParseStateNotetags','allowShiftScrolling','cursorRight','createPointAnimationTargets','\x0a\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%2\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27JS\x20Quick\x20Function\x20\x22%1\x22\x20Error!\x27);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20','StatusEquipRect','createMenuButton','_movementWholeDuration','useFontWidthFix','processPointAnimationRequests','drawGameSubtitle','INOUTBACK','Match','outbounce','zoomScale','isNwjs','Game_Picture_initRotation','areTileShadowsHidden','_displayX','text','isGamepadButtonPressed','stypeId','onMoveEnd','SParamVocab6','boxWidth','and\x20add\x20it\x20onto\x20this\x20one.','CommandWidth','Subtitle','onlyfilename','isNormalPriority','moveMenuButtonSideButtonLayout','itemWindowRect','scaleSprite','onKeyDownKeysF6F7','createSubSprite','INSERT','scrollY','VisuMZ_1_OptionsCore','ControllerMatches','DATABASE','Scene_Map_createSpriteset_detach','stop','startMove','MenuLayout','isSceneMap','cancelShowButton','F6key','buttonAssistOffset1','Scene_Item_create','_index','setActorHome','_onceParallelInterpreters','save','OUTQUAD','Key%1','ShortcutScripts','updateKeyText','bgsVolume','_displayY','dropItems','SystemLoadImages','Game_System_initialize','replace','_shouldPreventDefault','_commonEventLayers','_stored_powerUpColor','ItemStyle','_target','BoxMargin','WIN_OEM_FJ_JISHO','blt','targetX','_stored_tpGaugeColor2','%1%2','Window_NumberInput_start','update','TimeProgress','Game_Picture_calcEasing','updateScene','OUTQUART','_stored_crisisColor','command357','PageChange','Smooth','HRG','ATK','EXR','_troopId','maxLvGaugeColor1','SParameterFormula','Finish','_actor','STENCIL_TEST','checkPassage','animations','getButtonAssistLocation','EXECUTE','setAction','volume','tpGaugeColor1','Game_Picture_updateMove','mainAreaTop','concat','Abbreviation','\x5c}❪TAB❫\x5c{','_bypassCanCounterCheck','lineHeight','_setupEventHandlers','IconParam3','SwitchToggleRange','paramchangeTextColor','return\x200','Game_Character_processMoveCommand','_lastX','updateShadow','F11','Window_EquipItem_isEnabled','setupCustomRateCoreEngine','SParamVocab3','X:\x20%1','createButtonAssistWindow','_onKeyDown','pow','ScreenShake','KeyboardInput','EREOF','padZero','Gold','5781056rbBkqw','process_VisuMZ_CoreEngine_jsQuickFunctions','process_VisuMZ_CoreEngine_Notetags','_commandWindow','Flat2','updateMove','processMoveCommand','buttonAssistCancel','powerUpColor','_subject','FINAL','xparamFlatBonus','isTileExtended','normalColor','isPhysical','F19','targetObjects','drawParamText','itemRect','_margin','initMembers','redraw','command111','_backSprite1','fillAll','evaluate','updateScrollBarVisibility','isLoopHorizontal','TitleCommandList','_pressed','measureText','ParseActorNotetags','isOptionValid','SEMICOLON','OUTCIRC','endBattlerActions','Game_Troop_setup','SCROLLBAR','ActorRect','adjustX','updateFauxAnimations','_tileExtendSprites','loadPicture','itemBackColor1','Mute','runCombinedScrollingTextAsCode','SlotRect','anglePlus','_coreEasing','Input_setupEventHandlers','actorWindowRect','home','SceneManager_isGameActive','RowSpacing','showPointAnimations','Scene_Base_terminateAnimationClearBugFix','setupValueFont','getCombinedScrollingText','PA1','findSymbol','Input_clear','FontWidthFix','object','F14','OPEN_PAREN','HELP','Chance','IconXParam3','clearRect','buttonAssistKey5','_targetAnchor','origin','centerCameraCheckData','application/json','INOUTQUINT','backOpacity','CLEAR','setMoveEasingType','fadeSpeed','DocumentTitleFmt','Export\x20Troop\x20Text\x20operation\x20will\x20finish\x20in\x20%1\x20ms(s)','_lastCommandSymbol','key%1','StatusRect','skipBranch','createWindowLayer','CancelText','stencilOp','ActorTPColor','XParamVocab5','Window_NameInput_cursorLeft','setEnemyAction','ButtonFadeSpeed','Window_NameInput_initialize','_currentMap','_centerElementCoreEngine','updateBgsParameters','clearZoom','Bitmap_measureTextWidth','cos','isActor','processKeyboardEnd','setupCoreEasing','_backgroundSprite','img/%1/','Enable','drawTextTopAligned','gradientFillRect','join','getKeyboardInputButtonString','INQUAD','centerX','expGaugeColor2','setFrame','registerCommand','MODECHANGE','_customModified','ColorGaugeBack','xScrollLinkedOffset','DimColor2','seVolume','TAB','isOpenAndActive','textColor','SystemLoadAudio','duration','COMMA','Window_NameInput_cursorDown','open','CRSEL','Manual','targetY','displayX','Padding','Map%1','ParseItemNotetags','VisuMZ_2_BattleSystemPTB','contentsOpacity','_paramPlus','111XoQTFG','14hypspU','ItemHeight','Scene_Map_createMenuButton','F24','_bgsBuffer','editWindowRect','showIncompleteTilesetError','updatePositionCoreEngineShakeRand','_destroyInternalTextures','VisuMZ_2_BattleSystemSTB','_phase','fromCharCode','Spriteset_Base_initialize','setDisplayPos','AutoScrollLockY','GoldOverlap','createPointAnimationSprite','INQUART','seek','ShowJS','BTB','_shakePower','_stored_mpGaugeColor1','paramRateJS','%2%1%3','_scaleY','BarOffset','contentsBack','_cache','loadTitle1','gameTitle','targetScaleY','VisuMZ_2_BattleSystemETB','ItemBackColor1','#%1','ScaleY','Scene_Menu_create','ADD','Graphics_printError','getColorDataFromPluginParameters','AMPERSAND','ONE','powerDownColor','_lastY','bitmapWidth','movePageButtonSideButtonLayout','Bitmap_strokeRect','SkillMenu','turn','_digitGrouping','Scene_Shop_create','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','tilesetNames','categoryWindowRect','_sideButtonLayout','CommandRect','isUseModernControls','OPEN_BRACKET','autoRemovalTiming','pages','battlebacks1','setGuard','parallaxes','TRAIT_PARAM','easingType','description','IconXParam2','itemEva','children','QoL','MDR','usableSkills','WIN_OEM_CLEAR','BgFilename1','_animationSprites','switchModes','SaveMenu','Armor-%1-%2','bind','_stored_pendingColor','titles1','paramPlusJS','Sprite_Battler_startMove','StatusEquipBgType','_startPlaying','BlendMode','useDigitGrouping','picture','rightArrowWidth','events','mpGaugeColor1','2429670dGjmnH','_action','DisplayLockY','adjustPictureAntiZoom','buttonAssistText%1','number','Scene_Map_shouldAutosave','subtitle','select','buttonAssistText5','loadTitle2','_addShadow','paramPlus','IconXParam4','Param','KeyTAB','listWindowRect','lastAnimationSprite','call','SParamVocab7','titles2','BuyBgType','setupTileExtendTerrainTags','eventsXyNt','createTitleButtons','createDigits','paramY','isNumpadPressed','Scene_MenuBase_helpAreaTop','xparamFlat2','scaleMode','playTestShiftR','initButtonHidden','_tileSprite','default','_coreEasingType','playtestQuickLoad','keyCode','globalAlpha','_fauxAnimationQueue','drawFace','gaugeLineHeight','_showDevTools','ExportCurMapText','IconParam2','pageup','item','Game_Screen_initialize','Window_MapName_refresh','STRUCT','ParseWeaponNotetags','playLoad','outlineColorGauge','darwin','ENTER','_mapNameWindow','isItemStyle','AnimationMirrorOffset','_optionsWindow','scrollDown','process_VisuMZ_CoreEngine_CustomParameters','setAnchor','paramValueByName','SlotBgType','ExportCurTroopText','makeCoreEngineCommandList','drawGameVersion','escape','F17','rgba(0,\x200,\x200,\x201.0)','NUMPAD5','ColorExpGauge1','original','AnimationPoint','onLoad','DrawIcons','Pixelated','setSize','isOpening','isForFriend','_textQueue','processAlwaysEscape','levelUp','nickname','isSideButtonLayout','_blank','LEFT','Linear','loadSystem','TCR','tilesets','baseId','HIT','_mode','Title','BgType','DimColor1','SystemSetBattleSystem','initCoreEngine','baseTextRect','BuyRect','_buttonAssistWindow','initDigitGrouping','OutlineColor','ColorTPCost','anchorCoreEasing','moveCancelButtonSideButtonLayout','ControllerButtons','sparamFlatBonus','_offsetY','windowPadding','right','ImgLoad'];_0x4486=function(){return _0x4edfab;};return _0x4486();}Window_PictureCoordinates['prototype']=Object[_0x262cbe(0x3de)](Window_Base[_0x262cbe(0x800)]),Window_PictureCoordinates[_0x262cbe(0x800)][_0x262cbe(0x1ea)]=Window_PictureCoordinates,Window_PictureCoordinates[_0x262cbe(0x800)]['initialize']=function(){const _0x4dc4eb=_0x262cbe;this[_0x4dc4eb(0x2cc)]=_0x4dc4eb(0x5f7),this[_0x4dc4eb(0x674)]='nah',this[_0x4dc4eb(0x73a)]=_0x4dc4eb(0x5f7);const _0x26bd17=this[_0x4dc4eb(0x4cb)]();Window_Base[_0x4dc4eb(0x800)][_0x4dc4eb(0x1ad)]['call'](this,_0x26bd17),this[_0x4dc4eb(0xa6)](0x2);},Window_PictureCoordinates['prototype'][_0x262cbe(0x4cb)]=function(){const _0x1e64f4=_0x262cbe;let _0x10d211=0x0,_0x19d0ab=Graphics[_0x1e64f4(0x100)]-this[_0x1e64f4(0x66d)](),_0x2094a5=Graphics[_0x1e64f4(0x80a)],_0x3760c0=this[_0x1e64f4(0x66d)]();return new Rectangle(_0x10d211,_0x19d0ab,_0x2094a5,_0x3760c0);},Window_PictureCoordinates[_0x262cbe(0x800)]['updatePadding']=function(){const _0x583576=_0x262cbe;this[_0x583576(0x3e2)]=0x0;},Window_PictureCoordinates['prototype'][_0x262cbe(0x64e)]=function(){const _0x2351b4=_0x262cbe;Window_Base[_0x2351b4(0x800)][_0x2351b4(0x64e)][_0x2351b4(0x77c)](this),this['updateData']();},Window_PictureCoordinates[_0x262cbe(0x800)][_0x262cbe(0x4df)]=function(){const _0x308dd5=_0x262cbe;if(!this['needsUpdate']())return;this[_0x308dd5(0x14a)]();},Window_PictureCoordinates[_0x262cbe(0x800)][_0x262cbe(0x469)]=function(){const _0x411b42=_0x262cbe,_0x1f6e6b=$gameTemp[_0x411b42(0xe9)],_0x2e21f8=$gameScreen[_0x411b42(0x766)](_0x1f6e6b);return _0x2e21f8?this[_0x411b42(0x2cc)]!==_0x2e21f8['_origin']||this[_0x411b42(0x674)]!==_0x2e21f8['_x']||this[_0x411b42(0x73a)]!==_0x2e21f8['_y']:![];},Window_PictureCoordinates['prototype'][_0x262cbe(0x14a)]=function(){const _0x1a5c53=_0x262cbe;this['contents'][_0x1a5c53(0x294)]();const _0x146bf5=$gameTemp[_0x1a5c53(0xe9)],_0x3242d4=$gameScreen[_0x1a5c53(0x766)](_0x146bf5);if(!_0x3242d4)return;this[_0x1a5c53(0x2cc)]=_0x3242d4['_origin'],this[_0x1a5c53(0x674)]=_0x3242d4['_x'],this[_0x1a5c53(0x73a)]=_0x3242d4['_y'];const _0x5c680d=ColorManager[_0x1a5c53(0x6ae)]();this[_0x1a5c53(0xaf)][_0x1a5c53(0x46a)](0x0,0x0,this[_0x1a5c53(0x466)],this[_0x1a5c53(0x9d)],_0x5c680d);const _0x5144ff='\x20Origin:\x20%1'[_0x1a5c53(0x94)](_0x3242d4['_origin']===0x0?_0x1a5c53(0x839):_0x1a5c53(0x410)),_0x1a1d64=_0x1a5c53(0x67a)[_0x1a5c53(0x94)](_0x3242d4['_x']),_0x4653b6=_0x1a5c53(0x396)[_0x1a5c53(0x94)](_0x3242d4['_y']),_0x5a2743=_0x1a5c53(0x142)[_0x1a5c53(0x94)](TextManager['getInputButtonString']('cancel'));let _0x18c75f=Math[_0x1a5c53(0x431)](this['innerWidth']/0x4);this['drawText'](_0x5144ff,_0x18c75f*0x0,0x0,_0x18c75f),this[_0x1a5c53(0x549)](_0x1a1d64,_0x18c75f*0x1,0x0,_0x18c75f,_0x1a5c53(0x3b5)),this[_0x1a5c53(0x549)](_0x4653b6,_0x18c75f*0x2,0x0,_0x18c75f,'center');const _0xd96b11=this[_0x1a5c53(0x382)](_0x5a2743)[_0x1a5c53(0x80a)],_0x28d3aa=this['innerWidth']-_0xd96b11;this[_0x1a5c53(0x5db)](_0x5a2743,_0x28d3aa,0x0,_0xd96b11);};function Window_TextPopup(){this['initialize'](...arguments);}Window_TextPopup[_0x262cbe(0x800)]=Object['create'](Window_Base[_0x262cbe(0x800)]),Window_TextPopup[_0x262cbe(0x800)][_0x262cbe(0x1ea)]=Window_TextPopup,Window_TextPopup['SETTINGS']={'framesPerChar':VisuMZ['CoreEngine']['Settings']['Window'][_0x262cbe(0x426)]??1.5,'framesMin':VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)][_0x262cbe(0x10e)][_0x262cbe(0x104)]??0x5a,'framesMax':VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x84d)]['Window'][_0x262cbe(0x559)]??0x12c},Window_TextPopup[_0x262cbe(0x800)][_0x262cbe(0x1ad)]=function(){const _0x1fe21d=_0x262cbe,_0xa26b4e=new Rectangle(0x0,0x0,0x1,0x1);Window_Base[_0x1fe21d(0x800)][_0x1fe21d(0x1ad)]['call'](this,_0xa26b4e),this[_0x1fe21d(0x48d)]=0x0,this[_0x1fe21d(0x49b)]='',this[_0x1fe21d(0x7ba)]=[],this[_0x1fe21d(0x451)]=0x0;},Window_TextPopup[_0x262cbe(0x800)][_0x262cbe(0x19e)]=function(){return!![];},Window_TextPopup['prototype'][_0x262cbe(0x5af)]=function(_0x86a3c5){const _0x45d942=_0x262cbe;if(this['_textQueue'][this[_0x45d942(0x7ba)]['length']-0x1]===_0x86a3c5)return;this[_0x45d942(0x7ba)][_0x45d942(0x4ea)](_0x86a3c5),SceneManager[_0x45d942(0x207)][_0x45d942(0x286)](this);},Window_TextPopup[_0x262cbe(0x800)][_0x262cbe(0x64e)]=function(){const _0x45ff9a=_0x262cbe;Window_Base['prototype'][_0x45ff9a(0x64e)]['call'](this),this[_0x45ff9a(0x306)](),this['updateDuration']();},Window_TextPopup[_0x262cbe(0x800)][_0x262cbe(0x306)]=function(){const _0xcdb369=_0x262cbe;if(this['_text']!=='')return;if(this[_0xcdb369(0x7ba)][_0xcdb369(0x3c3)]<=0x0)return;if(!this['isClosed']())return;this[_0xcdb369(0x49b)]=this[_0xcdb369(0x7ba)][_0xcdb369(0x597)]();const _0x465cdf=Window_TextPopup[_0xcdb369(0x8c)],_0x14bfaa=Math['ceil'](this['_text'][_0xcdb369(0x3c3)]*_0x465cdf[_0xcdb369(0xd5)]);this['_timeDuration']=_0x14bfaa[_0xcdb369(0x565)](_0x465cdf[_0xcdb369(0xe5)],_0x465cdf[_0xcdb369(0x54c)]);const _0x4f52d3=this[_0xcdb369(0x382)](this[_0xcdb369(0x49b)]);let _0x3a508e=_0x4f52d3[_0xcdb369(0x80a)]+this['itemPadding']()*0x2;_0x3a508e+=$gameSystem[_0xcdb369(0x7d8)]()*0x2;let _0x44466f=Math[_0xcdb369(0x256)](_0x4f52d3[_0xcdb369(0x100)],this['lineHeight']());_0x44466f+=$gameSystem['windowPadding']()*0x2;const _0x2dd103=Math[_0xcdb369(0x38d)]((Graphics[_0xcdb369(0x80a)]-_0x3a508e)/0x2),_0x56678f=Math[_0xcdb369(0x38d)]((Graphics[_0xcdb369(0x100)]-_0x44466f)/0x2),_0x25706c=new Rectangle(_0x2dd103,_0x56678f,_0x3a508e,_0x44466f);this[_0xcdb369(0x5ea)](_0x25706c['x'],_0x25706c['y'],_0x25706c['width'],_0x25706c[_0xcdb369(0x100)]),this['createContents'](),this[_0xcdb369(0x14a)](),this[_0xcdb369(0x703)](),SceneManager[_0xcdb369(0x207)][_0xcdb369(0x286)](this);},Window_TextPopup['prototype'][_0x262cbe(0x14a)]=function(){const _0x306fbe=_0x262cbe,_0x4ceacb=this[_0x306fbe(0x7cd)]();this[_0x306fbe(0xaf)]['clear'](),this[_0x306fbe(0x5db)](this['_text'],_0x4ceacb['x'],_0x4ceacb['y'],_0x4ceacb['width']);},Window_TextPopup[_0x262cbe(0x800)][_0x262cbe(0x566)]=function(){const _0x3d42ba=_0x262cbe;if(this[_0x3d42ba(0x7b8)]()||this[_0x3d42ba(0x550)]())return;if(this[_0x3d42ba(0x451)]<=0x0)return;this[_0x3d42ba(0x451)]--,this['_timeDuration']<=0x0&&(this[_0x3d42ba(0x26b)](),this[_0x3d42ba(0x49b)]='');},VisuMZ['ShowDevTools']=function(_0x352ddc){const _0x5290bf=_0x262cbe;if(Utils[_0x5290bf(0x6a3)]('test')){var _0x2abf2c=require('nw.gui')[_0x5290bf(0x10e)][_0x5290bf(0x9a)]();SceneManager['showDevTools']();if(_0x352ddc)setTimeout(_0x2abf2c[_0x5290bf(0x33e)]['bind'](_0x2abf2c),0x190);}},VisuMZ[_0x262cbe(0x152)]=function(_0x3a9c5e,_0x143f66){const _0x530e56=_0x262cbe;_0x143f66=_0x143f66[_0x530e56(0x551)]();var _0x3d2aa2=1.70158,_0x400013=0.7;switch(_0x143f66){case _0x530e56(0x564):return _0x3a9c5e;case'INSINE':return-0x1*Math[_0x530e56(0x6e6)](_0x3a9c5e*(Math['PI']/0x2))+0x1;case'OUTSINE':return Math[_0x530e56(0x82)](_0x3a9c5e*(Math['PI']/0x2));case _0x530e56(0x5a9):return-0.5*(Math[_0x530e56(0x6e6)](Math['PI']*_0x3a9c5e)-0x1);case _0x530e56(0x6f1):return _0x3a9c5e*_0x3a9c5e;case _0x530e56(0x638):return _0x3a9c5e*(0x2-_0x3a9c5e);case _0x530e56(0x5e6):return _0x3a9c5e<0.5?0x2*_0x3a9c5e*_0x3a9c5e:-0x1+(0x4-0x2*_0x3a9c5e)*_0x3a9c5e;case _0x530e56(0x3ff):return _0x3a9c5e*_0x3a9c5e*_0x3a9c5e;case _0x530e56(0x830):var _0x89a9ae=_0x3a9c5e-0x1;return _0x89a9ae*_0x89a9ae*_0x89a9ae+0x1;case _0x530e56(0x113):return _0x3a9c5e<0.5?0x4*_0x3a9c5e*_0x3a9c5e*_0x3a9c5e:(_0x3a9c5e-0x1)*(0x2*_0x3a9c5e-0x2)*(0x2*_0x3a9c5e-0x2)+0x1;case _0x530e56(0x720):return _0x3a9c5e*_0x3a9c5e*_0x3a9c5e*_0x3a9c5e;case _0x530e56(0x652):var _0x89a9ae=_0x3a9c5e-0x1;return 0x1-_0x89a9ae*_0x89a9ae*_0x89a9ae*_0x89a9ae;case'INOUTQUART':var _0x89a9ae=_0x3a9c5e-0x1;return _0x3a9c5e<0.5?0x8*_0x3a9c5e*_0x3a9c5e*_0x3a9c5e*_0x3a9c5e:0x1-0x8*_0x89a9ae*_0x89a9ae*_0x89a9ae*_0x89a9ae;case _0x530e56(0x242):return _0x3a9c5e*_0x3a9c5e*_0x3a9c5e*_0x3a9c5e*_0x3a9c5e;case'OUTQUINT':var _0x89a9ae=_0x3a9c5e-0x1;return 0x1+_0x89a9ae*_0x89a9ae*_0x89a9ae*_0x89a9ae*_0x89a9ae;case _0x530e56(0x6cd):var _0x89a9ae=_0x3a9c5e-0x1;return _0x3a9c5e<0.5?0x10*_0x3a9c5e*_0x3a9c5e*_0x3a9c5e*_0x3a9c5e*_0x3a9c5e:0x1+0x10*_0x89a9ae*_0x89a9ae*_0x89a9ae*_0x89a9ae*_0x89a9ae;case _0x530e56(0x1f3):if(_0x3a9c5e===0x0)return 0x0;return Math[_0x530e56(0x67d)](0x2,0xa*(_0x3a9c5e-0x1));case _0x530e56(0x3b1):if(_0x3a9c5e===0x1)return 0x1;return-Math['pow'](0x2,-0xa*_0x3a9c5e)+0x1;case _0x530e56(0x465):if(_0x3a9c5e===0x0||_0x3a9c5e===0x1)return _0x3a9c5e;var _0x3c6913=_0x3a9c5e*0x2,_0x1f33b7=_0x3c6913-0x1;if(_0x3c6913<0x1)return 0.5*Math[_0x530e56(0x67d)](0x2,0xa*_0x1f33b7);return 0.5*(-Math[_0x530e56(0x67d)](0x2,-0xa*_0x1f33b7)+0x2);case _0x530e56(0x232):var _0x3c6913=_0x3a9c5e/0x1;return-0x1*(Math[_0x530e56(0x93)](0x1-_0x3c6913*_0x3a9c5e)-0x1);case _0x530e56(0x6a5):var _0x89a9ae=_0x3a9c5e-0x1;return Math[_0x530e56(0x93)](0x1-_0x89a9ae*_0x89a9ae);case _0x530e56(0x452):var _0x3c6913=_0x3a9c5e*0x2,_0x1f33b7=_0x3c6913-0x2;if(_0x3c6913<0x1)return-0.5*(Math['sqrt'](0x1-_0x3c6913*_0x3c6913)-0x1);return 0.5*(Math[_0x530e56(0x93)](0x1-_0x1f33b7*_0x1f33b7)+0x1);case _0x530e56(0x25e):return _0x3a9c5e*_0x3a9c5e*((_0x3d2aa2+0x1)*_0x3a9c5e-_0x3d2aa2);case _0x530e56(0xb0):var _0x3c6913=_0x3a9c5e/0x1-0x1;return _0x3c6913*_0x3c6913*((_0x3d2aa2+0x1)*_0x3c6913+_0x3d2aa2)+0x1;break;case _0x530e56(0x60e):var _0x3c6913=_0x3a9c5e*0x2,_0x2bb150=_0x3c6913-0x2,_0x585f35=_0x3d2aa2*1.525;if(_0x3c6913<0x1)return 0.5*_0x3c6913*_0x3c6913*((_0x585f35+0x1)*_0x3c6913-_0x585f35);return 0.5*(_0x2bb150*_0x2bb150*((_0x585f35+0x1)*_0x2bb150+_0x585f35)+0x2);case _0x530e56(0x1dc):if(_0x3a9c5e===0x0||_0x3a9c5e===0x1)return _0x3a9c5e;var _0x3c6913=_0x3a9c5e/0x1,_0x1f33b7=_0x3c6913-0x1,_0x43c061=0x1-_0x400013,_0x585f35=_0x43c061/(0x2*Math['PI'])*Math[_0x530e56(0x476)](0x1);return-(Math[_0x530e56(0x67d)](0x2,0xa*_0x1f33b7)*Math[_0x530e56(0x82)]((_0x1f33b7-_0x585f35)*(0x2*Math['PI'])/_0x43c061));case'OUTELASTIC':var _0x43c061=0x1-_0x400013,_0x3c6913=_0x3a9c5e*0x2;if(_0x3a9c5e===0x0||_0x3a9c5e===0x1)return _0x3a9c5e;var _0x585f35=_0x43c061/(0x2*Math['PI'])*Math['asin'](0x1);return Math[_0x530e56(0x67d)](0x2,-0xa*_0x3c6913)*Math[_0x530e56(0x82)]((_0x3c6913-_0x585f35)*(0x2*Math['PI'])/_0x43c061)+0x1;case _0x530e56(0x2ba):var _0x43c061=0x1-_0x400013;if(_0x3a9c5e===0x0||_0x3a9c5e===0x1)return _0x3a9c5e;var _0x3c6913=_0x3a9c5e*0x2,_0x1f33b7=_0x3c6913-0x1,_0x585f35=_0x43c061/(0x2*Math['PI'])*Math[_0x530e56(0x476)](0x1);if(_0x3c6913<0x1)return-0.5*(Math[_0x530e56(0x67d)](0x2,0xa*_0x1f33b7)*Math[_0x530e56(0x82)]((_0x1f33b7-_0x585f35)*(0x2*Math['PI'])/_0x43c061));return Math['pow'](0x2,-0xa*_0x1f33b7)*Math[_0x530e56(0x82)]((_0x1f33b7-_0x585f35)*(0x2*Math['PI'])/_0x43c061)*0.5+0x1;case _0x530e56(0xde):var _0x3c6913=_0x3a9c5e/0x1;if(_0x3c6913<0x1/2.75)return 7.5625*_0x3c6913*_0x3c6913;else{if(_0x3c6913<0x2/2.75){var _0x2bb150=_0x3c6913-1.5/2.75;return 7.5625*_0x2bb150*_0x2bb150+0.75;}else{if(_0x3c6913<2.5/2.75){var _0x2bb150=_0x3c6913-2.25/2.75;return 7.5625*_0x2bb150*_0x2bb150+0.9375;}else{var _0x2bb150=_0x3c6913-2.625/2.75;return 7.5625*_0x2bb150*_0x2bb150+0.984375;}}}case _0x530e56(0x46f):var _0x58abe9=0x1-VisuMZ['ApplyEasing'](0x1-_0x3a9c5e,_0x530e56(0x610));return _0x58abe9;case _0x530e56(0x5b0):if(_0x3a9c5e<0.5)var _0x58abe9=VisuMZ['ApplyEasing'](_0x3a9c5e*0x2,'inbounce')*0.5;else var _0x58abe9=VisuMZ[_0x530e56(0x152)](_0x3a9c5e*0x2-0x1,_0x530e56(0x610))*0.5+0.5;return _0x58abe9;default:return _0x3a9c5e;}},VisuMZ[_0x262cbe(0x2e9)]=function(_0x47e01f){const _0x591e41=_0x262cbe;_0x47e01f=String(_0x47e01f)[_0x591e41(0x551)]();const _0x483058=VisuMZ[_0x591e41(0x244)][_0x591e41(0x84d)][_0x591e41(0x778)];if(_0x47e01f===_0x591e41(0x92))return _0x483058[_0x591e41(0x3db)];if(_0x47e01f===_0x591e41(0x154))return _0x483058[_0x591e41(0x1ac)];if(_0x47e01f===_0x591e41(0x658))return _0x483058[_0x591e41(0x796)];if(_0x47e01f==='DEF')return _0x483058[_0x591e41(0x66f)];if(_0x47e01f==='MAT')return _0x483058[_0x591e41(0x49f)];if(_0x47e01f===_0x591e41(0x1d1))return _0x483058[_0x591e41(0x83a)];if(_0x47e01f===_0x591e41(0x3f1))return _0x483058[_0x591e41(0x836)];if(_0x47e01f==='LUK')return _0x483058[_0x591e41(0x5f1)];if(_0x47e01f===_0x591e41(0x7c6))return _0x483058[_0x591e41(0x369)];if(_0x47e01f===_0x591e41(0xc0))return _0x483058[_0x591e41(0xeb)];if(_0x47e01f==='CRI')return _0x483058[_0x591e41(0x751)];if(_0x47e01f==='CEV')return _0x483058[_0x591e41(0x6c6)];if(_0x47e01f===_0x591e41(0x30c))return _0x483058[_0x591e41(0x777)];if(_0x47e01f===_0x591e41(0x542))return _0x483058[_0x591e41(0x3c8)];if(_0x47e01f===_0x591e41(0xe8))return _0x483058['IconXParam6'];if(_0x47e01f===_0x591e41(0x657))return _0x483058[_0x591e41(0x193)];if(_0x47e01f==='MRG')return _0x483058[_0x591e41(0x1c2)];if(_0x47e01f===_0x591e41(0x4f5))return _0x483058['IconXParam9'];if(_0x47e01f==='TGR')return _0x483058['IconSParam0'];if(_0x47e01f==='GRD')return _0x483058[_0x591e41(0x49e)];if(_0x47e01f===_0x591e41(0x424))return _0x483058['IconSParam2'];if(_0x47e01f===_0x591e41(0x7c))return _0x483058[_0x591e41(0x3d0)];if(_0x47e01f===_0x591e41(0x2ef))return _0x483058[_0x591e41(0x52a)];if(_0x47e01f===_0x591e41(0x7c3))return _0x483058[_0x591e41(0x96)];if(_0x47e01f===_0x591e41(0x31b))return _0x483058[_0x591e41(0x1d8)];if(_0x47e01f==='MDR')return _0x483058['IconSParam7'];if(_0x47e01f===_0x591e41(0x3c7))return _0x483058['IconSParam8'];if(_0x47e01f==='EXR')return _0x483058[_0x591e41(0x9c)];if(VisuMZ[_0x591e41(0x244)][_0x591e41(0x393)][_0x47e01f])return VisuMZ['CoreEngine'][_0x591e41(0x393)][_0x47e01f]||0x0;return 0x0;},VisuMZ[_0x262cbe(0x4fb)]=function(_0x1b39bf,_0x2e4851,_0x457932){const _0x226645=_0x262cbe;if(_0x457932===undefined&&_0x1b39bf%0x1===0x0)return _0x1b39bf;if(_0x457932!==undefined&&[_0x226645(0x92),_0x226645(0x154),_0x226645(0x658),_0x226645(0x353),_0x226645(0xbd),_0x226645(0x1d1),_0x226645(0x3f1),'LUK'][_0x226645(0x14c)](String(_0x457932)[_0x226645(0x551)]()[_0x226645(0x4a7)]()))return _0x1b39bf;_0x2e4851=_0x2e4851||0x0;if(VisuMZ[_0x226645(0x244)][_0x226645(0x3dd)][_0x457932])return VisuMZ[_0x226645(0x244)][_0x226645(0x36a)][_0x457932]===_0x226645(0x25d)?_0x1b39bf:String((_0x1b39bf*0x64)[_0x226645(0x42a)](_0x2e4851))+'%';return String((_0x1b39bf*0x64)[_0x226645(0x42a)](_0x2e4851))+'%';},VisuMZ['GroupDigits']=function(_0x1f95db){const _0x18d7a3=_0x262cbe;_0x1f95db=String(_0x1f95db);if(!_0x1f95db)return _0x1f95db;if(typeof _0x1f95db!==_0x18d7a3(0x156))return _0x1f95db;const _0x1cb1ef=VisuMZ[_0x18d7a3(0x244)][_0x18d7a3(0x84d)][_0x18d7a3(0x754)][_0x18d7a3(0xcb)]||'en-US',_0x2d284f={'maximumFractionDigits':0x6};_0x1f95db=_0x1f95db[_0x18d7a3(0x641)](/\[(.*?)\]/g,(_0x3e9575,_0x242e2e)=>{const _0x49ae8d=_0x18d7a3;return VisuMZ[_0x49ae8d(0x2d1)](_0x242e2e,'[',']');}),_0x1f95db=_0x1f95db['replace'](/<(.*?)>/g,(_0x2b84e6,_0x4391d9)=>{const _0x5c7f02=_0x18d7a3;return VisuMZ[_0x5c7f02(0x2d1)](_0x4391d9,'<','>');}),_0x1f95db=_0x1f95db[_0x18d7a3(0x641)](/\{\{(.*?)\}\}/g,(_0x51815f,_0x57604b)=>{return VisuMZ['PreserveNumbers'](_0x57604b,'','');}),_0x1f95db=_0x1f95db[_0x18d7a3(0x641)](/(\d+\.?\d*)/g,(_0xa6db70,_0xad8944)=>{const _0x4f3267=_0x18d7a3;let _0x5e4ced=_0xad8944;if(_0x5e4ced[0x0]==='0')return _0x5e4ced;if(_0x5e4ced[_0x5e4ced['length']-0x1]==='.')return Number(_0x5e4ced)[_0x4f3267(0x33c)](_0x1cb1ef,_0x2d284f)+'.';else return _0x5e4ced[_0x5e4ced[_0x4f3267(0x3c3)]-0x1]===','?Number(_0x5e4ced)['toLocaleString'](_0x1cb1ef,_0x2d284f)+',':Number(_0x5e4ced)['toLocaleString'](_0x1cb1ef,_0x2d284f);});let _0x230778=0x3;while(_0x230778--){_0x1f95db=VisuMZ['RevertPreserveNumbers'](_0x1f95db);}return _0x1f95db;},VisuMZ[_0x262cbe(0x2d1)]=function(_0x3fde23,_0x533759,_0x5271b2){const _0x2c5ee8=_0x262cbe;return _0x3fde23=_0x3fde23[_0x2c5ee8(0x641)](/(\d)/gi,(_0x1ce4b0,_0x2f23c1)=>_0x2c5ee8(0xd3)[_0x2c5ee8(0x94)](Number(_0x2f23c1))),_0x2c5ee8(0x727)[_0x2c5ee8(0x94)](_0x3fde23,_0x533759,_0x5271b2);},VisuMZ['RevertPreserveNumbers']=function(_0x38d2c6){return _0x38d2c6=_0x38d2c6['replace'](/PRESERVCONVERSION\((\d+)\)/gi,(_0x2363ca,_0xf0c59)=>Number(parseInt(_0xf0c59))),_0x38d2c6;},VisuMZ[_0x262cbe(0x2e0)]=function(_0x23a95d){const _0x3147d3=_0x262cbe;SoundManager[_0x3147d3(0x2af)]();if(!Utils['isNwjs']()){const _0xfba285=window[_0x3147d3(0x703)](_0x23a95d,_0x3147d3(0x7bf));}else{const _0x55da16=process[_0x3147d3(0x14d)]==_0x3147d3(0x79f)?_0x3147d3(0x703):process['platform']==_0x3147d3(0x838)?_0x3147d3(0x4eb):_0x3147d3(0x129);require('child_process')[_0x3147d3(0x135)](_0x55da16+'\x20'+_0x23a95d);}},VisuMZ[_0x262cbe(0x36e)]=function(_0x22c418,_0x4f78d7){const _0x4b4f78=_0x262cbe;if(!_0x22c418)return'';const _0x5343ae=_0x22c418[_0x4b4f78(0x7c5)]||_0x22c418['id'];let _0x2166da='';return _0x22c418[_0x4b4f78(0x481)]!==undefined&&_0x22c418['nickname']!==undefined&&(_0x2166da=_0x4b4f78(0x1c6)[_0x4b4f78(0x94)](_0x5343ae,_0x4f78d7)),_0x22c418[_0x4b4f78(0x602)]!==undefined&&_0x22c418[_0x4b4f78(0x519)]!==undefined&&(_0x2166da=_0x4b4f78(0x107)[_0x4b4f78(0x94)](_0x5343ae,_0x4f78d7)),_0x22c418[_0x4b4f78(0x618)]!==undefined&&_0x22c418['requiredWtypeId1']!==undefined&&(_0x2166da='Skill-%1-%2'[_0x4b4f78(0x94)](_0x5343ae,_0x4f78d7)),_0x22c418[_0x4b4f78(0x2fb)]!==undefined&&_0x22c418[_0x4b4f78(0x441)]!==undefined&&(_0x2166da=_0x4b4f78(0x2ab)['format'](_0x5343ae,_0x4f78d7)),_0x22c418['wtypeId']!==undefined&&_0x22c418['etypeId']===0x1&&(_0x2166da=_0x4b4f78(0x7e3)[_0x4b4f78(0x94)](_0x5343ae,_0x4f78d7)),_0x22c418['atypeId']!==undefined&&_0x22c418[_0x4b4f78(0x5a8)]>0x1&&(_0x2166da=_0x4b4f78(0x75c)[_0x4b4f78(0x94)](_0x5343ae,_0x4f78d7)),_0x22c418[_0x4b4f78(0x63e)]!==undefined&&_0x22c418['battlerHue']!==undefined&&(_0x2166da='Enemy-%1-%2'[_0x4b4f78(0x94)](_0x5343ae,_0x4f78d7)),_0x22c418[_0x4b4f78(0x749)]!==undefined&&_0x22c418[_0x4b4f78(0x28a)]!==undefined&&(_0x2166da='State-%1-%2'['format'](_0x5343ae,_0x4f78d7)),_0x2166da;},Game_Picture[_0x262cbe(0x800)][_0x262cbe(0xc4)]=function(){const _0x5e9cf4=_0x262cbe;return this[_0x5e9cf4(0x3af)];},VisuMZ[_0x262cbe(0x244)]['Game_Picture_initBasic']=Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x599)],Game_Picture['prototype'][_0x262cbe(0x599)]=function(){const _0x21da50=_0x262cbe;VisuMZ['CoreEngine']['Game_Picture_initBasic'][_0x21da50(0x77c)](this),this[_0x21da50(0x3af)]={'x':0x0,'y':0x0},this[_0x21da50(0x6c9)]={'x':0x0,'y':0x0};},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x667)]=Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x688)],Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x688)]=function(){const _0x1b6904=_0x262cbe;this[_0x1b6904(0x50d)]();const _0x2b774f=this['_duration'];VisuMZ[_0x1b6904(0x244)][_0x1b6904(0x667)]['call'](this),_0x2b774f>0x0&&this[_0x1b6904(0x18b)]<=0x0&&(this['_x']=this['_targetX'],this['_y']=this['_targetY'],this[_0x1b6904(0x35c)]=this['_targetScaleX'],this[_0x1b6904(0x728)]=this[_0x1b6904(0x7f1)],this[_0x1b6904(0x5a0)]=this['_targetOpacity'],this[_0x1b6904(0x3af)]&&(this[_0x1b6904(0x3af)]['x']=this[_0x1b6904(0x6c9)]['x'],this[_0x1b6904(0x3af)]['y']=this[_0x1b6904(0x6c9)]['y']));},VisuMZ[_0x262cbe(0x244)]['Game_Picture_show']=Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x56b)],Game_Picture['prototype'][_0x262cbe(0x56b)]=function(_0x2494ac,_0x467e2a,_0x3585ca,_0xb9fd7,_0x1f7083,_0xc2fe1,_0x4abe73,_0x42fc02){const _0xc3c7fa=_0x262cbe;VisuMZ[_0xc3c7fa(0x244)][_0xc3c7fa(0x808)][_0xc3c7fa(0x77c)](this,_0x2494ac,_0x467e2a,_0x3585ca,_0xb9fd7,_0x1f7083,_0xc2fe1,_0x4abe73,_0x42fc02),this['setAnchor']([{'x':0x0,'y':0x0},{'x':0.5,'y':0.5}][_0x467e2a]||{'x':0x0,'y':0x0});},VisuMZ['CoreEngine']['Game_Picture_move']=Game_Picture[_0x262cbe(0x800)]['move'],Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x5ea)]=function(_0x21173f,_0x4bac49,_0x4e6559,_0x14e3ae,_0x172105,_0x1e323a,_0x3711d9,_0x57b8fc,_0x44fe36){const _0x2659b5=_0x262cbe;VisuMZ[_0x2659b5(0x244)]['Game_Picture_move'][_0x2659b5(0x77c)](this,_0x21173f,_0x4bac49,_0x4e6559,_0x14e3ae,_0x172105,_0x1e323a,_0x3711d9,_0x57b8fc,_0x44fe36),this[_0x2659b5(0x37c)]([{'x':0x0,'y':0x0},{'x':0.5,'y':0.5}][_0x21173f]||{'x':0x0,'y':0x0});},Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x50d)]=function(){const _0xc2aa1d=_0x262cbe;this[_0xc2aa1d(0x18b)]>0x0&&(this[_0xc2aa1d(0x3af)]['x']=this[_0xc2aa1d(0xad)](this[_0xc2aa1d(0x3af)]['x'],this[_0xc2aa1d(0x6c9)]['x']),this[_0xc2aa1d(0x3af)]['y']=this[_0xc2aa1d(0xad)](this[_0xc2aa1d(0x3af)]['y'],this[_0xc2aa1d(0x6c9)]['y']));},Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x7a7)]=function(_0x1b16cd){const _0x1d5c31=_0x262cbe;this[_0x1d5c31(0x3af)]=_0x1b16cd,this[_0x1d5c31(0x6c9)]=JsonEx[_0x1d5c31(0x54b)](this[_0x1d5c31(0x3af)]);},Game_Picture[_0x262cbe(0x800)][_0x262cbe(0x37c)]=function(_0x28068f){const _0x3e7b83=_0x262cbe;this[_0x3e7b83(0x6c9)]=_0x28068f;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x115)]=Sprite_Picture['prototype']['updateOrigin'],Sprite_Picture['prototype']['updateOrigin']=function(){const _0x299ad8=_0x262cbe,_0x22b648=this[_0x299ad8(0x766)]();!_0x22b648[_0x299ad8(0xc4)]()?VisuMZ[_0x299ad8(0x244)]['Sprite_Picture_updateOrigin'][_0x299ad8(0x77c)](this):(this['anchor']['x']=_0x22b648['anchor']()['x'],this['anchor']['y']=_0x22b648[_0x299ad8(0xc4)]()['y']);},Game_Action['prototype'][_0x262cbe(0x6de)]=function(_0x40546c){const _0x2ec3e5=_0x262cbe;if(_0x40546c){const _0x14f07a=_0x40546c[_0x2ec3e5(0x3d4)];if(_0x14f07a===0x1&&this['subject']()['attackSkillId']()!==0x1)this[_0x2ec3e5(0x4f0)]();else _0x14f07a===0x2&&this['subject']()['guardSkillId']()!==0x2?this[_0x2ec3e5(0x74c)]():this[_0x2ec3e5(0x829)](_0x14f07a);}else this[_0x2ec3e5(0x294)]();},Game_Actor[_0x262cbe(0x800)][_0x262cbe(0x756)]=function(){const _0x153401=_0x262cbe;return this[_0x153401(0x813)]()[_0x153401(0x1c7)](_0x4cc026=>this['canUse'](_0x4cc026)&&this[_0x153401(0x2ac)]()[_0x153401(0x14c)](_0x4cc026[_0x153401(0x618)]));},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x2b7)]=function(){const _0x391e33=_0x262cbe;this[_0x391e33(0x4bd)]=new Sprite(),this[_0x391e33(0x4bd)]['bitmap']=new Bitmap(0x0,0x0),this['_dimmerSprite']['x']=0x0,this[_0x391e33(0x81b)](this[_0x391e33(0x4bd)]);},Window_Base[_0x262cbe(0x800)][_0x262cbe(0x5c9)]=function(){const _0x5edb58=_0x262cbe;if(this['_dimmerSprite']){const _0xfea5b9=this['_dimmerSprite'][_0x5edb58(0x2a9)],_0x39576d=this[_0x5edb58(0x80a)],_0x42c1c1=this[_0x5edb58(0x100)],_0x54fdac=this[_0x5edb58(0x3e2)],_0x56f6d3=ColorManager[_0x5edb58(0x80e)](),_0x50dbb2=ColorManager[_0x5edb58(0x841)]();_0xfea5b9[_0x5edb58(0x397)](_0x39576d,_0x42c1c1),_0xfea5b9[_0x5edb58(0x6ee)](0x0,0x0,_0x39576d,_0x54fdac,_0x50dbb2,_0x56f6d3,!![]),_0xfea5b9['fillRect'](0x0,_0x54fdac,_0x39576d,_0x42c1c1-_0x54fdac*0x2,_0x56f6d3),_0xfea5b9[_0x5edb58(0x6ee)](0x0,_0x42c1c1-_0x54fdac,_0x39576d,_0x54fdac,_0x56f6d3,_0x50dbb2,!![]),this['_dimmerSprite'][_0x5edb58(0x6f4)](0x0,0x0,_0x39576d,_0x42c1c1);}},Game_Actor[_0x262cbe(0x800)][_0x262cbe(0xd9)]=function(){const _0x5eac17=_0x262cbe;for(let _0x1f7f17=0x0;_0x1f7f17<this[_0x5eac17(0x40a)]();_0x1f7f17++){const _0x4e3bf8=this['makeActionList']();let _0x56c7d6=Number[_0x5eac17(0x4ce)];this[_0x5eac17(0x664)](_0x1f7f17,_0x4e3bf8[0x0]);for(const _0x46c3aa of _0x4e3bf8){const _0x453578=_0x46c3aa[_0x5eac17(0x69c)]();_0x453578>_0x56c7d6&&(_0x56c7d6=_0x453578,this['setAction'](_0x1f7f17,_0x46c3aa));}}this[_0x5eac17(0x277)]('waiting');},Window_BattleItem[_0x262cbe(0x800)][_0x262cbe(0x1c1)]=function(_0x459ea0){const _0x1403b0=_0x262cbe;return BattleManager[_0x1403b0(0x57d)]()?BattleManager[_0x1403b0(0x57d)]()[_0x1403b0(0x4bf)](_0x459ea0):Window_ItemList[_0x1403b0(0x800)]['isEnabled'][_0x1403b0(0x77c)](this,_0x459ea0);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x7e8)]=Scene_Map['prototype'][_0x262cbe(0x568)],Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x568)]=function(){const _0x21a3d8=_0x262cbe;VisuMZ[_0x21a3d8(0x244)]['Scene_Map_createSpritesetFix']['call'](this);const _0x516722=this[_0x21a3d8(0x2aa)][_0x21a3d8(0x219)];if(_0x516722)this[_0x21a3d8(0x286)](_0x516722);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x123)]=Scene_Battle[_0x262cbe(0x800)][_0x262cbe(0x568)],Scene_Battle[_0x262cbe(0x800)]['createSpriteset']=function(){const _0x48b007=_0x262cbe;VisuMZ['CoreEngine'][_0x48b007(0x123)][_0x48b007(0x77c)](this);const _0x11226e=this[_0x48b007(0x2aa)][_0x48b007(0x219)];if(_0x11226e)this['addChild'](_0x11226e);},Sprite_Actor[_0x262cbe(0x800)][_0x262cbe(0x64e)]=function(){const _0x4b58e6=_0x262cbe;Sprite_Battler['prototype']['update'][_0x4b58e6(0x77c)](this),this[_0x4b58e6(0x675)]();if(this[_0x4b58e6(0x65e)])this[_0x4b58e6(0x3ba)]();else this['_battlerName']!==''&&(this['_battlerName']='');},Window[_0x262cbe(0x800)][_0x262cbe(0x485)]=function(){const _0x24d7e7=_0x262cbe,_0x16abe4=this[_0x24d7e7(0x807)],_0x4ae354=this[_0x24d7e7(0x5f9)],_0x20e4f5=0x18,_0x1f8983=_0x20e4f5/0x2,_0x39888e=0x60+_0x20e4f5,_0x402c5f=0x0+_0x20e4f5;this['_downArrowSprite'][_0x24d7e7(0x2a9)]=this[_0x24d7e7(0xba)],this[_0x24d7e7(0x432)][_0x24d7e7(0xc4)]['x']=0.5,this[_0x24d7e7(0x432)][_0x24d7e7(0xc4)]['y']=0.5,this[_0x24d7e7(0x432)]['setFrame'](_0x39888e+_0x1f8983,_0x402c5f+_0x1f8983+_0x20e4f5,_0x20e4f5,_0x1f8983),this[_0x24d7e7(0x432)][_0x24d7e7(0x5ea)](Math[_0x24d7e7(0x38d)](_0x16abe4/0x2),Math[_0x24d7e7(0x38d)](_0x4ae354-_0x1f8983)),this['_upArrowSprite'][_0x24d7e7(0x2a9)]=this[_0x24d7e7(0xba)],this[_0x24d7e7(0x416)]['anchor']['x']=0.5,this['_upArrowSprite'][_0x24d7e7(0xc4)]['y']=0.5,this['_upArrowSprite']['setFrame'](_0x39888e+_0x1f8983,_0x402c5f,_0x20e4f5,_0x1f8983),this['_upArrowSprite'][_0x24d7e7(0x5ea)](Math[_0x24d7e7(0x38d)](_0x16abe4/0x2),Math['round'](_0x1f8983));},Window['prototype'][_0x262cbe(0x846)]=function(){const _0x50afcb=_0x262cbe,_0x3a7592=0x90,_0x286939=0x60,_0x1841d8=0x18;this[_0x50afcb(0x1a2)][_0x50afcb(0x2a9)]=this[_0x50afcb(0xba)],this['_pauseSignSprite'][_0x50afcb(0xc4)]['x']=0.5,this[_0x50afcb(0x1a2)]['anchor']['y']=0x1,this['_pauseSignSprite'][_0x50afcb(0x5ea)](Math[_0x50afcb(0x38d)](this[_0x50afcb(0x807)]/0x2),this[_0x50afcb(0x5f9)]),this['_pauseSignSprite'][_0x50afcb(0x6f4)](_0x3a7592,_0x286939,_0x1841d8,_0x1841d8),this['_pauseSignSprite']['alpha']=0xff;},Window[_0x262cbe(0x800)][_0x262cbe(0x44d)]=function(){const _0x1e261d=_0x262cbe,_0x2ccdeb=this[_0x1e261d(0x103)][_0x1e261d(0xd2)][_0x1e261d(0x1c4)](new Point(0x0,0x0)),_0x2bd186=this['_clientArea']['filterArea'];_0x2bd186['x']=_0x2ccdeb['x']+this[_0x1e261d(0x6ca)]['x'],_0x2bd186['y']=_0x2ccdeb['y']+this[_0x1e261d(0x6ca)]['y'],_0x2bd186[_0x1e261d(0x80a)]=Math['ceil'](this[_0x1e261d(0x466)]*this[_0x1e261d(0xc6)]['x']),_0x2bd186[_0x1e261d(0x100)]=Math[_0x1e261d(0x4c7)](this[_0x1e261d(0x9d)]*this[_0x1e261d(0xc6)]['y']);},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x3c0)]=Window[_0x262cbe(0x800)][_0x262cbe(0x319)],Window[_0x262cbe(0x800)][_0x262cbe(0x319)]=function(){const _0x9541b6=_0x262cbe,_0x4cc41d=VisuMZ[_0x9541b6(0x244)][_0x9541b6(0x84d)][_0x9541b6(0x10e)][_0x9541b6(0x84a)]??!![];if(!_0x4cc41d)return VisuMZ[_0x9541b6(0x244)][_0x9541b6(0x3c0)][_0x9541b6(0x77c)](this);const _0x424029=this[_0x9541b6(0x696)],_0x3719f4=Math[_0x9541b6(0x256)](0x0,this[_0x9541b6(0x807)]-_0x424029*0x2),_0x16611d=Math[_0x9541b6(0x256)](0x0,this['_height']-_0x424029*0x2),_0x53ef02=this[_0x9541b6(0x3bf)],_0x5430eb=_0x53ef02[_0x9541b6(0x753)][0x0];_0x53ef02[_0x9541b6(0x2a9)]=this[_0x9541b6(0xba)],_0x53ef02[_0x9541b6(0x6f4)](0x0,0x0,0x60,0x60),_0x53ef02[_0x9541b6(0x5ea)](_0x424029,_0x424029),_0x53ef02[_0x9541b6(0xc6)]['x']=_0x3719f4/0x60,_0x53ef02[_0x9541b6(0xc6)]['y']=_0x16611d/0x60,_0x5430eb[_0x9541b6(0x2a9)]=this[_0x9541b6(0xba)],_0x5430eb[_0x9541b6(0x6f4)](0x0,0x60,0x60,0x60),_0x5430eb[_0x9541b6(0x5ea)](0x0,0x0,_0x3719f4,_0x16611d),_0x5430eb[_0x9541b6(0xc6)]['x']=0x1/_0x53ef02[_0x9541b6(0xc6)]['x'],_0x5430eb[_0x9541b6(0xc6)]['y']=0x1/_0x53ef02['scale']['y'],_0x53ef02[_0x9541b6(0x106)](this[_0x9541b6(0x401)]);},Game_Temp[_0x262cbe(0x800)][_0x262cbe(0x275)]=function(){const _0x4b1649=_0x262cbe;this[_0x4b1649(0x2d9)]=[],this['_fauxAnimationQueue']=[],this[_0x4b1649(0x2a2)]=[],this[_0x4b1649(0x47f)]=[];},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x6ba)]=Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x1f1)],Scene_Base[_0x262cbe(0x800)][_0x262cbe(0x1f1)]=function(){const _0x5797ad=_0x262cbe;if($gameTemp)$gameTemp[_0x5797ad(0x275)]();VisuMZ[_0x5797ad(0x244)]['Scene_Base_terminateAnimationClearBugFix'][_0x5797ad(0x77c)](this);},Bitmap[_0x262cbe(0x800)][_0x262cbe(0x195)]=function(_0x5c9f92){const _0x18cd77=_0x262cbe,_0x54c65d=this[_0x18cd77(0x545)];_0x54c65d['save'](),_0x54c65d[_0x18cd77(0x144)]=this['_makeFontNameText']();const _0x2c3486=_0x54c65d[_0x18cd77(0x6a1)](_0x5c9f92)[_0x18cd77(0x80a)];return _0x54c65d[_0x18cd77(0x5ef)](),_0x2c3486;},Window_Message[_0x262cbe(0x800)][_0x262cbe(0x5f0)]=function(_0x13cbf4){const _0x23d085=_0x262cbe;return this[_0x23d085(0x60b)]()?this[_0x23d085(0xaf)][_0x23d085(0x195)](_0x13cbf4):Window_Base[_0x23d085(0x800)][_0x23d085(0x5f0)][_0x23d085(0x77c)](this,_0x13cbf4);},Window_Message[_0x262cbe(0x800)]['useFontWidthFix']=function(){const _0x54d773=_0x262cbe;return VisuMZ[_0x54d773(0x244)][_0x54d773(0x84d)][_0x54d773(0x754)][_0x54d773(0x6c0)]??!![];},VisuMZ['CoreEngine']['Game_Action_numRepeats']=Game_Action[_0x262cbe(0x800)]['numRepeats'],Game_Action[_0x262cbe(0x800)][_0x262cbe(0x352)]=function(){const _0x1b8395=_0x262cbe;return this['item']()?VisuMZ[_0x1b8395(0x244)][_0x1b8395(0x137)][_0x1b8395(0x77c)](this):0x0;},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x198)]=Game_Action[_0x262cbe(0x800)][_0x262cbe(0x4f0)],Game_Action[_0x262cbe(0x800)][_0x262cbe(0x4f0)]=function(){const _0x38a5a6=_0x262cbe;if(this['subject']()&&this[_0x38a5a6(0x7f7)]()[_0x38a5a6(0x2b9)]())VisuMZ[_0x38a5a6(0x244)][_0x38a5a6(0x198)]['call'](this);else BattleManager[_0x38a5a6(0x66c)]?VisuMZ[_0x38a5a6(0x244)][_0x38a5a6(0x198)][_0x38a5a6(0x77c)](this):this[_0x38a5a6(0x294)]();},VisuMZ['CoreEngine'][_0x262cbe(0x7df)]=BattleManager[_0x262cbe(0x85b)],BattleManager[_0x262cbe(0x85b)]=function(_0xd92a85,_0x1e255f){const _0x5385a8=_0x262cbe;this[_0x5385a8(0x66c)]=!![],VisuMZ[_0x5385a8(0x244)][_0x5385a8(0x7df)][_0x5385a8(0x77c)](this,_0xd92a85,_0x1e255f),this['_bypassCanCounterCheck']=undefined;},Sprite_Name[_0x262cbe(0x800)]['bitmapHeight']=function(){return 0x24;},Sprite_Name[_0x262cbe(0x800)][_0x262cbe(0x698)]=function(){const _0x1c86f4=_0x262cbe,_0x68ee53=this[_0x1c86f4(0x84e)](),_0x214017=this[_0x1c86f4(0x73b)](),_0x54072d=this[_0x1c86f4(0x468)]();this['setupFont'](),this['bitmap']['clear'](),this[_0x1c86f4(0x2a9)][_0x1c86f4(0x6ed)](_0x68ee53,0x4,0x0,_0x214017-0xa,_0x54072d,'left');},Bitmap[_0x262cbe(0x800)]['drawTextTopAligned']=function(_0x31a9b9,_0x101652,_0x52aa04,_0x506797,_0x108386,_0x9727d0){const _0x1faf50=_0x262cbe,_0xbf2163=this[_0x1faf50(0x545)],_0x29231d=_0xbf2163[_0x1faf50(0x790)];_0x506797=_0x506797||0xffffffff;let _0x1d148a=_0x101652,_0x40505b=Math[_0x1faf50(0x38d)](_0x52aa04+0x18/0x2+this[_0x1faf50(0x5ad)]*0.35);_0x9727d0===_0x1faf50(0x3b5)&&(_0x1d148a+=_0x506797/0x2),_0x9727d0===_0x1faf50(0x7d9)&&(_0x1d148a+=_0x506797),_0xbf2163['save'](),_0xbf2163[_0x1faf50(0x144)]=this[_0x1faf50(0xfa)](),_0xbf2163[_0x1faf50(0x4d2)]=_0x9727d0,_0xbf2163[_0x1faf50(0x54e)]=_0x1faf50(0x82f),_0xbf2163[_0x1faf50(0x790)]=0x1,this['_drawTextOutline'](_0x31a9b9,_0x1d148a,_0x40505b,_0x506797),_0xbf2163[_0x1faf50(0x790)]=_0x29231d,this['_drawTextBody'](_0x31a9b9,_0x1d148a,_0x40505b,_0x506797),_0xbf2163['restore'](),this[_0x1faf50(0x3f7)][_0x1faf50(0x64e)]();},VisuMZ['CoreEngine'][_0x262cbe(0x161)]=BattleManager[_0x262cbe(0x5cb)],BattleManager[_0x262cbe(0x5cb)]=function(_0x213360){const _0x40678b=_0x262cbe;if(this[_0x40678b(0x76b)][_0x40678b(0x7b9)]())return![];return VisuMZ['CoreEngine']['BattleManager_checkSubstitute']['call'](this,_0x213360);},BattleManager[_0x262cbe(0xf7)]=function(){const _0x44c033=_0x262cbe;if(this[_0x44c033(0x68c)])this['_logWindow'][_0x44c033(0xf7)](this[_0x44c033(0x68c)]);this[_0x44c033(0x719)]=_0x44c033(0x73f),this[_0x44c033(0x68c)]&&this[_0x44c033(0x68c)][_0x44c033(0x40a)]()===0x0&&(this[_0x44c033(0x6a6)](this['_subject']),this[_0x44c033(0x68c)]=null);},Bitmap[_0x262cbe(0x800)][_0x262cbe(0x4ff)]=function(){const _0x37ef75=_0x262cbe;this[_0x37ef75(0x110)]=new Image(),this[_0x37ef75(0x110)][_0x37ef75(0x536)]=this[_0x37ef75(0x532)][_0x37ef75(0x75d)](this),this[_0x37ef75(0x110)][_0x37ef75(0x2a0)]=this['_onError']['bind'](this),this[_0x37ef75(0x2dd)](),this['_loadingState']=_0x37ef75(0x42d),Utils[_0x37ef75(0x12e)]()?this[_0x37ef75(0x1e0)]():(this[_0x37ef75(0x110)]['src']=this[_0x37ef75(0x1cd)],![]&&this['_image'][_0x37ef75(0x80a)]>0x0&&(this['_image'][_0x37ef75(0x536)]=null,this[_0x37ef75(0x532)]()));},Scene_Skill[_0x262cbe(0x800)][_0x262cbe(0x39a)]=function(){const _0x4f54fd=_0x262cbe;Scene_MenuBase['prototype'][_0x4f54fd(0x39a)][_0x4f54fd(0x77c)](this),this[_0x4f54fd(0x845)](),this[_0x4f54fd(0x15e)][_0x4f54fd(0x478)](),this[_0x4f54fd(0x15e)][_0x4f54fd(0x98)](),this[_0x4f54fd(0x3b6)][_0x4f54fd(0xdf)]();},Scene_Skill[_0x262cbe(0x800)][_0x262cbe(0x59c)]=function(){const _0x495763=_0x262cbe;return this[_0x495763(0x3b6)]&&this[_0x495763(0x3b6)][_0x495763(0x477)];},Game_Map['prototype'][_0x262cbe(0x660)]=function(_0x4c7e95,_0x416313,_0xa22d44){const _0x3ccf73=_0x262cbe,_0x366fd4=this[_0x3ccf73(0x552)](),_0xe92f53=this['allTiles'](_0x4c7e95,_0x416313);for(const _0x44fee9 of _0xe92f53){const _0x464351=_0x366fd4[_0x44fee9];if(_0x464351===undefined||_0x464351===null){if($gameTemp[_0x3ccf73(0x5ee)]()&&!DataManager[_0x3ccf73(0x4dd)]()){let _0x595544=_0x3ccf73(0x217)+'\x0a';_0x595544+=_0x3ccf73(0x407)+'\x0a',_0x595544+=_0x3ccf73(0x61c),this[_0x3ccf73(0x715)]()?(alert(_0x595544),SceneManager[_0x3ccf73(0x29d)]()):(console['log'](_0x595544),!$gameTemp['_showDevTools']&&($gameTemp[_0x3ccf73(0x794)]=!![],SceneManager[_0x3ccf73(0x348)]()));}}if((_0x464351&0x10)!==0x0)continue;if((_0x464351&_0xa22d44)===0x0)return!![];if((_0x464351&_0xa22d44)===_0xa22d44)return![];}return![];},Game_Map[_0x262cbe(0x800)][_0x262cbe(0x715)]=function(){const _0x441b69=_0x262cbe;if(Imported[_0x441b69(0x202)])return!![];if(Imported['VisuMZ_4_UniqueTileEffects'])return!![];return![];},Sprite_Animation[_0x262cbe(0x800)][_0x262cbe(0x321)]=function(_0x5a4d40){const _0xb0082f=_0x262cbe;!this[_0xb0082f(0x39c)]&&(this[_0xb0082f(0x39c)]=_0x5a4d40['gl'][_0xb0082f(0x7f8)](_0x5a4d40['gl']['VIEWPORT']));},VisuMZ[_0x262cbe(0x244)][_0x262cbe(0x770)]=Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x27a)],Scene_Map[_0x262cbe(0x800)][_0x262cbe(0x27a)]=function(){const _0x1e848e=_0x262cbe,_0x4bf600=SceneManager['_previousClass'][_0x1e848e(0x84e)];if([_0x1e848e(0x1b4),_0x1e848e(0x3d9),_0x1e848e(0x359),_0x1e848e(0x547)][_0x1e848e(0x14c)](_0x4bf600))return![];return VisuMZ['CoreEngine']['Scene_Map_shouldAutosave'][_0x1e848e(0x77c)](this);};